/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.IRemoteControlDisplay;
import android.media.MediaMetadata;
import android.media.MediaMetadataEditor;
import android.media.Rating;
import android.media.session.MediaController;
import android.media.session.MediaSessionLegacyHelper;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.List;

@Deprecated
public final class RemoteController {
    private static final boolean DEBUG = false;
    private static final int MAX_BITMAP_DIMENSION = 512;
    private static final int MSG_CLIENT_CHANGE = 4;
    private static final int MSG_DISPLAY_ENABLE = 5;
    private static final int MSG_NEW_MEDIA_METADATA = 7;
    private static final int MSG_NEW_METADATA = 3;
    private static final int MSG_NEW_PENDING_INTENT = 0;
    private static final int MSG_NEW_PLAYBACK_INFO = 1;
    private static final int MSG_NEW_PLAYBACK_STATE = 6;
    private static final int MSG_NEW_TRANSPORT_INFO = 2;
    public static final int POSITION_SYNCHRONIZATION_CHECK = 1;
    public static final int POSITION_SYNCHRONIZATION_NONE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int SENDMSG_REPLACE = 0;
    private static final String TAG = "RemoteController";
    private static final int TRANSPORT_UNKNOWN = 0;
    private static final boolean USE_SESSIONS = true;
    private static final Object mGenLock = new Object();
    private static final Object mInfoLock = new Object();
    private int mArtworkHeight = -1;
    private int mArtworkWidth = -1;
    private final AudioManager mAudioManager;
    private int mClientGenerationIdCurrent = 0;
    private PendingIntent mClientPendingIntentCurrent;
    private final Context mContext;
    private MediaController mCurrentSession;
    private boolean mEnabled = true;
    private final EventHandler mEventHandler;
    private boolean mIsRegistered = false;
    private PlaybackInfo mLastPlaybackInfo;
    private final int mMaxBitmapDimension;
    private MetadataEditor mMetadataEditor;
    private OnClientUpdateListener mOnClientUpdateListener;
    private final RcDisplay mRcd;
    private MediaController.Callback mSessionCb = new MediaControllerCallback();
    private MediaSessionManager.OnActiveSessionsChangedListener mSessionListener;
    private MediaSessionManager mSessionManager;

    public RemoteController(Context context, OnClientUpdateListener onClientUpdateListener) throws IllegalArgumentException {
        this(context, onClientUpdateListener, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RemoteController(Context context, OnClientUpdateListener onClientUpdateListener, Looper looper) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Invalid null Context");
        }
        if (onClientUpdateListener == null) {
            throw new IllegalArgumentException("Invalid null OnClientUpdateListener");
        }
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, looper);
        } else {
            Looper looper2 = Looper.myLooper();
            if (looper2 == null) {
                throw new IllegalArgumentException("Calling thread not associated with a looper");
            }
            this.mEventHandler = new EventHandler(this, looper2);
        }
        this.mOnClientUpdateListener = onClientUpdateListener;
        this.mContext = context;
        this.mRcd = new RcDisplay(this);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mSessionManager = (MediaSessionManager)context.getSystemService("media_session");
        this.mSessionListener = new TopTransportSessionListener();
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mMaxBitmapDimension = 512;
            return;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mMaxBitmapDimension = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    static /* synthetic */ int access$502(RemoteController remoteController, int n) {
        remoteController.mClientGenerationIdCurrent = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onClientChange(int n, boolean bl) {
        Object object = mGenLock;
        // MONITORENTER : object
        if (this.mClientGenerationIdCurrent != n) {
            // MONITOREXIT : object
            return;
        }
        // MONITOREXIT : object
        Object object2 = mInfoLock;
        // MONITORENTER : object2
        OnClientUpdateListener onClientUpdateListener = this.mOnClientUpdateListener;
        this.mMetadataEditor = null;
        // MONITOREXIT : object2
        if (onClientUpdateListener == null) return;
        onClientUpdateListener.onClientChange(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onDisplayEnable(boolean bl) {
        Object object = mInfoLock;
        // MONITORENTER : object
        this.mEnabled = bl;
        // MONITOREXIT : object
        if (bl) return;
        Object object2 = mGenLock;
        // MONITORENTER : object2
        int n = this.mClientGenerationIdCurrent;
        // MONITOREXIT : object2
        PlaybackInfo playbackInfo = new PlaybackInfo(1, SystemClock.elapsedRealtime(), 0L, 0.0f);
        RemoteController.sendMsg(this.mEventHandler, 1, 0, n, 0, playbackInfo, 0);
        RemoteController.sendMsg(this.mEventHandler, 2, 0, n, 0, null, 0);
        Bundle bundle = new Bundle(3);
        bundle.putString(String.valueOf(7), "");
        bundle.putString(String.valueOf(2), "");
        bundle.putLong(String.valueOf(9), 0L);
        RemoteController.sendMsg(this.mEventHandler, 3, 2, n, 0, bundle, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onNewMediaMetadata(MediaMetadata mediaMetadata) {
        MetadataEditor metadataEditor;
        OnClientUpdateListener onClientUpdateListener;
        block6: {
            block5: {
                if (mediaMetadata == null) break block5;
                Object object = mInfoLock;
                synchronized (object) {
                    onClientUpdateListener = this.mOnClientUpdateListener;
                    boolean bl = this.mCurrentSession != null && this.mCurrentSession.getRatingType() != 0;
                    long l = bl ? 0x10000001L : 0L;
                    metadataEditor = this.mMetadataEditor = new MetadataEditor(MediaSessionLegacyHelper.getOldMetadata(mediaMetadata, this.mArtworkWidth, this.mArtworkHeight), l);
                    if (onClientUpdateListener != null) break block6;
                }
            }
            return;
        }
        onClientUpdateListener.onClientMetadataUpdate(metadataEditor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onNewMetadata(int n, Bundle bundle) {
        Object object = mGenLock;
        // MONITORENTER : object
        if (this.mClientGenerationIdCurrent != n) {
            // MONITOREXIT : object
            return;
        }
        // MONITOREXIT : object
        long l = bundle.getLong(String.valueOf(0x1FFFFFFF), 0L);
        if (l != 0L) {
            bundle.remove(String.valueOf(0x1FFFFFFF));
        }
        Object object2 = mInfoLock;
        // MONITORENTER : object2
        OnClientUpdateListener onClientUpdateListener = this.mOnClientUpdateListener;
        if (this.mMetadataEditor != null && this.mMetadataEditor.mEditorMetadata != null) {
            if (this.mMetadataEditor.mEditorMetadata != bundle) {
                this.mMetadataEditor.mEditorMetadata.putAll(bundle);
            }
            this.mMetadataEditor.putBitmap(100, (Bitmap)bundle.getParcelable(String.valueOf(100)));
            this.mMetadataEditor.cleanupBitmapFromBundle(100);
        } else {
            this.mMetadataEditor = new MetadataEditor(bundle, l);
        }
        MetadataEditor metadataEditor = this.mMetadataEditor;
        // MONITOREXIT : object2
        if (onClientUpdateListener == null) return;
        onClientUpdateListener.onClientMetadataUpdate(metadataEditor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onNewPendingIntent(int n, PendingIntent pendingIntent) {
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != n) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            this.mClientPendingIntentCurrent = pendingIntent;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onNewPlaybackInfo(int n, PlaybackInfo playbackInfo) {
        Object object = mGenLock;
        // MONITORENTER : object
        if (this.mClientGenerationIdCurrent != n) {
            // MONITOREXIT : object
            return;
        }
        // MONITOREXIT : object
        Object object2 = mInfoLock;
        // MONITORENTER : object2
        OnClientUpdateListener onClientUpdateListener = this.mOnClientUpdateListener;
        this.mLastPlaybackInfo = playbackInfo;
        // MONITOREXIT : object2
        if (onClientUpdateListener == null) return;
        if (playbackInfo.mCurrentPosMs == -9216204211029966080L) {
            onClientUpdateListener.onClientPlaybackStateUpdate(playbackInfo.mState);
            return;
        }
        onClientUpdateListener.onClientPlaybackStateUpdate(playbackInfo.mState, playbackInfo.mStateChangeTimeMs, playbackInfo.mCurrentPosMs, playbackInfo.mSpeed);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onNewPlaybackState(PlaybackState playbackState) {
        Object object = mInfoLock;
        // MONITORENTER : object
        OnClientUpdateListener onClientUpdateListener = this.mOnClientUpdateListener;
        // MONITOREXIT : object
        if (onClientUpdateListener == null) return;
        int n = playbackState == null ? 0 : PlaybackState.getRccStateFromState(playbackState.getState());
        if (playbackState == null || playbackState.getPosition() == -1L) {
            onClientUpdateListener.onClientPlaybackStateUpdate(n);
        } else {
            onClientUpdateListener.onClientPlaybackStateUpdate(n, playbackState.getLastPositionUpdateTime(), playbackState.getPosition(), playbackState.getPlaybackSpeed());
        }
        if (playbackState == null) return;
        onClientUpdateListener.onClientTransportControlUpdate(PlaybackState.getRccControlFlagsFromActions(playbackState.getActions()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onNewTransportInfo(int n, int n2) {
        Object object = mGenLock;
        // MONITORENTER : object
        if (this.mClientGenerationIdCurrent != n) {
            // MONITOREXIT : object
            return;
        }
        // MONITOREXIT : object
        Object object2 = mInfoLock;
        // MONITORENTER : object2
        OnClientUpdateListener onClientUpdateListener = this.mOnClientUpdateListener;
        // MONITOREXIT : object2
        if (onClientUpdateListener == null) return;
        onClientUpdateListener.onClientTransportControlUpdate(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, Object object, int n5) {
        if (handler == null) {
            Log.e(TAG, "null event handler, will not deliver message " + n);
            return;
        }
        if (n2 == 0) {
            handler.removeMessages(n);
        } else if (n2 == 1 && handler.hasMessages(n)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(n, n3, n4, object), n5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateController(MediaController mediaController) {
        Object object = mInfoLock;
        synchronized (object) {
            if (mediaController == null) {
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.unregisterCallback(this.mSessionCb);
                    this.mCurrentSession = null;
                    RemoteController.sendMsg(this.mEventHandler, 4, 0, 0, 1, null, 0);
                }
            } else if (this.mCurrentSession == null || !mediaController.getSessionToken().equals(this.mCurrentSession.getSessionToken())) {
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.unregisterCallback(this.mSessionCb);
                }
                RemoteController.sendMsg(this.mEventHandler, 4, 0, 0, 0, null, 0);
                this.mCurrentSession = mediaController;
                this.mCurrentSession.registerCallback(this.mSessionCb, this.mEventHandler);
                PlaybackState playbackState = mediaController.getPlaybackState();
                RemoteController.sendMsg(this.mEventHandler, 6, 0, 0, 0, playbackState, 0);
                MediaMetadata mediaMetadata = mediaController.getMetadata();
                RemoteController.sendMsg(this.mEventHandler, 7, 0, 0, 0, mediaMetadata, 0);
            }
            return;
        }
    }

    public boolean clearArtworkConfiguration() {
        return this.setArtworkConfiguration(false, -1, -1);
    }

    public MetadataEditor editMetadata() {
        MetadataEditor metadataEditor = new MetadataEditor();
        metadataEditor.mEditorMetadata = new Bundle();
        metadataEditor.mEditorArtwork = null;
        metadataEditor.mMetadataChanged = true;
        metadataEditor.mArtworkChanged = true;
        metadataEditor.mEditableKeys = 0L;
        return metadataEditor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int[] getArtworkSize() {
        Object object = mInfoLock;
        synchronized (object) {
            int[] nArray = new int[]{this.mArtworkWidth, this.mArtworkHeight};
            return nArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getEstimatedMediaPosition() {
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession == null) return -1L;
            PlaybackState playbackState = this.mCurrentSession.getPlaybackState();
            if (playbackState == null) return -1L;
            return playbackState.getPosition();
        }
    }

    RcDisplay getRcDisplay() {
        return this.mRcd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRemoteControlClientPackageName() {
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession == null) return null;
            return this.mCurrentSession.getPackageName();
        }
    }

    OnClientUpdateListener getUpdateListener() {
        return this.mOnClientUpdateListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean seekTo(long l) throws IllegalArgumentException {
        if (!this.mEnabled) {
            Log.e(TAG, "Cannot use seekTo() from a disabled RemoteController");
            return false;
        }
        if (l < 0L) {
            throw new IllegalArgumentException("illegal negative time value");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession != null) {
                this.mCurrentSession.getTransportControls().seekTo(l);
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendMediaKeyEvent(KeyEvent keyEvent) throws IllegalArgumentException {
        if (!KeyEvent.isMediaKey(keyEvent.getKeyCode())) {
            throw new IllegalArgumentException("not a media key event");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession == null) return false;
            return this.mCurrentSession.dispatchMediaButtonEvent(keyEvent);
        }
    }

    public boolean setArtworkConfiguration(int n, int n2) throws IllegalArgumentException {
        return this.setArtworkConfiguration(true, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setArtworkConfiguration(boolean bl, int n, int n2) throws IllegalArgumentException {
        Object object = mInfoLock;
        synchronized (object) {
            block8: {
                if (bl) {
                    if (n > 0 && n2 > 0) {
                        if (n > this.mMaxBitmapDimension) {
                            n = this.mMaxBitmapDimension;
                        }
                        if (n2 > this.mMaxBitmapDimension) {
                            n2 = this.mMaxBitmapDimension;
                        }
                        this.mArtworkWidth = n;
                        this.mArtworkHeight = n2;
                        break block8;
                    } else {
                        throw new IllegalArgumentException("Invalid dimensions");
                    }
                }
                this.mArtworkWidth = -1;
                this.mArtworkHeight = -1;
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setIsRegistered(boolean bl) {
        Object object = mInfoLock;
        synchronized (object) {
            this.mIsRegistered = bl;
            return;
        }
    }

    public boolean setSynchronizationMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unknown synchronization mode " + n);
        }
        if (!this.mIsRegistered) {
            Log.e(TAG, "Cannot set synchronization mode on an unregistered RemoteController");
            return false;
        }
        AudioManager audioManager = this.mAudioManager;
        RcDisplay rcDisplay = this.mRcd;
        boolean bl = false;
        if (1 == n) {
            bl = true;
        }
        audioManager.remoteControlDisplayWantsPlaybackPositionSync(rcDisplay, bl);
        return true;
    }

    void startListeningToSessions() {
        ComponentName componentName = new ComponentName(this.mContext, this.mOnClientUpdateListener.getClass());
        Looper looper = Looper.myLooper();
        Handler handler = null;
        if (looper == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        this.mSessionManager.addOnActiveSessionsChangedListener(this.mSessionListener, componentName, UserHandle.myUserId(), handler);
        this.mSessionListener.onActiveSessionsChanged(this.mSessionManager.getActiveSessions(componentName));
    }

    void stopListeningToSessions() {
        this.mSessionManager.removeOnActiveSessionsChangedListener(this.mSessionListener);
    }

    private class EventHandler
    extends Handler {
        public EventHandler(RemoteController remoteController2, Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            int n = 1;
            switch (message.what) {
                default: {
                    Log.e(RemoteController.TAG, "unknown event " + message.what);
                    return;
                }
                case 0: {
                    RemoteController.this.onNewPendingIntent(message.arg1, (PendingIntent)message.obj);
                    return;
                }
                case 1: {
                    RemoteController.this.onNewPlaybackInfo(message.arg1, (PlaybackInfo)message.obj);
                    return;
                }
                case 2: {
                    RemoteController.this.onNewTransportInfo(message.arg1, message.arg2);
                    return;
                }
                case 3: {
                    RemoteController.this.onNewMetadata(message.arg1, (Bundle)message.obj);
                    return;
                }
                case 4: {
                    RemoteController remoteController = RemoteController.this;
                    int n2 = message.arg1;
                    if (message.arg2 != n) {
                        n = 0;
                    }
                    remoteController.onClientChange(n2, n != 0);
                    return;
                }
                case 5: {
                    RemoteController remoteController = RemoteController.this;
                    if (message.arg1 != n) {
                        n = 0;
                    }
                    remoteController.onDisplayEnable(n != 0);
                    return;
                }
                case 6: {
                    RemoteController.this.onNewPlaybackState((PlaybackState)message.obj);
                    return;
                }
                case 7: 
            }
            RemoteController.this.onNewMediaMetadata((MediaMetadata)message.obj);
        }
    }

    private class MediaControllerCallback
    extends MediaController.Callback {
        private MediaControllerCallback() {
        }

        @Override
        public void onMetadataChanged(MediaMetadata mediaMetadata) {
            RemoteController.this.onNewMediaMetadata(mediaMetadata);
        }

        @Override
        public void onPlaybackStateChanged(PlaybackState playbackState) {
            RemoteController.this.onNewPlaybackState(playbackState);
        }
    }

    public class MetadataEditor
    extends MediaMetadataEditor {
        protected MetadataEditor() {
        }

        protected MetadataEditor(Bundle bundle, long l) {
            this.mEditorMetadata = bundle;
            this.mEditableKeys = l;
            this.mEditorArtwork = (Bitmap)bundle.getParcelable(String.valueOf(100));
            if (this.mEditorArtwork != null) {
                this.cleanupBitmapFromBundle(100);
            }
            this.mMetadataChanged = true;
            this.mArtworkChanged = true;
            this.mApplied = false;
        }

        private void cleanupBitmapFromBundle(int n) {
            if (METADATA_KEYS_TYPE.get(n, -1) == 2) {
                this.mEditorMetadata.remove(String.valueOf(n));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void apply() {
            synchronized (this) {
                boolean bl = this.mMetadataChanged;
                if (bl) {
                    Object object = mInfoLock;
                    synchronized (object) {
                        Rating rating;
                        if (RemoteController.this.mCurrentSession != null && this.mEditorMetadata.containsKey(String.valueOf(0x10000001)) && (rating = (Rating)this.getObject(0x10000001, null)) != null) {
                            RemoteController.this.mCurrentSession.getTransportControls().setRating(rating);
                        }
                    }
                    this.mApplied = false;
                }
                return;
            }
        }
    }

    public static interface OnClientUpdateListener {
        public void onClientChange(boolean var1);

        public void onClientMetadataUpdate(MetadataEditor var1);

        public void onClientPlaybackStateUpdate(int var1);

        public void onClientPlaybackStateUpdate(int var1, long var2, long var4, float var6);

        public void onClientTransportControlUpdate(int var1);
    }

    private static class PlaybackInfo {
        long mCurrentPosMs;
        float mSpeed;
        int mState;
        long mStateChangeTimeMs;

        PlaybackInfo(int n, long l, long l2, float f) {
            this.mState = n;
            this.mStateChangeTimeMs = l;
            this.mCurrentPosMs = l2;
            this.mSpeed = f;
        }
    }

    private static class RcDisplay
    extends IRemoteControlDisplay.Stub {
        private final WeakReference<RemoteController> mController;

        RcDisplay(RemoteController remoteController) {
            this.mController = new WeakReference<RemoteController>(remoteController);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setAllMetadata(int n, Bundle bundle, Bitmap bitmap) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null) {
                return;
            }
            if (bundle == null) {
                if (bitmap == null) return;
            }
            Object object = mGenLock;
            // MONITORENTER : object
            if (remoteController.mClientGenerationIdCurrent != n) {
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (bundle == null) {
                bundle = new Bundle(1);
            }
            if (bitmap != null) {
                bundle.putParcelable(String.valueOf(100), bitmap);
            }
            RemoteController.sendMsg(remoteController.mEventHandler, 3, 2, n, 0, bundle, 0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setArtwork(int n, Bitmap bitmap) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (remoteController.mClientGenerationIdCurrent != n) {
                    return;
                }
            }
            Bundle bundle = new Bundle(1);
            bundle.putParcelable(String.valueOf(100), bitmap);
            RemoteController.sendMsg(remoteController.mEventHandler, 3, 2, n, 0, bundle, 0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setCurrentClientId(int n, PendingIntent pendingIntent, boolean bl) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null) {
                return;
            }
            Object object = mGenLock;
            // MONITORENTER : object
            int n2 = remoteController.mClientGenerationIdCurrent;
            boolean bl2 = false;
            if (n2 != n) {
                RemoteController.access$502(remoteController, n);
                bl2 = true;
            }
            // MONITOREXIT : object
            if (pendingIntent != null) {
                RemoteController.sendMsg(remoteController.mEventHandler, 0, 0, n, 0, pendingIntent, 0);
            }
            if (!bl2) {
                if (!bl) return;
            }
            EventHandler eventHandler = remoteController.mEventHandler;
            int n3 = bl ? 1 : 0;
            RemoteController.sendMsg(eventHandler, 4, 0, n, n3, null, 0);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setEnabled(boolean bl) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null) {
                return;
            }
            EventHandler eventHandler = remoteController.mEventHandler;
            int n = bl ? 1 : 0;
            RemoteController.sendMsg(eventHandler, 5, 0, n, 0, null, 0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setMetadata(int n, Bundle bundle) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null || bundle == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (remoteController.mClientGenerationIdCurrent != n) {
                    return;
                }
            }
            RemoteController.sendMsg(remoteController.mEventHandler, 3, 2, n, 0, bundle, 0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setPlaybackState(int n, int n2, long l, long l2, float f) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (remoteController.mClientGenerationIdCurrent != n) {
                    return;
                }
            }
            PlaybackInfo playbackInfo = new PlaybackInfo(n2, l, l2, f);
            RemoteController.sendMsg(remoteController.mEventHandler, 1, 0, n, 0, playbackInfo, 0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setTransportControlInfo(int n, int n2, int n3) {
            RemoteController remoteController = (RemoteController)this.mController.get();
            if (remoteController == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (remoteController.mClientGenerationIdCurrent != n) {
                    return;
                }
            }
            RemoteController.sendMsg(remoteController.mEventHandler, 2, 0, n, n2, null, 0);
        }
    }

    private class TopTransportSessionListener
    implements MediaSessionManager.OnActiveSessionsChangedListener {
        private TopTransportSessionListener() {
        }

        @Override
        public void onActiveSessionsChanged(List<MediaController> list) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                MediaController mediaController = list.get(i);
                if ((2L & mediaController.getFlags()) == 0L) continue;
                RemoteController.this.updateController(mediaController);
                return;
            }
            RemoteController.this.updateController(null);
        }
    }
}

