/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.util.StringTokenizer;

public class LoudnessEnhancer
extends AudioEffect {
    public static final int PARAM_TARGET_GAIN_MB = 0;
    private static final String TAG = "LoudnessEnhancer";
    private BaseParameterListener mBaseParamListener = null;
    private OnParameterChangeListener mParamListener = null;
    private final Object mParamListenerLock = new Object();

    public LoudnessEnhancer(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_LOUDNESS_ENHANCER, EFFECT_TYPE_NULL, 0, n);
        if (n == 0) {
            Log.w(TAG, "WARNING: attaching a LoudnessEnhancer to global output mix is deprecated!");
        }
    }

    public LoudnessEnhancer(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_LOUDNESS_ENHANCER, EFFECT_TYPE_NULL, n, n2);
        if (n2 == 0) {
            Log.w(TAG, "WARNING: attaching a LoudnessEnhancer to global output mix is deprecated!");
        }
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        int[] nArray = new int[1];
        this.checkStatus(this.getParameter(0, nArray));
        settings.targetGainmB = nArray[0];
        return settings;
    }

    public float getTargetGain() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[1];
        this.checkStatus(this.getParameter(0, nArray));
        return nArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            this.mParamListener = onParameterChangeListener;
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, settings.targetGainmB));
    }

    public void setTargetGain(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, n));
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            int n2;
            int n3;
            OnParameterChangeListener onParameterChangeListener;
            block10: {
                block9: {
                    if (n != 0) break block9;
                    Object object = LoudnessEnhancer.this.mParamListenerLock;
                    synchronized (object) {
                        OnParameterChangeListener onParameterChangeListener2 = LoudnessEnhancer.this.mParamListener;
                        onParameterChangeListener = null;
                        if (onParameterChangeListener2 != null) {
                            onParameterChangeListener = LoudnessEnhancer.this.mParamListener;
                        }
                        if (onParameterChangeListener == null) break block9;
                    }
                    n3 = -1;
                    n2 = Integer.MIN_VALUE;
                    if (byArray.length == 4) {
                        n3 = AudioEffect.byteArrayToInt(byArray, 0);
                    }
                    if (byArray2.length == 4) {
                        n2 = AudioEffect.byteArrayToInt(byArray2, 0);
                    }
                    if (n3 != -1 && n2 != Integer.MIN_VALUE) break block10;
                }
                return;
            }
            onParameterChangeListener.onParameterChange(LoudnessEnhancer.this, n3, n2);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(LoudnessEnhancer var1, int var2, int var3);
    }

    public static class Settings {
        public int targetGainmB;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            if (stringTokenizer.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(LoudnessEnhancer.TAG)) {
                throw new IllegalArgumentException("invalid settings for LoudnessEnhancer: " + string3);
            }
            try {
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("targetGainmB")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid value for key: " + string3);
            }
            {
                this.targetGainmB = Integer.parseInt(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            return new String("LoudnessEnhancer;targetGainmB=" + Integer.toString(this.targetGainmB));
        }
    }
}

