/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.graphics.Rect;
import android.media.tv.TvContentRating;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import java.lang.ref.WeakReference;
import java.util.List;

public class TvView
extends ViewGroup {
    private static final int CAPTION_DEFAULT = 0;
    private static final int CAPTION_DISABLED = 2;
    private static final int CAPTION_ENABLED = 1;
    private static final boolean DEBUG = false;
    private static final WeakReference<TvView> NULL_TV_VIEW = new WeakReference<Object>(null);
    private static final String TAG = "TvView";
    private static final int VIDEO_SIZE_VALUE_UNKNOWN = 0;
    private static final int ZORDER_MEDIA = 0;
    private static final int ZORDER_MEDIA_OVERLAY = 1;
    private static final int ZORDER_ON_TOP = 2;
    private static WeakReference<TvView> sMainTvView;
    private static final Object sMainTvViewLock;
    private final AttributeSet mAttrs;
    private TvInputCallback mCallback;
    private int mCaptionEnabled;
    private final int mDefStyleAttr;
    private final TvInputManager.Session.FinishedInputEventCallback mFinishedInputEventCallback;
    private final Handler mHandler = new Handler();
    private boolean mHasStreamVolume;
    private OnUnhandledInputEventListener mOnUnhandledInputEventListener;
    private boolean mOverlayViewCreated;
    private Rect mOverlayViewFrame;
    private TvInputManager.Session mSession;
    private MySessionCallback mSessionCallback;
    private float mStreamVolume;
    private Surface mSurface;
    private boolean mSurfaceChanged;
    private int mSurfaceFormat;
    private int mSurfaceHeight;
    private final SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback(){

        @Override
        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            TvView.access$002(TvView.this, n);
            TvView.access$102(TvView.this, n2);
            TvView.access$202(TvView.this, n3);
            TvView.access$302(TvView.this, true);
            TvView.this.dispatchSurfaceChanged(TvView.this.mSurfaceFormat, TvView.this.mSurfaceWidth, TvView.this.mSurfaceHeight);
        }

        @Override
        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            TvView.access$502(TvView.this, surfaceHolder.getSurface());
            TvView.this.setSessionSurface(TvView.this.mSurface);
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            TvView.access$502(TvView.this, null);
            TvView.access$302(TvView.this, false);
            TvView.this.setSessionSurface(null);
        }
    };
    private SurfaceView mSurfaceView;
    private int mSurfaceViewBottom;
    private int mSurfaceViewLeft;
    private int mSurfaceViewRight;
    private int mSurfaceViewTop;
    private int mSurfaceWidth;
    private final TvInputManager mTvInputManager;
    private boolean mUseRequestedSurfaceLayout;
    private int mVideoHeight = 0;
    private int mVideoWidth = 0;
    private int mWindowZOrder;

    static {
        sMainTvViewLock = new Object();
        sMainTvView = NULL_TV_VIEW;
    }

    public TvView(Context context) {
        this(context, null, 0);
    }

    public TvView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TvView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mFinishedInputEventCallback = new TvInputManager.Session.FinishedInputEventCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onFinishedInputEvent(Object object, boolean bl) {
                ViewRootImpl viewRootImpl;
                InputEvent inputEvent;
                if (bl || TvView.this.dispatchUnhandledInputEvent(inputEvent = (InputEvent)object) || (viewRootImpl = TvView.this.getViewRootImpl()) == null) {
                    return;
                }
                viewRootImpl.dispatchUnhandledInputEvent(inputEvent);
            }
        };
        this.mAttrs = attributeSet;
        this.mDefStyleAttr = n;
        this.resetSurfaceView();
        this.mTvInputManager = (TvInputManager)this.getContext().getSystemService("tv_input");
    }

    static /* synthetic */ int access$002(TvView tvView, int n) {
        tvView.mSurfaceFormat = n;
        return n;
    }

    static /* synthetic */ int access$102(TvView tvView, int n) {
        tvView.mSurfaceWidth = n;
        return n;
    }

    static /* synthetic */ boolean access$1702(TvView tvView, boolean bl) {
        tvView.mOverlayViewCreated = bl;
        return bl;
    }

    static /* synthetic */ Rect access$1802(TvView tvView, Rect rect) {
        tvView.mOverlayViewFrame = rect;
        return rect;
    }

    static /* synthetic */ int access$1902(TvView tvView, int n) {
        tvView.mSurfaceViewLeft = n;
        return n;
    }

    static /* synthetic */ int access$2002(TvView tvView, int n) {
        tvView.mSurfaceViewTop = n;
        return n;
    }

    static /* synthetic */ int access$202(TvView tvView, int n) {
        tvView.mSurfaceHeight = n;
        return n;
    }

    static /* synthetic */ int access$2102(TvView tvView, int n) {
        tvView.mSurfaceViewRight = n;
        return n;
    }

    static /* synthetic */ int access$2202(TvView tvView, int n) {
        tvView.mSurfaceViewBottom = n;
        return n;
    }

    static /* synthetic */ boolean access$2302(TvView tvView, boolean bl) {
        tvView.mUseRequestedSurfaceLayout = bl;
        return bl;
    }

    static /* synthetic */ boolean access$302(TvView tvView, boolean bl) {
        tvView.mSurfaceChanged = bl;
        return bl;
    }

    static /* synthetic */ Surface access$502(TvView tvView, Surface surface) {
        tvView.mSurface = surface;
        return surface;
    }

    static /* synthetic */ MySessionCallback access$802(TvView tvView, MySessionCallback mySessionCallback) {
        tvView.mSessionCallback = mySessionCallback;
        return mySessionCallback;
    }

    static /* synthetic */ TvInputManager.Session access$902(TvView tvView, TvInputManager.Session session) {
        tvView.mSession = session;
        return session;
    }

    private void createSessionOverlayView() {
        if (this.mSession == null || !this.isAttachedToWindow() || this.mOverlayViewCreated || this.mWindowZOrder != 0) {
            return;
        }
        this.mOverlayViewFrame = this.getViewFrameOnScreen();
        this.mSession.createOverlayView(this, this.mOverlayViewFrame);
        this.mOverlayViewCreated = true;
    }

    private void dispatchSurfaceChanged(int n, int n2, int n3) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.dispatchSurfaceChanged(n, n2, n3);
    }

    private Rect getViewFrameOnScreen() {
        int[] nArray = new int[2];
        this.getLocationOnScreen(nArray);
        return new Rect(nArray[0], nArray[1], nArray[0] + this.getWidth(), nArray[1] + this.getHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void relayoutSessionOverlayView() {
        Rect rect;
        if (this.mSession == null || !this.isAttachedToWindow() || !this.mOverlayViewCreated || this.mWindowZOrder != 0 || (rect = this.getViewFrameOnScreen()).equals(this.mOverlayViewFrame)) {
            return;
        }
        this.mSession.relayoutOverlayView(rect);
        this.mOverlayViewFrame = rect;
    }

    private void release() {
        this.setSessionSurface(null);
        this.removeSessionOverlayView();
        this.mUseRequestedSurfaceLayout = false;
        this.mSession.release();
        this.mSession = null;
        this.mSessionCallback = null;
    }

    private void removeSessionOverlayView() {
        if (this.mSession == null || !this.mOverlayViewCreated) {
            return;
        }
        this.mSession.removeOverlayView();
        this.mOverlayViewCreated = false;
        this.mOverlayViewFrame = null;
    }

    private void resetInternal() {
        if (this.mSession != null) {
            this.release();
            this.resetSurfaceView();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetSurfaceView() {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceHolderCallback);
            this.removeView(this.mSurfaceView);
        }
        this.mSurface = null;
        this.mSurfaceView = new SurfaceView(this.getContext(), this.mAttrs, this.mDefStyleAttr){

            @Override
            protected void updateWindow(boolean bl, boolean bl2) {
                super.updateWindow(bl, bl2);
                TvView.this.relayoutSessionOverlayView();
            }
        };
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceHolderCallback);
        if (this.mWindowZOrder == 1) {
            this.mSurfaceView.setZOrderMediaOverlay(true);
        } else if (this.mWindowZOrder == 2) {
            this.mSurfaceView.setZOrderOnTop(true);
        }
        this.addView(this.mSurfaceView);
    }

    private void setSessionSurface(Surface surface) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.setSurface(surface);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        block5: {
            block4: {
                if (super.dispatchGenericMotionEvent(motionEvent)) break block4;
                if (this.mSession == null) {
                    return false;
                }
                InputEvent inputEvent = motionEvent.copy();
                if (this.mSession.dispatchInputEvent(inputEvent, inputEvent, this.mFinishedInputEventCallback, this.mHandler) == 0) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        block5: {
            block4: {
                if (super.dispatchKeyEvent(keyEvent)) break block4;
                if (this.mSession == null) {
                    return false;
                }
                InputEvent inputEvent = keyEvent.copy();
                if (this.mSession.dispatchInputEvent(inputEvent, inputEvent, this.mFinishedInputEventCallback, this.mHandler) == 0) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        block5: {
            block4: {
                if (super.dispatchTouchEvent(motionEvent)) break block4;
                if (this.mSession == null) {
                    return false;
                }
                InputEvent inputEvent = motionEvent.copy();
                if (this.mSession.dispatchInputEvent(inputEvent, inputEvent, this.mFinishedInputEventCallback, this.mHandler) == 0) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        block5: {
            block4: {
                if (super.dispatchTrackballEvent(motionEvent)) break block4;
                if (this.mSession == null) {
                    return false;
                }
                InputEvent inputEvent = motionEvent.copy();
                if (this.mSession.dispatchInputEvent(inputEvent, inputEvent, this.mFinishedInputEventCallback, this.mHandler) == 0) break block5;
            }
            return true;
        }
        return false;
    }

    public boolean dispatchUnhandledInputEvent(InputEvent inputEvent) {
        if (this.mOnUnhandledInputEventListener != null && this.mOnUnhandledInputEventListener.onUnhandledInputEvent(inputEvent)) {
            return true;
        }
        return this.onUnhandledInputEvent(inputEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        super.dispatchWindowFocusChanged(bl);
        Object object = sMainTvViewLock;
        synchronized (object) {
            if (bl && this == sMainTvView.get() && this.mSession != null) {
                this.mSession.setMain();
            }
            return;
        }
    }

    public String getSelectedTrack(int n) {
        if (this.mSession == null) {
            return null;
        }
        return this.mSession.getSelectedTrack(n);
    }

    public List<TvTrackInfo> getTracks(int n) {
        if (this.mSession == null) {
            return null;
        }
        return this.mSession.getTracks(n);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.createSessionOverlayView();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.removeSessionOverlayView();
        super.onDetachedFromWindow();
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.mUseRequestedSurfaceLayout) {
            this.mSurfaceView.layout(this.mSurfaceViewLeft, this.mSurfaceViewTop, this.mSurfaceViewRight, this.mSurfaceViewBottom);
            return;
        }
        this.mSurfaceView.layout(0, 0, n3 - n, n4 - n2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.mSurfaceView.measure(n, n2);
        int n3 = this.mSurfaceView.getMeasuredWidth();
        int n4 = this.mSurfaceView.getMeasuredHeight();
        int n5 = this.mSurfaceView.getMeasuredState();
        this.setMeasuredDimension(TvView.resolveSizeAndState(n3, n, n5), TvView.resolveSizeAndState(n4, n2, n5 << 16));
    }

    public boolean onUnhandledInputEvent(InputEvent inputEvent) {
        return false;
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        this.mSurfaceView.setVisibility(n);
        if (n == 0) {
            this.createSessionOverlayView();
            return;
        }
        this.removeSessionOverlayView();
    }

    public void requestUnblockContent(TvContentRating tvContentRating) {
        if (this.mSession != null) {
            this.mSession.requestUnblockContent(tvContentRating);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        Object object = sMainTvViewLock;
        synchronized (object) {
            if (this == sMainTvView.get()) {
                sMainTvView = NULL_TV_VIEW;
            }
        }
        this.resetInternal();
    }

    public void selectTrack(int n, String string2) {
        if (this.mSession != null) {
            this.mSession.selectTrack(n, string2);
        }
    }

    public void sendAppPrivateCommand(String string2, Bundle bundle) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("action cannot be null or an empty string");
        }
        if (this.mSession != null) {
            this.mSession.sendAppPrivateCommand(string2, bundle);
        }
    }

    public void setCallback(TvInputCallback tvInputCallback) {
        this.mCallback = tvInputCallback;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCaptionEnabled(boolean bl) {
        int n = bl ? 1 : 2;
        this.mCaptionEnabled = n;
        if (this.mSession != null) {
            this.mSession.setCaptionEnabled(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMain() {
        Object object = sMainTvViewLock;
        synchronized (object) {
            sMainTvView = new WeakReference<TvView>(this);
            if (this.hasWindowFocus() && this.mSession != null) {
                this.mSession.setMain();
            }
            return;
        }
    }

    public void setOnUnhandledInputEventListener(OnUnhandledInputEventListener onUnhandledInputEventListener) {
        this.mOnUnhandledInputEventListener = onUnhandledInputEventListener;
    }

    public void setStreamVolume(float f) {
        this.mHasStreamVolume = true;
        this.mStreamVolume = f;
        if (this.mSession == null) {
            return;
        }
        this.mSession.setStreamVolume(f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setZOrderMediaOverlay(boolean bl) {
        if (bl) {
            this.mWindowZOrder = 1;
            this.removeSessionOverlayView();
        } else {
            this.mWindowZOrder = 0;
            this.createSessionOverlayView();
        }
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setZOrderOnTop(false);
            this.mSurfaceView.setZOrderMediaOverlay(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setZOrderOnTop(boolean bl) {
        if (bl) {
            this.mWindowZOrder = 2;
            this.removeSessionOverlayView();
        } else {
            this.mWindowZOrder = 0;
            this.createSessionOverlayView();
        }
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setZOrderMediaOverlay(false);
            this.mSurfaceView.setZOrderOnTop(bl);
        }
    }

    public void tune(String string2, Uri uri) {
        this.tune(string2, uri, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void tune(String string2, Uri uri, Bundle bundle) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("inputId cannot be null or an empty string");
        }
        Object object = sMainTvViewLock;
        // MONITORENTER : object
        if (sMainTvView.get() == null) {
            sMainTvView = new WeakReference<TvView>(this);
        }
        // MONITOREXIT : object
        if (this.mSessionCallback != null && this.mSessionCallback.mInputId.equals(string2)) {
            if (this.mSession != null) {
                this.mSession.tune(uri, bundle);
                return;
            }
            this.mSessionCallback.mChannelUri = uri;
            this.mSessionCallback.mTuneParams = bundle;
            return;
        }
        this.resetInternal();
        this.mSessionCallback = new MySessionCallback(string2, uri, bundle);
        if (this.mTvInputManager == null) return;
        this.mTvInputManager.createSession(string2, this.mSessionCallback, this.mHandler);
    }

    private class MySessionCallback
    extends TvInputManager.SessionCallback {
        Uri mChannelUri;
        final String mInputId;
        Bundle mTuneParams;

        MySessionCallback(String string2, Uri uri, Bundle bundle) {
            this.mInputId = string2;
            this.mChannelUri = uri;
            this.mTuneParams = bundle;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onChannelRetuned(TvInputManager.Session session, Uri uri) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onChannelRetuned(this.mInputId, uri);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onContentAllowed(TvInputManager.Session session) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onContentAllowed(this.mInputId);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onContentBlocked(TvInputManager.Session session, TvContentRating tvContentRating) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onContentBlocked(this.mInputId, tvContentRating);
        }

        @Override
        public void onLayoutSurface(TvInputManager.Session session, int n, int n2, int n3, int n4) {
            if (this != TvView.this.mSessionCallback) {
                return;
            }
            TvView.access$1902(TvView.this, n);
            TvView.access$2002(TvView.this, n2);
            TvView.access$2102(TvView.this, n3);
            TvView.access$2202(TvView.this, n4);
            TvView.access$2302(TvView.this, true);
            TvView.this.requestLayout();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onSessionCreated(TvInputManager.Session session) {
            int n = 1;
            if (this != TvView.this.mSessionCallback) {
                if (session == null) return;
                session.release();
                return;
            }
            TvView.access$902(TvView.this, session);
            if (session == null) {
                TvView.access$802(TvView.this, null);
                if (TvView.this.mCallback == null) return;
                TvView.this.mCallback.onConnectionFailed(this.mInputId);
                return;
            }
            Object object = sMainTvViewLock;
            // MONITORENTER : object
            if (TvView.this.hasWindowFocus() && TvView.this == sMainTvView.get()) {
                TvView.this.mSession.setMain();
            }
            // MONITOREXIT : object
            if (TvView.this.mSurface != null) {
                TvView.this.setSessionSurface(TvView.this.mSurface);
                if (TvView.this.mSurfaceChanged) {
                    TvView.this.dispatchSurfaceChanged(TvView.this.mSurfaceFormat, TvView.this.mSurfaceWidth, TvView.this.mSurfaceHeight);
                }
            }
            TvView.this.createSessionOverlayView();
            if (TvView.this.mCaptionEnabled != 0) {
                TvInputManager.Session session2 = TvView.this.mSession;
                if (TvView.this.mCaptionEnabled != n) {
                    n = 0;
                }
                session2.setCaptionEnabled(n != 0);
            }
            TvView.this.mSession.tune(this.mChannelUri, this.mTuneParams);
            if (!TvView.this.mHasStreamVolume) return;
            TvView.this.mSession.setStreamVolume(TvView.this.mStreamVolume);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSessionEvent(TvInputManager.Session session, String string2, Bundle bundle) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onEvent(this.mInputId, string2, bundle);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSessionReleased(TvInputManager.Session session) {
            block3: {
                block2: {
                    if (this != TvView.this.mSessionCallback) break block2;
                    TvView.access$1702(TvView.this, false);
                    TvView.access$1802(TvView.this, null);
                    TvView.access$802(TvView.this, null);
                    TvView.access$902(TvView.this, null);
                    if (TvView.this.mCallback != null) break block3;
                }
                return;
            }
            TvView.this.mCallback.onDisconnected(this.mInputId);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onTrackSelected(TvInputManager.Session session, int n, String string2) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onTrackSelected(this.mInputId, n, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onTracksChanged(TvInputManager.Session session, List<TvTrackInfo> list) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onTracksChanged(this.mInputId, list);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onVideoAvailable(TvInputManager.Session session) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onVideoAvailable(this.mInputId);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onVideoUnavailable(TvInputManager.Session session, int n) {
            if (this != TvView.this.mSessionCallback || TvView.this.mCallback == null) {
                return;
            }
            TvView.this.mCallback.onVideoUnavailable(this.mInputId, n);
        }
    }

    public static interface OnUnhandledInputEventListener {
        public boolean onUnhandledInputEvent(InputEvent var1);
    }

    public static abstract class TvInputCallback {
        public void onChannelRetuned(String string2, Uri uri) {
        }

        public void onConnectionFailed(String string2) {
        }

        public void onContentAllowed(String string2) {
        }

        public void onContentBlocked(String string2, TvContentRating tvContentRating) {
        }

        public void onDisconnected(String string2) {
        }

        public void onEvent(String string2, String string3, Bundle bundle) {
        }

        public void onTrackSelected(String string2, int n, String string3) {
        }

        public void onTracksChanged(String string2, List<TvTrackInfo> list) {
        }

        public void onVideoAvailable(String string2) {
        }

        public void onVideoSizeChanged(String string2, int n, int n2) {
        }

        public void onVideoUnavailable(String string2, int n) {
        }
    }
}

