/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.media.MediaScanner;
import android.mtp.MtpPropertyGroup;
import android.mtp.MtpPropertyList;
import android.mtp.MtpServer;
import android.mtp.MtpStorage;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.MediaStore;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class MtpDatabase {
    static final int[] ALL_PROPERTIES;
    static final int[] AUDIO_PROPERTIES;
    private static final int DEVICE_PROPERTIES_DATABASE_VERSION = 1;
    static final int[] FILE_PROPERTIES;
    private static final String FORMAT_PARENT_WHERE = "format=? AND parent=?";
    private static final String FORMAT_WHERE = "format=?";
    private static final String[] ID_PROJECTION;
    private static final String ID_WHERE = "_id=?";
    static final int[] IMAGE_PROPERTIES;
    private static final String[] OBJECT_INFO_PROJECTION;
    private static final String PARENT_WHERE = "parent=?";
    private static final String[] PATH_FORMAT_PROJECTION;
    private static final String[] PATH_PROJECTION;
    private static final String PATH_WHERE = "_data=?";
    private static final String STORAGE_FORMAT_PARENT_WHERE = "storage_id=? AND format=? AND parent=?";
    private static final String STORAGE_FORMAT_WHERE = "storage_id=? AND format=?";
    private static final String STORAGE_PARENT_WHERE = "storage_id=? AND parent=?";
    private static final String STORAGE_WHERE = "storage_id=?";
    private static final String TAG = "MtpDatabase";
    static final int[] VIDEO_PROPERTIES;
    private int mBatteryLevel;
    private BroadcastReceiver mBatteryReceiver;
    private int mBatteryScale;
    private final Context mContext;
    private boolean mDatabaseModified;
    private SharedPreferences mDeviceProperties;
    private final IContentProvider mMediaProvider;
    private final MediaScanner mMediaScanner;
    private final String mMediaStoragePath;
    private long mNativeContext;
    private final Uri mObjectsUri;
    private final String mPackageName;
    private final HashMap<Integer, MtpPropertyGroup> mPropertyGroupsByFormat;
    private final HashMap<Integer, MtpPropertyGroup> mPropertyGroupsByProperty;
    private MtpServer mServer;
    private final HashMap<String, MtpStorage> mStorageMap = new HashMap();
    private final String[] mSubDirectories;
    private String mSubDirectoriesWhere;
    private String[] mSubDirectoriesWhereArgs;
    private final String mVolumeName;

    static {
        ID_PROJECTION = new String[]{"_id"};
        PATH_PROJECTION = new String[]{"_id", "_data"};
        PATH_FORMAT_PROJECTION = new String[]{"_id", "_data", "format"};
        OBJECT_INFO_PROJECTION = new String[]{"_id", "storage_id", "format", "parent", "_data", "date_added", "date_modified"};
        System.loadLibrary("media_jni");
        FILE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56398};
        AUDIO_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56390, 56474, 56475, 56459, 56473, 56457, 56460, 56470, 56985, 56978, 56986, 56980, 56979};
        VIDEO_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56390, 56474, 56457, 56392};
        IMAGE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56392};
        ALL_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56392, 56390, 56474, 56475, 56459, 56473, 56457, 56460, 56470, 56390, 56474, 56457, 56392, 56392};
    }

    /*
     * Enabled aggressive block sorting
     */
    public MtpDatabase(Context context, String string2, String string3, String[] stringArray) {
        Locale locale;
        this.mPropertyGroupsByProperty = new HashMap();
        this.mPropertyGroupsByFormat = new HashMap();
        this.mBatteryReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.BATTERY_CHANGED")) {
                    MtpDatabase.access$002(MtpDatabase.this, intent.getIntExtra("scale", 0));
                    int n = intent.getIntExtra("level", 0);
                    if (n != MtpDatabase.this.mBatteryLevel) {
                        MtpDatabase.access$102(MtpDatabase.this, n);
                        if (MtpDatabase.this.mServer != null) {
                            MtpDatabase.this.mServer.sendDevicePropertyChanged(20481);
                        }
                    }
                }
            }
        };
        this.native_setup();
        this.mContext = context;
        this.mPackageName = context.getPackageName();
        this.mMediaProvider = context.getContentResolver().acquireProvider("media");
        this.mVolumeName = string2;
        this.mMediaStoragePath = string3;
        this.mObjectsUri = MediaStore.Files.getMtpObjectsUri(string2);
        this.mMediaScanner = new MediaScanner(context);
        this.mSubDirectories = stringArray;
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("_data=? OR _data LIKE ?");
                if (i == n - 1) continue;
                stringBuilder.append(" OR ");
            }
            stringBuilder.append(")");
            this.mSubDirectoriesWhere = stringBuilder.toString();
            this.mSubDirectoriesWhereArgs = new String[n * 2];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray[i];
                String[] stringArray2 = this.mSubDirectoriesWhereArgs;
                int n3 = n2 + 1;
                stringArray2[n2] = string4;
                String[] stringArray3 = this.mSubDirectoriesWhereArgs;
                n2 = n3 + 1;
                stringArray3[n3] = string4 + "/%";
            }
        }
        if ((locale = context.getResources().getConfiguration().locale) != null) {
            String string5 = locale.getLanguage();
            String string6 = locale.getCountry();
            if (string5 != null) {
                if (string6 != null) {
                    this.mMediaScanner.setLocale(string5 + "_" + string6);
                } else {
                    this.mMediaScanner.setLocale(string5);
                }
            }
        }
        this.initDeviceProperties(context);
    }

    static /* synthetic */ int access$002(MtpDatabase mtpDatabase, int n) {
        mtpDatabase.mBatteryScale = n;
        return n;
    }

    static /* synthetic */ int access$102(MtpDatabase mtpDatabase, int n) {
        mtpDatabase.mBatteryLevel = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int beginSendObject(String string2, int n, int n2, int n3, long l, long l2) {
        block12: {
            if (!this.inStorageRoot(string2)) {
                Log.e(TAG, "attempt to put file outside of storage area: " + string2);
                return -1;
            }
            if (!this.inStorageSubDirectory(string2)) {
                return -1;
            }
            if (string2 != null) {
                Cursor cursor = null;
                try {
                    cursor = this.mMediaProvider.query(this.mPackageName, this.mObjectsUri, ID_PROJECTION, PATH_WHERE, new String[]{string2}, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        Log.w(TAG, "file already exists in beginSendObject: " + string2);
                        int n4 = -1;
                        if (cursor == null) return n4;
                        cursor.close();
                        return n4;
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "RemoteException in beginSendObject", remoteException);
                }
                finally {
                    if (cursor == null) break block12;
                    cursor.close();
                }
            }
        }
        this.mDatabaseModified = true;
        ContentValues contentValues = new ContentValues();
        contentValues.put("_data", string2);
        contentValues.put("format", n);
        contentValues.put("parent", n2);
        contentValues.put("storage_id", n3);
        contentValues.put("_size", l);
        contentValues.put("date_modified", l2);
        try {
            Uri uri = this.mMediaProvider.insert(this.mPackageName, this.mObjectsUri, contentValues);
            if (uri == null) return -1;
            return Integer.parseInt(uri.getPathSegments().get(2));
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in beginSendObject", remoteException);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cursor createObjectQuery(int n, int n2, int n3) throws RemoteException {
        int n4;
        String[] stringArray;
        String string2;
        block20: {
            block21: {
                if (n != -1) break block21;
                if (n2 == 0) {
                    if (n3 == 0) {
                        string2 = null;
                        stringArray = null;
                        break block20;
                    } else {
                        if (n3 == -1) {
                            n3 = 0;
                        }
                        string2 = PARENT_WHERE;
                        stringArray = new String[]{Integer.toString(n3)};
                    }
                    break block20;
                } else if (n3 == 0) {
                    string2 = FORMAT_WHERE;
                    stringArray = new String[]{Integer.toString(n2)};
                    break block20;
                } else {
                    if (n3 == -1) {
                        n3 = 0;
                    }
                    string2 = FORMAT_PARENT_WHERE;
                    stringArray = new String[]{Integer.toString(n2), Integer.toString(n3)};
                }
                break block20;
            }
            if (n2 == 0) {
                if (n3 == 0) {
                    string2 = STORAGE_WHERE;
                    stringArray = new String[]{Integer.toString(n)};
                } else {
                    if (n3 == -1) {
                        n3 = 0;
                    }
                    string2 = STORAGE_PARENT_WHERE;
                    stringArray = new String[]{Integer.toString(n), Integer.toString(n3)};
                }
            } else if (n3 == 0) {
                string2 = STORAGE_FORMAT_WHERE;
                stringArray = new String[]{Integer.toString(n), Integer.toString(n2)};
            } else {
                if (n3 == -1) {
                    n3 = 0;
                }
                string2 = STORAGE_FORMAT_PARENT_WHERE;
                stringArray = new String[]{Integer.toString(n), Integer.toString(n2), Integer.toString(n3)};
            }
        }
        if (this.mSubDirectoriesWhere == null) return this.mMediaProvider.query(this.mPackageName, this.mObjectsUri, ID_PROJECTION, string2, stringArray, null, null);
        if (string2 == null) {
            string2 = this.mSubDirectoriesWhere;
            stringArray = this.mSubDirectoriesWhereArgs;
            return this.mMediaProvider.query(this.mPackageName, this.mObjectsUri, ID_PROJECTION, string2, stringArray, null, null);
        }
        string2 = string2 + " AND " + this.mSubDirectoriesWhere;
        String[] stringArray2 = new String[stringArray.length + this.mSubDirectoriesWhereArgs.length];
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            stringArray2[n4] = stringArray[n4];
        }
        int n5 = 0;
        while (true) {
            if (n5 >= this.mSubDirectoriesWhereArgs.length) {
                stringArray = stringArray2;
                return this.mMediaProvider.query(this.mPackageName, this.mObjectsUri, ID_PROJECTION, string2, stringArray, null, null);
            }
            stringArray2[n4] = this.mSubDirectoriesWhereArgs[n5];
            ++n4;
            ++n5;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int deleteFile(int var1_1) {
        block16: {
            this.mDatabaseModified = true;
            var2_2 = null;
            var7_3 = this.mMediaProvider;
            var8_4 = this.mPackageName;
            var9_5 = this.mObjectsUri;
            var10_6 = MtpDatabase.PATH_FORMAT_PROJECTION;
            var11_7 = new String[]{Integer.toString(var1_1)};
            var2_2 = var7_3.query(var8_4, var9_5, var10_6, "_id=?", var11_7, null, null);
            if (var2_2 == null || !var2_2.moveToNext()) ** GOTO lbl32
            var12_8 = var2_2.getString(1);
            var13_9 = var2_2.getInt(2);
            if (var12_8 == null || var13_9 == 0) {
                var6_10 = 8194;
                if (var2_2 == null) return var6_10;
                var2_2.close();
                return var6_10;
            }
            ** GOTO lbl-1000
            {
                catch (RemoteException var4_20) {
                    Log.e("MtpDatabase", "RemoteException in deleteFile", var4_20);
                    var6_10 = 8194;
                    if (var2_2 == null) return var6_10;
                    var2_2.close();
                    return var6_10;
                }
                catch (Throwable var3_21) {
                    if (var2_2 == null) throw var3_21;
                    var2_2.close();
                    throw var3_21;
                }
lbl30:
                // 4 sources

                return var6_10;
lbl32:
                // 1 sources

                var6_10 = 8201;
                if (var2_2 == null) ** GOTO lbl30
                var2_2.close();
                return var6_10;
lbl-1000:
                // 1 sources

                {
                    block17: {
                        var14_11 = this.isStorageSubDirectory(var12_8);
                        if (!var14_11) break block17;
                        var6_10 = 8205;
                        if (var2_2 == null) ** GOTO lbl30
                        var2_2.close();
                        return var6_10;
                    }
                    if (var13_9 != 12289) ** GOTO lbl50
                }
                {
                    var21_12 = MediaStore.Files.getMtpObjectsUri(this.mVolumeName);
                    var22_13 = this.mMediaProvider;
                    var23_14 = this.mPackageName;
                    var24_15 = new String[]{var12_8 + "/%", Integer.toString(1 + var12_8.length()), var12_8 + "/"};
                    var22_13.delete(var23_14, var21_12, "_data LIKE ?1 AND lower(substr(_data,1,?2))=lower(?3)", var24_15);
lbl50:
                    // 2 sources

                    if (this.mMediaProvider.delete(this.mPackageName, var15_16 = MediaStore.Files.getMtpObjectsUri(this.mVolumeName, var1_1), null, null) <= 0) break block16;
                    if (var13_9 == 12289 || !(var16_17 = var12_8.toLowerCase(Locale.US).endsWith("/.nomedia"))) ** GOTO lbl56
                }
                try {
                    var19_18 = var12_8.substring(0, var12_8.lastIndexOf("/"));
                    this.mMediaProvider.call(this.mPackageName, "unhide", var19_18, null);
lbl56:
                    // 3 sources

                    while (true) {
                        var6_10 = 8193;
                        if (var2_2 == null) ** GOTO lbl30
                        var2_2.close();
                        return var6_10;
                    }
                }
                catch (RemoteException var17_19) {}
                {
                    Log.e("MtpDatabase", "failed to unhide/rescan for " + var12_8);
                    ** continue;
                }
            }
        }
        var6_10 = 8201;
        ** while (var2_2 == null)
lbl68:
        // 1 sources

        var2_2.close();
        return var6_10;
    }

    private void endSendObject(String string2, int n, int n2, boolean bl) {
        if (bl) {
            if (n2 == 47621) {
                String string3 = string2;
                int n3 = string3.lastIndexOf(47);
                if (n3 >= 0) {
                    string3 = string3.substring(n3 + 1);
                }
                if (string3.endsWith(".pla")) {
                    string3 = string3.substring(0, -4 + string3.length());
                }
                ContentValues contentValues = new ContentValues(1);
                contentValues.put("_data", string2);
                contentValues.put("name", string3);
                contentValues.put("format", n2);
                contentValues.put("date_modified", System.currentTimeMillis() / 1000L);
                contentValues.put("media_scanner_new_object_id", n);
                try {
                    this.mMediaProvider.insert(this.mPackageName, MediaStore.Audio.Playlists.EXTERNAL_CONTENT_URI, contentValues);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "RemoteException in endSendObject", remoteException);
                    return;
                }
            }
            this.mMediaScanner.scanMtpFile(string2, this.mVolumeName, n, n2);
            return;
        }
        this.deleteFile(n);
    }

    private int getDeviceProperty(int n, long[] lArray, char[] cArray) {
        switch (n) {
            default: {
                return 8202;
            }
            case 54273: 
            case 54274: {
                String string2 = this.mDeviceProperties.getString(Integer.toString(n), "");
                int n2 = string2.length();
                if (n2 > 255) {
                    n2 = 255;
                }
                string2.getChars(0, n2, cArray, 0);
                cArray[n2] = '\u0000';
                return 8193;
            }
            case 20483: 
        }
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        int n3 = display.getMaximumSizeDimension();
        int n4 = display.getMaximumSizeDimension();
        String string3 = Integer.toString(n3) + "x" + Integer.toString(n4);
        string3.getChars(0, string3.length(), cArray, 0);
        cArray[string3.length()] = '\u0000';
        return 8193;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getNumObjects(int n, int n2, int n3) {
        Cursor cursor;
        block9: {
            cursor = null;
            cursor = this.createObjectQuery(n, n2, n3);
            if (cursor == null) break block9;
            try {
                int n4 = cursor.getCount();
                if (cursor == null) return n4;
                cursor.close();
                return n4;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in getNumObjects", remoteException);
                return -1;
            }
            finally {
                if (cursor == null) return -1;
                cursor.close();
                return -1;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getObjectFilePath(int n, char[] cArray, long[] lArray) {
        int n2;
        Cursor cursor;
        block6: {
            if (n == 0) {
                this.mMediaStoragePath.getChars(0, this.mMediaStoragePath.length(), cArray, 0);
                cArray[this.mMediaStoragePath.length()] = '\u0000';
                lArray[0] = 0L;
                lArray[1] = 12289L;
                return 8193;
            }
            cursor = null;
            IContentProvider iContentProvider = this.mMediaProvider;
            String string2 = this.mPackageName;
            Uri uri = this.mObjectsUri;
            String[] stringArray = PATH_FORMAT_PROJECTION;
            String[] stringArray2 = new String[]{Integer.toString(n)};
            cursor = iContentProvider.query(string2, uri, stringArray, ID_WHERE, stringArray2, null, null);
            if (cursor == null) break block6;
            try {
                if (!cursor.moveToNext()) break block6;
                String string3 = cursor.getString(1);
                string3.getChars(0, string3.length(), cArray, 0);
                cArray[string3.length()] = '\u0000';
                lArray[0] = new File(string3).length();
                lArray[1] = cursor.getLong(2);
                if (cursor == null) return 8193;
                cursor.close();
                return 8193;
            }
            catch (RemoteException remoteException) {
                try {
                    Log.e(TAG, "RemoteException in getObjectFilePath", remoteException);
                    n2 = 8194;
                    if (cursor == null) return n2;
                    cursor.close();
                    return n2;
                }
                catch (Throwable throwable) {
                    if (cursor == null) throw throwable;
                    cursor.close();
                    throw throwable;
                }
            }
        }
        n2 = 8201;
        if (cursor == null) return n2;
        cursor.close();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getObjectInfo(int n, int[] nArray, char[] cArray, long[] lArray) {
        Cursor cursor = null;
        try {
            IContentProvider iContentProvider = this.mMediaProvider;
            String string2 = this.mPackageName;
            Uri uri = this.mObjectsUri;
            String[] stringArray = OBJECT_INFO_PROJECTION;
            String[] stringArray2 = new String[]{Integer.toString(n)};
            cursor = iContentProvider.query(string2, uri, stringArray, ID_WHERE, stringArray2, null, null);
            if (cursor != null && cursor.moveToNext()) {
                nArray[0] = cursor.getInt(1);
                nArray[1] = cursor.getInt(2);
                nArray[2] = cursor.getInt(3);
                String string3 = cursor.getString(4);
                int n2 = string3.lastIndexOf(47);
                int n3 = n2 >= 0 ? n2 + 1 : 0;
                int n4 = string3.length();
                if (n4 - n3 > 255) {
                    n4 = n3 + 255;
                }
                string3.getChars(n3, n4, cArray, 0);
                cArray[n4 - n3] = '\u0000';
                lArray[0] = cursor.getLong(5);
                lArray[1] = cursor.getLong(6);
                if (lArray[0] == 0L) {
                    lArray[0] = lArray[1];
                }
                if (cursor == null) return true;
                cursor.close();
                return true;
            }
            if (cursor == null) return false;
            cursor.close();
            return false;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getObjectInfo", remoteException);
            return false;
        }
        finally {
            if (cursor == null) return false;
            cursor.close();
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] getObjectList(int n, int n2, int n3) {
        int[] nArray;
        Cursor cursor = null;
        try {
            Cursor cursor2;
            cursor = cursor2 = this.createObjectQuery(n, n2, n3);
            if (cursor == null) {
                if (cursor != null) {
                    cursor.close();
                }
                nArray = null;
                return nArray;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getObjectList", remoteException);
            return null;
        }
        {
            int n4 = cursor.getCount();
            if (n4 > 0) {
                nArray = new int[n4];
                int n5 = 0;
                while (true) {
                    if (n5 >= n4) {
                        if (cursor == null) return nArray;
                        cursor.close();
                        return nArray;
                    }
                    cursor.moveToNext();
                    nArray[n5] = cursor.getInt(0);
                    ++n5;
                }
            }
            if (cursor == null) return null;
            cursor.close();
        }
        return null;
        finally {
            if (cursor == null) return null;
            cursor.close();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private MtpPropertyList getObjectPropertyList(long l, int n, long l2, int n2, int n3) {
        MtpPropertyGroup mtpPropertyGroup;
        if (n2 != 0) {
            return new MtpPropertyList(0, 43015);
        }
        if (l2 == 0xFFFFFFFFL) {
            mtpPropertyGroup = this.mPropertyGroupsByFormat.get(n);
            if (mtpPropertyGroup != null) return mtpPropertyGroup.getPropertyList((int)l, n, n3);
            int[] nArray = this.getSupportedObjectProperties(n);
            mtpPropertyGroup = new MtpPropertyGroup(this, this.mMediaProvider, this.mPackageName, this.mVolumeName, nArray);
            this.mPropertyGroupsByFormat.put(new Integer(n), mtpPropertyGroup);
            return mtpPropertyGroup.getPropertyList((int)l, n, n3);
        }
        mtpPropertyGroup = this.mPropertyGroupsByProperty.get(l2);
        if (mtpPropertyGroup != null) return mtpPropertyGroup.getPropertyList((int)l, n, n3);
        int[] nArray = new int[]{(int)l2};
        mtpPropertyGroup = new MtpPropertyGroup(this, this.mMediaProvider, this.mPackageName, this.mVolumeName, nArray);
        this.mPropertyGroupsByProperty.put(new Integer((int)l2), mtpPropertyGroup);
        return mtpPropertyGroup.getPropertyList((int)l, n, n3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] getObjectReferences(int n) {
        int[] nArray;
        Uri uri = MediaStore.Files.getMtpReferencesUri(this.mVolumeName, n);
        Cursor cursor = null;
        try {
            Cursor cursor2;
            cursor = cursor2 = this.mMediaProvider.query(this.mPackageName, uri, ID_PROJECTION, null, null, null, null);
            if (cursor == null) {
                if (cursor != null) {
                    cursor.close();
                }
                nArray = null;
                return nArray;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getObjectList", remoteException);
            return null;
        }
        {
            int n2 = cursor.getCount();
            if (n2 > 0) {
                nArray = new int[n2];
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        if (cursor == null) return nArray;
                        cursor.close();
                        return nArray;
                    }
                    cursor.moveToNext();
                    nArray[n3] = cursor.getInt(0);
                    ++n3;
                }
            }
            if (cursor == null) return null;
            cursor.close();
        }
        return null;
        finally {
            if (cursor == null) return null;
            cursor.close();
            return null;
        }
    }

    private int[] getSupportedCaptureFormats() {
        return null;
    }

    private int[] getSupportedDeviceProperties() {
        return new int[]{54273, 54274, 20483, 20481};
    }

    private int[] getSupportedObjectProperties(int n) {
        switch (n) {
            default: {
                return FILE_PROPERTIES;
            }
            case 12296: 
            case 12297: 
            case 47361: 
            case 47362: 
            case 47363: {
                return AUDIO_PROPERTIES;
            }
            case 12299: 
            case 47489: 
            case 47492: {
                return VIDEO_PROPERTIES;
            }
            case 14337: 
            case 14340: 
            case 14343: 
            case 14347: {
                return IMAGE_PROPERTIES;
            }
            case 0: 
        }
        return ALL_PROPERTIES;
    }

    private int[] getSupportedPlaybackFormats() {
        return new int[]{12288, 12289, 12292, 12293, 12296, 12297, 12299, 14337, 14338, 14340, 14343, 14344, 14347, 14349, 47361, 47362, 47363, 47490, 47491, 47492, 47621, 47632, 47633, 47636, 47746, 47366};
    }

    private boolean inStorageRoot(String string2) {
        try {
            String string3 = new File(string2).getCanonicalPath();
            Iterator<String> iterator = this.mStorageMap.keySet().iterator();
            while (iterator.hasNext()) {
                boolean bl = string3.startsWith(iterator.next());
                if (!bl) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inStorageSubDirectory(String string2) {
        if (this.mSubDirectories == null) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        int n = string2.length();
        int n2 = 0;
        while (n2 < this.mSubDirectories.length) {
            if (bl) return bl;
            String string3 = this.mSubDirectories[n2];
            int n3 = string3.length();
            if (n3 < n && string2.charAt(n3) == '/' && string2.startsWith(string3)) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDeviceProperties(Context var1_1) {
        block12: {
            this.mDeviceProperties = var1_1.getSharedPreferences("device-properties", 0);
            if (!var1_1.getDatabasePath("device-properties").exists()) return;
            var2_2 = null;
            var3_3 = null;
            try {
                try {
                    var2_2 = var1_1.openOrCreateDatabase("device-properties", 0, null);
                    var3_3 = null;
                    if (var2_2 == null || (var3_3 = var2_2.query("properties", new String[]{"_id", "code", "value"}, null, null, null, null, null)) == null) break block12;
                    var8_4 = this.mDeviceProperties.edit();
                    while (var3_3.moveToNext()) {
                        var8_4.putString(var3_3.getString(1), var3_3.getString(2));
                    }
                }
                catch (Exception var5_5) {
                    Log.e("MtpDatabase", "failed to migrate device properties", var5_5);
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
lbl23:
                    // 5 sources

                    while (true) {
                        var1_1.deleteDatabase("device-properties");
                        return;
                    }
                }
            }
            catch (Throwable var4_6) {
                if (var3_3 != null) {
                    var3_3.close();
                }
                if (var2_2 == null) throw var4_6;
                var2_2.close();
                throw var4_6;
            }
            {
                var8_4.commit();
            }
        }
        if (var3_3 != null) {
            var3_3.close();
        }
        if (var2_2 == null) ** GOTO lbl23
        var2_2.close();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isStorageSubDirectory(String string2) {
        if (this.mSubDirectories != null) {
            for (int i = 0; i < this.mSubDirectories.length; ++i) {
                if (!string2.equals(this.mSubDirectories[i])) continue;
                return true;
            }
        }
        return false;
    }

    private final native void native_finalize();

    private final native void native_setup();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int renameFile(int n, String string2) {
        int n2;
        String string3;
        Cursor cursor = null;
        String[] stringArray = new String[]{Integer.toString(n)};
        try {
            cursor = this.mMediaProvider.query(this.mPackageName, this.mObjectsUri, PATH_PROJECTION, ID_WHERE, stringArray, null, null);
            string3 = null;
            if (cursor != null) {
                boolean bl = cursor.moveToNext();
                string3 = null;
                if (bl) {
                    String string4;
                    string3 = string4 = cursor.getString(1);
                }
            }
            if (cursor != null) {
                cursor.close();
            }
            if (string3 == null) {
                return 8201;
            }
        }
        catch (RemoteException remoteException) {
            try {
                Log.e(TAG, "RemoteException in getObjectFilePath", remoteException);
                int n3 = 8194;
                if (cursor == null) return n3;
                cursor.close();
                return n3;
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
        }
        if (this.isStorageSubDirectory(string3)) {
            return 8205;
        }
        File file = new File(string3);
        int n4 = string3.lastIndexOf(47);
        if (n4 <= 1) {
            return 8194;
        }
        String string5 = string3.substring(0, n4 + 1) + string2;
        File file2 = new File(string5);
        if (!file.renameTo(file2)) {
            Log.w(TAG, "renaming " + string3 + " to " + string5 + " failed");
            return 8194;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("_data", string5);
        try {
            int n5;
            n2 = n5 = this.mMediaProvider.update(this.mPackageName, this.mObjectsUri, contentValues, ID_WHERE, stringArray);
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in mMediaProvider.update", remoteException);
            n2 = 0;
        }
        if (n2 == 0) {
            Log.e(TAG, "Unable to update path for " + string3 + " to " + string5);
            file2.renameTo(file);
            return 8194;
        }
        if (file2.isDirectory()) {
            if (!file.getName().startsWith(".")) return 8193;
            if (string5.startsWith(".")) return 8193;
            try {
                this.mMediaProvider.call(this.mPackageName, "unhide", string5, null);
                return 8193;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "failed to unhide/rescan for " + string5);
                return 8193;
            }
        }
        if (!file.getName().toLowerCase(Locale.US).equals(".nomedia")) return 8193;
        if (string5.toLowerCase(Locale.US).equals(".nomedia")) return 8193;
        try {
            this.mMediaProvider.call(this.mPackageName, "unhide", file.getParent(), null);
            return 8193;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to unhide/rescan for " + string5);
            return 8193;
        }
    }

    private void sessionEnded() {
        if (this.mDatabaseModified) {
            this.mContext.sendBroadcast(new Intent("android.provider.action.MTP_SESSION_END"));
            this.mDatabaseModified = false;
        }
    }

    private void sessionStarted() {
        this.mDatabaseModified = false;
    }

    private int setDeviceProperty(int n, long l, String string2) {
        switch (n) {
            default: {
                return 8202;
            }
            case 54273: 
            case 54274: 
        }
        SharedPreferences.Editor editor = this.mDeviceProperties.edit();
        editor.putString(Integer.toString(n), string2);
        if (editor.commit()) {
            return 8193;
        }
        return 8194;
    }

    private int setObjectProperty(int n, int n2, long l, String string2) {
        switch (n2) {
            default: {
                return 43018;
            }
            case 56327: 
        }
        return this.renameFile(n, string2);
    }

    private int setObjectReferences(int n, int[] nArray) {
        this.mDatabaseModified = true;
        Uri uri = MediaStore.Files.getMtpReferencesUri(this.mVolumeName, n);
        int n2 = nArray.length;
        ContentValues[] contentValuesArray = new ContentValues[n2];
        for (int i = 0; i < n2; ++i) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("_id", nArray[i]);
            contentValuesArray[i] = contentValues;
        }
        try {
            int n3 = this.mMediaProvider.bulkInsert(this.mPackageName, uri, contentValuesArray);
            if (n3 > 0) {
                return 8193;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in setObjectReferences", remoteException);
        }
        return 8194;
    }

    public void addStorage(MtpStorage mtpStorage) {
        this.mStorageMap.put(mtpStorage.getPath(), mtpStorage);
    }

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void removeStorage(MtpStorage mtpStorage) {
        this.mStorageMap.remove(mtpStorage.getPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServer(MtpServer mtpServer) {
        this.mServer = mtpServer;
        try {
            this.mContext.unregisterReceiver(this.mBatteryReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (mtpServer != null) {
            this.mContext.registerReceiver(this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }
}

