/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.Context;
import android.os.storage.StorageVolume;

public class MtpStorage {
    private final String mDescription;
    private final long mMaxFileSize;
    private final String mPath;
    private final boolean mRemovable;
    private final long mReserveSpace;
    private final int mStorageId;

    public MtpStorage(StorageVolume storageVolume, Context context) {
        this.mStorageId = storageVolume.getStorageId();
        this.mPath = storageVolume.getPath();
        this.mDescription = context.getResources().getString(storageVolume.getDescriptionId());
        this.mReserveSpace = 1024L * (1024L * (long)storageVolume.getMtpReserveSpace());
        this.mRemovable = storageVolume.isRemovable();
        this.mMaxFileSize = storageVolume.getMaxFileSize();
    }

    public static int getStorageId(int n) {
        return 1 + (n + 1 << 16);
    }

    public final String getDescription() {
        return this.mDescription;
    }

    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }

    public final String getPath() {
        return this.mPath;
    }

    public final long getReserveSpace() {
        return this.mReserveSpace;
    }

    public final int getStorageId() {
        return this.mStorageId;
    }

    public final boolean isRemovable() {
        return this.mRemovable;
    }
}

