/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ProxyInfo;
import android.net.StaticIpConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class IpConfiguration
implements Parcelable {
    public static final Parcelable.Creator<IpConfiguration> CREATOR = new Parcelable.Creator<IpConfiguration>(){

        @Override
        public IpConfiguration createFromParcel(Parcel parcel) {
            IpConfiguration ipConfiguration = new IpConfiguration();
            ipConfiguration.ipAssignment = IpAssignment.valueOf(parcel.readString());
            ipConfiguration.proxySettings = ProxySettings.valueOf(parcel.readString());
            ipConfiguration.staticIpConfiguration = (StaticIpConfiguration)parcel.readParcelable(null);
            ipConfiguration.httpProxy = (ProxyInfo)parcel.readParcelable(null);
            return ipConfiguration;
        }

        public IpConfiguration[] newArray(int n) {
            return new IpConfiguration[n];
        }
    };
    private static final String TAG = "IpConfiguration";
    public ProxyInfo httpProxy;
    public IpAssignment ipAssignment;
    public ProxySettings proxySettings;
    public StaticIpConfiguration staticIpConfiguration;

    public IpConfiguration() {
        this.init(IpAssignment.UNASSIGNED, ProxySettings.UNASSIGNED, null, null);
    }

    public IpConfiguration(IpAssignment ipAssignment, ProxySettings proxySettings, StaticIpConfiguration staticIpConfiguration, ProxyInfo proxyInfo) {
        this.init(ipAssignment, proxySettings, staticIpConfiguration, proxyInfo);
    }

    public IpConfiguration(IpConfiguration ipConfiguration) {
        this();
        if (ipConfiguration != null) {
            this.init(ipConfiguration.ipAssignment, ipConfiguration.proxySettings, ipConfiguration.staticIpConfiguration, ipConfiguration.httpProxy);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(IpAssignment ipAssignment, ProxySettings proxySettings, StaticIpConfiguration staticIpConfiguration, ProxyInfo proxyInfo) {
        this.ipAssignment = ipAssignment;
        this.proxySettings = proxySettings;
        StaticIpConfiguration staticIpConfiguration2 = staticIpConfiguration == null ? null : new StaticIpConfiguration(staticIpConfiguration);
        this.staticIpConfiguration = staticIpConfiguration2;
        ProxyInfo proxyInfo2 = null;
        if (proxyInfo != null) {
            proxyInfo2 = new ProxyInfo(proxyInfo);
        }
        this.httpProxy = proxyInfo2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof IpConfiguration)) {
                    return false;
                }
                IpConfiguration ipConfiguration = (IpConfiguration)object;
                if (this.ipAssignment != ipConfiguration.ipAssignment || this.proxySettings != ipConfiguration.proxySettings || !Objects.equals(this.staticIpConfiguration, ipConfiguration.staticIpConfiguration) || !Objects.equals(this.httpProxy, ipConfiguration.httpProxy)) break block5;
            }
            return true;
        }
        return false;
    }

    public ProxyInfo getHttpProxy() {
        return this.httpProxy;
    }

    public IpAssignment getIpAssignment() {
        return this.ipAssignment;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public StaticIpConfiguration getStaticIpConfiguration() {
        return this.staticIpConfiguration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        if (this.staticIpConfiguration != null) {
            n = this.staticIpConfiguration.hashCode();
            return n + 13 + 17 * this.ipAssignment.ordinal() + 47 * this.proxySettings.ordinal() + 83 * this.httpProxy.hashCode();
        }
        n = 0;
        return n + 13 + 17 * this.ipAssignment.ordinal() + 47 * this.proxySettings.ordinal() + 83 * this.httpProxy.hashCode();
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        this.httpProxy = proxyInfo;
    }

    public void setIpAssignment(IpAssignment ipAssignment) {
        this.ipAssignment = ipAssignment;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public void setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this.staticIpConfiguration = staticIpConfiguration;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IP assignment: " + this.ipAssignment.toString());
        stringBuilder.append("\n");
        if (this.staticIpConfiguration != null) {
            stringBuilder.append("Static configuration: " + this.staticIpConfiguration.toString());
            stringBuilder.append("\n");
        }
        stringBuilder.append("Proxy settings: " + this.proxySettings.toString());
        stringBuilder.append("\n");
        if (this.httpProxy != null) {
            stringBuilder.append("HTTP proxy: " + this.httpProxy.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.ipAssignment.name());
        parcel.writeString(this.proxySettings.name());
        parcel.writeParcelable(this.staticIpConfiguration, n);
        parcel.writeParcelable(this.httpProxy, n);
    }

    public static final class IpAssignment
    extends Enum<IpAssignment> {
        private static final /* synthetic */ IpAssignment[] $VALUES;
        public static final /* enum */ IpAssignment DHCP;
        public static final /* enum */ IpAssignment STATIC;
        public static final /* enum */ IpAssignment UNASSIGNED;

        static {
            STATIC = new IpAssignment();
            DHCP = new IpAssignment();
            UNASSIGNED = new IpAssignment();
            IpAssignment[] ipAssignmentArray = new IpAssignment[]{STATIC, DHCP, UNASSIGNED};
            $VALUES = ipAssignmentArray;
        }

        public static IpAssignment valueOf(String string2) {
            return Enum.valueOf(IpAssignment.class, string2);
        }

        public static IpAssignment[] values() {
            return (IpAssignment[])$VALUES.clone();
        }
    }

    public static final class ProxySettings
    extends Enum<ProxySettings> {
        private static final /* synthetic */ ProxySettings[] $VALUES;
        public static final /* enum */ ProxySettings NONE = new ProxySettings();
        public static final /* enum */ ProxySettings PAC;
        public static final /* enum */ ProxySettings STATIC;
        public static final /* enum */ ProxySettings UNASSIGNED;

        static {
            STATIC = new ProxySettings();
            UNASSIGNED = new ProxySettings();
            PAC = new ProxySettings();
            ProxySettings[] proxySettingsArray = new ProxySettings[]{NONE, STATIC, UNASSIGNED, PAC};
            $VALUES = proxySettingsArray;
        }

        public static ProxySettings valueOf(String string2) {
            return Enum.valueOf(ProxySettings.class, string2);
        }

        public static ProxySettings[] values() {
            return (ProxySettings[])$VALUES.clone();
        }
    }
}

