/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class IpPrefix
implements Parcelable {
    public static final Parcelable.Creator<IpPrefix> CREATOR = new Parcelable.Creator<IpPrefix>(){

        @Override
        public IpPrefix createFromParcel(Parcel parcel) {
            return new IpPrefix(parcel.createByteArray(), parcel.readInt());
        }

        public IpPrefix[] newArray(int n) {
            return new IpPrefix[n];
        }
    };
    private final byte[] address;
    private final int prefixLength;

    public IpPrefix(String string2) {
        Pair<InetAddress, Integer> pair = NetworkUtils.parseIpAndMask(string2);
        this.address = ((InetAddress)pair.first).getAddress();
        this.prefixLength = (Integer)pair.second;
        this.checkAndMaskAddressAndPrefixLength();
    }

    public IpPrefix(InetAddress inetAddress, int n) {
        this.address = inetAddress.getAddress();
        this.prefixLength = n;
        this.checkAndMaskAddressAndPrefixLength();
    }

    public IpPrefix(byte[] byArray, int n) {
        this.address = (byte[])byArray.clone();
        this.prefixLength = n;
        this.checkAndMaskAddressAndPrefixLength();
    }

    private void checkAndMaskAddressAndPrefixLength() {
        if (this.address.length != 4 && this.address.length != 16) {
            throw new IllegalArgumentException("IpPrefix has " + this.address.length + " bytes which is neither 4 nor 16");
        }
        NetworkUtils.maskRawAddress(this.address, this.prefixLength);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof IpPrefix)) break block2;
                IpPrefix ipPrefix = (IpPrefix)object;
                if (Arrays.equals(this.address, ipPrefix.address) && this.prefixLength == ipPrefix.prefixLength) break block3;
            }
            return false;
        }
        return true;
    }

    public InetAddress getAddress() {
        try {
            InetAddress inetAddress = InetAddress.getByAddress(this.address);
            return inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public byte[] getRawAddress() {
        return (byte[])this.address.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.address) + 11 * this.prefixLength;
    }

    public String toString() {
        try {
            String string2 = InetAddress.getByAddress(this.address).getHostAddress() + "/" + this.prefixLength;
            return string2;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalStateException("IpPrefix with invalid address! Shouldn't happen.", unknownHostException);
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.address);
        parcel.writeInt(this.prefixLength);
    }
}

