/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpDeclinePacket;
import android.net.dhcp.DhcpDiscoverPacket;
import android.net.dhcp.DhcpInformPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpRequestPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class DhcpPacket {
    protected static final byte CLIENT_ID_ETHER = 1;
    protected static final byte DHCP_BOOTREPLY = 2;
    protected static final byte DHCP_BOOTREQUEST = 1;
    protected static final byte DHCP_BROADCAST_ADDRESS = 28;
    static final short DHCP_CLIENT = 68;
    protected static final byte DHCP_CLIENT_IDENTIFIER = 61;
    protected static final byte DHCP_DNS_SERVER = 6;
    protected static final byte DHCP_DOMAIN_NAME = 15;
    protected static final byte DHCP_HOST_NAME = 12;
    protected static final byte DHCP_LEASE_TIME = 51;
    protected static final byte DHCP_MESSAGE = 56;
    protected static final byte DHCP_MESSAGE_TYPE = 53;
    protected static final byte DHCP_MESSAGE_TYPE_ACK = 5;
    protected static final byte DHCP_MESSAGE_TYPE_DECLINE = 4;
    protected static final byte DHCP_MESSAGE_TYPE_DISCOVER = 1;
    protected static final byte DHCP_MESSAGE_TYPE_INFORM = 8;
    protected static final byte DHCP_MESSAGE_TYPE_NAK = 6;
    protected static final byte DHCP_MESSAGE_TYPE_OFFER = 2;
    protected static final byte DHCP_MESSAGE_TYPE_REQUEST = 3;
    protected static final byte DHCP_PARAMETER_LIST = 55;
    protected static final byte DHCP_RENEWAL_TIME = 58;
    protected static final byte DHCP_REQUESTED_IP = 50;
    protected static final byte DHCP_ROUTER = 3;
    static final short DHCP_SERVER = 67;
    protected static final byte DHCP_SERVER_IDENTIFIER = 54;
    protected static final byte DHCP_SUBNET_MASK = 1;
    protected static final byte DHCP_VENDOR_CLASS_ID = 60;
    public static final int ENCAP_BOOTP = 2;
    public static final int ENCAP_L2 = 0;
    public static final int ENCAP_L3 = 1;
    private static final short IP_FLAGS_OFFSET = 16384;
    private static final byte IP_TOS_LOWDELAY = 16;
    private static final byte IP_TTL = 64;
    private static final byte IP_TYPE_UDP = 17;
    private static final byte IP_VERSION_HEADER_LEN = 69;
    protected static final int MAX_LENGTH = 1500;
    protected static final String TAG = "DhcpPacket";
    protected boolean mBroadcast;
    protected InetAddress mBroadcastAddress;
    protected final InetAddress mClientIp;
    protected final byte[] mClientMac;
    protected List<InetAddress> mDnsServers;
    protected String mDomainName;
    protected InetAddress mGateway;
    protected String mHostName;
    protected Integer mLeaseTime;
    protected String mMessage;
    private final InetAddress mNextIp;
    private final InetAddress mRelayIp;
    protected InetAddress mRequestedIp;
    protected byte[] mRequestedParams;
    protected InetAddress mServerIdentifier;
    protected InetAddress mSubnetMask;
    protected final int mTransId;
    protected final InetAddress mYourIp;

    protected DhcpPacket(int n, InetAddress inetAddress, InetAddress inetAddress2, InetAddress inetAddress3, InetAddress inetAddress4, byte[] byArray, boolean bl) {
        this.mTransId = n;
        this.mClientIp = inetAddress;
        this.mYourIp = inetAddress2;
        this.mNextIp = inetAddress3;
        this.mRelayIp = inetAddress4;
        this.mClientMac = byArray;
        this.mBroadcast = bl;
    }

    public static ByteBuffer buildAckPacket(int n, int n2, boolean bl, InetAddress inetAddress, InetAddress inetAddress2, byte[] byArray, Integer n3, InetAddress inetAddress3, InetAddress inetAddress4, InetAddress inetAddress5, List<InetAddress> list, InetAddress inetAddress6, String string2) {
        DhcpAckPacket dhcpAckPacket = new DhcpAckPacket(n2, bl, inetAddress, inetAddress2, byArray);
        dhcpAckPacket.mGateway = inetAddress5;
        dhcpAckPacket.mDnsServers = list;
        dhcpAckPacket.mLeaseTime = n3;
        dhcpAckPacket.mDomainName = string2;
        dhcpAckPacket.mSubnetMask = inetAddress3;
        dhcpAckPacket.mServerIdentifier = inetAddress6;
        dhcpAckPacket.mBroadcastAddress = inetAddress4;
        return ((DhcpPacket)dhcpAckPacket).buildPacket(n, (short)68, (short)67);
    }

    public static ByteBuffer buildDiscoverPacket(int n, int n2, byte[] byArray, boolean bl, byte[] byArray2) {
        DhcpDiscoverPacket dhcpDiscoverPacket = new DhcpDiscoverPacket(n2, byArray, bl);
        dhcpDiscoverPacket.mRequestedParams = byArray2;
        return ((DhcpPacket)dhcpDiscoverPacket).buildPacket(n, (short)67, (short)68);
    }

    public static ByteBuffer buildNakPacket(int n, int n2, InetAddress inetAddress, InetAddress inetAddress2, byte[] byArray) {
        DhcpNakPacket dhcpNakPacket = new DhcpNakPacket(n2, inetAddress2, inetAddress, inetAddress, inetAddress, byArray);
        dhcpNakPacket.mMessage = "requested address not available";
        dhcpNakPacket.mRequestedIp = inetAddress2;
        return ((DhcpPacket)dhcpNakPacket).buildPacket(n, (short)68, (short)67);
    }

    public static ByteBuffer buildOfferPacket(int n, int n2, boolean bl, InetAddress inetAddress, InetAddress inetAddress2, byte[] byArray, Integer n3, InetAddress inetAddress3, InetAddress inetAddress4, InetAddress inetAddress5, List<InetAddress> list, InetAddress inetAddress6, String string2) {
        DhcpOfferPacket dhcpOfferPacket = new DhcpOfferPacket(n2, bl, inetAddress, inetAddress2, byArray);
        dhcpOfferPacket.mGateway = inetAddress5;
        dhcpOfferPacket.mDnsServers = list;
        dhcpOfferPacket.mLeaseTime = n3;
        dhcpOfferPacket.mDomainName = string2;
        dhcpOfferPacket.mServerIdentifier = inetAddress6;
        dhcpOfferPacket.mSubnetMask = inetAddress3;
        dhcpOfferPacket.mBroadcastAddress = inetAddress4;
        return ((DhcpPacket)dhcpOfferPacket).buildPacket(n, (short)68, (short)67);
    }

    public static ByteBuffer buildRequestPacket(int n, int n2, InetAddress inetAddress, boolean bl, byte[] byArray, InetAddress inetAddress2, InetAddress inetAddress3, byte[] byArray2, String string2) {
        DhcpRequestPacket dhcpRequestPacket = new DhcpRequestPacket(n2, inetAddress, byArray, bl);
        dhcpRequestPacket.mRequestedIp = inetAddress2;
        dhcpRequestPacket.mServerIdentifier = inetAddress3;
        dhcpRequestPacket.mHostName = string2;
        dhcpRequestPacket.mRequestedParams = byArray2;
        return ((DhcpPacket)dhcpRequestPacket).buildPacket(n, (short)67, (short)68);
    }

    private int checksum(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int n4 = n;
        int n5 = byteBuffer.position();
        byteBuffer.position(n2);
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        byteBuffer.position(n5);
        short[] sArray = new short[(n3 - n2) / 2];
        shortBuffer.get(sArray);
        int n6 = sArray.length;
        for (int i = 0; i < n6; ++i) {
            n4 += this.intAbs(sArray[i]);
        }
        int n7 = n2 + 2 * sArray.length;
        if (n3 != n7) {
            short s = byteBuffer.get(n7);
            if (s < 0) {
                s = (short)(s + 256);
            }
            n4 += s * 256;
        }
        int n8 = (0xFFFF & n4 >> 16) + (0xFFFF & n4);
        return this.intAbs((short)(0xFFFFFFFF ^ 0xFFFF & n8 + (0xFFFF & n8 >> 16)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DhcpPacket decodeFullPacket(ByteBuffer byteBuffer, int n) {
        void var37_35;
        InetAddress inetAddress;
        InetAddress inetAddress2;
        InetAddress inetAddress3;
        InetAddress inetAddress4;
        InetAddress inetAddress5;
        int n2;
        InetAddress inetAddress6;
        InetAddress inetAddress7;
        String string2;
        String string3;
        byte[] byArray;
        String string4;
        InetAddress inetAddress8;
        InetAddress inetAddress9;
        Integer n3;
        InetAddress inetAddress10;
        ArrayList<InetAddress> arrayList;
        block42: {
            block41: {
                arrayList = new ArrayList<InetAddress>();
                inetAddress10 = null;
                n3 = null;
                inetAddress9 = null;
                inetAddress8 = null;
                string4 = null;
                byArray = null;
                string3 = null;
                string2 = null;
                inetAddress7 = null;
                inetAddress6 = null;
                n2 = -1;
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                if (n == 0) {
                    byte[] byArray2 = new byte[6];
                    byte[] byArray3 = new byte[6];
                    byteBuffer.get(byArray2);
                    byteBuffer.get(byArray3);
                    if (byteBuffer.getShort() != 2048) {
                        return null;
                    }
                }
                if (n == 0) break block41;
                inetAddress5 = null;
                if (n != 1) break block42;
            }
            byteBuffer.get();
            byteBuffer.get();
            byteBuffer.getShort();
            byteBuffer.getShort();
            byteBuffer.get();
            byteBuffer.get();
            byteBuffer.get();
            byte by = byteBuffer.get();
            byteBuffer.getShort();
            inetAddress5 = DhcpPacket.readIpAddress(byteBuffer);
            DhcpPacket.readIpAddress(byteBuffer);
            if (by != 17) {
                return null;
            }
            short s = byteBuffer.getShort();
            byteBuffer.getShort();
            byteBuffer.getShort();
            byteBuffer.getShort();
            if (s != 67 && s != 68) {
                return null;
            }
        }
        byteBuffer.get();
        byteBuffer.get();
        byte by = byteBuffer.get();
        byteBuffer.get();
        int n4 = byteBuffer.getInt();
        byteBuffer.getShort();
        boolean bl = (0x8000 & byteBuffer.getShort()) != 0;
        byte[] byArray4 = new byte[4];
        try {
            byteBuffer.get(byArray4);
            inetAddress4 = InetAddress.getByAddress(byArray4);
            byteBuffer.get(byArray4);
            inetAddress3 = InetAddress.getByAddress(byArray4);
            byteBuffer.get(byArray4);
            inetAddress2 = InetAddress.getByAddress(byArray4);
            byteBuffer.get(byArray4);
            inetAddress = InetAddress.getByAddress(byArray4);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        byte[] byArray5 = new byte[by];
        byteBuffer.get(byArray5);
        byteBuffer.position(128 + (64 + (byteBuffer.position() + (16 - by))));
        if (byteBuffer.getInt() != 1669485411) {
            return null;
        }
        boolean bl2 = true;
        while (byteBuffer.position() < byteBuffer.limit() && bl2) {
            byte by2 = byteBuffer.get();
            if (by2 == -1) {
                bl2 = false;
                continue;
            }
            int n5 = byteBuffer.get();
            int n6 = 0;
            switch (by2) {
                default: {
                    for (int i = 0; i < n5; ++n6, ++i) {
                        byteBuffer.get();
                    }
                    break;
                }
                case 1: {
                    inetAddress8 = DhcpPacket.readIpAddress(byteBuffer);
                    n6 = 4;
                    break;
                }
                case 3: {
                    inetAddress10 = DhcpPacket.readIpAddress(byteBuffer);
                    n6 = 4;
                    break;
                }
                case 6: {
                    for (n6 = 0; n6 < n5; n6 += 4) {
                        arrayList.add(DhcpPacket.readIpAddress(byteBuffer));
                    }
                    break;
                }
                case 12: {
                    n6 = n5;
                    string3 = DhcpPacket.readAsciiString(byteBuffer, n5);
                    break;
                }
                case 15: {
                    n6 = n5;
                    string2 = DhcpPacket.readAsciiString(byteBuffer, n5);
                    break;
                }
                case 28: {
                    inetAddress7 = DhcpPacket.readIpAddress(byteBuffer);
                    n6 = 4;
                    break;
                }
                case 50: {
                    inetAddress6 = DhcpPacket.readIpAddress(byteBuffer);
                    n6 = 4;
                    break;
                }
                case 51: {
                    n3 = byteBuffer.getInt();
                    n6 = 4;
                    break;
                }
                case 53: {
                    n2 = byteBuffer.get();
                    n6 = 1;
                    break;
                }
                case 54: {
                    inetAddress9 = DhcpPacket.readIpAddress(byteBuffer);
                    n6 = 4;
                    break;
                }
                case 55: {
                    byArray = new byte[n5];
                    byteBuffer.get(byArray);
                    n6 = n5;
                    break;
                }
                case 56: {
                    n6 = n5;
                    string4 = DhcpPacket.readAsciiString(byteBuffer, n5);
                    break;
                }
                case 60: {
                    n6 = n5;
                    DhcpPacket.readAsciiString(byteBuffer, n5);
                    break;
                }
                case 61: {
                    byteBuffer.get(new byte[n5]);
                    n6 = n5;
                }
            }
            if (n6 == n5) continue;
            return null;
        }
        switch (n2) {
            default: {
                System.out.println("Unimplemented type: " + n2);
                return null;
            }
            case -1: {
                return null;
            }
            case 1: {
                DhcpDiscoverPacket dhcpDiscoverPacket = new DhcpDiscoverPacket(n4, byArray5, bl);
                break;
            }
            case 2: {
                DhcpOfferPacket dhcpOfferPacket = new DhcpOfferPacket(n4, bl, inetAddress5, inetAddress3, byArray5);
                break;
            }
            case 3: {
                DhcpRequestPacket dhcpRequestPacket = new DhcpRequestPacket(n4, inetAddress4, byArray5, bl);
                break;
            }
            case 4: {
                DhcpDeclinePacket dhcpDeclinePacket = new DhcpDeclinePacket(n4, inetAddress4, inetAddress3, inetAddress2, inetAddress, byArray5);
                break;
            }
            case 5: {
                DhcpAckPacket dhcpAckPacket = new DhcpAckPacket(n4, bl, inetAddress5, inetAddress3, byArray5);
                break;
            }
            case 6: {
                DhcpNakPacket dhcpNakPacket = new DhcpNakPacket(n4, inetAddress4, inetAddress3, inetAddress2, inetAddress, byArray5);
                break;
            }
            case 8: {
                DhcpInformPacket dhcpInformPacket = new DhcpInformPacket(n4, inetAddress4, inetAddress3, inetAddress2, inetAddress, byArray5);
            }
        }
        var37_35.mBroadcastAddress = inetAddress7;
        var37_35.mDnsServers = arrayList;
        var37_35.mDomainName = string2;
        var37_35.mGateway = inetAddress10;
        var37_35.mHostName = string3;
        var37_35.mLeaseTime = n3;
        var37_35.mMessage = string4;
        var37_35.mRequestedIp = inetAddress6;
        var37_35.mRequestedParams = byArray;
        var37_35.mServerIdentifier = inetAddress9;
        var37_35.mSubnetMask = inetAddress8;
        return var37_35;
    }

    public static DhcpPacket decodeFullPacket(byte[] byArray, int n) {
        return DhcpPacket.decodeFullPacket(ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN), n);
    }

    private int intAbs(short s) {
        if (s < 0) {
            return s + 65536;
        }
        return s;
    }

    public static String macToString(byte[] byArray) {
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string3 = "0" + Integer.toHexString(byArray[i]);
            string2 = string2 + string3.substring(-2 + string3.length());
            if (i == -1 + byArray.length) continue;
            string2 = string2 + ":";
        }
        return string2;
    }

    private static String readAsciiString(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, 0, byArray.length, StandardCharsets.US_ASCII);
    }

    private static InetAddress readIpAddress(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        try {
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            return inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    protected void addTlv(ByteBuffer byteBuffer, byte by, byte by2) {
        byteBuffer.put(by);
        byteBuffer.put((byte)1);
        byteBuffer.put(by2);
    }

    protected void addTlv(ByteBuffer byteBuffer, byte by, Integer n) {
        if (n != null) {
            byteBuffer.put(by);
            byteBuffer.put((byte)4);
            byteBuffer.putInt(n);
        }
    }

    protected void addTlv(ByteBuffer byteBuffer, byte by, String string2) {
        if (string2 != null) {
            byteBuffer.put(by);
            byteBuffer.put((byte)string2.length());
            for (int i = 0; i < string2.length(); ++i) {
                byteBuffer.put((byte)string2.charAt(i));
            }
        }
    }

    protected void addTlv(ByteBuffer byteBuffer, byte by, InetAddress inetAddress) {
        if (inetAddress != null) {
            this.addTlv(byteBuffer, by, inetAddress.getAddress());
        }
    }

    protected void addTlv(ByteBuffer byteBuffer, byte by, List<InetAddress> list) {
        if (list != null && list.size() > 0) {
            byteBuffer.put(by);
            byteBuffer.put((byte)(4 * list.size()));
            Iterator<InetAddress> iterator = list.iterator();
            while (iterator.hasNext()) {
                byteBuffer.put(iterator.next().getAddress());
            }
        }
    }

    protected void addTlv(ByteBuffer byteBuffer, byte by, byte[] byArray) {
        if (byArray != null) {
            byteBuffer.put(by);
            byteBuffer.put((byte)byArray.length);
            byteBuffer.put(byArray);
        }
    }

    protected void addTlvEnd(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)-1);
    }

    public abstract ByteBuffer buildPacket(int var1, short var2, short var3);

    public abstract void doNextOp(DhcpStateMachine var1);

    /*
     * Enabled aggressive block sorting
     */
    protected void fillInPacket(int n, InetAddress inetAddress, InetAddress inetAddress2, short s, short s2, ByteBuffer byteBuffer, byte by, boolean bl) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n == 1) {
            byteBuffer.put((byte)69);
            byteBuffer.put((byte)16);
            n4 = byteBuffer.position();
            byteBuffer.putShort((short)0);
            byteBuffer.putShort((short)0);
            byteBuffer.putShort((short)16384);
            byteBuffer.put((byte)64);
            byteBuffer.put((byte)17);
            n3 = byteBuffer.position();
            byteBuffer.putShort((short)0);
            byteBuffer.put(byArray2);
            byteBuffer.put(byArray);
            n2 = byteBuffer.position();
            n6 = byteBuffer.position();
            byteBuffer.putShort(s2);
            byteBuffer.putShort(s);
            n7 = byteBuffer.position();
            byteBuffer.putShort((short)0);
            n5 = byteBuffer.position();
            byteBuffer.putShort((short)0);
        }
        byteBuffer.put(by);
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)this.mClientMac.length);
        byteBuffer.put((byte)0);
        byteBuffer.putInt(this.mTransId);
        byteBuffer.putShort((short)0);
        if (bl) {
            byteBuffer.putShort((short)Short.MIN_VALUE);
        } else {
            byteBuffer.putShort((short)0);
        }
        byteBuffer.put(this.mClientIp.getAddress());
        byteBuffer.put(this.mYourIp.getAddress());
        byteBuffer.put(this.mNextIp.getAddress());
        byteBuffer.put(this.mRelayIp.getAddress());
        byteBuffer.put(this.mClientMac);
        byteBuffer.position(128 + (64 + (byteBuffer.position() + (16 - this.mClientMac.length))));
        byteBuffer.putInt(1669485411);
        this.finishPacket(byteBuffer);
        if ((1 & byteBuffer.position()) == 1) {
            byteBuffer.put((byte)0);
        }
        if (n == 1) {
            short s3 = (short)(byteBuffer.position() - n6);
            byteBuffer.putShort(n7, s3);
            byteBuffer.putShort(n5, (short)this.checksum(byteBuffer, s3 + (17 + (0 + this.intAbs(byteBuffer.getShort(n3 + 2)) + this.intAbs(byteBuffer.getShort(n3 + 4)) + this.intAbs(byteBuffer.getShort(n3 + 6)) + this.intAbs(byteBuffer.getShort(n3 + 8)))), n6, byteBuffer.position()));
            byteBuffer.putShort(n4, (short)byteBuffer.position());
            byteBuffer.putShort(n3, (short)this.checksum(byteBuffer, 0, 0, n2));
        }
    }

    abstract void finishPacket(ByteBuffer var1);

    public int getTransactionId() {
        return this.mTransId;
    }

    public String toString() {
        return DhcpPacket.macToString(this.mClientMac);
    }
}

