/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.DelegatingSSLSession;
import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Slog;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.TrustManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertificateChainValidator {
    private static final String TAG = "CertificateChainValidator";
    private X509TrustManager mTrustManager;

    private CertificateChainValidator() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X.509");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        int n = trustManagerArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                TrustManager trustManager = trustManagerArray[i];
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.mTrustManager = (X509TrustManager)trustManager;
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("X.509 TrustManagerFactory must be available", noSuchAlgorithmException);
            }
            catch (KeyStoreException keyStoreException) {
                throw new RuntimeException("X.509 TrustManagerFactory cannot be initialized", keyStoreException);
            }
        }
        if (this.mTrustManager == null) {
            throw new RuntimeException("None of the X.509 TrustManagers are X509TrustManager");
        }
    }

    private void closeSocketThrowException(SSLSocket sSLSocket, String string2) throws IOException {
        if (sSLSocket != null) {
            SSLSession sSLSession = sSLSocket.getSession();
            if (sSLSession != null) {
                sSLSession.invalidate();
            }
            sSLSocket.close();
        }
        throw new SSLHandshakeException(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void closeSocketThrowException(SSLSocket sSLSocket, String string2, String string3) throws IOException {
        if (string2 == null) {
            string2 = string3;
        }
        this.closeSocketThrowException(sSLSocket, string2);
    }

    public static CertificateChainValidator getInstance() {
        return NoPreloadHolder.sInstance;
    }

    private X509TrustManager getTrustManager() {
        return this.mTrustManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void handleTrustStorageUpdate() {
        boolean bl;
        TrustManager[] trustManagerArray;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X.509");
            trustManagerFactory.init((KeyStore)null);
            trustManagerArray = trustManagerFactory.getTrustManagers();
            bl = false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Slog.w(TAG, "Couldn't find default X.509 TrustManagerFactory");
            return;
        }
        catch (KeyStoreException keyStoreException) {
            Slog.w(TAG, "Couldn't initialize default X.509 TrustManagerFactory", keyStoreException);
            return;
        }
        int n = trustManagerArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (bl) return;
                Slog.w(TAG, "Didn't find a TrustManager to handle CA list update");
                return;
            }
            TrustManager trustManager = trustManagerArray[n2];
            try {
                Method method = trustManager.getClass().getDeclaredMethod("handleTrustStorageUpdate", new Class[0]);
                method.setAccessible(true);
                method.invoke(trustManager, new Object[0]);
                bl = true;
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public static SslError verifyServerCertificates(byte[][] byArray, String string2, String string3) throws IOException {
        int n;
        CertificateFactory certificateFactory;
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("bad certificate chain");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
            n = 0;
        }
        catch (CertificateException certificateException) {
            throw new IOException("can't read certificate", certificateException);
        }
        while (true) {
            if (n < byArray.length) {
                x509CertificateArray[n] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray[n]));
                ++n;
                continue;
            }
            break;
        }
        return CertificateChainValidator.verifyServerDomainAndCertificates(x509CertificateArray, string2, string3);
    }

    private static SslError verifyServerDomainAndCertificates(X509Certificate[] x509CertificateArray, String string2, String string3) throws IOException {
        X509Certificate x509Certificate = x509CertificateArray[0];
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate for this site is null");
        }
        boolean bl = false;
        if (string2 != null) {
            boolean bl2 = string2.isEmpty();
            bl = false;
            if (!bl2) {
                boolean bl3 = NoPreloadHolder.sVerifier.verify(string2, new DelegatingSSLSession.CertificateWrap(x509Certificate));
                bl = false;
                if (bl3) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            return new SslError(2, x509Certificate);
        }
        try {
            X509TrustManager x509TrustManager = SSLParametersImpl.getDefaultX509TrustManager();
            if (x509TrustManager instanceof TrustManagerImpl) {
                ((TrustManagerImpl)x509TrustManager).checkServerTrusted(x509CertificateArray, string3, string2);
            } else {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string3);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            return new SslError(3, x509Certificate);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection httpsConnection, SSLSocket sSLSocket, String string2) throws IOException {
        Certificate[] certificateArray;
        if (!sSLSocket.getSession().isValid()) {
            this.closeSocketThrowException(sSLSocket, "failed to perform SSL handshake");
        }
        if ((certificateArray = sSLSocket.getSession().getPeerCertificates()) != null && certificateArray.length != 0) {
            if (httpsConnection == null) return CertificateChainValidator.verifyServerDomainAndCertificates((X509Certificate[])certificateArray, string2, "RSA");
            if (certificateArray[0] == null) return CertificateChainValidator.verifyServerDomainAndCertificates((X509Certificate[])certificateArray, string2, "RSA");
            httpsConnection.setCertificate(new SslCertificate((X509Certificate)certificateArray[0]));
            return CertificateChainValidator.verifyServerDomainAndCertificates((X509Certificate[])certificateArray, string2, "RSA");
        }
        this.closeSocketThrowException(sSLSocket, "failed to retrieve peer certificates");
        return CertificateChainValidator.verifyServerDomainAndCertificates((X509Certificate[])certificateArray, string2, "RSA");
    }

    private static class NoPreloadHolder {
        private static final CertificateChainValidator sInstance = new CertificateChainValidator();
        private static final HostnameVerifier sVerifier = HttpsURLConnection.getDefaultHostnameVerifier();

        private NoPreloadHolder() {
        }
    }
}

