/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class NsdServiceInfo
implements Parcelable {
    public static final Parcelable.Creator<NsdServiceInfo> CREATOR = new Parcelable.Creator<NsdServiceInfo>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NsdServiceInfo createFromParcel(Parcel parcel) {
            NsdServiceInfo nsdServiceInfo = new NsdServiceInfo();
            NsdServiceInfo.access$002(nsdServiceInfo, parcel.readString());
            NsdServiceInfo.access$102(nsdServiceInfo, parcel.readString());
            if (parcel.readInt() == 1) {
                try {
                    NsdServiceInfo.access$202(nsdServiceInfo, InetAddress.getByAddress(parcel.createByteArray()));
                }
                catch (UnknownHostException unknownHostException) {}
            }
            NsdServiceInfo.access$302(nsdServiceInfo, parcel.readInt());
            int n = parcel.readInt();
            int n2 = 0;
            while (n2 < n) {
                int n3 = parcel.readInt();
                byte[] byArray = null;
                if (n3 == 1) {
                    byArray = new byte[parcel.readInt()];
                    parcel.readByteArray(byArray);
                }
                nsdServiceInfo.mTxtRecord.put(parcel.readString(), byArray);
                ++n2;
            }
            return nsdServiceInfo;
        }

        public NsdServiceInfo[] newArray(int n) {
            return new NsdServiceInfo[n];
        }
    };
    private static final String TAG = "NsdServiceInfo";
    private InetAddress mHost;
    private int mPort;
    private String mServiceName;
    private String mServiceType;
    private final ArrayMap<String, byte[]> mTxtRecord = new ArrayMap();

    public NsdServiceInfo() {
    }

    public NsdServiceInfo(String string2, String string3) {
        this.mServiceName = string2;
        this.mServiceType = string3;
    }

    static /* synthetic */ String access$002(NsdServiceInfo nsdServiceInfo, String string2) {
        nsdServiceInfo.mServiceName = string2;
        return string2;
    }

    static /* synthetic */ String access$102(NsdServiceInfo nsdServiceInfo, String string2) {
        nsdServiceInfo.mServiceType = string2;
        return string2;
    }

    static /* synthetic */ InetAddress access$202(NsdServiceInfo nsdServiceInfo, InetAddress inetAddress) {
        nsdServiceInfo.mHost = inetAddress;
        return inetAddress;
    }

    static /* synthetic */ int access$302(NsdServiceInfo nsdServiceInfo, int n) {
        nsdServiceInfo.mPort = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getTxtRecordSize() {
        int n = 0;
        Iterator<Map.Entry<String, byte[]>> iterator = this.mTxtRecord.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            int n2 = n + 2 + entry.getKey().length();
            byte[] byArray = entry.getValue();
            int n3 = byArray == null ? 0 : byArray.length;
            n = n2 + n3;
        }
        return n;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Map<String, byte[]> getAttributes() {
        return Collections.unmodifiableMap(this.mTxtRecord);
    }

    public InetAddress getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public String getServiceType() {
        return this.mServiceType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] getTxtRecord() {
        int n = this.getTxtRecordSize();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        Iterator<Map.Entry<String, byte[]>> iterator = this.mTxtRecord.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            String string2 = entry.getKey();
            byte[] byArray2 = entry.getValue();
            int n3 = n2 + 1;
            int n4 = string2.length();
            int n5 = byArray2 == null ? 0 : byArray2.length;
            byArray[n2] = (byte)(1 + (n5 + n4));
            System.arraycopy((byte[])string2.getBytes(StandardCharsets.US_ASCII), (int)0, (byte[])byArray, (int)n3, (int)string2.length());
            int n6 = n3 + string2.length();
            int n7 = n6 + 1;
            byArray[n6] = 61;
            if (byArray2 != null) {
                System.arraycopy((byte[])byArray2, (int)0, (byte[])byArray, (int)n7, (int)byArray2.length);
                n2 = n7 + byArray2.length;
                continue;
            }
            n2 = n7;
        }
        return byArray;
    }

    public void removeAttribute(String string2) {
        this.mTxtRecord.remove(string2);
    }

    /*
     * Unable to fully structure code
     */
    public void setAttribute(String var1_1, String var2_2) {
        if (var2_2 != null) ** GOTO lbl7
        try {
            var5_3 = null;
lbl4:
            // 2 sources

            while (true) {
                this.setAttribute(var1_1, var5_3);
                return;
            }
lbl7:
            // 1 sources

            var4_4 = var2_2.getBytes("UTF-8");
            var5_3 = var4_4;
            ** continue;
        }
        catch (UnsupportedEncodingException var3_5) {
            throw new IllegalArgumentException("Value must be UTF-8");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAttribute(String string2, byte[] byArray) {
        int n;
        int n2;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c < ' ' || c > '~') {
                throw new IllegalArgumentException("Key strings must be printable US-ASCII");
            }
            if (c != '=') continue;
            throw new IllegalArgumentException("Key strings must not include '='");
        }
        int n3 = byArray == null ? 0 : byArray.length;
        if (n3 + (n2 = string2.length()) >= 255) {
            throw new IllegalArgumentException("Key length + value length must be < 255 bytes");
        }
        if (string2.length() > 9) {
            Log.w(TAG, "Key lengths > 9 are discouraged: " + string2);
        }
        int n4 = this.getTxtRecordSize() + string2.length();
        int n5 = 0;
        if (byArray != null) {
            n5 = byArray.length;
        }
        if ((n = 2 + (n5 + n4)) > 1300) {
            throw new IllegalArgumentException("Total length of attributes must be < 1300 bytes");
        }
        if (n > 400) {
            Log.w(TAG, "Total length of all attributes exceeds 400 bytes; truncation may occur");
        }
        this.mTxtRecord.put(string2, byArray);
    }

    public void setHost(InetAddress inetAddress) {
        this.mHost = inetAddress;
    }

    public void setPort(int n) {
        this.mPort = n;
    }

    public void setServiceName(String string2) {
        this.mServiceName = string2;
    }

    public void setServiceType(String string2) {
        this.mServiceType = string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name: ").append(this.mServiceName).append(", type: ").append(this.mServiceType).append(", host: ").append(this.mHost).append(", port: ").append(this.mPort);
        byte[] byArray = this.getTxtRecord();
        if (byArray != null) {
            stringBuffer.append(", txtRecord: ").append(new String(byArray, StandardCharsets.UTF_8));
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mServiceName);
        parcel.writeString(this.mServiceType);
        if (this.mHost != null) {
            parcel.writeInt(1);
            parcel.writeByteArray(this.mHost.getAddress());
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mPort);
        parcel.writeInt(this.mTxtRecord.size());
        Iterator<String> iterator = this.mTxtRecord.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            byte[] byArray = this.mTxtRecord.get(string2);
            if (byArray != null) {
                parcel.writeInt(1);
                parcel.writeInt(byArray.length);
                parcel.writeByteArray(byArray);
            } else {
                parcel.writeInt(0);
            }
            parcel.writeString(string2);
        }
        return;
    }
}

