/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.INfcTag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.nfc.tech.NfcBarcode;
import android.nfc.tech.NfcF;
import android.nfc.tech.NfcV;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public final class Tag
implements Parcelable {
    public static final Parcelable.Creator<Tag> CREATOR = new Parcelable.Creator<Tag>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Tag createFromParcel(Parcel parcel) {
            INfcTag iNfcTag;
            byte[] byArray = Tag.readBytesWithNull(parcel);
            int[] nArray = new int[parcel.readInt()];
            parcel.readIntArray(nArray);
            Bundle[] bundleArray = parcel.createTypedArray(Bundle.CREATOR);
            int n = parcel.readInt();
            if (parcel.readInt() == 0) {
                iNfcTag = INfcTag.Stub.asInterface(parcel.readStrongBinder());
                return new Tag(byArray, nArray, bundleArray, n, iNfcTag);
            }
            iNfcTag = null;
            return new Tag(byArray, nArray, bundleArray, n, iNfcTag);
        }

        public Tag[] newArray(int n) {
            return new Tag[n];
        }
    };
    int mConnectedTechnology;
    final byte[] mId;
    final int mServiceHandle;
    final INfcTag mTagService;
    final Bundle[] mTechExtras;
    final int[] mTechList;
    final String[] mTechStringList;

    public Tag(byte[] byArray, int[] nArray, Bundle[] bundleArray, int n, INfcTag iNfcTag) {
        if (nArray == null) {
            throw new IllegalArgumentException("rawTargets cannot be null");
        }
        this.mId = byArray;
        this.mTechList = Arrays.copyOf(nArray, nArray.length);
        this.mTechStringList = this.generateTechStringList(nArray);
        this.mTechExtras = Arrays.copyOf(bundleArray, nArray.length);
        this.mServiceHandle = n;
        this.mTagService = iNfcTag;
        this.mConnectedTechnology = -1;
    }

    public static Tag createMockTag(byte[] byArray, int[] nArray, Bundle[] bundleArray) {
        return new Tag(byArray, nArray, bundleArray, 0, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] generateTechStringList(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            switch (nArray[n2]) {
                default: {
                    throw new IllegalArgumentException("Unknown tech type " + nArray[n2]);
                }
                case 3: {
                    stringArray[n2] = IsoDep.class.getName();
                    break;
                }
                case 8: {
                    stringArray[n2] = MifareClassic.class.getName();
                    break;
                }
                case 9: {
                    stringArray[n2] = MifareUltralight.class.getName();
                    break;
                }
                case 6: {
                    stringArray[n2] = Ndef.class.getName();
                    break;
                }
                case 7: {
                    stringArray[n2] = NdefFormatable.class.getName();
                    break;
                }
                case 1: {
                    stringArray[n2] = NfcA.class.getName();
                    break;
                }
                case 2: {
                    stringArray[n2] = NfcB.class.getName();
                    break;
                }
                case 4: {
                    stringArray[n2] = NfcF.class.getName();
                    break;
                }
                case 5: {
                    stringArray[n2] = NfcV.class.getName();
                    break;
                }
                case 10: {
                    stringArray[n2] = NfcBarcode.class.getName();
                }
            }
            ++n2;
        }
        return stringArray;
    }

    static int[] getTechCodesFromStrings(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        int[] nArray = new int[stringArray.length];
        HashMap<String, Integer> hashMap = Tag.getTechStringToCodeMap();
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = hashMap.get(stringArray[i]);
            if (n == null) {
                throw new IllegalArgumentException("Unknown tech type " + stringArray[i]);
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private static HashMap<String, Integer> getTechStringToCodeMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(IsoDep.class.getName(), 3);
        hashMap.put(MifareClassic.class.getName(), 8);
        hashMap.put(MifareUltralight.class.getName(), 9);
        hashMap.put(Ndef.class.getName(), 6);
        hashMap.put(NdefFormatable.class.getName(), 7);
        hashMap.put(NfcA.class.getName(), 1);
        hashMap.put(NfcB.class.getName(), 2);
        hashMap.put(NfcF.class.getName(), 4);
        hashMap.put(NfcV.class.getName(), 5);
        hashMap.put(NfcBarcode.class.getName(), 10);
        return hashMap;
    }

    static byte[] readBytesWithNull(Parcel parcel) {
        int n = parcel.readInt();
        byte[] byArray = null;
        if (n >= 0) {
            byArray = new byte[n];
            parcel.readByteArray(byArray);
        }
        return byArray;
    }

    static void writeBytesWithNull(Parcel parcel, byte[] byArray) {
        if (byArray == null) {
            parcel.writeInt(-1);
            return;
        }
        parcel.writeInt(byArray.length);
        parcel.writeByteArray(byArray);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getConnectedTechnology() {
        return this.mConnectedTechnology;
    }

    public byte[] getId() {
        return this.mId;
    }

    public int getServiceHandle() {
        return this.mServiceHandle;
    }

    public INfcTag getTagService() {
        return this.mTagService;
    }

    public int[] getTechCodeList() {
        return this.mTechList;
    }

    public Bundle getTechExtras(int n) {
        int n2 = -1;
        int n3 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n3 >= this.mTechList.length) break block3;
                    if (this.mTechList[n3] != n) break block4;
                    n2 = n3;
                }
                if (n2 >= 0) break;
                return null;
            }
            ++n3;
        }
        return this.mTechExtras[n2];
    }

    public String[] getTechList() {
        return this.mTechStringList;
    }

    public boolean hasTech(int n) {
        int[] nArray = this.mTechList;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public Tag rediscover() throws IOException {
        block5: {
            if (this.getConnectedTechnology() != -1) {
                throw new IllegalStateException("Close connection to the technology first!");
            }
            if (this.mTagService == null) {
                throw new IOException("Mock tags don't support this operation.");
            }
            try {
                Tag tag = this.mTagService.rediscover(this.getServiceHandle());
                if (tag == null) break block5;
                return tag;
            }
            catch (RemoteException remoteException) {
                throw new IOException("NFC service dead");
            }
        }
        throw new IOException("Failed to rediscover tag");
    }

    public void setConnectedTechnology(int n) {
        synchronized (this) {
            if (this.mConnectedTechnology == -1) {
                this.mConnectedTechnology = n;
                return;
            }
            throw new IllegalStateException("Close other technology first!");
        }
    }

    public void setTechnologyDisconnected() {
        this.mConnectedTechnology = -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TAG: Tech [");
        String[] stringArray = this.getTechList();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mTagService == null ? 1 : 0;
        Tag.writeBytesWithNull(parcel, this.mId);
        parcel.writeInt(this.mTechList.length);
        parcel.writeIntArray(this.mTechList);
        parcel.writeTypedArray(this.mTechExtras, 0);
        parcel.writeInt(this.mServiceHandle);
        parcel.writeInt(n2);
        if (n2 == 0) {
            parcel.writeStrongBinder(this.mTagService.asBinder());
        }
    }
}

