/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.FileUtils;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Environment {
    public static final boolean APPS_TO_SECONDARY_EXT_STORAGE = true;
    private static final String CANONCIAL_EMULATED_STORAGE_TARGET;
    private static final File DATA_DIRECTORY;
    public static String DIRECTORY_ALARMS;
    @Deprecated
    public static final String DIRECTORY_ANDROID = "Android";
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOCUMENTS;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    public static final String DIR_ANDROID = "Android";
    private static final File DIR_ANDROID_ROOT;
    private static final String DIR_CACHE = "cache";
    private static final String DIR_DATA = "data";
    private static final String DIR_FILES = "files";
    private static final String DIR_MEDIA = "media";
    private static final File DIR_MEDIA_STORAGE;
    private static final String DIR_OBB = "obb";
    private static final File DIR_OEM_ROOT;
    private static final File DIR_VENDOR_ROOT;
    private static final File DOWNLOAD_CACHE_DIRECTORY;
    private static final String ENV_ANDROID_ROOT = "ANDROID_ROOT";
    private static final String ENV_EMULATED_STORAGE_SOURCE = "EMULATED_STORAGE_SOURCE";
    private static final String ENV_EMULATED_STORAGE_TARGET = "EMULATED_STORAGE_TARGET";
    private static final String ENV_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    private static final String ENV_MEDIA_STORAGE = "MEDIA_STORAGE";
    private static final String ENV_OEM_ROOT = "OEM_ROOT";
    private static final String ENV_SECONDARY_STORAGE = "SECONDARY_STORAGE";
    private static final String ENV_VENDOR_ROOT = "VENDOR_ROOT";
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_UNKNOWN = "unknown";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    public static final String MOUNT_POINT_MICROSD;
    public static final String SECONDARY_OBB_PATH = ".android_obb";
    private static final File SECURE_DATA_DIRECTORY;
    private static final String SYSTEM_PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static final String TAG = "Environment";
    private static volatile File mSecondaryExternalStorage;
    private static UserEnvironment sCurrentUser;
    private static final Object sLock;
    @GuardedBy(value="sLock")
    private static volatile StorageVolume sSecondaryVolume;
    private static boolean sUserRequired;

    static {
        DIR_ANDROID_ROOT = Environment.getDirectory(ENV_ANDROID_ROOT, "/system");
        DIR_OEM_ROOT = Environment.getDirectory(ENV_OEM_ROOT, "/oem");
        DIR_VENDOR_ROOT = Environment.getDirectory(ENV_VENDOR_ROOT, "/vendor");
        DIR_MEDIA_STORAGE = Environment.getDirectory(ENV_MEDIA_STORAGE, "/data/media");
        CANONCIAL_EMULATED_STORAGE_TARGET = Environment.getCanonicalPathOrNull(ENV_EMULATED_STORAGE_TARGET);
        sLock = new Object();
        Environment.initForCurrentUser();
        DATA_DIRECTORY = Environment.getDirectory("ANDROID_DATA", "/data");
        SECURE_DATA_DIRECTORY = Environment.getDirectory("ANDROID_SECURE_DATA", "/data/secure");
        DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
        DIRECTORY_DOCUMENTS = "Documents";
        MOUNT_POINT_MICROSD = SystemProperties.get("ro.epad.mount_point.microsd", "/Removable/MicroSD");
    }

    public static File[] buildExternalStorageAndroidDataDirs() {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAndroidDataDirs();
    }

    public static File[] buildExternalStorageAppCacheDirs(String string2) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppCacheDirs(string2);
    }

    public static File[] buildExternalStorageAppDataDirs(String string2) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppDataDirs(string2);
    }

    public static File[] buildExternalStorageAppFilesDirs(String string2) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppFilesDirs(string2);
    }

    public static File[] buildExternalStorageAppMediaDirs(String string2) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppMediaDirs(string2);
    }

    public static File[] buildExternalStorageAppObbDirs(String string2) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppObbDirs(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static File buildPath(File file, String ... stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        File file2 = file;
        while (n2 < n) {
            String string2 = stringArray[n2];
            File file3 = file2 == null ? new File(string2) : new File(file2, string2);
            ++n2;
            file2 = file3;
        }
        return file2;
    }

    public static File[] buildPaths(File[] fileArray, String ... stringArray) {
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = Environment.buildPath(fileArray[i], stringArray);
        }
        return fileArray2;
    }

    private static String getCanonicalPathOrNull(String string2) {
        String string3 = System.getenv(string2);
        if (string3 == null) {
            return null;
        }
        try {
            String string4 = new File(string3).getCanonicalPath();
            return string4;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Unable to resolve canonical path for " + string3);
            return null;
        }
    }

    public static File getDataDirectory() {
        return DATA_DIRECTORY;
    }

    static File getDirectory(String string2, String string3) {
        String string4 = System.getenv(string2);
        if (string4 == null) {
            return new File(string3);
        }
        return new File(string4);
    }

    public static File getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    public static File getEmulatedStorageObbSource() {
        return new File(System.getenv(ENV_EMULATED_STORAGE_SOURCE), DIR_OBB);
    }

    public static File getEmulatedStorageSource(int n) {
        return new File(System.getenv(ENV_EMULATED_STORAGE_SOURCE), String.valueOf(n));
    }

    public static File getExternalStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getExternalDirsForApp()[0];
    }

    public static File getExternalStoragePublicDirectory(String string2) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStoragePublicDirs(string2)[0];
    }

    public static String getExternalStorageState() {
        return Environment.getExternalStorageState(sCurrentUser.getExternalDirsForApp()[0]);
    }

    public static String getExternalStorageState(File file) {
        StorageVolume storageVolume = Environment.getStorageVolume(file);
        if (storageVolume != null) {
            IMountService iMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            try {
                String string2 = iMountService.getVolumeState(storageVolume.getPath());
                return string2;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return MEDIA_UNKNOWN;
    }

    public static File getLegacyExternalStorageDirectory() {
        return new File(System.getenv(ENV_EXTERNAL_STORAGE));
    }

    public static File getLegacyExternalStorageObbDirectory() {
        return Environment.buildPath(Environment.getLegacyExternalStorageDirectory(), "Android", DIR_OBB);
    }

    public static File getMediaStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getMediaDir();
    }

    public static File getOemDirectory() {
        return DIR_OEM_ROOT;
    }

    public static File getRootDirectory() {
        return DIR_ANDROID_ROOT;
    }

    public static File getSecondaryExternalObbDirectory() {
        File file = Environment.getSecondaryExternalStorageDirectory();
        if (file != null) {
            return Environment.buildPath(file, SECONDARY_OBB_PATH);
        }
        return null;
    }

    public static File getSecondaryExternalObbPackageDirectory(String string2) {
        File file = Environment.getSecondaryExternalStorageDirectory();
        if (file != null) {
            return Environment.buildPath(file, SECONDARY_OBB_PATH, string2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getSecondaryExternalStorageDirectory() {
        if (mSecondaryExternalStorage == null) {
            Environment.updateSecondaryExternalStorage();
        }
        Object object = sLock;
        synchronized (object) {
            return mSecondaryExternalStorage;
        }
    }

    public static String getSecondaryExternalStorageState() {
        block3: {
            StorageVolume storageVolume;
            IMountService iMountService;
            try {
                iMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
                storageVolume = Environment.getSecondaryVolume();
                if (storageVolume == null) break block3;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to read secondary external storage state; assuming REMOVED: " + remoteException);
                return MEDIA_REMOVED;
            }
            return iMountService.getVolumeState(storageVolume.getPath());
        }
        return MEDIA_REMOVED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StorageVolume getSecondaryVolume() {
        if (sSecondaryVolume == null) {
            Object object = sLock;
            synchronized (object) {
                StorageVolume storageVolume = sSecondaryVolume;
                if (storageVolume == null) {
                    try {
                        sSecondaryVolume = StorageManager.getSecondaryVolume(IMountService.Stub.asInterface(ServiceManager.getService("mount")).getVolumeList());
                    }
                    catch (Exception exception) {
                        Log.e(TAG, "couldn't talk to MountService", exception);
                    }
                }
            }
        }
        return sSecondaryVolume;
    }

    public static File getSecureDataDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return SECURE_DATA_DIRECTORY;
        }
        return DATA_DIRECTORY;
    }

    @Deprecated
    public static String getStorageState(File file) {
        return Environment.getExternalStorageState(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StorageVolume getStorageVolume(File file) {
        File file2;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
        try {}
        catch (RemoteException remoteException) {
            // empty catch block
            return null;
        }
        for (StorageVolume storageVolume : IMountService.Stub.asInterface(ServiceManager.getService("mount")).getVolumeList()) {
            boolean bl = FileUtils.contains(storageVolume.getPathFile(), file2);
            if (!bl) continue;
            return storageVolume;
        }
        return null;
    }

    public static File getSystemSecureDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return new File(SECURE_DATA_DIRECTORY, "system");
        }
        return new File(DATA_DIRECTORY, "system");
    }

    public static File getUserConfigDirectory(int n) {
        return new File(new File(new File(Environment.getDataDirectory(), "misc"), "user"), Integer.toString(n));
    }

    public static File getUserSystemDirectory(int n) {
        return new File(new File(Environment.getSystemSecureDirectory(), "users"), Integer.toString(n));
    }

    public static File getVendorDirectory() {
        return DIR_VENDOR_ROOT;
    }

    public static void initForCurrentUser() {
        sCurrentUser = new UserEnvironment(UserHandle.myUserId());
    }

    public static boolean isEncryptedFilesystemEnabled() {
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_EFS_ENABLED, false);
    }

    public static boolean isExternalStorageEmulated() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        return Environment.isExternalStorageEmulated(sCurrentUser.getExternalDirsForApp()[0]);
    }

    public static boolean isExternalStorageEmulated(File file) {
        StorageVolume storageVolume = Environment.getStorageVolume(file);
        if (storageVolume != null) {
            return storageVolume.isEmulated();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + file);
    }

    public static boolean isExternalStorageRemovable() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        return Environment.isExternalStorageRemovable(sCurrentUser.getExternalDirsForApp()[0]);
    }

    public static boolean isExternalStorageRemovable(File file) {
        StorageVolume storageVolume = Environment.getStorageVolume(file);
        if (storageVolume != null) {
            return storageVolume.isRemovable();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + file);
    }

    public static boolean isSecondaryExternalStorage(StorageVolume storageVolume) {
        if (storageVolume != null) {
            return storageVolume.getPath().equals(MOUNT_POINT_MICROSD);
        }
        return false;
    }

    public static boolean isSecondaryExternalStorageRemovable() {
        StorageVolume storageVolume = Environment.getSecondaryVolume();
        boolean bl = false;
        if (storageVolume != null) {
            boolean bl2 = storageVolume.isRemovable();
            bl = false;
            if (bl2) {
                boolean bl3 = SystemProperties.getBoolean("ro.bsp.app2sd", false);
                bl = false;
                if (bl3) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static boolean isStorageDisabled() {
        return SystemProperties.getBoolean("config.disable_storage", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File maybeTranslateEmulatedPathToInternal(File file) {
        if (!Environment.isExternalStorageEmulated() || CANONCIAL_EMULATED_STORAGE_TARGET == null) return file;
        try {
            File file2;
            boolean bl;
            String string2 = file.getCanonicalPath();
            if (!string2.startsWith(CANONCIAL_EMULATED_STORAGE_TARGET) || !(bl = (file2 = new File(DIR_MEDIA_STORAGE, string2.substring(CANONCIAL_EMULATED_STORAGE_TARGET.length()))).exists())) return file;
            return file2;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Failed to resolve canonical path for " + file);
            return file;
        }
    }

    public static void setUserRequired(boolean bl) {
        sUserRequired = bl;
    }

    private static void throwIfSystem() {
        if (Process.myUid() == 1000) {
            Log.wtf(TAG, "Static storage paths aren't available from AID_SYSTEM", new Throwable());
        }
    }

    private static void throwIfUserRequired() {
        if (sUserRequired) {
            Log.wtf(TAG, "Path requests must specify a user by using UserEnvironment", new Throwable());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateSecondaryExternalStorage() {
        if (MEDIA_MOUNTED.equals(Environment.getSecondaryExternalStorageState())) {
            if (mSecondaryExternalStorage == null) {
                Object object = sLock;
                synchronized (object) {
                    mSecondaryExternalStorage = new File(Environment.getSecondaryVolume().getPath());
                }
            }
        } else {
            Object object = sLock;
            synchronized (object) {
                mSecondaryExternalStorage = null;
            }
        }
        Log.i(TAG, "mSecondaryExternalStorage = " + mSecondaryExternalStorage);
    }

    public static class UserEnvironment {
        private final File mEmulatedDirForDirect;
        private final File[] mExternalDirsForApp;
        private final File[] mExternalDirsForVold;

        /*
         * Enabled aggressive block sorting
         */
        public UserEnvironment(int n) {
            String string2;
            String string3 = System.getenv(Environment.ENV_EXTERNAL_STORAGE);
            String string4 = System.getenv(Environment.ENV_EMULATED_STORAGE_SOURCE);
            String string5 = System.getenv(Environment.ENV_EMULATED_STORAGE_TARGET);
            String string6 = System.getenv(Environment.ENV_MEDIA_STORAGE);
            if (TextUtils.isEmpty(string6)) {
                string6 = "/data/media";
            }
            ArrayList<File> arrayList = Lists.newArrayList();
            ArrayList<File> arrayList2 = Lists.newArrayList();
            if (!TextUtils.isEmpty(string5)) {
                String string7 = Integer.toString(n);
                File file = new File(string4);
                File file2 = new File(string5);
                File file3 = new File(string6);
                arrayList.add(Environment.buildPath(file, string7));
                arrayList2.add(Environment.buildPath(file2, string7));
                this.mEmulatedDirForDirect = Environment.buildPath(file3, string7);
            } else {
                File file;
                if (TextUtils.isEmpty(string3)) {
                    Log.w(Environment.TAG, "EXTERNAL_STORAGE undefined; falling back to default");
                    string3 = "/storage/sdcard0";
                }
                File file4 = new File(string3);
                arrayList.add(file4);
                File file5 = new File(string3);
                arrayList2.add(file5);
                this.mEmulatedDirForDirect = file = new File(string6);
            }
            if (!TextUtils.isEmpty(string2 = System.getenv(Environment.ENV_SECONDARY_STORAGE)) && n == 0) {
                for (String string8 : string2.split(":")) {
                    File file = new File(string8);
                    arrayList.add(file);
                    File file6 = new File(string8);
                    arrayList2.add(file6);
                }
            }
            this.mExternalDirsForVold = arrayList.toArray(new File[arrayList.size()]);
            this.mExternalDirsForApp = arrayList2.toArray(new File[arrayList2.size()]);
        }

        private static File[] filterMountedVolume(File[] fileArray) {
            ArrayList<File> arrayList = Lists.newArrayList();
            for (File file : fileArray) {
                String string2 = Environment.getStorageState(file);
                if (!Environment.MEDIA_MOUNTED.equals(string2) && !Environment.MEDIA_UNKNOWN.equals(string2)) continue;
                arrayList.add(file);
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }

        public File[] buildExternalStorageAndroidDataDirs() {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_DATA);
        }

        public File[] buildExternalStorageAndroidObbDirs() {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_OBB);
        }

        public File[] buildExternalStorageAppCacheDirs(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_DATA, string2, Environment.DIR_CACHE);
        }

        public File[] buildExternalStorageAppDataDirs(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_DATA, string2);
        }

        public File[] buildExternalStorageAppDataDirsForVold(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForVold), "Android", Environment.DIR_DATA, string2);
        }

        public File[] buildExternalStorageAppFilesDirs(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_DATA, string2, Environment.DIR_FILES);
        }

        public File[] buildExternalStorageAppMediaDirs(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_MEDIA, string2);
        }

        public File[] buildExternalStorageAppMediaDirsForVold(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForVold), "Android", Environment.DIR_MEDIA, string2);
        }

        public File[] buildExternalStorageAppObbDirs(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), "Android", Environment.DIR_OBB, string2);
        }

        public File[] buildExternalStorageAppObbDirsForVold(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForVold), "Android", Environment.DIR_OBB, string2);
        }

        public File[] buildExternalStoragePublicDirs(String string2) {
            return Environment.buildPaths(UserEnvironment.filterMountedVolume(this.mExternalDirsForApp), string2);
        }

        public File[] getExternalDirsForApp() {
            return UserEnvironment.filterMountedVolume(this.mExternalDirsForApp);
        }

        public File[] getExternalDirsForVold() {
            return UserEnvironment.filterMountedVolume(this.mExternalDirsForVold);
        }

        public File getExternalStorageAppObbDirectory(String string2) {
            return this.buildExternalStorageAppObbDirs(string2)[0];
        }

        @Deprecated
        public File getExternalStorageDirectory() {
            return this.mExternalDirsForApp[0];
        }

        @Deprecated
        public File getExternalStoragePublicDirectory(String string2) {
            return this.buildExternalStoragePublicDirs(string2)[0];
        }

        public File getMediaDir() {
            return this.mEmulatedDirForDirect;
        }
    }
}

