/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IMessenger;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;

public class Handler {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final String TAG = "Handler";
    final boolean mAsynchronous;
    final Callback mCallback;
    final Looper mLooper;
    IMessenger mMessenger;
    final MessageQueue mQueue;

    public Handler() {
        this(null, false);
    }

    public Handler(Callback callback) {
        this(callback, false);
    }

    public Handler(Callback callback, boolean bl) {
        this.mLooper = Looper.myLooper();
        if (this.mLooper == null) {
            throw new RuntimeException("Can't create handler inside thread that has not called Looper.prepare()");
        }
        this.mQueue = this.mLooper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = bl;
    }

    public Handler(Looper looper) {
        this(looper, null, false);
    }

    public Handler(Looper looper, Callback callback) {
        this(looper, callback, false);
    }

    public Handler(Looper looper, Callback callback, boolean bl) {
        this.mLooper = looper;
        this.mQueue = looper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = bl;
    }

    public Handler(boolean bl) {
        this(null, bl);
    }

    private boolean enqueueMessage(MessageQueue messageQueue, Message message, long l) {
        message.target = this;
        if (this.mAsynchronous) {
            message.setAsynchronous(true);
        }
        return messageQueue.enqueueMessage(message, l);
    }

    private static Message getPostMessage(Runnable runnable) {
        Message message = Message.obtain();
        message.callback = runnable;
        return message;
    }

    private static Message getPostMessage(Runnable runnable, Object object) {
        Message message = Message.obtain();
        message.obj = object;
        message.callback = runnable;
        return message;
    }

    private static void handleCallback(Message message) {
        message.callback.run();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchMessage(Message message) {
        if (message.callback != null) {
            Handler.handleCallback(message);
            return;
        } else {
            if (this.mCallback != null && this.mCallback.handleMessage(message)) return;
            this.handleMessage(message);
            return;
        }
    }

    public final void dump(Printer printer, String string2) {
        printer.println(string2 + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            printer.println(string2 + "looper uninitialized");
            return;
        }
        this.mLooper.dump(printer, string2 + "  ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final IMessenger getIMessenger() {
        MessageQueue messageQueue = this.mQueue;
        synchronized (messageQueue) {
            this.mMessenger = new MessengerImpl();
            if (this.mMessenger == null) return this.mMessenger;
            return this.mMessenger;
        }
    }

    public final Looper getLooper() {
        return this.mLooper;
    }

    public String getMessageName(Message message) {
        if (message.callback != null) {
            return message.callback.getClass().getName();
        }
        return "0x" + Integer.toHexString(message.what);
    }

    public void handleMessage(Message message) {
    }

    public final boolean hasCallbacks(Runnable runnable) {
        return this.mQueue.hasMessages(this, runnable, null);
    }

    public final boolean hasMessages(int n) {
        return this.mQueue.hasMessages(this, n, null);
    }

    public final boolean hasMessages(int n, Object object) {
        return this.mQueue.hasMessages(this, n, object);
    }

    public final Message obtainMessage() {
        return Message.obtain(this);
    }

    public final Message obtainMessage(int n) {
        return Message.obtain(this, n);
    }

    public final Message obtainMessage(int n, int n2, int n3) {
        return Message.obtain(this, n, n2, n3);
    }

    public final Message obtainMessage(int n, int n2, int n3, Object object) {
        return Message.obtain(this, n, n2, n3, object);
    }

    public final Message obtainMessage(int n, Object object) {
        return Message.obtain(this, n, object);
    }

    public final boolean post(Runnable runnable) {
        return this.sendMessageDelayed(Handler.getPostMessage(runnable), 0L);
    }

    public final boolean postAtFrontOfQueue(Runnable runnable) {
        return this.sendMessageAtFrontOfQueue(Handler.getPostMessage(runnable));
    }

    public final boolean postAtTime(Runnable runnable, long l) {
        return this.sendMessageAtTime(Handler.getPostMessage(runnable), l);
    }

    public final boolean postAtTime(Runnable runnable, Object object, long l) {
        return this.sendMessageAtTime(Handler.getPostMessage(runnable, object), l);
    }

    public final boolean postDelayed(Runnable runnable, long l) {
        return this.sendMessageDelayed(Handler.getPostMessage(runnable), l);
    }

    public final void removeCallbacks(Runnable runnable) {
        this.mQueue.removeMessages(this, runnable, null);
    }

    public final void removeCallbacks(Runnable runnable, Object object) {
        this.mQueue.removeMessages(this, runnable, object);
    }

    public final void removeCallbacksAndMessages(Object object) {
        this.mQueue.removeCallbacksAndMessages(this, object);
    }

    public final void removeMessages(int n) {
        this.mQueue.removeMessages(this, n, null);
    }

    public final void removeMessages(int n, Object object) {
        this.mQueue.removeMessages(this, n, object);
    }

    public final boolean runWithScissors(Runnable runnable, long l) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        if (Looper.myLooper() == this.mLooper) {
            runnable.run();
            return true;
        }
        return new BlockingRunnable(runnable).postAndWait(this, l);
    }

    public final boolean sendEmptyMessage(int n) {
        return this.sendEmptyMessageDelayed(n, 0L);
    }

    public final boolean sendEmptyMessageAtTime(int n, long l) {
        Message message = Message.obtain();
        message.what = n;
        return this.sendMessageAtTime(message, l);
    }

    public final boolean sendEmptyMessageDelayed(int n, long l) {
        Message message = Message.obtain();
        message.what = n;
        return this.sendMessageDelayed(message, l);
    }

    public final boolean sendMessage(Message message) {
        return this.sendMessageDelayed(message, 0L);
    }

    public final boolean sendMessageAtFrontOfQueue(Message message) {
        MessageQueue messageQueue = this.mQueue;
        if (messageQueue == null) {
            RuntimeException runtimeException = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", runtimeException.getMessage(), runtimeException);
            return false;
        }
        return this.enqueueMessage(messageQueue, message, 0L);
    }

    public boolean sendMessageAtTime(Message message, long l) {
        MessageQueue messageQueue = this.mQueue;
        if (messageQueue == null) {
            RuntimeException runtimeException = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", runtimeException.getMessage(), runtimeException);
            return false;
        }
        return this.enqueueMessage(messageQueue, message, l);
    }

    public final boolean sendMessageDelayed(Message message, long l) {
        if (l < 0L) {
            l = 0L;
        }
        return this.sendMessageAtTime(message, l + SystemClock.uptimeMillis());
    }

    public String toString() {
        return "Handler (" + this.getClass().getName() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    private static final class BlockingRunnable
    implements Runnable {
        private boolean mDone;
        private final Runnable mTask;

        public BlockingRunnable(Runnable runnable) {
            this.mTask = runnable;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean postAndWait(Handler handler, long l) {
            if (!handler.post(this)) {
                return false;
            }
            synchronized (this) {
                if (l > 0L) {
                    long l2 = l + SystemClock.uptimeMillis();
                    while (!this.mDone) {
                        long l3 = l2 - SystemClock.uptimeMillis();
                        if (l3 <= 0L) {
                            return false;
                        }
                        try {
                            this.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    boolean bl;
                    while (!(bl = this.mDone)) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.mTask.run();
                return;
            }
            finally {
                synchronized (this) {
                    this.mDone = true;
                    this.notifyAll();
                }
            }
        }
    }

    public static interface Callback {
        public boolean handleMessage(Message var1);
    }

    private final class MessengerImpl
    extends IMessenger.Stub {
        private MessengerImpl() {
        }

        @Override
        public void send(Message message) {
            message.sendingUid = Binder.getCallingUid();
            Handler.this.sendMessage(message);
        }
    }
}

