/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import java.util.ArrayList;

public final class MessageQueue {
    private boolean mBlocked;
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    Message mMessages;
    private int mNextBarrierToken;
    private IdleHandler[] mPendingIdleHandlers;
    private long mPtr;
    private final boolean mQuitAllowed;
    private boolean mQuitting;

    MessageQueue(boolean bl) {
        this.mQuitAllowed = bl;
        this.mPtr = MessageQueue.nativeInit();
    }

    private void dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    private boolean isIdlingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsIdling(this.mPtr);
    }

    private static native void nativeDestroy(long var0);

    private static native long nativeInit();

    private static native boolean nativeIsIdling(long var0);

    private static native void nativePollOnce(long var0, int var2);

    private static native void nativeWake(long var0);

    /*
     * Unable to fully structure code
     */
    private void removeAllFutureMessagesLocked() {
        block3: {
            var1_1 = SystemClock.uptimeMillis();
            var3_2 = this.mMessages;
            if (var3_2 == null) break block3;
            if (var3_2.when <= var1_1) ** GOTO lbl10
            this.removeAllMessagesLocked();
        }
        return;
lbl-1000:
        // 1 sources

        {
            var3_2 = var4_3;
lbl10:
            // 2 sources

            if ((var4_3 = var3_2.next) == null) ** continue;
            ** while (var4_3.when <= var1_1)
        }
lbl12:
        // 1 sources

        var3_2.next = null;
        do {
            var5_4 = var4_3;
            var4_3 = var5_4.next;
            var5_4.recycleUnchecked();
        } while (var4_3 != null);
    }

    private void removeAllMessagesLocked() {
        Message message = this.mMessages;
        while (message != null) {
            Message message2 = message.next;
            message.recycleUnchecked();
            message = message2;
        }
        this.mMessages = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIdleHandler(IdleHandler idleHandler) {
        if (idleHandler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        synchronized (this) {
            this.mIdleHandlers.add(idleHandler);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dump(Printer printer, String string2) {
        synchronized (this) {
            long l = SystemClock.uptimeMillis();
            int n = 0;
            Message message = this.mMessages;
            while (true) {
                if (message == null) {
                    printer.println(string2 + "(Total messages: " + n + ", idling=" + this.isIdlingLocked() + ", quitting=" + this.mQuitting + ")");
                    return;
                }
                printer.println(string2 + "Message " + n + ": " + message.toString(l));
                ++n;
                message = message.next;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean enqueueMessage(Message var1_1, long var2_2) {
        if (var1_1.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        if (var1_1.isInUse()) {
            throw new IllegalStateException(var1_1 + " This message is already in use.");
        }
        synchronized (this) {
            block13: {
                block12: {
                    if (this.mQuitting) {
                        var5_3 = new IllegalStateException(var1_1.target + " sending message to a Handler on a dead thread");
                        Log.w("MessageQueue", var5_3.getMessage(), var5_3);
                        var1_1.recycle();
                        return false;
                    }
                    var1_1.markInUse();
                    var1_1.when = var2_2;
                    var7_4 = this.mMessages;
                    if (var7_4 == null || var2_2 == 0L || var2_2 < var7_4.when) break block12;
                    var9_6 = this.mBlocked;
                    var8_5 = false;
                    if (!var9_6) break block13;
                    var10_7 = var7_4.target;
                    var8_5 = false;
                    if (var10_7 == null) {
                        var11_8 = var1_1.isAsynchronous();
                        var8_5 = false;
                        if (var11_8) {
                            var8_5 = true;
                        }
                    }
                    break block13;
                }
                var1_1.next = var7_4;
                this.mMessages = var1_1;
                var8_5 = this.mBlocked;
lbl32:
                // 2 sources

                while (true) {
                    if (var8_5) {
                        MessageQueue.nativeWake(this.mPtr);
                    }
                    return true;
                }
            }
            while (true) {
                var12_9 = var7_4;
                var7_4 = var7_4.next;
                if (var7_4 == null || var2_2 < var7_4.when) {
                    var1_1.next = var7_4;
                    var12_9.next = var1_1;
                    ** continue;
                }
                if (!var8_5 || !(var13_10 = var7_4.isAsynchronous())) continue;
                var8_5 = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int enqueueSyncBarrier(long l) {
        synchronized (this) {
            int n = this.mNextBarrierToken;
            this.mNextBarrierToken = n + 1;
            Message message = Message.obtain();
            message.markInUse();
            message.when = l;
            message.arg1 = n;
            Message message2 = this.mMessages;
            long l2 = l - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            Message message3 = null;
            if (l3 != false) {
                while (message2 != null && message2.when <= l) {
                    message3 = message2;
                    message2 = message2.next;
                }
            }
            if (message3 != null) {
                message.next = message2;
                message3.next = message;
            } else {
                message.next = message2;
                this.mMessages = message;
            }
            return n;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasMessages(Handler handler, int n, Object object) {
        if (handler == null) {
            return false;
        }
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null) {
                if (message.target == handler && message.what == n && (object == null || message.obj == object)) {
                    return true;
                }
                message = message.next;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasMessages(Handler handler, Runnable runnable, Object object) {
        if (handler == null) {
            return false;
        }
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null) {
                if (message.target == handler && message.callback == runnable && (object == null || message.obj == object)) {
                    return true;
                }
                message = message.next;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isIdling() {
        synchronized (this) {
            return this.isIdlingLocked();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Message next() {
        long l = this.mPtr;
        if (l == 0L) {
            return null;
        }
        int n = -1;
        int n2 = 0;
        while (true) {
            if (n2 != 0) {
                Binder.flushPendingCommands();
            }
            MessageQueue.nativePollOnce(l, n2);
            synchronized (this) {
                long l2;
                block24: {
                    l2 = SystemClock.uptimeMillis();
                    Message message = this.mMessages;
                    Message message2 = null;
                    if (message != null) {
                        Handler handler = message.target;
                        message2 = null;
                        if (handler == null) {
                            do {
                                message2 = message;
                            } while ((message = message.next) != null && !message.isAsynchronous());
                        }
                    }
                    if (message != null) {
                        if (l2 < message.when) {
                            n2 = (int)Math.min(message.when - l2, Integer.MAX_VALUE);
                            break block24;
                        } else {
                            this.mBlocked = false;
                            if (message2 != null) {
                                message2.next = message.next;
                            } else {
                                this.mMessages = message.next;
                            }
                            message.next = null;
                            return message;
                        }
                    }
                    n2 = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (n < 0 && (this.mMessages == null || l2 < this.mMessages.when)) {
                    n = this.mIdleHandlers.size();
                }
                if (n <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(n, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < n; ++i) {
                boolean bl;
                IdleHandler idleHandler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                try {
                    boolean bl2;
                    bl = bl2 = idleHandler.queueIdle();
                }
                catch (Throwable throwable) {
                    Log.wtf("MessageQueue", "IdleHandler threw exception", throwable);
                    bl = false;
                }
                if (bl) continue;
                synchronized (this) {
                    this.mIdleHandlers.remove(idleHandler);
                    continue;
                }
            }
            n2 = 0;
            n = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void quit(boolean bl) {
        if (!this.mQuitAllowed) {
            throw new IllegalStateException("Main thread not allowed to quit.");
        }
        synchronized (this) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (bl) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeCallbacksAndMessages(Handler handler, Object object) {
        if (handler == null) {
            return;
        }
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null && message.target == handler && (object == null || message.obj == object)) {
                Message message2;
                this.mMessages = message2 = message.next;
                message.recycleUnchecked();
                message = message2;
            }
            while (message != null) {
                Message message3 = message.next;
                if (message3 != null && message3.target == handler && (object == null || message3.obj == object)) {
                    Message message4 = message3.next;
                    message3.recycleUnchecked();
                    message.next = message4;
                    continue;
                }
                message = message3;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeIdleHandler(IdleHandler idleHandler) {
        synchronized (this) {
            this.mIdleHandlers.remove(idleHandler);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeMessages(Handler handler, int n, Object object) {
        if (handler == null) {
            return;
        }
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null && message.target == handler && message.what == n && (object == null || message.obj == object)) {
                Message message2;
                this.mMessages = message2 = message.next;
                message.recycleUnchecked();
                message = message2;
            }
            while (message != null) {
                Message message3 = message.next;
                if (message3 != null && message3.target == handler && message3.what == n && (object == null || message3.obj == object)) {
                    Message message4 = message3.next;
                    message3.recycleUnchecked();
                    message.next = message4;
                    continue;
                }
                message = message3;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeMessages(Handler handler, Runnable runnable, Object object) {
        if (handler == null || runnable == null) {
            return;
        }
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null && message.target == handler && message.callback == runnable && (object == null || message.obj == object)) {
                Message message2;
                this.mMessages = message2 = message.next;
                message.recycleUnchecked();
                message = message2;
            }
            while (message != null) {
                Message message3 = message.next;
                if (message3 != null && message3.target == handler && message3.callback == runnable && (object == null || message3.obj == object)) {
                    Message message4 = message3.next;
                    message3.recycleUnchecked();
                    message.next = message4;
                    continue;
                }
                message = message3;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeSyncBarrier(int n) {
        synchronized (this) {
            boolean bl;
            Message message = null;
            Message message2 = this.mMessages;
            while (message2 != null && (message2.target != null || message2.arg1 != n)) {
                message = message2;
                message2 = message2.next;
            }
            if (message2 == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (message != null) {
                message.next = message2.next;
                bl = false;
            } else {
                Handler handler;
                this.mMessages = message2.next;
                bl = this.mMessages == null || (handler = this.mMessages.target) != null;
            }
            message2.recycleUnchecked();
            if (bl && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
            return;
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

