/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.location.Country;
import android.location.CountryDetector;
import android.net.Uri;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.BaseColumns;
import android.provider.ContactsContract;
import android.telecom.PhoneAccountHandle;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.telephony.CallerInfo;
import java.util.List;

public class CallLog {
    public static final String AUTHORITY = "call_log";
    public static final Uri CONTENT_URI = Uri.parse("content://call_log");
    private static final String TAG = "CallLog";

    public static class Calls
    implements BaseColumns {
        public static final String ALLOW_VOICEMAILS_PARAM_KEY = "allow_voicemails";
        public static final String CACHED_FORMATTED_NUMBER = "formatted_number";
        public static final String CACHED_LOOKUP_URI = "lookup_uri";
        public static final String CACHED_MATCHED_NUMBER = "matched_number";
        public static final String CACHED_NAME = "name";
        public static final String CACHED_NORMALIZED_NUMBER = "normalized_number";
        public static final String CACHED_NUMBER_LABEL = "numberlabel";
        public static final String CACHED_NUMBER_TYPE = "numbertype";
        public static final String CACHED_PHOTO_ID = "photo_id";
        public static final String CITY_ID = "city_id";
        public static final String CONTACTID = "block";
        public static final Uri CONTENT_FILTER_URI;
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/calls";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/calls";
        public static final Uri CONTENT_URI;
        public static final Uri CONTENT_URI_WITH_VOICEMAIL;
        public static final String COUNTRY_ISO = "countryiso";
        public static final String DATA_USAGE = "data_usage";
        public static final String DATE = "date";
        public static final String DEFAULT_SORT_ORDER = "date DESC";
        public static final String DURATION = "duration";
        public static final String EXTRA_CALL_TYPE_FILTER = "android.provider.extra.CALL_TYPE_FILTER";
        public static final String FEATURES = "features";
        public static final int FEATURES_VIDEO = 1;
        public static final String GEOCODED_LOCATION = "geocoded_location";
        public static final int INCOMING_TYPE = 1;
        public static final String ISBLOCK = "contact_id";
        public static final String IS_READ = "is_read";
        public static final String LIMIT_PARAM_KEY = "limit";
        private static final int MIN_DURATION_FOR_NORMALIZED_NUMBER_UPDATE_MS = 10000;
        public static final int MISSED_TYPE = 3;
        public static final String NEW = "new";
        public static final String NUMBER = "number";
        public static final String NUMBER_PRESENTATION = "presentation";
        public static final String OFFSET_PARAM_KEY = "offset";
        public static final int OUTGOING_TYPE = 2;
        public static final String PHONE_ACCOUNT_COMPONENT_NAME = "subscription_component_name";
        public static final String PHONE_ACCOUNT_ID = "subscription_id";
        public static final int PRESENTATION_ALLOWED = 1;
        public static final int PRESENTATION_PAYPHONE = 4;
        public static final int PRESENTATION_RESTRICTED = 2;
        public static final int PRESENTATION_UNKNOWN = 3;
        public static final String SIM_INDEX = "sim_index";
        public static final String SUB_ID = "sub_id";
        public static final String TRANSCRIPTION = "transcription";
        public static final String TYPE = "type";
        public static final int VOICEMAIL_TYPE = 4;
        public static final String VOICEMAIL_URI = "voicemail_uri";

        static {
            CONTENT_URI = Uri.parse("content://call_log/calls");
            CONTENT_FILTER_URI = Uri.parse("content://call_log/calls/filter");
            CONTENT_URI_WITH_VOICEMAIL = CONTENT_URI.buildUpon().appendQueryParameter(ALLOW_VOICEMAILS_PARAM_KEY, "true").build();
        }

        public static Uri addCall(CallerInfo callerInfo, Context context, String string2, int n, int n2, int n3, PhoneAccountHandle phoneAccountHandle, long l, int n4, Long l2) {
            return Calls.addCall(callerInfo, context, string2, n, n2, n3, phoneAccountHandle, l, n4, l2, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Uri addCall(CallerInfo callerInfo, Context context, String string2, int n, int n2, int n3, PhoneAccountHandle phoneAccountHandle, long l, int n4, Long l2, boolean bl) {
            Cursor cursor;
            ContentValues contentValues;
            block21: {
                ContentResolver contentResolver = context.getContentResolver();
                int n5 = 1;
                if (n == 2) {
                    n5 = 2;
                } else if (n == 4) {
                    n5 = 4;
                } else if (TextUtils.isEmpty(string2) || n == 3) {
                    n5 = 3;
                }
                if (n5 != 1) {
                    string2 = "";
                    if (callerInfo != null) {
                        callerInfo.name = "";
                    }
                }
                String string3 = null;
                String string4 = null;
                if (phoneAccountHandle != null) {
                    string3 = phoneAccountHandle.getComponentName().flattenToString();
                    string4 = phoneAccountHandle.getId();
                }
                contentValues = new ContentValues(6);
                contentValues.put(NUMBER, string2);
                contentValues.put(NUMBER_PRESENTATION, n5);
                contentValues.put(TYPE, n2);
                contentValues.put(FEATURES, n3);
                contentValues.put(DATE, l);
                contentValues.put(DURATION, Long.valueOf(n4));
                if (l2 != null) {
                    contentValues.put(DATA_USAGE, l2);
                }
                contentValues.put(PHONE_ACCOUNT_COMPONENT_NAME, string3);
                contentValues.put(PHONE_ACCOUNT_ID, string4);
                contentValues.put(NEW, 1);
                if (n2 == 3) {
                    contentValues.put(IS_READ, 0);
                }
                if (callerInfo != null) {
                    contentValues.put(CACHED_NAME, callerInfo.name);
                    contentValues.put(CACHED_NUMBER_TYPE, callerInfo.numberType);
                    contentValues.put(CACHED_NUMBER_LABEL, callerInfo.numberLabel);
                }
                if (callerInfo != null && callerInfo.contactIdOrZero > 0L) {
                    if (callerInfo.normalizedNumber != null) {
                        String string5 = callerInfo.normalizedNumber;
                        Uri uri = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
                        String[] stringArray = new String[]{"_id"};
                        String[] stringArray2 = new String[]{String.valueOf(callerInfo.contactIdOrZero), string5};
                        cursor = contentResolver.query(uri, stringArray, "contact_id =? AND data4 =?", stringArray2, null);
                    } else {
                        String string6 = callerInfo.phoneNumber != null ? callerInfo.phoneNumber : string2;
                        Uri uri = Uri.withAppendedPath(ContactsContract.CommonDataKinds.Callable.CONTENT_FILTER_URI, Uri.encode(string6));
                        String[] stringArray = new String[]{"_id"};
                        String[] stringArray3 = new String[]{String.valueOf(callerInfo.contactIdOrZero)};
                        cursor = contentResolver.query(uri, stringArray, "contact_id =?", stringArray3, null);
                    }
                    if (cursor != null) {
                        if (cursor.getCount() <= 0 || !cursor.moveToFirst()) break block21;
                        String string7 = cursor.getString(0);
                        Calls.updateDataUsageStatForData(contentResolver, string7);
                        if (n4 < 10000 || n2 != 2 || !TextUtils.isEmpty(callerInfo.normalizedNumber)) break block21;
                        Calls.updateNormalizedNumber(context, contentResolver, string7, string2);
                    }
                }
            }
            Uri uri = null;
            if (!bl) return Calls.addEntryAndRemoveExpiredEntries(context, CONTENT_URI, contentValues);
            UserManager userManager = (UserManager)context.getSystemService("user");
            List<UserInfo> list = userManager.getUsers(true);
            int n6 = userManager.getUserHandle();
            int n7 = list.size();
            int n8 = 0;
            while (n8 < n7) {
                UserInfo userInfo = list.get(n8);
                UserHandle userHandle = userInfo.getUserHandle();
                if (userManager.isUserRunning(userHandle) && !userManager.hasUserRestriction("no_outgoing_calls", userHandle) && !userInfo.isManagedProfile()) {
                    Uri uri2 = Calls.addEntryAndRemoveExpiredEntries(context, ContentProvider.maybeAddUserId(CONTENT_URI, userInfo.id), contentValues);
                    if (userInfo.id == n6) {
                        uri = uri2;
                    }
                }
                ++n8;
            }
            return uri;
            finally {
                cursor.close();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Uri addCall(CallerInfo callerInfo, Context context, String string2, int n, int n2, int n3, PhoneAccountHandle phoneAccountHandle, long l, int n4, Long l2, boolean bl, int n5, int n6, String string3) {
            Uri uri;
            block21: {
                ContentValues contentValues;
                block20: {
                    Cursor cursor;
                    block19: {
                        ContentResolver contentResolver = context.getContentResolver();
                        int n7 = 1;
                        if (n == 2) {
                            n7 = 2;
                        } else if (n == 4) {
                            n7 = 4;
                        } else if (TextUtils.isEmpty(string2) || n == 3) {
                            n7 = 3;
                        }
                        if (n7 != 1) {
                            string2 = "";
                            if (callerInfo != null) {
                                callerInfo.name = "";
                            }
                        }
                        String string4 = null;
                        String string5 = null;
                        if (phoneAccountHandle != null) {
                            string4 = phoneAccountHandle.getComponentName().flattenToString();
                            string5 = phoneAccountHandle.getId();
                        }
                        contentValues = new ContentValues(6);
                        contentValues.put(NUMBER, string2);
                        contentValues.put(NUMBER_PRESENTATION, n7);
                        contentValues.put(TYPE, n2);
                        contentValues.put(ISBLOCK, n5);
                        contentValues.put(SIM_INDEX, n6);
                        contentValues.put(CITY_ID, string3);
                        contentValues.put(FEATURES, n3);
                        contentValues.put(DATE, l);
                        contentValues.put(DURATION, Long.valueOf(n4));
                        if (l2 != null) {
                            contentValues.put(DATA_USAGE, l2);
                        }
                        contentValues.put(PHONE_ACCOUNT_COMPONENT_NAME, string4);
                        contentValues.put(PHONE_ACCOUNT_ID, string5);
                        contentValues.put(NEW, 1);
                        if (n2 == 3) {
                            contentValues.put(IS_READ, 0);
                        }
                        if (callerInfo != null) {
                            contentValues.put(CACHED_NAME, callerInfo.name);
                            contentValues.put(CACHED_NUMBER_TYPE, callerInfo.numberType);
                            contentValues.put(CACHED_NUMBER_LABEL, callerInfo.numberLabel);
                        }
                        if (callerInfo != null && callerInfo.contactIdOrZero > 0L) {
                            contentValues.put(CONTACTID, callerInfo.contactIdOrZero);
                            if (callerInfo.normalizedNumber != null) {
                                String string6 = callerInfo.normalizedNumber;
                                Uri uri2 = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
                                String[] stringArray = new String[]{"_id"};
                                String[] stringArray2 = new String[]{String.valueOf(callerInfo.contactIdOrZero), string6};
                                cursor = contentResolver.query(uri2, stringArray, "contact_id =? AND data4 =?", stringArray2, null);
                            } else {
                                String string7 = callerInfo.phoneNumber != null ? callerInfo.phoneNumber : string2;
                                Uri uri3 = Uri.withAppendedPath(ContactsContract.CommonDataKinds.Callable.CONTENT_FILTER_URI, Uri.encode(string7));
                                String[] stringArray = new String[]{"_id"};
                                String[] stringArray3 = new String[]{String.valueOf(callerInfo.contactIdOrZero)};
                                cursor = contentResolver.query(uri3, stringArray, "contact_id =?", stringArray3, null);
                            }
                            if (cursor != null) {
                                if (cursor.getCount() <= 0 || !cursor.moveToFirst()) break block19;
                                String string8 = cursor.getString(0);
                                Calls.updateDataUsageStatForData(contentResolver, string8);
                                if (n4 < 10000 || n2 != 2 || !TextUtils.isEmpty(callerInfo.normalizedNumber)) break block19;
                                Calls.updateNormalizedNumber(context, contentResolver, string8, string2);
                            }
                        }
                    }
                    uri = null;
                    if (!bl) break block20;
                    UserManager userManager = (UserManager)context.getSystemService("user");
                    List<UserInfo> list = userManager.getUsers(true);
                    int n8 = userManager.getUserHandle();
                    int n9 = list.size();
                    for (int i = 0; i < n9; ++i) {
                        UserInfo userInfo = list.get(i);
                        UserHandle userHandle = userInfo.getUserHandle();
                        if (!userManager.isUserRunning(userHandle) || userManager.hasUserRestriction("no_outgoing_calls", userHandle) || userInfo.isManagedProfile()) continue;
                        Uri uri4 = Calls.addEntryAndRemoveExpiredEntries(context, ContentProvider.maybeAddUserId(CONTENT_URI, userInfo.id), contentValues);
                        if (userInfo.id != n8) continue;
                        uri = uri4;
                    }
                    break block21;
                    finally {
                        cursor.close();
                    }
                }
                uri = Calls.addEntryAndRemoveExpiredEntries(context, CONTENT_URI, contentValues);
            }
            Calls.removeExpiredEntries(context);
            return uri;
        }

        private static Uri addEntryAndRemoveExpiredEntries(Context context, Uri uri, ContentValues contentValues) {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri2 = contentResolver.insert(uri, contentValues);
            contentResolver.delete(uri, "_id IN (SELECT _id FROM calls ORDER BY date DESC LIMIT -1 OFFSET 500)", null);
            return uri2;
        }

        private static String getCurrentCountryIso(Context context) {
            CountryDetector countryDetector = (CountryDetector)context.getSystemService("country_detector");
            String string2 = null;
            if (countryDetector != null) {
                Country country = countryDetector.detectCountry();
                string2 = null;
                if (country != null) {
                    string2 = country.getCountryIso();
                }
            }
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String getLastOutgoingCall(Context context) {
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = null;
            try {
                String string2;
                String string3;
                cursor = contentResolver.query(CONTENT_URI, new String[]{NUMBER}, "type = 2", null, "date DESC LIMIT 1");
                if (cursor == null || !cursor.moveToFirst()) {
                    string3 = "";
                    if (cursor == null) return string3;
                    cursor.close();
                    return string3;
                }
                string3 = string2 = cursor.getString(0);
                if (cursor == null) return string3;
                cursor.close();
                return string3;
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
        }

        private static void removeExpiredEntries(Context context) {
            context.getContentResolver().delete(CONTENT_URI, "_id IN (SELECT _id FROM calls ORDER BY date DESC LIMIT -1 OFFSET 500)", null);
        }

        private static void updateDataUsageStatForData(ContentResolver contentResolver, String string2) {
            contentResolver.update(ContactsContract.DataUsageFeedback.FEEDBACK_URI.buildUpon().appendPath(string2).appendQueryParameter(TYPE, "call").build(), new ContentValues(), null, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void updateNormalizedNumber(Context context, ContentResolver contentResolver, String string2, String string3) {
            String string4;
            if (TextUtils.isEmpty(string3) || TextUtils.isEmpty(string2) || TextUtils.isEmpty(Calls.getCurrentCountryIso(context)) || TextUtils.isEmpty(string4 = PhoneNumberUtils.formatNumberToE164(string3, Calls.getCurrentCountryIso(context)))) {
                return;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("data4", string4);
            contentResolver.update(ContactsContract.Data.CONTENT_URI, contentValues, "_id=?", new String[]{string2});
        }
    }
}

