/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.os.RemoteException;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public final class DocumentsContract {
    public static final String ACTION_MANAGE_DOCUMENT = "android.provider.action.MANAGE_DOCUMENT";
    public static final String ACTION_MANAGE_ROOT = "android.provider.action.MANAGE_ROOT";
    public static final String EXTRA_ERROR = "error";
    public static final String EXTRA_INFO = "info";
    public static final String EXTRA_LOADING = "loading";
    public static final String EXTRA_ORIENTATION = "android.content.extra.ORIENTATION";
    public static final String EXTRA_PACKAGE_NAME = "android.content.extra.PACKAGE_NAME";
    public static final String EXTRA_SHOW_ADVANCED = "android.content.extra.SHOW_ADVANCED";
    public static final String EXTRA_URI = "uri";
    public static final String METHOD_CREATE_DOCUMENT = "android:createDocument";
    public static final String METHOD_DELETE_DOCUMENT = "android:deleteDocument";
    public static final String METHOD_RENAME_DOCUMENT = "android:renameDocument";
    private static final String PARAM_MANAGE = "manage";
    private static final String PARAM_QUERY = "query";
    private static final String PATH_CHILDREN = "children";
    private static final String PATH_DOCUMENT = "document";
    private static final String PATH_RECENT = "recent";
    private static final String PATH_ROOT = "root";
    private static final String PATH_SEARCH = "search";
    private static final String PATH_TREE = "tree";
    public static final String PROVIDER_INTERFACE = "android.content.action.DOCUMENTS_PROVIDER";
    private static final String TAG = "Documents";
    private static final int THUMBNAIL_BUFFER_SIZE = 131072;

    private DocumentsContract() {
    }

    public static Uri buildChildDocumentsUri(String string2, String string3) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_DOCUMENT).appendPath(string3).appendPath(PATH_CHILDREN).build();
    }

    public static Uri buildChildDocumentsUriUsingTree(Uri uri, String string2) {
        return new Uri.Builder().scheme("content").authority(uri.getAuthority()).appendPath(PATH_TREE).appendPath(DocumentsContract.getTreeDocumentId(uri)).appendPath(PATH_DOCUMENT).appendPath(string2).appendPath(PATH_CHILDREN).build();
    }

    public static Uri buildDocumentUri(String string2, String string3) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_DOCUMENT).appendPath(string3).build();
    }

    public static Uri buildDocumentUriMaybeUsingTree(Uri uri, String string2) {
        if (DocumentsContract.isTreeUri(uri)) {
            return DocumentsContract.buildDocumentUriUsingTree(uri, string2);
        }
        return DocumentsContract.buildDocumentUri(uri.getAuthority(), string2);
    }

    public static Uri buildDocumentUriUsingTree(Uri uri, String string2) {
        return new Uri.Builder().scheme("content").authority(uri.getAuthority()).appendPath(PATH_TREE).appendPath(DocumentsContract.getTreeDocumentId(uri)).appendPath(PATH_DOCUMENT).appendPath(string2).build();
    }

    public static Uri buildRecentDocumentsUri(String string2, String string3) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_ROOT).appendPath(string3).appendPath(PATH_RECENT).build();
    }

    public static Uri buildRootUri(String string2, String string3) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_ROOT).appendPath(string3).build();
    }

    public static Uri buildRootsUri(String string2) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_ROOT).build();
    }

    public static Uri buildSearchDocumentsUri(String string2, String string3, String string4) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_ROOT).appendPath(string3).appendPath(PATH_SEARCH).appendQueryParameter(PARAM_QUERY, string4).build();
    }

    public static Uri buildTreeDocumentUri(String string2, String string3) {
        return new Uri.Builder().scheme("content").authority(string2).appendPath(PATH_TREE).appendPath(string3).build();
    }

    public static Uri createDocument(ContentProviderClient contentProviderClient, Uri uri, String string2, String string3) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA_URI, uri);
        bundle.putString("mime_type", string2);
        bundle.putString("_display_name", string3);
        return (Uri)contentProviderClient.call(METHOD_CREATE_DOCUMENT, null, bundle).getParcelable(EXTRA_URI);
    }

    public static Uri createDocument(ContentResolver contentResolver, Uri uri, String string2, String string3) {
        ContentProviderClient contentProviderClient = contentResolver.acquireUnstableContentProviderClient(uri.getAuthority());
        try {
            Uri uri2 = DocumentsContract.createDocument(contentProviderClient, uri, string2, string3);
            return uri2;
        }
        catch (Exception exception) {
            Log.w(TAG, "Failed to create document", exception);
            return null;
        }
        finally {
            ContentProviderClient.releaseQuietly(contentProviderClient);
        }
    }

    public static void deleteDocument(ContentProviderClient contentProviderClient, Uri uri) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA_URI, uri);
        contentProviderClient.call(METHOD_DELETE_DOCUMENT, null, bundle);
    }

    public static boolean deleteDocument(ContentResolver contentResolver, Uri uri) {
        ContentProviderClient contentProviderClient = contentResolver.acquireUnstableContentProviderClient(uri.getAuthority());
        try {
            DocumentsContract.deleteDocument(contentProviderClient, uri);
            return true;
        }
        catch (Exception exception) {
            Log.w(TAG, "Failed to delete document", exception);
            return false;
        }
        finally {
            ContentProviderClient.releaseQuietly(contentProviderClient);
        }
    }

    public static String getDocumentId(Uri uri) {
        List<String> list = uri.getPathSegments();
        if (list.size() >= 2 && PATH_DOCUMENT.equals(list.get(0))) {
            return list.get(1);
        }
        if (list.size() >= 4 && PATH_TREE.equals(list.get(0)) && PATH_DOCUMENT.equals(list.get(2))) {
            return list.get(3);
        }
        throw new IllegalArgumentException("Invalid URI: " + uri);
    }

    /*
     * Exception decompiling
     */
    public static Bitmap getDocumentThumbnail(ContentProviderClient var0, Uri var1_1, Point var2_2, CancellationSignal var3_3) throws RemoteException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [11 : 293->329)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Bitmap getDocumentThumbnail(ContentResolver contentResolver, Uri uri, Point point, CancellationSignal cancellationSignal) {
        ContentProviderClient contentProviderClient = contentResolver.acquireUnstableContentProviderClient(uri.getAuthority());
        try {
            Bitmap bitmap = DocumentsContract.getDocumentThumbnail(contentProviderClient, uri, point, cancellationSignal);
            return bitmap;
        }
        catch (Exception exception) {
            if (!(exception instanceof OperationCanceledException)) {
                Log.w(TAG, "Failed to load thumbnail for " + uri + ": " + exception);
            }
            return null;
        }
        finally {
            ContentProviderClient.releaseQuietly(contentProviderClient);
        }
    }

    public static String getRootId(Uri uri) {
        List<String> list = uri.getPathSegments();
        if (list.size() >= 2 && PATH_ROOT.equals(list.get(0))) {
            return list.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + uri);
    }

    public static String getSearchDocumentsQuery(Uri uri) {
        return uri.getQueryParameter(PARAM_QUERY);
    }

    public static String getTreeDocumentId(Uri uri) {
        List<String> list = uri.getPathSegments();
        if (list.size() >= 2 && PATH_TREE.equals(list.get(0))) {
            return list.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDocumentUri(Context context, Uri uri) {
        List<String> list = uri.getPathSegments();
        if (list.size() == 2 && PATH_DOCUMENT.equals(list.get(0))) {
            return DocumentsContract.isDocumentsProvider(context, uri.getAuthority());
        }
        int n = list.size();
        boolean bl = false;
        if (n != 4) return bl;
        boolean bl2 = PATH_TREE.equals(list.get(0));
        bl = false;
        if (!bl2) return bl;
        boolean bl3 = PATH_DOCUMENT.equals(list.get(2));
        bl = false;
        if (!bl3) return bl;
        return DocumentsContract.isDocumentsProvider(context, uri.getAuthority());
    }

    private static boolean isDocumentsProvider(Context context, String string2) {
        boolean bl;
        block1: {
            Intent intent = new Intent(PROVIDER_INTERFACE);
            Iterator<ResolveInfo> iterator = context.getPackageManager().queryIntentContentProviders(intent, 0).iterator();
            do {
                boolean bl2 = iterator.hasNext();
                bl = false;
                if (!bl2) break block1;
            } while (!string2.equals(iterator.next().providerInfo.authority));
            bl = true;
        }
        return bl;
    }

    public static boolean isManageMode(Uri uri) {
        return uri.getBooleanQueryParameter(PARAM_MANAGE, false);
    }

    public static boolean isTreeUri(Uri uri) {
        List<String> list = uri.getPathSegments();
        int n = list.size();
        boolean bl = false;
        if (n >= 2) {
            boolean bl2 = PATH_TREE.equals(list.get(0));
            bl = false;
            if (bl2) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    public static AssetFileDescriptor openImageThumbnail(File var0) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Uri renameDocument(ContentProviderClient contentProviderClient, Uri uri, String string2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA_URI, uri);
        bundle.putString("_display_name", string2);
        Uri uri2 = (Uri)contentProviderClient.call(METHOD_RENAME_DOCUMENT, null, bundle).getParcelable(EXTRA_URI);
        if (uri2 != null) {
            return uri2;
        }
        return uri;
    }

    public static Uri renameDocument(ContentResolver contentResolver, Uri uri, String string2) {
        ContentProviderClient contentProviderClient = contentResolver.acquireUnstableContentProviderClient(uri.getAuthority());
        try {
            Uri uri2 = DocumentsContract.renameDocument(contentProviderClient, uri, string2);
            return uri2;
        }
        catch (Exception exception) {
            Log.w(TAG, "Failed to rename document", exception);
            return null;
        }
        finally {
            ContentProviderClient.releaseQuietly(contentProviderClient);
        }
    }

    public static Uri setManageMode(Uri uri) {
        return uri.buildUpon().appendQueryParameter(PARAM_MANAGE, "true").build();
    }

    public static final class Document {
        public static final String COLUMN_DISPLAY_NAME = "_display_name";
        public static final String COLUMN_DOCUMENT_ID = "document_id";
        public static final String COLUMN_FLAGS = "flags";
        public static final String COLUMN_ICON = "icon";
        public static final String COLUMN_LAST_MODIFIED = "last_modified";
        public static final String COLUMN_MIME_TYPE = "mime_type";
        public static final String COLUMN_SIZE = "_size";
        public static final String COLUMN_SUMMARY = "summary";
        public static final int FLAG_DIR_HIDE_GRID_TITLES = 65536;
        public static final int FLAG_DIR_PREFERS_GRID = 16;
        public static final int FLAG_DIR_PREFERS_LAST_MODIFIED = 32;
        public static final int FLAG_DIR_SUPPORTS_CREATE = 8;
        public static final int FLAG_SUPPORTS_DELETE = 4;
        public static final int FLAG_SUPPORTS_RENAME = 64;
        public static final int FLAG_SUPPORTS_THUMBNAIL = 1;
        public static final int FLAG_SUPPORTS_WRITE = 2;
        public static final String MIME_TYPE_DIR = "vnd.android.document/directory";

        private Document() {
        }
    }

    public static final class Root {
        public static final String COLUMN_AVAILABLE_BYTES = "available_bytes";
        public static final String COLUMN_DOCUMENT_ID = "document_id";
        public static final String COLUMN_FLAGS = "flags";
        public static final String COLUMN_ICON = "icon";
        public static final String COLUMN_MIME_TYPES = "mime_types";
        public static final String COLUMN_ROOT_ID = "root_id";
        public static final String COLUMN_SUMMARY = "summary";
        public static final String COLUMN_TITLE = "title";
        public static final int FLAG_ADVANCED = 131072;
        public static final int FLAG_EMPTY = 65536;
        public static final int FLAG_LOCAL_ONLY = 2;
        public static final int FLAG_SUPPORTS_CREATE = 1;
        public static final int FLAG_SUPPORTS_IS_CHILD = 16;
        public static final int FLAG_SUPPORTS_RECENTS = 4;
        public static final int FLAG_SUPPORTS_SEARCH = 8;
        public static final String MIME_TYPE_ITEM = "vnd.android.document/root";

        private Root() {
        }
    }
}

