/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.util.Pair;

public class SyncStateContract {

    public static interface Columns
    extends BaseColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String DATA = "data";
    }

    public static class Constants
    implements Columns {
        public static final String CONTENT_DIRECTORY = "syncstate";
    }

    public static final class Helpers {
        private static final String[] DATA_PROJECTION = new String[]{"data", "_id"};
        private static final String SELECT_BY_ACCOUNT = "account_name=? AND account_type=?";

        public static byte[] get(ContentProviderClient contentProviderClient, Uri uri, Account account) throws RemoteException {
            String[] stringArray = DATA_PROJECTION;
            String[] stringArray2 = new String[]{account.name, account.type};
            Cursor cursor = contentProviderClient.query(uri, stringArray, SELECT_BY_ACCOUNT, stringArray2, null);
            if (cursor == null) {
                throw new RemoteException();
            }
            try {
                if (cursor.moveToNext()) {
                    byte[] byArray = cursor.getBlob(cursor.getColumnIndexOrThrow("data"));
                    return byArray;
                }
                return null;
            }
            finally {
                cursor.close();
            }
        }

        public static Pair<Uri, byte[]> getWithUri(ContentProviderClient contentProviderClient, Uri uri, Account account) throws RemoteException {
            String[] stringArray = DATA_PROJECTION;
            String[] stringArray2 = new String[]{account.name, account.type};
            Cursor cursor = contentProviderClient.query(uri, stringArray, SELECT_BY_ACCOUNT, stringArray2, null);
            if (cursor == null) {
                throw new RemoteException();
            }
            try {
                if (cursor.moveToNext()) {
                    long l = cursor.getLong(1);
                    byte[] byArray = cursor.getBlob(cursor.getColumnIndexOrThrow("data"));
                    Pair<Uri, byte[]> pair = Pair.create(ContentUris.withAppendedId(uri, l), byArray);
                    return pair;
                }
                return null;
            }
            finally {
                cursor.close();
            }
        }

        public static Uri insert(ContentProviderClient contentProviderClient, Uri uri, Account account, byte[] byArray) throws RemoteException {
            ContentValues contentValues = new ContentValues();
            contentValues.put("data", byArray);
            contentValues.put("account_name", account.name);
            contentValues.put("account_type", account.type);
            return contentProviderClient.insert(uri, contentValues);
        }

        public static ContentProviderOperation newSetOperation(Uri uri, Account account, byte[] byArray) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("data", byArray);
            return ContentProviderOperation.newInsert(uri).withValue("account_name", account.name).withValue("account_type", account.type).withValues(contentValues).build();
        }

        public static ContentProviderOperation newUpdateOperation(Uri uri, byte[] byArray) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("data", byArray);
            return ContentProviderOperation.newUpdate(uri).withValues(contentValues).build();
        }

        public static void set(ContentProviderClient contentProviderClient, Uri uri, Account account, byte[] byArray) throws RemoteException {
            ContentValues contentValues = new ContentValues();
            contentValues.put("data", byArray);
            contentValues.put("account_name", account.name);
            contentValues.put("account_type", account.type);
            contentProviderClient.insert(uri, contentValues);
        }

        public static void update(ContentProviderClient contentProviderClient, Uri uri, byte[] byArray) throws RemoteException {
            ContentValues contentValues = new ContentValues();
            contentValues.put("data", byArray);
            contentProviderClient.update(uri, contentValues, null, null);
        }
    }
}

