/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Environment;
import android.renderscript.BaseObj;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Font
extends BaseObj {
    private static Map<String, FontFamily> sFontFamilyMap;
    private static final String[] sMonoNames;
    private static final String[] sSansNames;
    private static final String[] sSerifNames;

    static {
        sSansNames = new String[]{"sans-serif", "arial", "helvetica", "tahoma", "verdana"};
        sSerifNames = new String[]{"serif", "times", "times new roman", "palatino", "georgia", "baskerville", "goudy", "fantasy", "cursive", "ITC Stone Serif"};
        sMonoNames = new String[]{"monospace", "courier", "courier new", "monaco"};
        Font.initFontFamilyMap();
    }

    Font(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    private static void addFamilyToMap(FontFamily fontFamily) {
        for (int i = 0; i < fontFamily.mNames.length; ++i) {
            sFontFamilyMap.put(fontFamily.mNames[i], fontFamily);
        }
    }

    public static Font create(RenderScript renderScript, Resources resources, String string2, Style style2, float f) {
        String string3 = Font.getFontFileName(string2, style2);
        String string4 = Environment.getRootDirectory().getAbsolutePath();
        return Font.createFromFile(renderScript, resources, string4 + "/fonts/" + string3, f);
    }

    public static Font createFromAsset(RenderScript renderScript, Resources resources, String string2, float f) {
        renderScript.validate();
        long l = renderScript.nFontCreateFromAsset(resources.getAssets(), string2, f, resources.getDisplayMetrics().densityDpi);
        if (l == 0L) {
            throw new RSRuntimeException("Unable to create font from asset " + string2);
        }
        return new Font(l, renderScript);
    }

    public static Font createFromFile(RenderScript renderScript, Resources resources, File file, float f) {
        return Font.createFromFile(renderScript, resources, file.getAbsolutePath(), f);
    }

    public static Font createFromFile(RenderScript renderScript, Resources resources, String string2, float f) {
        renderScript.validate();
        long l = renderScript.nFontCreateFromFile(string2, f, resources.getDisplayMetrics().densityDpi);
        if (l == 0L) {
            throw new RSRuntimeException("Unable to create font from file " + string2);
        }
        return new Font(l, renderScript);
    }

    public static Font createFromResource(RenderScript renderScript, Resources resources, int n, float f) {
        long l;
        block4: {
            block3: {
                int n2;
                InputStream inputStream;
                String string2 = "R." + Integer.toString(n);
                renderScript.validate();
                try {
                    inputStream = resources.openRawResource(n);
                    n2 = resources.getDisplayMetrics().densityDpi;
                }
                catch (Exception exception) {
                    throw new RSRuntimeException("Unable to open resource " + n);
                }
                if (!(inputStream instanceof AssetManager.AssetInputStream)) break block3;
                l = renderScript.nFontCreateFromAssetStream(string2, f, n2, ((AssetManager.AssetInputStream)inputStream).getNativeAsset());
                if (l == 0L) {
                    throw new RSRuntimeException("Unable to create font from resource " + n);
                }
                break block4;
            }
            throw new RSRuntimeException("Unsupported asset stream created");
        }
        return new Font(l, renderScript);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getFontFileName(String string2, Style style2) {
        FontFamily fontFamily = sFontFamilyMap.get(string2);
        if (fontFamily == null) return "DroidSans.ttf";
        switch (1.$SwitchMap$android$renderscript$Font$Style[style2.ordinal()]) {
            default: {
                return "DroidSans.ttf";
            }
            case 1: {
                return fontFamily.mNormalFileName;
            }
            case 2: {
                return fontFamily.mBoldFileName;
            }
            case 3: {
                return fontFamily.mItalicFileName;
            }
            case 4: 
        }
        return fontFamily.mBoldItalicFileName;
    }

    private static void initFontFamilyMap() {
        sFontFamilyMap = new HashMap<String, FontFamily>();
        FontFamily fontFamily = new FontFamily();
        fontFamily.mNames = sSansNames;
        fontFamily.mNormalFileName = "Roboto-Regular.ttf";
        fontFamily.mBoldFileName = "Roboto-Bold.ttf";
        fontFamily.mItalicFileName = "Roboto-Italic.ttf";
        fontFamily.mBoldItalicFileName = "Roboto-BoldItalic.ttf";
        Font.addFamilyToMap(fontFamily);
        FontFamily fontFamily2 = new FontFamily();
        fontFamily2.mNames = sSerifNames;
        fontFamily2.mNormalFileName = "NotoSerif-Regular.ttf";
        fontFamily2.mBoldFileName = "NotoSerif-Bold.ttf";
        fontFamily2.mItalicFileName = "NotoSerif-Italic.ttf";
        fontFamily2.mBoldItalicFileName = "NotoSerif-BoldItalic.ttf";
        Font.addFamilyToMap(fontFamily2);
        FontFamily fontFamily3 = new FontFamily();
        fontFamily3.mNames = sMonoNames;
        fontFamily3.mNormalFileName = "DroidSansMono.ttf";
        fontFamily3.mBoldFileName = "DroidSansMono.ttf";
        fontFamily3.mItalicFileName = "DroidSansMono.ttf";
        fontFamily3.mBoldItalicFileName = "DroidSansMono.ttf";
        Font.addFamilyToMap(fontFamily3);
    }

    private static class FontFamily {
        String mBoldFileName;
        String mBoldItalicFileName;
        String mItalicFileName;
        String[] mNames;
        String mNormalFileName;

        private FontFamily() {
        }
    }

    public static final class Style
    extends Enum<Style> {
        private static final /* synthetic */ Style[] $VALUES;
        public static final /* enum */ Style BOLD;
        public static final /* enum */ Style BOLD_ITALIC;
        public static final /* enum */ Style ITALIC;
        public static final /* enum */ Style NORMAL;

        static {
            NORMAL = new Style();
            BOLD = new Style();
            ITALIC = new Style();
            BOLD_ITALIC = new Style();
            Style[] styleArray = new Style[]{NORMAL, BOLD, ITALIC, BOLD_ITALIC};
            $VALUES = styleArray;
        }

        public static Style valueOf(String string2) {
            return Enum.valueOf(Style.class, string2);
        }

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }
    }
}

