/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.security.Credentials;
import android.security.KeyPairGeneratorSpec;
import android.security.KeyStore;
import com.android.org.bouncycastle.x509.X509V3CertificateGenerator;
import com.android.org.conscrypt.OpenSSLEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;

public class AndroidKeyPairGenerator
extends KeyPairGeneratorSpi {
    private KeyStore mKeyStore;
    private KeyPairGeneratorSpec mSpec;

    /*
     * Enabled aggressive block sorting
     */
    private static byte[][] getArgsForKeyType(int n, AlgorithmParameterSpec algorithmParameterSpec) {
        switch (n) {
            case 6: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) return null;
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                byte[][] byArrayArray = new byte[][]{rSAKeyGenParameterSpec.getPublicExponent().toByteArray()};
                return byArrayArray;
            }
            default: {
                return null;
            }
            case 116: {
                if (!(algorithmParameterSpec instanceof DSAParameterSpec)) return null;
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
                byte[][] byArrayArray = new byte[][]{dSAParameterSpec.getG().toByteArray(), dSAParameterSpec.getP().toByteArray(), dSAParameterSpec.getQ().toByteArray()};
                return byArrayArray;
            }
        }
    }

    private static String getDefaultSignatureAlgorithmForKeyType(String string2) {
        if ("RSA".equalsIgnoreCase(string2)) {
            return "sha256WithRSA";
        }
        if ("DSA".equalsIgnoreCase(string2)) {
            return "sha1WithDSA";
        }
        if ("EC".equalsIgnoreCase(string2)) {
            return "sha256WithECDSA";
        }
        throw new IllegalArgumentException("Unsupported key type " + string2);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public KeyPair generateKeyPair() {
        X509Certificate x509Certificate;
        byte[] byArray;
        PrivateKey privateKey;
        if (this.mKeyStore == null || this.mSpec == null) {
            throw new IllegalStateException("Must call initialize with an android.security.KeyPairGeneratorSpec first");
        }
        if ((1 & this.mSpec.getFlags()) != 0 && this.mKeyStore.state() != KeyStore.State.UNLOCKED) {
            throw new IllegalStateException("Android keystore must be in initialized and unlocked state if encryption is required");
        }
        String string2 = this.mSpec.getKeystoreAlias();
        Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
        int n = KeyStore.getKeyTypeForAlgorithm(this.mSpec.getKeyType());
        byte[][] byArray2 = AndroidKeyPairGenerator.getArgsForKeyType(n, this.mSpec.getAlgorithmParameterSpec());
        String string3 = "USRPKEY_" + string2;
        if (!this.mKeyStore.generate(string3, -1, n, this.mSpec.getKeySize(), this.mSpec.getFlags(), byArray2)) {
            throw new IllegalStateException("could not generate key in keystore");
        }
        OpenSSLEngine openSSLEngine = OpenSSLEngine.getInstance((String)"keystore");
        try {
            privateKey = openSSLEngine.getPrivateKeyById(string3);
            byArray = this.mKeyStore.getPubkey(string3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Can't get key", invalidKeyException);
        }
        PublicKey publicKey = KeyFactory.getInstance(this.mSpec.getKeyType()).generatePublic(new X509EncodedKeySpec(byArray));
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSerialNumber(this.mSpec.getSerialNumber());
        x509V3CertificateGenerator.setSubjectDN(this.mSpec.getSubjectDN());
        x509V3CertificateGenerator.setIssuerDN(this.mSpec.getSubjectDN());
        x509V3CertificateGenerator.setNotBefore(this.mSpec.getStartDate());
        x509V3CertificateGenerator.setNotAfter(this.mSpec.getEndDate());
        x509V3CertificateGenerator.setSignatureAlgorithm(AndroidKeyPairGenerator.getDefaultSignatureAlgorithmForKeyType(this.mSpec.getKeyType()));
        try {
            x509Certificate = x509V3CertificateGenerator.generate(privateKey);
        }
        catch (Exception exception) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
            throw new IllegalStateException("Can't generate certificate", exception);
        }
        try {
            byte[] byArray3 = x509Certificate.getEncoded();
            if (this.mKeyStore.put("USRCERT_" + string2, byArray3, -1, this.mSpec.getFlags())) return new KeyPair(publicKey, privateKey);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
            throw new IllegalStateException("Can't get encoding of certificate", certificateEncodingException);
        }
        Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
        throw new IllegalStateException("Can't store certificate in AndroidKeyStore");
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Can't instantiate key generator", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalStateException("keystore returned invalid key encoding", invalidKeySpecException);
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("cannot specify keysize with AndroidKeyPairGenerator");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("must supply params of type android.security.KeyPairGeneratorSpec");
        }
        if (!(algorithmParameterSpec instanceof KeyPairGeneratorSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type android.security.KeyPairGeneratorSpec");
        }
        this.mSpec = (KeyPairGeneratorSpec)algorithmParameterSpec;
        this.mKeyStore = KeyStore.getInstance();
    }
}

