/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.security.IKeystoreService;
import android.util.Log;
import java.util.Locale;

public class KeyStore {
    public static final int FLAG_ENCRYPTED = 1;
    public static final int FLAG_NONE = 0;
    public static final int KEY_NOT_FOUND = 7;
    public static final int LOCKED = 2;
    public static final int NO_ERROR = 1;
    public static final int PERMISSION_DENIED = 6;
    public static final int PROTOCOL_ERROR = 5;
    public static final int SYSTEM_ERROR = 4;
    private static final String TAG = "KeyStore";
    public static final int UID_SELF = -1;
    public static final int UNDEFINED_ACTION = 9;
    public static final int UNINITIALIZED = 3;
    public static final int VALUE_CORRUPTED = 8;
    public static final int WRONG_PASSWORD = 10;
    private final IKeystoreService mBinder;
    private int mError = 1;

    private KeyStore(IKeystoreService iKeystoreService) {
        this.mBinder = iKeystoreService;
    }

    public static KeyStore getInstance() {
        return new KeyStore(IKeystoreService.Stub.asInterface(ServiceManager.getService("android.security.keystore")));
    }

    static int getKeyTypeForAlgorithm(String string2) throws IllegalArgumentException {
        if ("RSA".equalsIgnoreCase(string2)) {
            return 6;
        }
        if ("DSA".equalsIgnoreCase(string2)) {
            return 116;
        }
        if ("EC".equalsIgnoreCase(string2)) {
            return 408;
        }
        throw new IllegalArgumentException("Unsupported key type: " + string2);
    }

    public boolean clearUid(int n) {
        try {
            int n2 = this.mBinder.clear_uid(n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean contains(String string2) {
        return this.contains(string2, -1);
    }

    public boolean contains(String string2, int n) {
        try {
            int n2 = this.mBinder.exist(string2, n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean delKey(String string2) {
        return this.delKey(string2, -1);
    }

    public boolean delKey(String string2, int n) {
        try {
            int n2 = this.mBinder.del_key(string2, n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean delete(String string2) {
        return this.delete(string2, -1);
    }

    public boolean delete(String string2, int n) {
        try {
            int n2 = this.mBinder.del(string2, n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean duplicate(String string2, int n, String string3, int n2) {
        try {
            int n3 = this.mBinder.duplicate(string2, n, string3, n2);
            return n3 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean generate(String string2, int n, int n2, int n3, int n4, byte[][] byArray) {
        try {
            int n5 = this.mBinder.generate(string2, n, n2, n3, n4, byArray);
            return n5 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public byte[] get(String string2) {
        try {
            byte[] byArray = this.mBinder.get(string2);
            return byArray;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return null;
        }
    }

    public int getLastError() {
        return this.mError;
    }

    public byte[] getPubkey(String string2) {
        try {
            byte[] byArray = this.mBinder.get_pubkey(string2);
            return byArray;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return null;
        }
    }

    public long getmtime(String string2) {
        try {
            long l = this.mBinder.getmtime(string2);
            if (l == -1L) {
                return -1L;
            }
            return 1000L * l;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return -1L;
        }
    }

    public boolean grant(String string2, int n) {
        try {
            int n2 = this.mBinder.grant(string2, n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean importKey(String string2, byte[] byArray, int n, int n2) {
        try {
            int n3 = this.mBinder.import_key(string2, byArray, n, n2);
            return n3 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean isEmpty() {
        try {
            int n = this.mBinder.zero();
            boolean bl = false;
            if (n == 7) {
                bl = true;
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean isHardwareBacked() {
        return this.isHardwareBacked("RSA");
    }

    public boolean isHardwareBacked(String string2) {
        try {
            int n = this.mBinder.is_hardware_backed(string2.toUpperCase(Locale.US));
            return n == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean isUnlocked() {
        return this.state() == State.UNLOCKED;
    }

    public boolean lock() {
        try {
            int n = this.mBinder.lock();
            return n == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean password(String string2) {
        try {
            int n = this.mBinder.password(string2);
            return n == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean passwordUid(String string2, int n) {
        try {
            int n2 = this.mError = this.mBinder.password_uid(string2, n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean put(String string2, byte[] byArray, int n, int n2) {
        try {
            int n3 = this.mBinder.insert(string2, byArray, n, n2);
            return n3 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean reset() {
        try {
            int n = this.mBinder.reset();
            return n == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean resetUid(int n) {
        try {
            int n2 = this.mError = this.mBinder.reset_uid(n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public String[] saw(String string2) {
        return this.saw(string2, -1);
    }

    public String[] saw(String string2, int n) {
        try {
            String[] stringArray = this.mBinder.saw(string2, n);
            return stringArray;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return null;
        }
    }

    public byte[] sign(String string2, byte[] byArray) {
        try {
            byte[] byArray2 = this.mBinder.sign(string2, byArray);
            return byArray2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public State state() {
        int n;
        try {
            n = this.mBinder.test();
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            throw new AssertionError((Object)remoteException);
        }
        switch (n) {
            default: {
                throw new AssertionError(this.mError);
            }
            case 1: {
                return State.UNLOCKED;
            }
            case 2: {
                return State.LOCKED;
            }
            case 3: 
        }
        return State.UNINITIALIZED;
    }

    public boolean syncUid(int n, int n2) {
        try {
            int n3 = this.mError = this.mBinder.sync_uid(n, n2);
            return n3 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean ungrant(String string2, int n) {
        try {
            int n2 = this.mBinder.ungrant(string2, n);
            return n2 == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean unlock(String string2) {
        try {
            int n = this.mError = this.mBinder.unlock(string2);
            return n == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public boolean verify(String string2, byte[] byArray, byte[] byArray2) {
        try {
            int n = this.mBinder.verify(string2, byArray, byArray2);
            return n == 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Cannot connect to keystore", remoteException);
            return false;
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State LOCKED;
        public static final /* enum */ State UNINITIALIZED;
        public static final /* enum */ State UNLOCKED;

        static {
            UNLOCKED = new State();
            LOCKED = new State();
            UNINITIALIZED = new State();
            State[] stateArray = new State[]{UNLOCKED, LOCKED, UNINITIALIZED};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

