/*
 * Decompiled with CFR 0.152.
 */
package android.service.dreams;

import android.app.Service;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.dreams.IDreamManager;
import android.service.dreams.IDreamService;
import android.util.MathUtils;
import android.util.Slog;
import android.view.ActionMode;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.DumpUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class DreamService
extends Service
implements Window.Callback {
    public static final String DREAM_META_DATA = "android.service.dream";
    public static final String DREAM_SERVICE = "dreams";
    public static final String SERVICE_INTERFACE = "android.service.dreams.DreamService";
    private final String TAG = DreamService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private boolean mCanDoze;
    private boolean mDebug = false;
    private int mDozeScreenBrightness = -1;
    private int mDozeScreenState = 0;
    private boolean mDozing;
    private boolean mFinished;
    private boolean mFullscreen;
    private final Handler mHandler = new Handler();
    private boolean mInteractive;
    private boolean mLowProfile = true;
    private final IDreamManager mSandman = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
    private boolean mScreenBright = true;
    private boolean mStarted;
    private boolean mWaking;
    private Window mWindow;
    private IBinder mWindowToken;
    private boolean mWindowless;

    static /* synthetic */ boolean access$502(DreamService dreamService, boolean bl) {
        dreamService.mStarted = bl;
        return bl;
    }

    private int applyFlags(int n, int n2, int n3) {
        return n & ~n3 | n2 & n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applySystemUiVisibilityFlags(int n, int n2) {
        if (this.mWindow == null) {
            return;
        }
        View view = this.mWindow.getDecorView();
        if (view == null) return;
        view.setSystemUiVisibility(this.applyFlags(view.getSystemUiVisibility(), n, n2));
    }

    private void applyWindowFlags(int n, int n2) {
        if (this.mWindow != null) {
            WindowManager.LayoutParams layoutParams = this.mWindow.getAttributes();
            layoutParams.flags = this.applyFlags(layoutParams.flags, n, n2);
            this.mWindow.setAttributes(layoutParams);
            this.mWindow.getWindowManager().updateViewLayout(this.mWindow.getDecorView(), layoutParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void attach(IBinder iBinder, boolean bl) {
        if (this.mWindowToken != null) {
            Slog.e(this.TAG, "attach() called when already attached with token=" + this.mWindowToken);
            return;
        }
        if (this.mFinished || this.mWaking) {
            Slog.w(this.TAG, "attach() called after dream already finished");
            try {
                this.mSandman.finishSelf(iBinder, true);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
        this.mWindowToken = iBinder;
        this.mCanDoze = bl;
        if (this.mWindowless && !this.mCanDoze) {
            throw new IllegalStateException("Only doze dreams can be windowless");
        }
        if (!this.mWindowless) {
            this.mWindow = PolicyManager.makeNewWindow(this);
            this.mWindow.setCallback(this);
            this.mWindow.requestFeature(1);
            this.mWindow.setBackgroundDrawable(new ColorDrawable(-16777216));
            this.mWindow.setFormat(-1);
            if (this.mDebug) {
                String string2 = this.TAG;
                Object[] objectArray = new Object[]{iBinder, 2023};
                Slog.v(string2, String.format("Attaching window token: %s to window of type %s", objectArray));
            }
            WindowManager.LayoutParams layoutParams = this.mWindow.getAttributes();
            layoutParams.type = 2023;
            layoutParams.token = iBinder;
            layoutParams.windowAnimations = 16974567;
            int n = layoutParams.flags;
            int n2 = this.mFullscreen ? 1024 : 0;
            int n3 = 0x490101 | n2;
            int n4 = this.mScreenBright ? 128 : 0;
            layoutParams.flags = n | (n4 | n3);
            this.mWindow.setAttributes(layoutParams);
            this.mWindow.clearFlags(Integer.MIN_VALUE);
            this.mWindow.setWindowManager(null, iBinder, "dream", true);
            boolean bl2 = this.mLowProfile;
            int n5 = 0;
            if (bl2) {
                n5 = 1;
            }
            this.applySystemUiVisibilityFlags(n5, 1);
            try {
                this.getWindowManager().addView(this.mWindow.getDecorView(), this.mWindow.getAttributes());
            }
            catch (WindowManager.BadTokenException badTokenException) {
                Slog.i(this.TAG, "attach() called after window token already removed, dream will finish soon");
                this.mWindow = null;
                return;
            }
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (DreamService.this.mWindow != null || DreamService.this.mWindowless) {
                    if (DreamService.this.mDebug) {
                        Slog.v(DreamService.this.TAG, "Calling onDreamingStarted()");
                    }
                    DreamService.access$502(DreamService.this, true);
                    DreamService.this.onDreamingStarted();
                }
            }
        });
    }

    private static int clampAbsoluteBrightness(int n) {
        return MathUtils.constrain(n, 0, 255);
    }

    private final void detach() {
        if (this.mStarted) {
            if (this.mDebug) {
                Slog.v(this.TAG, "detach(): Calling onDreamingStopped()");
            }
            this.mStarted = false;
            this.onDreamingStopped();
        }
        if (this.mWindow != null) {
            if (this.mDebug) {
                Slog.v(this.TAG, "detach(): Removing window from window manager");
            }
            this.mWindow.getWindowManager().removeViewImmediate(this.mWindow.getDecorView());
            this.mWindow = null;
        }
        if (this.mWindowToken != null) {
            WindowManagerGlobal.getInstance().closeAll(this.mWindowToken, this.getClass().getName(), "Dream");
            this.mWindowToken = null;
            this.mCanDoze = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean getSystemUiVisibilityFlagValue(int n, boolean bl) {
        View view = this.mWindow == null ? null : this.mWindow.getDecorView();
        if (view == null) {
            return bl;
        }
        return (n & view.getSystemUiVisibility()) != 0;
    }

    private boolean getWindowFlagValue(int n, boolean bl) {
        if (this.mWindow == null) {
            return bl;
        }
        return (n & this.mWindow.getAttributes().flags) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDoze() {
        if (!this.mDozing) return;
        try {
            this.mSandman.startDozing(this.mWindowToken, this.mDozeScreenState, this.mDozeScreenBrightness);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private void wakeUp(boolean bl) {
        block7: {
            block6: {
                if (this.mDebug) {
                    Slog.v(this.TAG, "wakeUp(): fromSystem=" + bl + ", mWaking=" + this.mWaking + ", mFinished=" + this.mFinished);
                }
                if (this.mWaking || this.mFinished) break block6;
                this.mWaking = true;
                this.onWakeUp();
                if (bl || this.mFinished) break block6;
                if (this.mWindowToken != null) break block7;
                Slog.w(this.TAG, "WakeUp was called before the dream was attached.");
            }
            return;
        }
        try {
            this.mSandman.finishSelf(this.mWindowToken, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.getWindow().addContentView(view, layoutParams);
    }

    public boolean canDoze() {
        return this.mCanDoze;
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on genericMotionEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchGenericMotionEvent(motionEvent);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on keyEvent");
            }
            this.wakeUp();
            return true;
        }
        if (keyEvent.getKeyCode() == 4) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on back key");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchKeyEvent(keyEvent);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on keyShortcutEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchKeyShortcutEvent(keyEvent);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return false;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on touchEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchTouchEvent(motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on trackballEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchTrackballEvent(motionEvent);
    }

    @Override
    protected void dump(final FileDescriptor fileDescriptor, PrintWriter printWriter, final String[] stringArray) {
        DumpUtils.dumpAsync(this.mHandler, new DumpUtils.Dump(){

            @Override
            public void dump(PrintWriter printWriter) {
                DreamService.this.dumpOnHandler(fileDescriptor, printWriter, stringArray);
            }
        }, printWriter, 1000L);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dumpOnHandler(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.print(this.TAG + ": ");
        if (this.mWindowToken == null) {
            printWriter.println("stopped");
        } else {
            printWriter.println("running (token=" + this.mWindowToken + ")");
        }
        printWriter.println("  window: " + this.mWindow);
        printWriter.print("  flags:");
        if (this.isInteractive()) {
            printWriter.print(" interactive");
        }
        if (this.isLowProfile()) {
            printWriter.print(" lowprofile");
        }
        if (this.isFullscreen()) {
            printWriter.print(" fullscreen");
        }
        if (this.isScreenBright()) {
            printWriter.print(" bright");
        }
        if (this.isWindowless()) {
            printWriter.print(" windowless");
        }
        if (this.isDozing()) {
            printWriter.print(" dozing");
        } else if (this.canDoze()) {
            printWriter.print(" candoze");
        }
        printWriter.println();
        if (this.canDoze()) {
            printWriter.println("  doze screen state: " + Display.stateToString(this.mDozeScreenState));
            printWriter.println("  doze screen brightness: " + this.mDozeScreenBrightness);
        }
    }

    public View findViewById(int n) {
        return this.getWindow().findViewById(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void finish() {
        if (this.mDebug) {
            Slog.v(this.TAG, "finish(): mFinished=" + this.mFinished);
        }
        if (!this.mFinished) {
            this.mFinished = true;
            if (this.mWindowToken == null) {
                Slog.w(this.TAG, "Finish was called before the dream was attached.");
            } else {
                try {
                    this.mSandman.finishSelf(this.mWindowToken, true);
                }
                catch (RemoteException remoteException) {}
            }
            this.stopSelf();
        }
    }

    public int getDozeScreenBrightness() {
        return this.mDozeScreenBrightness;
    }

    public int getDozeScreenState() {
        return this.mDozeScreenState;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public WindowManager getWindowManager() {
        if (this.mWindow != null) {
            return this.mWindow.getWindowManager();
        }
        return null;
    }

    public boolean isDozing() {
        return this.mDozing;
    }

    public boolean isFullscreen() {
        return this.mFullscreen;
    }

    public boolean isInteractive() {
        return this.mInteractive;
    }

    public boolean isLowProfile() {
        return this.getSystemUiVisibilityFlagValue(1, this.mLowProfile);
    }

    public boolean isScreenBright() {
        return this.getWindowFlagValue(128, this.mScreenBright);
    }

    public boolean isWindowless() {
        return this.mWindowless;
    }

    @Override
    public void onActionModeFinished(ActionMode actionMode) {
    }

    @Override
    public void onActionModeStarted(ActionMode actionMode) {
    }

    @Override
    public void onAttachedToWindow() {
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (this.mDebug) {
            Slog.v(this.TAG, "onBind() intent = " + intent);
        }
        return new DreamServiceWrapper();
    }

    @Override
    public void onContentChanged() {
    }

    @Override
    public void onCreate() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onCreate()");
        }
        super.onCreate();
    }

    @Override
    public boolean onCreatePanelMenu(int n, Menu menu2) {
        return false;
    }

    @Override
    public View onCreatePanelView(int n) {
        return null;
    }

    @Override
    public void onDestroy() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDestroy()");
        }
        this.detach();
        super.onDestroy();
    }

    @Override
    public void onDetachedFromWindow() {
    }

    public void onDreamingStarted() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDreamingStarted()");
        }
    }

    public void onDreamingStopped() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDreamingStopped()");
        }
    }

    @Override
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        return false;
    }

    @Override
    public boolean onMenuOpened(int n, Menu menu2) {
        return false;
    }

    @Override
    public void onPanelClosed(int n, Menu menu2) {
    }

    @Override
    public boolean onPreparePanel(int n, View view, Menu menu2) {
        return false;
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    public void onWakeUp() {
        this.finish();
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return null;
    }

    public void setContentView(int n) {
        this.getWindow().setContentView(n);
    }

    public void setContentView(View view) {
        this.getWindow().setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.getWindow().setContentView(view, layoutParams);
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setDozeScreenBrightness(int n) {
        if (n != -1) {
            n = DreamService.clampAbsoluteBrightness(n);
        }
        if (this.mDozeScreenBrightness != n) {
            this.mDozeScreenBrightness = n;
            this.updateDoze();
        }
    }

    public void setDozeScreenState(int n) {
        if (this.mDozeScreenState != n) {
            this.mDozeScreenState = n;
            this.updateDoze();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFullscreen(boolean bl) {
        if (this.mFullscreen != bl) {
            this.mFullscreen = bl;
            int n = this.mFullscreen ? 1024 : 0;
            this.applyWindowFlags(n, 1024);
        }
    }

    public void setInteractive(boolean bl) {
        this.mInteractive = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLowProfile(boolean bl) {
        if (this.mLowProfile != bl) {
            this.mLowProfile = bl;
            int n = this.mLowProfile ? 1 : 0;
            this.applySystemUiVisibilityFlags(n, 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setScreenBright(boolean bl) {
        if (this.mScreenBright != bl) {
            this.mScreenBright = bl;
            int n = this.mScreenBright ? 128 : 0;
            this.applyWindowFlags(n, 128);
        }
    }

    public void setWindowless(boolean bl) {
        this.mWindowless = bl;
    }

    public void startDozing() {
        if (this.mCanDoze && !this.mDozing) {
            this.mDozing = true;
            this.updateDoze();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopDozing() {
        if (!this.mDozing) return;
        this.mDozing = false;
        try {
            this.mSandman.stopDozing(this.mWindowToken);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void wakeUp() {
        this.wakeUp(false);
    }

    private final class DreamServiceWrapper
    extends IDreamService.Stub {
        private DreamServiceWrapper() {
        }

        @Override
        public void attach(final IBinder iBinder, final boolean bl) {
            DreamService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    DreamService.this.attach(iBinder, bl);
                }
            });
        }

        @Override
        public void detach() {
            DreamService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    DreamService.this.detach();
                }
            });
        }

        @Override
        public void wakeUp() {
            DreamService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    DreamService.this.wakeUp(true);
                }
            });
        }
    }
}

