/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.Notification;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;

public class StatusBarNotification
implements Parcelable {
    public static final Parcelable.Creator<StatusBarNotification> CREATOR = new Parcelable.Creator<StatusBarNotification>(){

        @Override
        public StatusBarNotification createFromParcel(Parcel parcel) {
            return new StatusBarNotification(parcel);
        }

        public StatusBarNotification[] newArray(int n) {
            return new StatusBarNotification[n];
        }
    };
    private final String groupKey;
    private final int id;
    private final int initialPid;
    private final String key;
    private final Notification notification;
    private final String opPkg;
    private final String pkg;
    private final long postTime;
    private final int score;
    private final String tag;
    private final int uid;
    private final UserHandle user;

    /*
     * Enabled aggressive block sorting
     */
    public StatusBarNotification(Parcel parcel) {
        this.pkg = parcel.readString();
        this.opPkg = parcel.readString();
        this.id = parcel.readInt();
        this.tag = parcel.readInt() != 0 ? parcel.readString() : null;
        this.uid = parcel.readInt();
        this.initialPid = parcel.readInt();
        this.score = parcel.readInt();
        this.notification = new Notification(parcel);
        this.user = UserHandle.readFromParcel(parcel);
        this.postTime = parcel.readLong();
        this.key = this.key();
        this.groupKey = this.groupKey();
    }

    public StatusBarNotification(String string2, String string3, int n, String string4, int n2, int n3, int n4, Notification notification, UserHandle userHandle) {
        this(string2, string3, n, string4, n2, n3, n4, notification, userHandle, System.currentTimeMillis());
    }

    public StatusBarNotification(String string2, String string3, int n, String string4, int n2, int n3, int n4, Notification notification, UserHandle userHandle, long l) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (notification == null) {
            throw new NullPointerException();
        }
        this.pkg = string2;
        this.opPkg = string3;
        this.id = n;
        this.tag = string4;
        this.uid = n2;
        this.initialPid = n3;
        this.score = n4;
        this.notification = notification;
        this.user = userHandle;
        this.postTime = l;
        this.key = this.key();
        this.groupKey = this.groupKey();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String groupKey() {
        String string2;
        String string3 = this.getNotification().getGroup();
        String string4 = this.getNotification().getSortKey();
        if (string3 == null && string4 == null) {
            return this.key;
        }
        StringBuilder stringBuilder = new StringBuilder().append(this.user.getIdentifier()).append("|").append(this.pkg).append("|");
        if (string3 == null) {
            string2 = "p:" + this.notification.priority;
            return stringBuilder.append(string2).toString();
        }
        string2 = "g:" + string3;
        return stringBuilder.append(string2).toString();
    }

    private String key() {
        return this.user.getIdentifier() + "|" + this.pkg + "|" + this.id + "|" + this.tag + "|" + this.uid;
    }

    public StatusBarNotification clone() {
        return new StatusBarNotification(this.pkg, this.opPkg, this.id, this.tag, this.uid, this.initialPid, this.score, this.notification.clone(), this.user, this.postTime);
    }

    public StatusBarNotification cloneLight() {
        Notification notification = new Notification();
        this.notification.cloneInto(notification, false);
        return new StatusBarNotification(this.pkg, this.opPkg, this.id, this.tag, this.uid, this.initialPid, this.score, notification, this.user, this.postTime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public int getId() {
        return this.id;
    }

    public int getInitialPid() {
        return this.initialPid;
    }

    public String getKey() {
        return this.key;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public String getOpPkg() {
        return this.opPkg;
    }

    public String getPackageName() {
        return this.pkg;
    }

    public long getPostTime() {
        return this.postTime;
    }

    public int getScore() {
        return this.score;
    }

    public String getTag() {
        return this.tag;
    }

    public int getUid() {
        return this.uid;
    }

    public UserHandle getUser() {
        return this.user;
    }

    public int getUserId() {
        return this.user.getIdentifier();
    }

    public boolean isClearable() {
        return (2 & this.notification.flags) == 0 && (0x20 & this.notification.flags) == 0;
    }

    public boolean isOngoing() {
        return (2 & this.notification.flags) != 0;
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.pkg, this.user, this.id, this.tag, this.score, this.key, this.notification};
        return String.format("StatusBarNotification(pkg=%s user=%s id=%d tag=%s score=%d key=%s: %s)", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.pkg);
        parcel.writeString(this.opPkg);
        parcel.writeInt(this.id);
        if (this.tag != null) {
            parcel.writeInt(1);
            parcel.writeString(this.tag);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.uid);
        parcel.writeInt(this.initialPid);
        parcel.writeInt(this.score);
        this.notification.writeToParcel(parcel, n);
        this.user.writeToParcel(parcel, n);
        parcel.writeLong(this.postTime);
    }
}

