/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.voice.AlwaysOnHotwordDetector;
import android.service.voice.IVoiceInteractionService;
import com.android.internal.app.IVoiceInteractionManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Locale;

public class VoiceInteractionService
extends Service {
    static final int MSG_READY = 1;
    static final int MSG_SHUTDOWN = 2;
    static final int MSG_SOUND_MODELS_CHANGED = 3;
    public static final String SERVICE_INTERFACE = "android.service.voice.VoiceInteractionService";
    public static final String SERVICE_META_DATA = "android.voice_interaction";
    MyHandler mHandler;
    private AlwaysOnHotwordDetector mHotwordDetector;
    IVoiceInteractionService mInterface = new IVoiceInteractionService.Stub(){

        @Override
        public void ready() {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(1);
        }

        @Override
        public void shutdown() {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(2);
        }

        @Override
        public void soundModelsChanged() {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(3);
        }
    };
    private KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private final Object mLock = new Object();
    IVoiceInteractionManagerService mSystemService;

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isActiveService(Context context, ComponentName componentName) {
        ComponentName componentName2;
        String string2 = Settings.Secure.getString(context.getContentResolver(), "voice_interaction_service");
        if (string2 == null || string2.isEmpty() || (componentName2 = ComponentName.unflattenFromString(string2)) == null) {
            return false;
        }
        return componentName2.equals(componentName);
    }

    private void onShutdownInternal() {
        this.onShutdown();
        this.safelyShutdownHotwordDetector();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSoundModelsChangedInternal() {
        synchronized (this) {
            if (this.mHotwordDetector != null) {
                this.mHotwordDetector.onSoundModelsChanged();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void safelyShutdownHotwordDetector() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHotwordDetector == null) break block5;
                this.mHotwordDetector.stopRecognition();
            }
        }
        catch (Exception exception) {
            return;
        }
        {
            block5: {
                this.mHotwordDetector.invalidate();
                this.mHotwordDetector = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AlwaysOnHotwordDetector createAlwaysOnHotwordDetector(String string2, Locale locale, AlwaysOnHotwordDetector.Callback callback) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.safelyShutdownHotwordDetector();
            this.mHotwordDetector = new AlwaysOnHotwordDetector(string2, locale, callback, this.mKeyphraseEnrollmentInfo, this.mInterface, this.mSystemService);
            return this.mHotwordDetector;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.println("VOICE INTERACTION");
        Object object = this.mLock;
        synchronized (object) {
            printWriter.println("  AlwaysOnHotwordDetector");
            if (this.mHotwordDetector == null) {
                printWriter.println("    NULL");
            } else {
                this.mHotwordDetector.dump("    ", printWriter);
            }
            return;
        }
    }

    protected final KeyphraseEnrollmentInfo getKeyphraseEnrollmentInfo() {
        return this.mKeyphraseEnrollmentInfo;
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandler = new MyHandler();
    }

    public void onReady() {
        this.mSystemService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
        this.mKeyphraseEnrollmentInfo = new KeyphraseEnrollmentInfo(this.getPackageManager());
    }

    public void onShutdown() {
    }

    public void startSession(Bundle bundle) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        try {
            this.mSystemService.startSession(this.mInterface, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    class MyHandler
    extends Handler {
        MyHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    super.handleMessage(message);
                    return;
                }
                case 1: {
                    VoiceInteractionService.this.onReady();
                    return;
                }
                case 2: {
                    VoiceInteractionService.this.onShutdownInternal();
                    return;
                }
                case 3: 
            }
            VoiceInteractionService.this.onSoundModelsChangedInternal();
        }
    }
}

