/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.RemoteException;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class VoiceInteractionServiceInfo {
    static final String TAG = "VoiceInteractionServiceInfo";
    private String mParseError;
    private String mRecognitionService;
    private ServiceInfo mServiceInfo;
    private String mSessionService;
    private String mSettingsActivity;

    public VoiceInteractionServiceInfo(PackageManager packageManager, ComponentName componentName) throws PackageManager.NameNotFoundException {
        this(packageManager, packageManager.getServiceInfo(componentName, 128));
    }

    public VoiceInteractionServiceInfo(PackageManager packageManager, ComponentName componentName, int n) throws PackageManager.NameNotFoundException, RemoteException {
        this(packageManager, AppGlobals.getPackageManager().getServiceInfo(componentName, 128, n));
    }

    /*
     * Unable to fully structure code
     */
    public VoiceInteractionServiceInfo(PackageManager var1_1, ServiceInfo var2_2) {
        block17: {
            block18: {
                super();
                if (!"android.permission.BIND_VOICE_INTERACTION".equals(var2_2.permission)) {
                    this.mParseError = "Service does not require permission android.permission.BIND_VOICE_INTERACTION";
lbl4:
                    // 5 sources

                    return;
                }
                var3_3 = null;
                var3_3 = var2_2.loadXmlMetaData(var1_1, "android.voice_interaction");
                if (var3_3 != null) break block18;
                this.mParseError = "No android.voice_interaction meta-data for " + var2_2.packageName;
                if (var3_3 == null) ** GOTO lbl4
                var3_3.close();
                return;
            }
            var11_4 = var1_1.getResourcesForApplication(var2_2.applicationInfo);
            var12_5 = Xml.asAttributeSet(var3_3);
            while ((var13_6 = var3_3.next()) != 1 && var13_6 != 2) {
            }
            if ("voice-interaction-service".equals(var3_3.getName())) break block17;
            this.mParseError = "Meta-data does not start with voice-interaction-service tag";
            if (var3_3 == null) ** GOTO lbl4
            var3_3.close();
            return;
        }
        try {
            block19: {
                var14_7 = var11_4.obtainAttributes(var12_5, R.styleable.VoiceInteractionService);
                this.mSessionService = var14_7.getString(1);
                this.mRecognitionService = var14_7.getString(2);
                this.mSettingsActivity = var14_7.getString(0);
                var14_7.recycle();
                if (this.mSessionService != null) break block19;
                this.mParseError = "No sessionService specified";
                if (var3_3 == null) ** GOTO lbl4
                var3_3.close();
                return;
            }
            if (var3_3 != null) {
                var3_3.close();
            }
            this.mServiceInfo = var2_2;
            return;
        }
        catch (XmlPullParserException var9_8) {
            this.mParseError = "Error parsing voice interation service meta-data: " + var9_8;
            Log.w("VoiceInteractionServiceInfo", "error parsing voice interaction service meta-data", var9_8);
            return;
        }
        catch (IOException var7_9) {
            this.mParseError = "Error parsing voice interation service meta-data: " + var7_9;
            Log.w("VoiceInteractionServiceInfo", "error parsing voice interaction service meta-data", var7_9);
            return;
        }
        catch (PackageManager.NameNotFoundException var5_10) {
            this.mParseError = "Error parsing voice interation service meta-data: " + var5_10;
            Log.w("VoiceInteractionServiceInfo", "error parsing voice interaction service meta-data", var5_10);
            return;
        }
        catch (Throwable var4_11) {
            throw var4_11;
        }
        finally {
            if (var3_3 == null) ** continue;
            var3_3.close();
        }
    }

    public String getParseError() {
        return this.mParseError;
    }

    public String getRecognitionService() {
        return this.mRecognitionService;
    }

    public ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public String getSessionService() {
        return this.mSessionService;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivity;
    }
}

