/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class ConnectionServiceAdapter
implements IBinder.DeathRecipient {
    private final Set<IConnectionServiceAdapter> mAdapters = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));

    ConnectionServiceAdapter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
        if (!this.mAdapters.add(iConnectionServiceAdapter)) return;
        try {
            iConnectionServiceAdapter.asBinder().linkToDeath(this, 0);
            return;
        }
        catch (RemoteException remoteException) {
            this.mAdapters.remove(iConnectionServiceAdapter);
            return;
        }
    }

    void addConferenceCall(String string2, ParcelableConference parcelableConference) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.addConferenceCall(string2, parcelableConference);
            }
            catch (RemoteException remoteException) {}
        }
    }

    @Override
    public void binderDied() {
        Iterator<IConnectionServiceAdapter> iterator = this.mAdapters.iterator();
        while (iterator.hasNext()) {
            IConnectionServiceAdapter iConnectionServiceAdapter = iterator.next();
            if (iConnectionServiceAdapter.asBinder().isBinderAlive()) continue;
            iterator.remove();
            iConnectionServiceAdapter.asBinder().unlinkToDeath(this, 0);
        }
    }

    void handleCreateConnectionComplete(String string2, ConnectionRequest connectionRequest, ParcelableConnection parcelableConnection) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.handleCreateConnectionComplete(string2, connectionRequest, parcelableConnection);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void onPostDialWait(String string2, String string3) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.onPostDialWait(string2, string3);
            }
            catch (RemoteException remoteException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void queryRemoteConnectionServices(RemoteServiceCallback remoteServiceCallback) {
        if (this.mAdapters.size() != 1) return;
        try {
            this.mAdapters.iterator().next().queryRemoteConnectionServices(remoteServiceCallback);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(this, (Throwable)remoteException, "Exception trying to query for remote CSs", new Object[0]);
            return;
        }
    }

    void removeAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
        if (iConnectionServiceAdapter != null && this.mAdapters.remove(iConnectionServiceAdapter)) {
            iConnectionServiceAdapter.asBinder().unlinkToDeath(this, 0);
        }
    }

    void removeCall(String string2) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.removeCall(string2);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setActive(String string2) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setActive(string2);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setAddress(String string2, Uri uri, int n) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setAddress(string2, uri, n);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setCallCapabilities(String string2, int n) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setCallCapabilities(string2, n);
            }
            catch (RemoteException remoteException) {}
        }
    }

    public final void setCallSubstate(String string2, int n) {
        Object[] objectArray = new Object[]{n};
        Log.v(this, "setCallSubstate: %d", objectArray);
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setCallSubstate(string2, n);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setCallerDisplayName(String string2, String string3, int n) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setCallerDisplayName(string2, string3, n);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setConferenceableConnections(String string2, List<String> list) {
        Log.v(this, "setConferenceableConnections: %s, %s", string2, list);
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setConferenceableConnections(string2, list);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setDialing(String string2) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setDialing(string2);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setDisconnected(String string2, DisconnectCause disconnectCause) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setDisconnected(string2, disconnectCause);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setDisconnectedWithSsNotification(String string2, int n, String string3, int n2, int n3) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setDisconnectedWithSsNotification(string2, n, string3, n2, n3);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setIsConferenced(String string2, String string3) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                Log.d(this, "sending connection %s with conference %s", string2, string3);
                iConnectionServiceAdapter.setIsConferenced(string2, string3);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setIsVoipAudioMode(String string2, boolean bl) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setIsVoipAudioMode(string2, bl);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setOnHold(String string2) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setOnHold(string2);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setPhoneAccountHandle(String string2, PhoneAccountHandle phoneAccountHandle) {
        Log.v(this, "setPhoneAccountHandle: %s, %s", string2, phoneAccountHandle);
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setPhoneAccountHandle(string2, phoneAccountHandle);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setRingbackRequested(String string2, boolean bl) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setRingbackRequested(string2, bl);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setRinging(String string2) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setRinging(string2);
            }
            catch (RemoteException remoteException) {}
        }
    }

    void setStatusHints(String string2, StatusHints statusHints) {
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setStatusHints(string2, statusHints);
            }
            catch (RemoteException remoteException) {}
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setVideoProvider(String var1_1, Connection.VideoProvider var2_2) {
        var3_3 = this.mAdapters.iterator();
        while (true) {
            if (!var3_3.hasNext()) {
                return;
            }
            var4_4 = var3_3.next();
            var6_6 = var2_2 == null ? null : (var5_5 = var2_2.getInterface());
            {
                ** try [egrp 0[TRYBLOCK] [0 : 37->56)] { 
lbl8:
                // 1 sources

                var4_4.setVideoProvider(var1_1, var6_6);
            }
lbl10:
            // 1 sources

            catch (RemoteException var7_7) {
            }
            {
                continue;
            }
            break;
        }
    }

    void setVideoState(String string2, int n) {
        Object[] objectArray = new Object[]{n};
        Log.v(this, "setVideoState: %d", objectArray);
        for (IConnectionServiceAdapter iConnectionServiceAdapter : this.mAdapters) {
            try {
                iConnectionServiceAdapter.setVideoState(string2, n);
            }
            catch (RemoteException remoteException) {}
        }
    }
}

