/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import com.android.i18n.phonenumbers.AsYouTypeFormatter;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Locale;

public class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private AsYouTypeFormatter mFormatter;
    private boolean mSelfChange = false;
    private boolean mStopFormatting;

    public PhoneNumberFormattingTextWatcher() {
        this(Locale.getDefault().getCountry());
    }

    public PhoneNumberFormattingTextWatcher(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.mFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(string2);
    }

    private String getFormattedNumber(char c, boolean bl) {
        if (bl) {
            return this.mFormatter.inputDigitAndRememberPosition(c);
        }
        return this.mFormatter.inputDigit(c);
    }

    private boolean hasSeparator(CharSequence charSequence, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (PhoneNumberUtils.isNonSeparator(charSequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private String reformat(CharSequence charSequence, int n) {
        int n2 = n - 1;
        String string2 = null;
        this.mFormatter.clear();
        char c = '\u0000';
        boolean bl = false;
        int n3 = charSequence.length();
        for (int i = 0; i < n3; ++i) {
            char c2 = charSequence.charAt(i);
            if (PhoneNumberUtils.isNonSeparator(c2)) {
                if (c != '\u0000') {
                    string2 = this.getFormattedNumber(c, bl);
                    bl = false;
                }
                c = c2;
            }
            if (i != n2) continue;
            bl = true;
        }
        if (c != '\u0000') {
            string2 = this.getFormattedNumber(c, bl);
        }
        return string2;
    }

    private void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void afterTextChanged(Editable editable) {
        boolean bl = true;
        synchronized (this) {
            String string2;
            if (this.mStopFormatting) {
                if (editable.length() == 0) {
                    bl = false;
                }
                this.mStopFormatting = bl;
            } else if (!this.mSelfChange && (string2 = this.reformat(editable, Selection.getSelectionEnd(editable))) != null) {
                int n = this.mFormatter.getRememberedPosition();
                this.mSelfChange = true;
                editable.replace(0, editable.length(), string2, 0, string2.length());
                if (string2.equals(editable.toString())) {
                    Selection.setSelection(editable, n);
                }
                this.mSelfChange = false;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.mSelfChange || this.mStopFormatting || n2 <= 0 || !this.hasSeparator(charSequence, n, n2)) {
            return;
        }
        this.stopFormatting();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.mSelfChange || this.mStopFormatting || n3 <= 0 || !this.hasSeparator(charSequence, n, n3)) {
            return;
        }
        this.stopFormatting();
    }
}

