/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;

public interface InputFilter {
    public CharSequence filter(CharSequence var1, int var2, int var3, Spanned var4, int var5, int var6);

    public static class AllCaps
    implements InputFilter {
        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            for (int i = n; i < n2; ++i) {
                if (!Character.isLowerCase(charSequence.charAt(i))) continue;
                char[] cArray = new char[n2 - n];
                TextUtils.getChars(charSequence, n, n2, cArray, 0);
                String string2 = new String(cArray).toUpperCase();
                if (charSequence instanceof Spanned) {
                    SpannableString spannableString = new SpannableString(string2);
                    TextUtils.copySpansFrom((Spanned)charSequence, n, n2, null, spannableString, 0);
                    return spannableString;
                }
                return string2;
            }
            return null;
        }
    }

    public static class LengthFilter
    implements InputFilter {
        private final int mMax;

        public LengthFilter(int n) {
            this.mMax = n;
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            int n5 = this.mMax - (spanned.length() - (n4 - n3));
            if (n5 <= 0) {
                return "";
            }
            if (n5 >= n2 - n) {
                return null;
            }
            int n6 = n5 + n;
            if (Character.isHighSurrogate(charSequence.charAt(n6 - 1)) && --n6 == n) {
                return "";
            }
            return charSequence.subSequence(n, n6);
        }

        public int getMax() {
            return this.mMax;
        }
    }
}

