/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.SpanSet;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

class TextLine {
    private static final boolean DEBUG = false;
    private static final int TAB_INCREMENT = 20;
    private static final TextLine[] sCached = new TextLine[3];
    private final SpanSet<CharacterStyle> mCharacterStyleSpanSet;
    private char[] mChars;
    private boolean mCharsValid;
    private int mDir;
    private Layout.Directions mDirections;
    private boolean mHasTabs;
    private int mLen;
    private final SpanSet<MetricAffectingSpan> mMetricAffectingSpanSpanSet;
    private TextPaint mPaint;
    private final SpanSet<ReplacementSpan> mReplacementSpanSpanSet;
    private Spanned mSpanned;
    private int mStart;
    private Layout.TabStops mTabs;
    private CharSequence mText;
    private final TextPaint mWorkPaint = new TextPaint();

    TextLine() {
        this.mMetricAffectingSpanSpanSet = new SpanSet<MetricAffectingSpan>(MetricAffectingSpan.class);
        this.mCharacterStyleSpanSet = new SpanSet<CharacterStyle>(CharacterStyle.class);
        this.mReplacementSpanSpanSet = new SpanSet<ReplacementSpan>(ReplacementSpan.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    private float drawRun(Canvas canvas, int n, int n2, boolean bl, float f, int n3, int n4, int n5, boolean bl2) {
        boolean bl3 = this.mDir == 1;
        if (bl3 == bl) {
            float f2 = -this.measureRun(n, n2, n2, bl, null);
            this.handleRun(n, n2, n2, bl, canvas, f + f2, n3, n4, n5, null, false);
            return f2;
        }
        return this.handleRun(n, n2, n2, bl, canvas, f, n3, n4, n5, null, bl2);
    }

    private void drawTextRun(Canvas canvas, TextPaint textPaint, int n, int n2, int n3, int n4, boolean bl, float f, int n5) {
        if (this.mCharsValid) {
            int n6 = n2 - n;
            int n7 = n4 - n3;
            canvas.drawTextRun(this.mChars, n, n6, n3, n7, f, (float)n5, bl, (Paint)textPaint);
            return;
        }
        int n8 = this.mStart;
        canvas.drawTextRun(this.mText, n8 + n, n8 + n2, n8 + n3, n8 + n4, f, (float)n5, bl, (Paint)textPaint);
    }

    private static void expandMetricsFromPaint(Paint.FontMetricsInt fontMetricsInt, TextPaint textPaint) {
        int n = fontMetricsInt.top;
        int n2 = fontMetricsInt.ascent;
        int n3 = fontMetricsInt.descent;
        int n4 = fontMetricsInt.bottom;
        int n5 = fontMetricsInt.leading;
        textPaint.getFontMetricsInt(fontMetricsInt);
        TextLine.updateMetrics(fontMetricsInt, n, n2, n3, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    private int getOffsetBeforeAfter(int var1_1, int var2_2, int var3_3, boolean var4_4, int var5_5, boolean var6_6) {
        block12: {
            block13: {
                block20: {
                    block16: {
                        block15: {
                            block14: {
                                block21: {
                                    block19: {
                                        block18: {
                                            block11: {
                                                block17: {
                                                    if (var1_1 < 0) ** GOTO lbl-1000
                                                    if (!var6_6) break block17;
                                                    var8_7 = this.mLen;
lbl4:
                                                    // 2 sources

                                                    while (var5_5 == var8_7) lbl-1000:
                                                    // 2 sources

                                                    {
                                                        if (var6_6) {
                                                            var7_8 = TextUtils.getOffsetAfter(this.mText, var5_5 + this.mStart) - this.mStart;
lbl7:
                                                            // 2 sources

                                                            return var7_8;
                                                        }
                                                        break block11;
                                                    }
                                                    break block18;
                                                }
                                                var8_7 = 0;
                                                ** GOTO lbl4
                                            }
                                            return TextUtils.getOffsetBefore(this.mText, var5_5 + this.mStart) - this.mStart;
                                        }
                                        var9_9 = this.mWorkPaint;
                                        var9_9.set(this.mPaint);
                                        var10_10 = var2_2;
                                        if (this.mSpanned != null) break block19;
                                        var7_8 = var3_3;
lbl22:
                                        // 3 sources

                                        while (var4_4) {
                                            var17_11 = 1;
lbl24:
                                            // 2 sources

                                            while (var6_6) {
                                                var18_12 = 0;
lbl26:
                                                // 2 sources

                                                while (this.mCharsValid) {
                                                    return var9_9.getTextRunCursor(this.mChars, var10_10, var7_8 - var10_10, var17_11, var5_5, var18_12);
                                                }
                                                break block12;
                                            }
                                            break block13;
                                        }
                                        break block20;
                                    }
                                    if (!var6_6) break block21;
                                    var11_13 = var5_5 + 1;
lbl34:
                                    // 2 sources

                                    while (true) {
                                        var12_14 = var3_3 + this.mStart;
lbl36:
                                        // 2 sources

                                        while (true) {
                                            var7_8 = this.mSpanned.nextSpanTransition(var10_10 + this.mStart, var12_14, MetricAffectingSpan.class) - this.mStart;
                                            if (var7_8 < var11_13) break block14;
                                            var13_15 = TextUtils.removeEmptySpans(this.mSpanned.getSpans(var10_10 + this.mStart, var7_8 + this.mStart, MetricAffectingSpan.class), this.mSpanned, MetricAffectingSpan.class);
                                            if (var13_15.length <= 0) ** GOTO lbl22
                                            var14_16 = null;
                                            block7: for (var15_17 = 0; var15_17 < (var16_18 = var13_15.length); ++var15_17) {
                                                var23_19 = var13_15[var15_17];
                                                if (var23_19 instanceof ReplacementSpan) {
                                                    var14_16 = (ReplacementSpan)var23_19;
lbl46:
                                                    // 2 sources

                                                    continue block7;
                                                }
                                                break block15;
                                            }
                                            break block16;
                                            break;
                                        }
                                        break;
                                    }
                                }
                                var11_13 = var5_5;
                                ** while (true)
                            }
                            var10_10 = var7_8;
                            ** while (true)
                        }
                        var23_19.updateMeasureState(var9_9);
                        ** while (true)
                    }
                    if (var14_16 == null) ** GOTO lbl22
                    ** while (var6_6)
lbl62:
                    // 1 sources

                    return var10_10;
                }
                var17_11 = 0;
                ** GOTO lbl24
            }
            var18_12 = 2;
            ** GOTO lbl26
        }
        var19_20 = this.mText;
        var20_21 = var10_10 + this.mStart;
        var21_22 = var7_8 + this.mStart;
        var22_23 = var5_5 + this.mStart;
        return var9_9.getTextRunCursor(var19_20, var20_21, var21_22, var17_11, var22_23, var18_12) - this.mStart;
    }

    /*
     * Enabled aggressive block sorting
     */
    private float handleReplacement(ReplacementSpan replacementSpan, TextPaint textPaint, int n, int n2, boolean bl, Canvas canvas, float f, int n3, int n4, int n5, Paint.FontMetricsInt fontMetricsInt, boolean bl2) {
        float f2;
        int n6;
        int n7;
        block8: {
            block7: {
                n7 = n + this.mStart;
                n6 = n2 + this.mStart;
                if (bl2) break block7;
                f2 = 0.0f;
                if (canvas == null) break block8;
                f2 = 0.0f;
                if (!bl) break block8;
            }
            boolean bl3 = fontMetricsInt != null;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (bl3) {
                n8 = fontMetricsInt.top;
                n9 = fontMetricsInt.ascent;
                n10 = fontMetricsInt.descent;
                n11 = fontMetricsInt.bottom;
                n12 = fontMetricsInt.leading;
            }
            f2 = replacementSpan.getSize(textPaint, this.mText, n7, n6, fontMetricsInt);
            if (bl3) {
                TextLine.updateMetrics(fontMetricsInt, n8, n9, n10, n11, n12);
            }
        }
        if (canvas != null) {
            if (bl) {
                f -= f2;
            }
            replacementSpan.draw(canvas, this.mText, n7, n6, f, n3, n4, n5, textPaint);
        }
        if (!bl) return f2;
        return -f2;
    }

    /*
     * Unable to fully structure code
     */
    private float handleRun(int var1_1, int var2_2, int var3_3, boolean var4_4, Canvas var5_5, float var6_6, int var7_7, int var8_8, int var9_9, Paint.FontMetricsInt var10_10, boolean var11_11) {
        if (var1_1 == var2_2) {
            var30_12 = this.mWorkPaint;
            var30_12.set(this.mPaint);
            if (var10_10 != null) {
                TextLine.expandMetricsFromPaint(var10_10, var30_12);
            }
            return 0.0f;
        }
        if (this.mSpanned == null) {
            var28_13 = this.mWorkPaint;
            var28_13.set(this.mPaint);
            if (var11_11 || var2_2 < var2_2) {
                var29_14 = true;
lbl12:
                // 2 sources

                return this.handleText(var28_13, var1_1, var2_2, var1_1, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var29_14);
            }
            var29_14 = false;
            ** continue;
        }
        this.mMetricAffectingSpanSpanSet.init(this.mSpanned, var1_1 + this.mStart, var3_3 + this.mStart);
        this.mCharacterStyleSpanSet.init(this.mSpanned, var1_1 + this.mStart, var3_3 + this.mStart);
        var12_15 = var6_6;
        var13_16 = var1_1;
        block1: while (var13_16 < var2_2) {
            var14_17 = this.mWorkPaint;
            var14_17.set(this.mPaint);
            var15_18 = this.mMetricAffectingSpanSpanSet.getNextTransition(var13_16 + this.mStart, var3_3 + this.mStart) - this.mStart;
            var16_19 = Math.min(var15_18, var2_2);
            var17_20 = null;
            block2: for (var18_21 = 0; var18_21 < (var19_22 = this.mMetricAffectingSpanSpanSet.numberOfSpans); ++var18_21) {
                block18: {
                    if (this.mMetricAffectingSpanSpanSet.spanStarts[var18_21] >= var16_19 + this.mStart || this.mMetricAffectingSpanSpanSet.spanEnds[var18_21] <= var13_16 + this.mStart) lbl-1000:
                    // 3 sources

                    {
                        continue block2;
                    }
                    var27_29 = ((MetricAffectingSpan[])this.mMetricAffectingSpanSpanSet.spans)[var18_21];
                    if (!(var27_29 instanceof ReplacementSpan)) break block18;
                    var17_20 = (ReplacementSpan)var27_29;
                    ** GOTO lbl-1000
                }
                var27_29.updateDrawState(var14_17);
                ** continue;
            }
            if (var17_20 != null) {
                if (var11_11 || var16_19 < var2_2) {
                    var25_28 = true;
lbl40:
                    // 2 sources

                    while (true) {
                        var6_6 += this.handleReplacement(var17_20, var14_17, var13_16, var16_19, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var25_28);
                        while (true) {
                            var13_16 = var15_18;
                            continue block1;
                            break;
                        }
                        break;
                    }
                }
                var25_28 = false;
                ** continue;
            }
            var20_23 = var13_16;
            block6: while (true) {
                if (var20_23 >= var16_19) ** continue;
                var21_24 = this.mCharacterStyleSpanSet.getNextTransition(var20_23 + this.mStart, var16_19 + this.mStart) - this.mStart;
                var14_17.set(this.mPaint);
                block7: for (var22_25 = 0; var22_25 < (var23_26 = this.mCharacterStyleSpanSet.numberOfSpans); ++var22_25) {
                    if (this.mCharacterStyleSpanSet.spanStarts[var22_25] >= var21_24 + this.mStart || this.mCharacterStyleSpanSet.spanEnds[var22_25] <= var20_23 + this.mStart) lbl-1000:
                    // 2 sources

                    {
                        continue block7;
                    }
                    ((CharacterStyle[])this.mCharacterStyleSpanSet.spans)[var22_25].updateDrawState(var14_17);
                    ** continue;
                }
                if (!var11_11 && var21_24 >= var2_2) break;
                var24_27 = true;
lbl61:
                // 2 sources

                while (true) {
                    var6_6 += this.handleText(var14_17, var20_23, var21_24, var13_16, var15_18, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var24_27);
                    var20_23 = var21_24;
                    continue block6;
                    break;
                }
                break;
            }
            var24_27 = false;
            ** continue;
        }
        return var6_6 - var12_15;
    }

    /*
     * Enabled aggressive block sorting
     */
    private float handleText(TextPaint textPaint, int n, int n2, int n3, int n4, boolean bl, Canvas canvas, float f, int n5, int n6, int n7, Paint.FontMetricsInt fontMetricsInt, boolean bl2) {
        float f2;
        block12: {
            int n8;
            int n9;
            block11: {
                if (fontMetricsInt != null) {
                    TextLine.expandMetricsFromPaint(fontMetricsInt, textPaint);
                }
                if ((n9 = n2 - n) == 0) {
                    return 0.0f;
                }
                n8 = n4 - n3;
                if (bl2) break block11;
                f2 = 0.0f;
                if (canvas == null) break block12;
                if (textPaint.bgColor != 0 || textPaint.underlineColor != 0) break block11;
                f2 = 0.0f;
                if (!bl) break block12;
            }
            if (this.mCharsValid) {
                f2 = textPaint.getTextRunAdvances(this.mChars, n, n9, n3, n8, bl, null, 0);
            } else {
                int n10 = this.mStart;
                f2 = textPaint.getTextRunAdvances(this.mText, n10 + n, n10 + n2, n10 + n3, n10 + n4, bl, null, 0);
            }
        }
        if (canvas != null) {
            if (bl) {
                f -= f2;
            }
            if (textPaint.bgColor != 0) {
                int n11 = textPaint.getColor();
                Paint.Style style2 = textPaint.getStyle();
                textPaint.setColor(textPaint.bgColor);
                textPaint.setStyle(Paint.Style.FILL);
                float f3 = n5;
                float f4 = f + f2;
                float f5 = n7;
                canvas.drawRect(f, f3, f4, f5, textPaint);
                textPaint.setStyle(style2);
                textPaint.setColor(n11);
            }
            if (textPaint.underlineColor != 0) {
                float f6 = (float)(n6 + textPaint.baselineShift) + 0.11111111f * textPaint.getTextSize();
                int n12 = textPaint.getColor();
                Paint.Style style3 = textPaint.getStyle();
                boolean bl3 = textPaint.isAntiAlias();
                textPaint.setStyle(Paint.Style.FILL);
                textPaint.setAntiAlias(true);
                textPaint.setColor(textPaint.underlineColor);
                float f7 = f + f2;
                float f8 = f6 + textPaint.underlineThickness;
                canvas.drawRect(f, f6, f7, f8, textPaint);
                textPaint.setStyle(style3);
                textPaint.setColor(n12);
                textPaint.setAntiAlias(bl3);
            }
            int n13 = n6 + textPaint.baselineShift;
            this.drawTextRun(canvas, textPaint, n, n2, n3, n4, bl, f, n13);
        }
        if (!bl) return f2;
        return -f2;
    }

    private float measureRun(int n, int n2, int n3, boolean bl, Paint.FontMetricsInt fontMetricsInt) {
        return this.handleRun(n, n2, n3, bl, null, 0.0f, 0, 0, 0, fontMetricsInt, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TextLine obtain() {
        TextLine[] textLineArray = sCached;
        synchronized (textLineArray) {
            int n = sCached.length;
            do {
                if (--n >= 0) continue;
                return new TextLine();
            } while (sCached[n] == null);
            TextLine textLine = sCached[n];
            TextLine.sCached[n] = null;
            return textLine;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TextLine recycle(TextLine textLine) {
        textLine.mText = null;
        textLine.mPaint = null;
        textLine.mDirections = null;
        textLine.mMetricAffectingSpanSpanSet.recycle();
        textLine.mCharacterStyleSpanSet.recycle();
        textLine.mReplacementSpanSpanSet.recycle();
        TextLine[] textLineArray = sCached;
        synchronized (textLineArray) {
            int n = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n >= sCached.length) break block5;
                        if (sCached[n] != null) break block6;
                        TextLine.sCached[n] = textLine;
                    }
                    return null;
                }
                ++n;
            }
        }
    }

    static void updateMetrics(Paint.FontMetricsInt fontMetricsInt, int n, int n2, int n3, int n4, int n5) {
        fontMetricsInt.top = Math.min(fontMetricsInt.top, n);
        fontMetricsInt.ascent = Math.min(fontMetricsInt.ascent, n2);
        fontMetricsInt.descent = Math.max(fontMetricsInt.descent, n3);
        fontMetricsInt.bottom = Math.max(fontMetricsInt.bottom, n4);
        fontMetricsInt.leading = Math.max(fontMetricsInt.leading, n5);
    }

    float ascent(int n) {
        if (this.mSpanned == null) {
            return this.mPaint.ascent();
        }
        int n2 = n + this.mStart;
        MetricAffectingSpan[] metricAffectingSpanArray = this.mSpanned.getSpans(n2, n2 + 1, MetricAffectingSpan.class);
        if (metricAffectingSpanArray.length == 0) {
            return this.mPaint.ascent();
        }
        TextPaint textPaint = this.mWorkPaint;
        textPaint.set(this.mPaint);
        int n3 = metricAffectingSpanArray.length;
        for (int i = 0; i < n3; ++i) {
            metricAffectingSpanArray[i].updateMeasureState(textPaint);
        }
        return textPaint.ascent();
    }

    /*
     * Enabled aggressive block sorting
     */
    void draw(Canvas canvas, float f, int n, int n2, int n3) {
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                this.drawRun(canvas, 0, this.mLen, false, f, n, n2, n3, false);
                return;
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                this.drawRun(canvas, 0, this.mLen, true, f, n, n2, n3, false);
                return;
            }
        }
        float f2 = 0.0f;
        int[] nArray = this.mDirections.mDirections;
        RectF rectF = null;
        int n4 = -2 + nArray.length;
        int n5 = 0;
        int n6;
        while (n5 < (n6 = nArray.length)) {
            int n7 = nArray[n5];
            int n8 = n7 + (0x3FFFFFF & nArray[n5 + 1]);
            int n9 = this.mLen;
            if (n8 > n9) {
                n8 = this.mLen;
            }
            boolean bl = (0x4000000 & nArray[n5 + 1]) != 0;
            int n10 = n7;
            for (int i = this.mHasTabs ? n7 : n8; i <= n8; ++i) {
                boolean bl2 = this.mHasTabs;
                Bitmap bitmap = null;
                int n11 = 0;
                if (bl2) {
                    int n12 = n8;
                    bitmap = null;
                    n11 = 0;
                    if (i < n12) {
                        n11 = this.mChars[i];
                        bitmap = null;
                        if (n11 >= 55296) {
                            bitmap = null;
                            if (n11 < 56320) {
                                int n13 = i + 1;
                                int n14 = n8;
                                bitmap = null;
                                if (n13 < n14) {
                                    n11 = Character.codePointAt(this.mChars, i);
                                    if (n11 >= Layout.MIN_EMOJI && n11 <= Layout.MAX_EMOJI) {
                                        bitmap = Layout.EMOJI_FACTORY.getBitmapFromAndroidPua(n11);
                                    } else {
                                        bitmap = null;
                                        if (n11 > 65535) {
                                            ++i;
                                            continue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (i != n8 && n11 != 9 && bitmap == null) continue;
                float f3 = f + f2;
                boolean bl3 = n5 != n4 || i != this.mLen;
                f2 += this.drawRun(canvas, n10, i, bl, f3, n, n2, n3, bl3);
                if (n11 == 9) {
                    f2 = (float)this.mDir * this.nextTab(f2 * (float)this.mDir);
                } else if (bitmap != null) {
                    float f4 = this.ascent(i);
                    float f5 = bitmap.getHeight();
                    float f6 = -f4 / f5 * (float)bitmap.getWidth();
                    if (rectF == null) {
                        rectF = new RectF();
                    }
                    float f7 = f + f2;
                    float f8 = f4 + (float)n2;
                    float f9 = f6 + (f + f2);
                    float f10 = n2;
                    rectF.set(f7, f8, f9, f10);
                    TextPaint textPaint = this.mPaint;
                    canvas.drawBitmap(bitmap, null, rectF, (Paint)textPaint);
                    f2 += f6;
                    ++i;
                }
                n10 = i + 1;
            }
            n5 += 2;
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    int getOffsetToLeftRightOf(int var1_1, boolean var2_2) {
        block43: {
            block41: {
                block42: {
                    block30: {
                        block40: {
                            block27: {
                                block28: {
                                    block26: {
                                        block25: {
                                            block29: {
                                                block24: {
                                                    block31: {
                                                        block32: {
                                                            block33: {
                                                                block34: {
                                                                    block35: {
                                                                        block36: {
                                                                            block23: {
                                                                                var3_3 = this.mLen;
                                                                                if (this.mDir == -1) {
                                                                                    var4_4 = true;
lbl4:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var5_5 = this.mDirections.mDirections;
                                                                                        var6_6 = 0;
                                                                                        var7_7 = 0;
                                                                                        var8_8 = var3_3;
                                                                                        var9_9 = -1;
                                                                                        if (var1_1 != 0) break block23;
                                                                                        var10_10 = -2;
lbl12:
                                                                                        // 6 sources

                                                                                        block1: while (var2_2 == var4_4) {
                                                                                            var17_17 = true;
lbl14:
                                                                                            // 2 sources

                                                                                            while (var17_17) {
                                                                                                var18_18 = 2;
lbl16:
                                                                                                // 2 sources

                                                                                                while ((var19_19 = var10_10 + var18_18) >= 0 && var19_19 < var5_5.length) {
                                                                                                    var20_20 = 0 + var5_5[var19_19];
                                                                                                    var21_21 = var20_20 + (0x3FFFFFF & var5_5[var19_19 + 1]);
                                                                                                    if (var21_21 > var3_3) {
                                                                                                        var21_21 = var3_3;
                                                                                                    }
                                                                                                    if (((var22_22 = 63 & var5_5[var19_19 + 1] >>> 26) & 1) == 0) break block24;
                                                                                                    var23_23 = true;
lbl23:
                                                                                                    // 2 sources

                                                                                                    while (var2_2 == var23_23) {
                                                                                                        var24_24 = true;
lbl25:
                                                                                                        // 2 sources

                                                                                                        while (var9_9 == -1) {
                                                                                                            if (!var24_24) break block25;
                                                                                                            var25_25 = var20_20;
lbl28:
                                                                                                            // 2 sources

                                                                                                            while (true) {
                                                                                                                var9_9 = this.getOffsetBeforeAfter(var19_19, var20_20, var21_21, var23_23, var25_25, var24_24);
                                                                                                                if (!var24_24) break block26;
lbl31:
                                                                                                                // 2 sources

                                                                                                                while (var9_9 == var21_21) {
                                                                                                                    var10_10 = var19_19;
                                                                                                                    var6_6 = var22_22;
                                                                                                                    continue block1;
                                                                                                                }
                                                                                                                break block27;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        break block28;
                                                                                                    }
                                                                                                    break block29;
                                                                                                }
                                                                                                break block30;
                                                                                            }
                                                                                            break block31;
                                                                                        }
                                                                                        break block32;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                var4_4 = false;
                                                                                ** while (true)
                                                                            }
                                                                            if (var1_1 != var3_3) break block36;
                                                                            var10_10 = var5_5.length;
                                                                            var6_6 = 0;
                                                                            ** GOTO lbl12
                                                                        }
                                                                        var10_10 = 0;
                                                                        block8: while (true) {
                                                                            block37: {
                                                                                var11_11 = var5_5.length;
                                                                                var6_6 = 0;
                                                                                var12_12 = false;
                                                                                if (var10_10 >= var11_11) ** GOTO lbl82
                                                                                var7_7 = 0 + var5_5[var10_10];
                                                                                if (var1_1 < var7_7) break block37;
                                                                                var8_8 = var7_7 + (0x3FFFFFF & var5_5[var10_10 + 1]);
                                                                                if (var8_8 > var3_3) {
                                                                                    var8_8 = var3_3;
                                                                                }
                                                                                if (var1_1 >= var8_8) break block37;
                                                                                var6_6 = 63 & var5_5[var10_10 + 1] >>> 26;
                                                                                var12_12 = false;
                                                                                if (var1_1 != var7_7) ** GOTO lbl82
                                                                                var26_26 = var1_1 - 1;
                                                                                var27_27 = 0;
                                                                                while (true) {
                                                                                    block39: {
                                                                                        block38: {
                                                                                            var28_28 = var5_5.length;
                                                                                            var29_29 = var27_27;
                                                                                            var12_12 = false;
                                                                                            if (var29_29 >= var28_28) break block38;
                                                                                            var30_30 = 0 + var5_5[var27_27];
                                                                                            if (var26_26 < var30_30) break block39;
                                                                                            var31_31 = var30_30 + (0x3FFFFFF & var5_5[var27_27 + 1]);
                                                                                            if (var31_31 > var3_3) {
                                                                                                var31_31 = var3_3;
                                                                                            }
                                                                                            if (var26_26 >= var31_31 || (var32_32 = 63 & var5_5[var27_27 + 1] >>> 26) >= var6_6) break block39;
                                                                                            var10_10 = var27_27;
                                                                                            var6_6 = var32_32;
                                                                                            var7_7 = var30_30;
                                                                                            var8_8 = var31_31;
                                                                                            var12_12 = true;
                                                                                        }
                                                                                        if (var10_10 == var5_5.length) ** GOTO lbl12
                                                                                        if (!(var6_6 & true)) break block8;
                                                                                        var13_13 = true;
lbl86:
                                                                                        // 2 sources

                                                                                        while (var2_2 == var13_13) {
                                                                                            var14_14 = true;
lbl88:
                                                                                            // 2 sources

                                                                                            while (var14_14) {
                                                                                                var15_15 = var8_8;
lbl90:
                                                                                                // 2 sources

                                                                                                while (var1_1 != var15_15 || var14_14 != var12_12) {
                                                                                                    var9_9 = this.getOffsetBeforeAfter(var10_10, var7_7, var8_8, var13_13, var1_1, var14_14);
                                                                                                    if (!var14_14) break block33;
                                                                                                    var16_16 = var8_8;
lbl94:
                                                                                                    // 2 sources

                                                                                                    while (var9_9 != var16_16) {
                                                                                                        return var9_9;
                                                                                                    }
                                                                                                    ** GOTO lbl12
                                                                                                }
                                                                                                ** GOTO lbl12
                                                                                            }
                                                                                            break block34;
                                                                                        }
                                                                                        break block35;
                                                                                    }
                                                                                    var27_27 += 2;
                                                                                }
                                                                            }
                                                                            var10_10 += 2;
                                                                        }
                                                                        var13_13 = false;
                                                                        ** GOTO lbl86
                                                                    }
                                                                    var14_14 = false;
                                                                    ** GOTO lbl88
                                                                }
                                                                var15_15 = var7_7;
                                                                ** GOTO lbl90
                                                            }
                                                            var16_16 = var7_7;
                                                            ** GOTO lbl94
                                                        }
                                                        var17_17 = false;
                                                        ** GOTO lbl14
                                                    }
                                                    var18_18 = -2;
                                                    ** GOTO lbl16
                                                }
                                                var23_23 = false;
                                                ** GOTO lbl23
                                            }
                                            var24_24 = false;
                                            ** GOTO lbl25
                                        }
                                        var25_25 = var21_21;
                                        ** while (true)
                                    }
                                    var21_21 = var20_20;
                                    ** GOTO lbl31
                                }
                                if (var22_22 >= var6_6) break block27;
                                if (!var24_24) break block40;
                                var9_9 = var20_20;
                            }
lbl140:
                            // 7 sources

                            return var9_9;
                        }
                        var9_9 = var21_21;
                        ** GOTO lbl140
                    }
                    if (var9_9 != -1) break block41;
                    if (!var17_17) break block42;
                    var9_9 = 1 + this.mLen;
                    ** GOTO lbl140
                }
                var9_9 = -1;
                ** GOTO lbl140
            }
            if (var9_9 > var3_3) ** GOTO lbl140
            if (!var17_17) break block43;
            var9_9 = var3_3;
            ** GOTO lbl140
        }
        var9_9 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    float measure(int n, boolean bl, Paint.FontMetricsInt fontMetricsInt) {
        int n2 = bl ? n - 1 : n;
        if (n2 < 0) {
            return 0.0f;
        }
        float f = 0.0f;
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                return this.measureRun(0, n, this.mLen, false, fontMetricsInt);
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                return this.measureRun(0, n, this.mLen, true, fontMetricsInt);
            }
        }
        char[] cArray = this.mChars;
        int[] nArray = this.mDirections.mDirections;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            int n5 = n4 + (0x3FFFFFF & nArray[n3 + 1]);
            if (n5 > this.mLen) {
                n5 = this.mLen;
            }
            boolean bl2 = (0x4000000 & nArray[n3 + 1]) != 0;
            int n6 = n4;
            for (int i = this.mHasTabs ? n4 : n5; i <= n5; ++i) {
                boolean bl3 = this.mHasTabs;
                Bitmap bitmap = null;
                int n7 = 0;
                if (bl3) {
                    bitmap = null;
                    n7 = 0;
                    if (i < n5) {
                        n7 = cArray[i];
                        bitmap = null;
                        if (n7 >= 55296) {
                            bitmap = null;
                            if (n7 < 56320) {
                                int n8 = i + 1;
                                bitmap = null;
                                if (n8 < n5) {
                                    n7 = Character.codePointAt(cArray, i);
                                    if (n7 >= Layout.MIN_EMOJI && n7 <= Layout.MAX_EMOJI) {
                                        bitmap = Layout.EMOJI_FACTORY.getBitmapFromAndroidPua(n7);
                                    } else {
                                        bitmap = null;
                                        if (n7 > 65535) {
                                            ++i;
                                            continue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (i != n5 && n7 != 9 && bitmap == null) continue;
                boolean bl4 = n2 >= n6 && n2 < i;
                boolean bl5 = this.mDir == -1;
                boolean bl6 = bl5 == bl2;
                if (bl4 && bl6) {
                    return f + this.measureRun(n6, n, i, bl2, fontMetricsInt);
                }
                float f2 = this.measureRun(n6, i, i, bl2, fontMetricsInt);
                if (!bl6) {
                    f2 = -f2;
                }
                f += f2;
                if (bl4) {
                    return f + this.measureRun(n6, n, i, bl2, null);
                }
                if (n7 == 9) {
                    if (n == i) return f;
                    f = (float)this.mDir * this.nextTab(f * (float)this.mDir);
                    if (n2 == i) return f;
                }
                if (bitmap != null) {
                    float f3 = this.ascent(i);
                    f += (float)bitmap.getWidth() * -f3 / (float)bitmap.getHeight() * (float)this.mDir;
                    ++i;
                }
                n6 = i + 1;
            }
            n3 += 2;
        }
        return f;
    }

    float metrics(Paint.FontMetricsInt fontMetricsInt) {
        return this.measure(this.mLen, false, fontMetricsInt);
    }

    float nextTab(float f) {
        if (this.mTabs != null) {
            return this.mTabs.nextTab(f);
        }
        return Layout.TabStops.nextDefaultStop(f, 20);
    }

    /*
     * Enabled aggressive block sorting
     */
    void set(TextPaint textPaint, CharSequence charSequence, int n, int n2, int n3, Layout.Directions directions, boolean bl, Layout.TabStops tabStops) {
        this.mPaint = textPaint;
        this.mText = charSequence;
        this.mStart = n;
        this.mLen = n2 - n;
        this.mDir = n3;
        this.mDirections = directions;
        if (this.mDirections == null) {
            throw new IllegalArgumentException("Directions cannot be null");
        }
        this.mHasTabs = bl;
        this.mSpanned = null;
        boolean bl2 = charSequence instanceof Spanned;
        boolean bl3 = false;
        if (bl2) {
            this.mSpanned = (Spanned)charSequence;
            this.mReplacementSpanSpanSet.init(this.mSpanned, n, n2);
            bl3 = this.mReplacementSpanSpanSet.numberOfSpans > 0;
        }
        boolean bl4 = bl3 || bl || directions != Layout.DIRS_ALL_LEFT_TO_RIGHT;
        this.mCharsValid = bl4;
        if (this.mCharsValid) {
            if (this.mChars == null || this.mChars.length < this.mLen) {
                this.mChars = ArrayUtils.newUnpaddedCharArray(this.mLen);
            }
            TextUtils.getChars(charSequence, n, n2, this.mChars, 0);
            if (bl3) {
                char[] cArray = this.mChars;
                int n4 = n;
                while (n4 < n2) {
                    int n5 = this.mReplacementSpanSpanSet.getNextTransition(n4, n2);
                    if (this.mReplacementSpanSpanSet.hasSpansIntersecting(n4, n5)) {
                        cArray[n4 - n] = 65532;
                        int n6 = n5 - n;
                        for (int i = 1 + (n4 - n); i < n6; ++i) {
                            cArray[i] = 65279;
                        }
                    }
                    n4 = n5;
                }
            }
        }
        this.mTabs = tabStops;
    }
}

