/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.BaseMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.text.method.WordIterator;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class ArrowKeyMovementMethod
extends BaseMovementMethod
implements MovementMethod {
    private static final Object LAST_TAP_DOWN = new Object();
    private static ArrowKeyMovementMethod sInstance;

    private static int getCurrentLineTop(Spannable spannable, Layout layout2) {
        return layout2.getLineTop(layout2.getLineForOffset(Selection.getSelectionEnd(spannable)));
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ArrowKeyMovementMethod();
        }
        return sInstance;
    }

    private static int getPageHeight(TextView textView) {
        Rect rect = new Rect();
        if (textView.getGlobalVisibleRect(rect)) {
            return rect.height();
        }
        return 0;
    }

    private static boolean isSelecting(Spannable spannable) {
        return MetaKeyKeyListener.getMetaState((CharSequence)spannable, 1) == 1 || MetaKeyKeyListener.getMetaState((CharSequence)spannable, 2048) != 0;
    }

    private static boolean isTouchSelecting(boolean bl, Spannable spannable) {
        if (bl) {
            return Touch.isActivelySelecting(spannable);
        }
        return ArrowKeyMovementMethod.isSelecting(spannable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean bottom(TextView textView, Spannable spannable) {
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            Selection.extendSelection(spannable, spannable.length());
            return true;
        }
        Selection.setSelection(spannable, spannable.length());
        return true;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return true;
    }

    @Override
    protected boolean down(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            return Selection.extendDown(spannable, layout2);
        }
        return Selection.moveDown(spannable, layout2);
    }

    @Override
    protected boolean end(TextView textView, Spannable spannable) {
        return this.lineEnd(textView, spannable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean handleMovementKey(TextView textView, Spannable spannable, int n, int n2, KeyEvent keyEvent) {
        switch (n) {
            default: {
                return super.handleMovementKey(textView, spannable, n, n2, keyEvent);
            }
            case 23: {
                if (!KeyEvent.metaStateHasNoModifiers(n2) || keyEvent.getAction() != 0 || keyEvent.getRepeatCount() != 0 || MetaKeyKeyListener.getMetaState(spannable, 2048, keyEvent) == 0) return super.handleMovementKey(textView, spannable, n, n2, keyEvent);
                return textView.showContextMenu();
            }
        }
    }

    @Override
    protected boolean home(TextView textView, Spannable spannable) {
        return this.lineStart(textView, spannable);
    }

    @Override
    public void initialize(TextView textView, Spannable spannable) {
        Selection.setSelection(spannable, 0);
    }

    @Override
    protected boolean left(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            return Selection.extendLeft(spannable, layout2);
        }
        return Selection.moveLeft(spannable, layout2);
    }

    @Override
    protected boolean leftWord(TextView textView, Spannable spannable) {
        int n = textView.getSelectionEnd();
        WordIterator wordIterator = textView.getWordIterator();
        wordIterator.setCharSequence(spannable, n, n);
        return Selection.moveToPreceding(spannable, wordIterator, ArrowKeyMovementMethod.isSelecting(spannable));
    }

    @Override
    protected boolean lineEnd(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            return Selection.extendToRightEdge(spannable, layout2);
        }
        return Selection.moveToRightEdge(spannable, layout2);
    }

    @Override
    protected boolean lineStart(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            return Selection.extendToLeftEdge(spannable, layout2);
        }
        return Selection.moveToLeftEdge(spannable, layout2);
    }

    @Override
    public void onTakeFocus(TextView textView, Spannable spannable, int n) {
        if ((n & 0x82) != 0) {
            if (textView.getLayout() == null) {
                Selection.setSelection(spannable, spannable.length());
            }
            return;
        }
        Selection.setSelection(spannable, spannable.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        int n = -1;
        int n2 = -1;
        int n3 = motionEvent.getAction();
        boolean bl = motionEvent.isFromSource(8194);
        if (n3 == 1) {
            n = Touch.getInitialScrollX(textView, spannable);
            n2 = Touch.getInitialScrollY(textView, spannable);
        }
        boolean bl2 = Touch.onTouchEvent(textView, spannable, motionEvent);
        if (!textView.isFocused() || textView.didTouchFocusSelect()) return bl2;
        if (n3 == 0) {
            if (!bl && !ArrowKeyMovementMethod.isTouchSelecting(bl, spannable)) return bl2;
            int n4 = textView.getOffsetForPosition(motionEvent.getX(), motionEvent.getY());
            spannable.setSpan(LAST_TAP_DOWN, n4, n4, 34);
            textView.getParent().requestDisallowInterceptTouchEvent(true);
            return bl2;
        }
        if (n3 == 2) {
            if (bl && Touch.isSelectionStarted(spannable)) {
                Selection.setSelection(spannable, spannable.getSpanStart(LAST_TAP_DOWN));
            }
            if (!ArrowKeyMovementMethod.isTouchSelecting(bl, spannable) || !bl2) return bl2;
            textView.cancelLongPress();
            Selection.extendSelection(spannable, textView.getOffsetForPosition(motionEvent.getX(), motionEvent.getY()));
            return true;
        }
        if (n3 != 1) return bl2;
        if (n2 >= 0 && n2 != textView.getScrollY() || n >= 0 && n != textView.getScrollX()) {
            textView.moveCursorToVisibleOffset();
            return true;
        }
        int n5 = textView.getOffsetForPosition(motionEvent.getX(), motionEvent.getY());
        if (ArrowKeyMovementMethod.isTouchSelecting(bl, spannable)) {
            spannable.removeSpan(LAST_TAP_DOWN);
            Selection.extendSelection(spannable, n5);
        }
        MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
        MetaKeyKeyListener.resetLockedMeta(spannable);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean pageDown(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        boolean bl = ArrowKeyMovementMethod.isSelecting(spannable);
        int n = ArrowKeyMovementMethod.getCurrentLineTop(spannable, layout2) + ArrowKeyMovementMethod.getPageHeight(textView);
        boolean bl2 = false;
        do {
            int n2 = Selection.getSelectionEnd(spannable);
            if (bl) {
                Selection.extendDown(spannable, layout2);
            } else {
                Selection.moveDown(spannable, layout2);
            }
            if (Selection.getSelectionEnd(spannable) == n2) {
                return bl2;
            }
            bl2 = true;
        } while (ArrowKeyMovementMethod.getCurrentLineTop(spannable, layout2) < n);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean pageUp(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        boolean bl = ArrowKeyMovementMethod.isSelecting(spannable);
        int n = ArrowKeyMovementMethod.getCurrentLineTop(spannable, layout2) - ArrowKeyMovementMethod.getPageHeight(textView);
        boolean bl2 = false;
        do {
            int n2 = Selection.getSelectionEnd(spannable);
            if (bl) {
                Selection.extendUp(spannable, layout2);
            } else {
                Selection.moveUp(spannable, layout2);
            }
            if (Selection.getSelectionEnd(spannable) == n2) {
                return bl2;
            }
            bl2 = true;
        } while (ArrowKeyMovementMethod.getCurrentLineTop(spannable, layout2) > n);
        return bl2;
    }

    @Override
    protected boolean right(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            return Selection.extendRight(spannable, layout2);
        }
        return Selection.moveRight(spannable, layout2);
    }

    @Override
    protected boolean rightWord(TextView textView, Spannable spannable) {
        int n = textView.getSelectionEnd();
        WordIterator wordIterator = textView.getWordIterator();
        wordIterator.setCharSequence(spannable, n, n);
        return Selection.moveToFollowing(spannable, wordIterator, ArrowKeyMovementMethod.isSelecting(spannable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean top(TextView textView, Spannable spannable) {
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            Selection.extendSelection(spannable, 0);
            return true;
        }
        Selection.setSelection(spannable, 0);
        return true;
    }

    @Override
    protected boolean up(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(spannable)) {
            return Selection.extendUp(spannable, layout2);
        }
        return Selection.moveUp(spannable, layout2);
    }
}

