/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public class DebugUtils {
    public static void buildShortClassTag(Object object, StringBuilder stringBuilder) {
        int n;
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        String string2 = object.getClass().getSimpleName();
        if ((string2 == null || string2.isEmpty()) && (n = (string2 = object.getClass().getName()).lastIndexOf(46)) > 0) {
            string2 = string2.substring(n + 1);
        }
        stringBuilder.append(string2);
        stringBuilder.append('{');
        stringBuilder.append(Integer.toHexString(System.identityHashCode(object)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isObjectSelected(Object object) {
        String string2 = System.getenv("ANDROID_OBJECT_FILTER");
        boolean bl = false;
        if (string2 != null) {
            int n = string2.length();
            bl = false;
            if (n > 0) {
                String[] stringArray = string2.split("@");
                boolean bl2 = object.getClass().getSimpleName().matches(stringArray[0]);
                bl = false;
                if (bl2) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        Class<?> clazz;
                        String[] stringArray2 = stringArray[i].split("=");
                        Class<?> clazz2 = clazz = object.getClass();
                        try {
                            Method method;
                            do {
                                method = clazz2.getDeclaredMethod("get" + stringArray2[0].substring(0, 1).toUpperCase(Locale.ROOT) + stringArray2[0].substring(1), null);
                            } while ((clazz2 = clazz.getSuperclass()) != null && method == null);
                            if (method == null) continue;
                            Object object2 = method.invoke(object, null);
                            String string3 = object2 != null ? object2.toString() : "null";
                            bl |= string3.matches(stringArray2[1]);
                            continue;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            noSuchMethodException.printStackTrace();
                            continue;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            continue;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                }
            }
        }
        return bl;
    }
}

