/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.JsonScope;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonWriter
implements Closeable {
    private String indent;
    private boolean lenient;
    private final Writer out;
    private String separator;
    private final List<JsonScope> stack = new ArrayList<JsonScope>();

    public JsonWriter(Writer writer) {
        this.stack.add(JsonScope.EMPTY_DOCUMENT);
        this.separator = ":";
        if (writer == null) {
            throw new NullPointerException("out == null");
        }
        this.out = writer;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void beforeName() throws IOException {
        JsonScope jsonScope = this.peek();
        if (jsonScope == JsonScope.NONEMPTY_OBJECT) {
            this.out.write(44);
        } else if (jsonScope != JsonScope.EMPTY_OBJECT) {
            throw new IllegalStateException("Nesting problem: " + this.stack);
        }
        this.newline();
        this.replaceTop(JsonScope.DANGLING_NAME);
    }

    private void beforeValue(boolean bl) throws IOException {
        switch (1.$SwitchMap$android$util$JsonScope[this.peek().ordinal()]) {
            default: {
                throw new IllegalStateException("Nesting problem: " + this.stack);
            }
            case 1: {
                if (!this.lenient && !bl) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                return;
            }
            case 2: {
                this.replaceTop(JsonScope.NONEMPTY_ARRAY);
                this.newline();
                return;
            }
            case 3: {
                this.out.append(',');
                this.newline();
                return;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(JsonScope.NONEMPTY_OBJECT);
                return;
            }
            case 5: 
        }
        throw new IllegalStateException("JSON must have only one top-level value.");
    }

    private JsonWriter close(JsonScope jsonScope, JsonScope jsonScope2, String string2) throws IOException {
        JsonScope jsonScope3 = this.peek();
        if (jsonScope3 != jsonScope2 && jsonScope3 != jsonScope) {
            throw new IllegalStateException("Nesting problem: " + this.stack);
        }
        this.stack.remove(-1 + this.stack.size());
        if (jsonScope3 == jsonScope2) {
            this.newline();
        }
        this.out.write(string2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void newline() throws IOException {
        if (this.indent != null) {
            this.out.write("\n");
            for (int i = 1; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
    }

    private JsonWriter open(JsonScope jsonScope, String string2) throws IOException {
        this.beforeValue(true);
        this.stack.add(jsonScope);
        this.out.write(string2);
        return this;
    }

    private JsonScope peek() {
        return this.stack.get(-1 + this.stack.size());
    }

    private void replaceTop(JsonScope jsonScope) {
        this.stack.set(-1 + this.stack.size(), jsonScope);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void string(String string2) throws IOException {
        this.out.write("\"");
        int n = 0;
        int n2 = string2.length();
        while (true) {
            block11: {
                if (n >= n2) {
                    this.out.write("\"");
                    return;
                }
                char c = string2.charAt(n);
                switch (c) {
                    default: {
                        if (c > '\u001f') break;
                        Writer writer = this.out;
                        Object[] objectArray = new Object[]{(int)c};
                        writer.write(String.format("\\u%04x", objectArray));
                        break block11;
                    }
                    case '\"': 
                    case '\\': {
                        this.out.write(92);
                        this.out.write(c);
                        break block11;
                    }
                    case '\t': {
                        this.out.write("\\t");
                        break block11;
                    }
                    case '\b': {
                        this.out.write("\\b");
                        break block11;
                    }
                    case '\n': {
                        this.out.write("\\n");
                        break block11;
                    }
                    case '\r': {
                        this.out.write("\\r");
                        break block11;
                    }
                    case '\f': {
                        this.out.write("\\f");
                        break block11;
                    }
                    case '\u2028': 
                    case '\u2029': {
                        Writer writer = this.out;
                        Object[] objectArray = new Object[]{(int)c};
                        writer.write(String.format("\\u%04x", objectArray));
                        break block11;
                    }
                }
                this.out.write(c);
            }
            ++n;
        }
    }

    public JsonWriter beginArray() throws IOException {
        return this.open(JsonScope.EMPTY_ARRAY, "[");
    }

    public JsonWriter beginObject() throws IOException {
        return this.open(JsonScope.EMPTY_OBJECT, "{");
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.peek() != JsonScope.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
    }

    public JsonWriter endArray() throws IOException {
        return this.close(JsonScope.EMPTY_ARRAY, JsonScope.NONEMPTY_ARRAY, "]");
    }

    public JsonWriter endObject() throws IOException {
        return this.close(JsonScope.EMPTY_OBJECT, JsonScope.NONEMPTY_OBJECT, "}");
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public JsonWriter name(String string2) throws IOException {
        if (string2 == null) {
            throw new NullPointerException("name == null");
        }
        this.beforeName();
        this.string(string2);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.beforeValue(false);
        this.out.write("null");
        return this;
    }

    public void setIndent(String string2) {
        if (string2.isEmpty()) {
            this.indent = null;
            this.separator = ":";
            return;
        }
        this.indent = string2;
        this.separator = ": ";
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public JsonWriter value(double d) throws IOException {
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + d);
        }
        this.beforeValue(false);
        this.out.append(Double.toString(d));
        return this;
    }

    public JsonWriter value(long l) throws IOException {
        this.beforeValue(false);
        this.out.write(Long.toString(l));
        return this;
    }

    public JsonWriter value(Number number) throws IOException {
        if (number == null) {
            return this.nullValue();
        }
        String string2 = number.toString();
        if (!this.lenient && (string2.equals("-Infinity") || string2.equals("Infinity") || string2.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + number);
        }
        this.beforeValue(false);
        this.out.append(string2);
        return this;
    }

    public JsonWriter value(String string2) throws IOException {
        if (string2 == null) {
            return this.nullValue();
        }
        this.beforeValue(false);
        this.string(string2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public JsonWriter value(boolean bl) throws IOException {
        this.beforeValue(false);
        Writer writer = this.out;
        String string2 = bl ? "true" : "false";
        writer.write(string2);
        return this;
    }
}

