/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.DisplayMetrics;

public class TypedValue {
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_UNIT_DIP = 1;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_NONE = 65535;
    private static final String[] DIMENSION_UNIT_STRS;
    private static final String[] FRACTION_UNIT_STRS;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FIRST_COLOR_INT = 28;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_FRACTION = 6;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_INT_COLOR_ARGB4 = 30;
    public static final int TYPE_INT_COLOR_ARGB8 = 28;
    public static final int TYPE_INT_COLOR_RGB4 = 31;
    public static final int TYPE_INT_COLOR_RGB8 = 29;
    public static final int TYPE_INT_DEC = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_LAST_COLOR_INT = 31;
    public static final int TYPE_LAST_INT = 31;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_STRING = 3;
    public int assetCookie;
    public int changingConfigurations = -1;
    public int data;
    public int density;
    public int resourceId;
    public CharSequence string;
    public int type;

    static {
        RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
        DIMENSION_UNIT_STRS = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
        FRACTION_UNIT_STRS = new String[]{"%", "%p"};
    }

    public static float applyDimension(int n, float f, DisplayMetrics displayMetrics) {
        switch (n) {
            default: {
                f = 0.0f;
            }
            case 0: {
                return f;
            }
            case 1: {
                return f * displayMetrics.density;
            }
            case 2: {
                return f * displayMetrics.scaledDensity;
            }
            case 3: {
                return 0.013888889f * (f * displayMetrics.xdpi);
            }
            case 4: {
                return f * displayMetrics.xdpi;
            }
            case 5: 
        }
        return 0.03937008f * (f * displayMetrics.xdpi);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final String coerceToString(int n, int n2) {
        String string2 = null;
        switch (n) {
            default: {
                if (n < 28 || n > 31) break;
                string2 = "#" + Integer.toHexString(n2);
            }
            case 0: {
                return string2;
            }
            case 1: {
                return "@" + n2;
            }
            case 2: {
                return "?" + n2;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(n2));
            }
            case 5: {
                return Float.toString(TypedValue.complexToFloat(n2)) + DIMENSION_UNIT_STRS[0xF & n2 >> 0];
            }
            case 6: {
                return Float.toString(100.0f * TypedValue.complexToFloat(n2)) + FRACTION_UNIT_STRS[0xF & n2 >> 0];
            }
            case 17: {
                return "0x" + Integer.toHexString(n2);
            }
            case 18: {
                if (n2 == 0) return "false";
                return "true";
            }
        }
        string2 = null;
        if (n < 16) return string2;
        string2 = null;
        if (n > 31) return string2;
        return Integer.toString(n2);
    }

    public static float complexToDimension(int n, DisplayMetrics displayMetrics) {
        return TypedValue.applyDimension(0xF & n >> 0, TypedValue.complexToFloat(n), displayMetrics);
    }

    @Deprecated
    public static float complexToDimensionNoisy(int n, DisplayMetrics displayMetrics) {
        return TypedValue.complexToDimension(n, displayMetrics);
    }

    public static int complexToDimensionPixelOffset(int n, DisplayMetrics displayMetrics) {
        return (int)TypedValue.applyDimension(0xF & n >> 0, TypedValue.complexToFloat(n), displayMetrics);
    }

    public static int complexToDimensionPixelSize(int n, DisplayMetrics displayMetrics) {
        float f = TypedValue.complexToFloat(n);
        int n2 = (int)(0.5f + TypedValue.applyDimension(0xF & n >> 0, f, displayMetrics));
        if (n2 != 0) {
            return n2;
        }
        if (f == 0.0f) {
            return 0;
        }
        if (f > 0.0f) {
            return 1;
        }
        return -1;
    }

    public static float complexToFloat(int n) {
        return (float)(n & 0xFFFFFF00) * RADIX_MULTS[3 & n >> 4];
    }

    public static float complexToFraction(int n, float f, float f2) {
        switch (0xF & n >> 0) {
            default: {
                return 0.0f;
            }
            case 0: {
                return f * TypedValue.complexToFloat(n);
            }
            case 1: 
        }
        return f2 * TypedValue.complexToFloat(n);
    }

    public final CharSequence coerceToString() {
        int n = this.type;
        if (n == 3) {
            return this.string;
        }
        return TypedValue.coerceToString(n, this.data);
    }

    public float getDimension(DisplayMetrics displayMetrics) {
        return TypedValue.complexToDimension(this.data, displayMetrics);
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.data);
    }

    public float getFraction(float f, float f2) {
        return TypedValue.complexToFraction(this.data, f, f2);
    }

    public void setTo(TypedValue typedValue) {
        this.type = typedValue.type;
        this.string = typedValue.string;
        this.data = typedValue.data;
        this.assetCookie = typedValue.assetCookie;
        this.resourceId = typedValue.resourceId;
        this.density = typedValue.density;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TypedValue{t=0x").append(Integer.toHexString(this.type));
        stringBuilder.append("/d=0x").append(Integer.toHexString(this.data));
        if (this.type == 3) {
            void var8_4;
            StringBuilder stringBuilder2 = stringBuilder.append(" \"");
            if (this.string != null) {
                CharSequence charSequence = this.string;
            } else {
                String string2 = "<null>";
            }
            stringBuilder2.append((CharSequence)var8_4).append("\"");
        }
        if (this.assetCookie != 0) {
            stringBuilder.append(" a=").append(this.assetCookie);
        }
        if (this.resourceId != 0) {
            stringBuilder.append(" r=0x").append(Integer.toHexString(this.resourceId));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

