/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FocusFinder {
    private static final ThreadLocal<FocusFinder> tlFocusFinder = new ThreadLocal<FocusFinder>(){

        @Override
        protected FocusFinder initialValue() {
            return new FocusFinder();
        }
    };
    final Rect mBestCandidateRect;
    final Rect mFocusedRect = new Rect();
    final Rect mOtherRect = new Rect();
    final SequentialFocusComparator mSequentialFocusComparator;
    private final ArrayList<View> mTempList;

    private FocusFinder() {
        this.mBestCandidateRect = new Rect();
        this.mSequentialFocusComparator = new SequentialFocusComparator();
        this.mTempList = new ArrayList();
    }

    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n) {
        View view2 = null;
        if (view != null) {
            view2 = this.findNextUserSpecifiedFocus(viewGroup, view, n);
        }
        if (view2 != null) {
            return view2;
        }
        ArrayList<View> arrayList = this.mTempList;
        try {
            arrayList.clear();
            viewGroup.addFocusables(arrayList, n);
            if (!arrayList.isEmpty()) {
                View view3;
                view2 = view3 = this.findNextFocus(viewGroup, view, rect, n, arrayList);
            }
            arrayList.clear();
            return view2;
        }
        catch (Throwable throwable) {
            arrayList.clear();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n, ArrayList<View> arrayList) {
        block14: {
            block15: {
                if (view == null) break block15;
                if (rect == null) {
                    rect = this.mFocusedRect;
                }
                view.getFocusedRect(rect);
                viewGroup.offsetDescendantRectToMyCoords(view, rect);
                break block14;
            }
            if (rect == null) {
                rect = this.mFocusedRect;
                switch (n) {
                    default: {
                        break block14;
                    }
                    case 1: {
                        if (!viewGroup.isLayoutRtl()) break;
                        this.setFocusTopLeft(viewGroup, rect);
                        break block14;
                    }
                    case 66: 
                    case 130: {
                        this.setFocusTopLeft(viewGroup, rect);
                        break block14;
                    }
                    case 2: {
                        if (viewGroup.isLayoutRtl()) {
                            this.setFocusBottomRight(viewGroup, rect);
                            break block14;
                        } else {
                            this.setFocusTopLeft(viewGroup, rect);
                        }
                        break block14;
                    }
                    case 17: 
                    case 33: {
                        this.setFocusBottomRight(viewGroup, rect);
                        break block14;
                    }
                }
                this.setFocusBottomRight(viewGroup, rect);
            }
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown direction: " + n);
            }
            case 1: 
            case 2: {
                return this.findNextFocusInRelativeDirection(arrayList, viewGroup, view, rect, n);
            }
            case 17: 
            case 33: 
            case 66: 
            case 130: 
        }
        return this.findNextFocusInAbsoluteDirection(arrayList, viewGroup, view, rect, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private View findNextFocusInRelativeDirection(ArrayList<View> arrayList, ViewGroup viewGroup, View view, Rect rect, int n) {
        this.mSequentialFocusComparator.setRoot(viewGroup);
        this.mSequentialFocusComparator.setIsLayoutRtl(viewGroup.isLayoutRtl());
        Collections.sort(arrayList, this.mSequentialFocusComparator);
        int n2 = arrayList.size();
        switch (n) {
            default: {
                return arrayList.get(n2 - 1);
            }
            finally {
                this.mSequentialFocusComparator.recycle();
            }
            case 2: {
                return FocusFinder.getNextFocusable(view, arrayList, n2);
            }
            case 1: 
        }
        return FocusFinder.getPreviousFocusable(view, arrayList, n2);
    }

    private View findNextUserSpecifiedFocus(ViewGroup viewGroup, View view, int n) {
        View view2 = view.findUserSetNextFocus(viewGroup, n);
        if (view2 != null && view2.isFocusable() && (!view2.isInTouchMode() || view2.isFocusableInTouchMode())) {
            return view2;
        }
        return null;
    }

    public static FocusFinder getInstance() {
        return tlFocusFinder.get();
    }

    private static View getNextFocusable(View view, ArrayList<View> arrayList, int n) {
        int n2;
        if (view != null && (n2 = arrayList.lastIndexOf(view)) >= 0 && n2 + 1 < n) {
            return arrayList.get(n2 + 1);
        }
        if (!arrayList.isEmpty()) {
            return arrayList.get(0);
        }
        return null;
    }

    private static View getPreviousFocusable(View view, ArrayList<View> arrayList, int n) {
        int n2;
        if (view != null && (n2 = arrayList.indexOf(view)) > 0) {
            return arrayList.get(n2 - 1);
        }
        if (!arrayList.isEmpty()) {
            return arrayList.get(n - 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isTouchCandidate(int n, int n2, Rect rect, int n3) {
        block6: {
            switch (n3) {
                default: {
                    throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
                }
                case 17: {
                    if (rect.left <= n && rect.top <= n2 && n2 <= rect.bottom) break;
                    return false;
                }
                case 66: {
                    if (rect.left >= n && rect.top <= n2 && n2 <= rect.bottom) break;
                    return false;
                }
                case 33: {
                    if (rect.top <= n2 && rect.left <= n && n <= rect.right) break;
                    return false;
                }
                case 130: {
                    if (rect.top < n2 || rect.left > n || n > rect.right) break block6;
                }
            }
            return true;
        }
        return false;
    }

    static int majorAxisDistance(int n, Rect rect, Rect rect2) {
        return Math.max(0, FocusFinder.majorAxisDistanceRaw(n, rect, rect2));
    }

    static int majorAxisDistanceRaw(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                return rect.left - rect2.right;
            }
            case 66: {
                return rect2.left - rect.right;
            }
            case 33: {
                return rect.top - rect2.bottom;
            }
            case 130: 
        }
        return rect2.top - rect.bottom;
    }

    static int majorAxisDistanceToFarEdge(int n, Rect rect, Rect rect2) {
        return Math.max(1, FocusFinder.majorAxisDistanceToFarEdgeRaw(n, rect, rect2));
    }

    static int majorAxisDistanceToFarEdgeRaw(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                return rect.left - rect2.left;
            }
            case 66: {
                return rect2.right - rect.right;
            }
            case 33: {
                return rect.top - rect2.top;
            }
            case 130: 
        }
        return rect2.bottom - rect.bottom;
    }

    static int minorAxisDistance(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: 
            case 66: {
                return Math.abs(rect.top + rect.height() / 2 - (rect2.top + rect2.height() / 2));
            }
            case 33: 
            case 130: 
        }
        return Math.abs(rect.left + rect.width() / 2 - (rect2.left + rect2.width() / 2));
    }

    private void setFocusBottomRight(ViewGroup viewGroup, Rect rect) {
        int n = viewGroup.getScrollY() + viewGroup.getHeight();
        int n2 = viewGroup.getScrollX() + viewGroup.getWidth();
        rect.set(n2, n, n2, n);
    }

    private void setFocusTopLeft(ViewGroup viewGroup, Rect rect) {
        int n = viewGroup.getScrollY();
        int n2 = viewGroup.getScrollX();
        rect.set(n2, n, n2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean beamBeats(int n, Rect rect, Rect rect2, Rect rect3) {
        boolean bl = true;
        boolean bl2 = this.beamsOverlap(n, rect, rect2);
        if (this.beamsOverlap(n, rect, rect3)) return false;
        if (!bl2) {
            return false;
        }
        if (!this.isToDirectionOf(n, rect, rect3)) return bl;
        if (n == 17) return bl;
        if (n == 66) return bl;
        if (FocusFinder.majorAxisDistance(n, rect, rect2) < FocusFinder.majorAxisDistanceToFarEdge(n, rect, rect3)) return bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean beamsOverlap(int n, Rect rect, Rect rect2) {
        block4: {
            switch (n) {
                default: {
                    throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
                }
                case 17: 
                case 66: {
                    if (rect2.bottom >= rect.top && rect2.top <= rect.bottom) break;
                    return false;
                }
                case 33: 
                case 130: {
                    if (rect2.right < rect.left || rect2.left > rect.right) break block4;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View findNearestTouchable(ViewGroup viewGroup, int n, int n2, int n3, int[] nArray) {
        ArrayList<View> arrayList = viewGroup.getTouchables();
        int n4 = Integer.MAX_VALUE;
        View view = null;
        int n5 = arrayList.size();
        int n6 = ViewConfiguration.get(viewGroup.mContext).getScaledEdgeSlop();
        Rect rect = new Rect();
        Rect rect2 = this.mOtherRect;
        int n7 = 0;
        while (n7 < n5) {
            View view2 = arrayList.get(n7);
            view2.getDrawingRect(rect2);
            viewGroup.offsetRectBetweenParentAndChild(view2, rect2, true, true);
            if (this.isTouchCandidate(n, n2, rect2, n3)) {
                int n8 = Integer.MAX_VALUE;
                switch (n3) {
                    case 17: {
                        n8 = 1 + (n - rect2.right);
                        break;
                    }
                    case 66: {
                        n8 = rect2.left;
                        break;
                    }
                    case 33: {
                        n8 = 1 + (n2 - rect2.bottom);
                        break;
                    }
                    case 130: {
                        n8 = rect2.top;
                        break;
                    }
                }
                if (n8 < n6 && (view == null || rect.contains(rect2) || !rect2.contains(rect) && n8 < n4)) {
                    n4 = n8;
                    view = view2;
                    rect.set(rect2);
                    switch (n3) {
                        default: {
                            break;
                        }
                        case 17: {
                            nArray[0] = -n8;
                            break;
                        }
                        case 66: {
                            nArray[0] = n8;
                            break;
                        }
                        case 33: {
                            nArray[1] = -n8;
                            break;
                        }
                        case 130: {
                            nArray[1] = n8;
                        }
                    }
                }
            }
            ++n7;
        }
        return view;
    }

    public final View findNextFocus(ViewGroup viewGroup, View view, int n) {
        return this.findNextFocus(viewGroup, view, null, n);
    }

    public View findNextFocusFromRect(ViewGroup viewGroup, Rect rect, int n) {
        this.mFocusedRect.set(rect);
        return this.findNextFocus(viewGroup, null, this.mFocusedRect, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    View findNextFocusInAbsoluteDirection(ArrayList<View> arrayList, ViewGroup viewGroup, View view, Rect rect, int n) {
        this.mBestCandidateRect.set(rect);
        switch (n) {
            case 17: {
                this.mBestCandidateRect.offset(1 + rect.width(), 0);
                break;
            }
            case 66: {
                this.mBestCandidateRect.offset(-(1 + rect.width()), 0);
                break;
            }
            case 33: {
                this.mBestCandidateRect.offset(0, 1 + rect.height());
                break;
            }
            case 130: {
                this.mBestCandidateRect.offset(0, -(1 + rect.height()));
            }
        }
        View view2 = null;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            View view3 = arrayList.get(i);
            if (view3 == view || view3 == viewGroup) continue;
            view3.getFocusedRect(this.mOtherRect);
            viewGroup.offsetDescendantRectToMyCoords(view3, this.mOtherRect);
            if (!this.isBetterCandidate(n, rect, this.mOtherRect, this.mBestCandidateRect)) continue;
            this.mBestCandidateRect.set(this.mOtherRect);
            view2 = view3;
        }
        return view2;
    }

    int getWeightedDistanceFor(int n, int n2) {
        return n * (n * 13) + n2 * n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isBetterCandidate(int n, Rect rect, Rect rect2, Rect rect3) {
        boolean bl = true;
        if (!this.isCandidate(rect, rect2, n)) {
            return false;
        }
        if (!this.isCandidate(rect, rect3, n)) return bl;
        if (this.beamBeats(n, rect, rect2, rect3)) return bl;
        if (this.beamBeats(n, rect, rect3, rect2)) {
            return false;
        }
        if (this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(n, rect, rect2), FocusFinder.minorAxisDistance(n, rect, rect2)) < this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(n, rect, rect3), FocusFinder.minorAxisDistance(n, rect, rect3))) return bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isCandidate(Rect rect, Rect rect2, int n) {
        block6: {
            switch (n) {
                default: {
                    throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
                }
                case 17: {
                    if ((rect.right > rect2.right || rect.left >= rect2.right) && rect.left > rect2.left) break;
                    return false;
                }
                case 66: {
                    if ((rect.left < rect2.left || rect.right <= rect2.left) && rect.right < rect2.right) break;
                    return false;
                }
                case 33: {
                    if ((rect.bottom > rect2.bottom || rect.top >= rect2.bottom) && rect.top > rect2.top) break;
                    return false;
                }
                case 130: {
                    if (rect.top >= rect2.top && rect.bottom > rect2.top || rect.bottom >= rect2.bottom) break block6;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isToDirectionOf(int n, Rect rect, Rect rect2) {
        block6: {
            switch (n) {
                default: {
                    throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
                }
                case 17: {
                    if (rect.left >= rect2.right) break;
                    return false;
                }
                case 66: {
                    if (rect.right <= rect2.left) break;
                    return false;
                }
                case 33: {
                    if (rect.top >= rect2.bottom) break;
                    return false;
                }
                case 130: {
                    if (rect.bottom > rect2.top) break block6;
                }
            }
            return true;
        }
        return false;
    }

    private static final class SequentialFocusComparator
    implements Comparator<View> {
        private final Rect mFirstRect = new Rect();
        private boolean mIsLayoutRtl;
        private ViewGroup mRoot;
        private final Rect mSecondRect = new Rect();

        private SequentialFocusComparator() {
        }

        private void getRect(View view, Rect rect) {
            view.getDrawingRect(rect);
            this.mRoot.offsetDescendantRectToMyCoords(view, rect);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(View view, View view2) {
            int n = 1;
            int n2 = -1;
            if (view == view2) {
                return 0;
            }
            this.getRect(view, this.mFirstRect);
            this.getRect(view2, this.mSecondRect);
            if (this.mFirstRect.top < this.mSecondRect.top) return n2;
            if (this.mFirstRect.top > this.mSecondRect.top) {
                return n;
            }
            if (this.mFirstRect.left < this.mSecondRect.left) {
                if (!this.mIsLayoutRtl) return n2;
                return n;
            }
            if (this.mFirstRect.left > this.mSecondRect.left) {
                if (this.mIsLayoutRtl) return n2;
                return n;
            }
            if (this.mFirstRect.bottom < this.mSecondRect.bottom) return n2;
            if (this.mFirstRect.bottom > this.mSecondRect.bottom) {
                return n;
            }
            if (this.mFirstRect.right < this.mSecondRect.right) {
                if (!this.mIsLayoutRtl) return n2;
                return n;
            }
            if (this.mFirstRect.right <= this.mSecondRect.right) return 0;
            if (this.mIsLayoutRtl) return n2;
            return n;
        }

        public void recycle() {
            this.mRoot = null;
        }

        public void setIsLayoutRtl(boolean bl) {
            this.mIsLayoutRtl = bl;
        }

        public void setRoot(ViewGroup viewGroup) {
            this.mRoot = viewGroup;
        }
    }
}

