/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.InputEvent;
import android.view.KeyEvent;

public final class MotionEvent
extends InputEvent
implements Parcelable {
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_HOVER_ENTER = 9;
    public static final int ACTION_HOVER_EXIT = 10;
    public static final int ACTION_HOVER_MOVE = 7;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_OUTSIDE = 4;
    @Deprecated
    public static final int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static final int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static final int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static final int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static final int ACTION_POINTER_3_UP = 518;
    public static final int ACTION_POINTER_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_SCROLL = 8;
    public static final int ACTION_UP = 1;
    public static final int AXIS_BRAKE = 23;
    public static final int AXIS_DISTANCE = 24;
    public static final int AXIS_GAS = 22;
    public static final int AXIS_GENERIC_1 = 32;
    public static final int AXIS_GENERIC_10 = 41;
    public static final int AXIS_GENERIC_11 = 42;
    public static final int AXIS_GENERIC_12 = 43;
    public static final int AXIS_GENERIC_13 = 44;
    public static final int AXIS_GENERIC_14 = 45;
    public static final int AXIS_GENERIC_15 = 46;
    public static final int AXIS_GENERIC_16 = 47;
    public static final int AXIS_GENERIC_2 = 33;
    public static final int AXIS_GENERIC_3 = 34;
    public static final int AXIS_GENERIC_4 = 35;
    public static final int AXIS_GENERIC_5 = 36;
    public static final int AXIS_GENERIC_6 = 37;
    public static final int AXIS_GENERIC_7 = 38;
    public static final int AXIS_GENERIC_8 = 39;
    public static final int AXIS_GENERIC_9 = 40;
    public static final int AXIS_HAT_X = 15;
    public static final int AXIS_HAT_Y = 16;
    public static final int AXIS_HSCROLL = 10;
    public static final int AXIS_LTRIGGER = 17;
    public static final int AXIS_ORIENTATION = 8;
    public static final int AXIS_PRESSURE = 2;
    public static final int AXIS_RTRIGGER = 18;
    public static final int AXIS_RUDDER = 20;
    public static final int AXIS_RX = 12;
    public static final int AXIS_RY = 13;
    public static final int AXIS_RZ = 14;
    public static final int AXIS_SIZE = 3;
    private static final SparseArray<String> AXIS_SYMBOLIC_NAMES;
    public static final int AXIS_THROTTLE = 19;
    public static final int AXIS_TILT = 25;
    public static final int AXIS_TOOL_MAJOR = 6;
    public static final int AXIS_TOOL_MINOR = 7;
    public static final int AXIS_TOUCH_MAJOR = 4;
    public static final int AXIS_TOUCH_MINOR = 5;
    public static final int AXIS_VSCROLL = 9;
    public static final int AXIS_WHEEL = 21;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 11;
    public static final int BUTTON_BACK = 8;
    public static final int BUTTON_FORWARD = 16;
    public static final int BUTTON_MENU = 0x40000000;
    public static final int BUTTON_PRIMARY = 1;
    public static final int BUTTON_SECONDARY = 2;
    private static final String[] BUTTON_SYMBOLIC_NAMES;
    public static final int BUTTON_TERTIARY = 4;
    public static final Parcelable.Creator<MotionEvent> CREATOR;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int EDGE_TOP = 1;
    public static final int FLAG_TAINTED = Integer.MIN_VALUE;
    public static final int FLAG_WINDOW_IS_OBSCURED = 1;
    private static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    public static final int INVALID_POINTER_ID = -1;
    private static final String LABEL_PREFIX = "AXIS_";
    private static final int MAX_RECYCLED = 10;
    private static final long NS_PER_MS = 1000000L;
    public static final int TOOL_TYPE_ERASER = 4;
    public static final int TOOL_TYPE_FINGER = 1;
    public static final int TOOL_TYPE_MOUSE = 3;
    public static final int TOOL_TYPE_STYLUS = 2;
    private static final SparseArray<String> TOOL_TYPE_SYMBOLIC_NAMES;
    public static final int TOOL_TYPE_UNKNOWN;
    private static final Object gRecyclerLock;
    private static MotionEvent gRecyclerTop;
    private static int gRecyclerUsed;
    private static final Object gSharedTempLock;
    private static PointerCoords[] gSharedTempPointerCoords;
    private static int[] gSharedTempPointerIndexMap;
    private static PointerProperties[] gSharedTempPointerProperties;
    private long mNativePtr;
    private MotionEvent mNext;

    static {
        SparseArray<String> sparseArray = AXIS_SYMBOLIC_NAMES = new SparseArray();
        sparseArray.append(0, "AXIS_X");
        sparseArray.append(1, "AXIS_Y");
        sparseArray.append(2, "AXIS_PRESSURE");
        sparseArray.append(3, "AXIS_SIZE");
        sparseArray.append(4, "AXIS_TOUCH_MAJOR");
        sparseArray.append(5, "AXIS_TOUCH_MINOR");
        sparseArray.append(6, "AXIS_TOOL_MAJOR");
        sparseArray.append(7, "AXIS_TOOL_MINOR");
        sparseArray.append(8, "AXIS_ORIENTATION");
        sparseArray.append(9, "AXIS_VSCROLL");
        sparseArray.append(10, "AXIS_HSCROLL");
        sparseArray.append(11, "AXIS_Z");
        sparseArray.append(12, "AXIS_RX");
        sparseArray.append(13, "AXIS_RY");
        sparseArray.append(14, "AXIS_RZ");
        sparseArray.append(15, "AXIS_HAT_X");
        sparseArray.append(16, "AXIS_HAT_Y");
        sparseArray.append(17, "AXIS_LTRIGGER");
        sparseArray.append(18, "AXIS_RTRIGGER");
        sparseArray.append(19, "AXIS_THROTTLE");
        sparseArray.append(20, "AXIS_RUDDER");
        sparseArray.append(21, "AXIS_WHEEL");
        sparseArray.append(22, "AXIS_GAS");
        sparseArray.append(23, "AXIS_BRAKE");
        sparseArray.append(24, "AXIS_DISTANCE");
        sparseArray.append(25, "AXIS_TILT");
        sparseArray.append(32, "AXIS_GENERIC_1");
        sparseArray.append(33, "AXIS_GENERIC_2");
        sparseArray.append(34, "AXIS_GENERIC_3");
        sparseArray.append(35, "AXIS_GENERIC_4");
        sparseArray.append(36, "AXIS_GENERIC_5");
        sparseArray.append(37, "AXIS_GENERIC_6");
        sparseArray.append(38, "AXIS_GENERIC_7");
        sparseArray.append(39, "AXIS_GENERIC_8");
        sparseArray.append(40, "AXIS_GENERIC_9");
        sparseArray.append(41, "AXIS_GENERIC_10");
        sparseArray.append(42, "AXIS_GENERIC_11");
        sparseArray.append(43, "AXIS_GENERIC_12");
        sparseArray.append(44, "AXIS_GENERIC_13");
        sparseArray.append(45, "AXIS_GENERIC_14");
        sparseArray.append(46, "AXIS_GENERIC_15");
        sparseArray.append(47, "AXIS_GENERIC_16");
        BUTTON_SYMBOLIC_NAMES = new String[]{"BUTTON_PRIMARY", "BUTTON_SECONDARY", "BUTTON_TERTIARY", "BUTTON_BACK", "BUTTON_FORWARD", "0x00000020", "0x00000040", "0x00000080", "0x00000100", "0x00000200", "0x00000400", "0x00000800", "0x00001000", "0x00002000", "0x00004000", "0x00008000", "0x00010000", "0x00020000", "0x00040000", "0x00080000", "0x00100000", "0x00200000", "0x00400000", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
        SparseArray<String> sparseArray2 = TOOL_TYPE_SYMBOLIC_NAMES = new SparseArray();
        sparseArray2.append(0, "TOOL_TYPE_UNKNOWN");
        sparseArray2.append(1, "TOOL_TYPE_FINGER");
        sparseArray2.append(2, "TOOL_TYPE_STYLUS");
        sparseArray2.append(3, "TOOL_TYPE_MOUSE");
        sparseArray2.append(4, "TOOL_TYPE_ERASER");
        gRecyclerLock = new Object();
        gSharedTempLock = new Object();
        CREATOR = new Parcelable.Creator<MotionEvent>(){

            @Override
            public MotionEvent createFromParcel(Parcel parcel) {
                parcel.readInt();
                return MotionEvent.createFromParcelBody(parcel);
            }

            public MotionEvent[] newArray(int n) {
                return new MotionEvent[n];
            }
        };
    }

    private MotionEvent() {
    }

    /*
     * Exception decompiling
     */
    public static String actionToString(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 11[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int axisFromString(String string2) {
        int n;
        if (string2.startsWith(LABEL_PREFIX) && (n = MotionEvent.nativeAxisFromString(string2 = string2.substring(LABEL_PREFIX.length()))) >= 0) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2, 10);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String axisToString(int n) {
        String string2 = MotionEvent.nativeAxisToString(n);
        if (string2 != null) {
            return LABEL_PREFIX + string2;
        }
        return Integer.toString(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String buttonStateToString(int n) {
        if (n == 0) {
            return "0";
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        while (n != 0) {
            boolean bl = (n & 1) != 0;
            n >>>= 1;
            if (bl) {
                String string2 = BUTTON_SYMBOLIC_NAMES[n2];
                if (stringBuilder == null) {
                    if (n == 0) return string2;
                    stringBuilder = new StringBuilder(string2);
                } else {
                    stringBuilder.append('|');
                    stringBuilder.append(string2);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static final float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static MotionEvent createFromParcelBody(Parcel parcel) {
        MotionEvent motionEvent = MotionEvent.obtain();
        motionEvent.mNativePtr = MotionEvent.nativeReadFromParcel(motionEvent.mNativePtr, parcel);
        return motionEvent;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void ensureSharedTempPointerCapacity(int n) {
        if (gSharedTempPointerCoords == null || gSharedTempPointerCoords.length < n) {
            int n2;
            for (n2 = gSharedTempPointerCoords != null ? gSharedTempPointerCoords.length : 8; n2 < n; n2 *= 2) {
            }
            gSharedTempPointerCoords = PointerCoords.createArray(n2);
            gSharedTempPointerProperties = PointerProperties.createArray(n2);
            gSharedTempPointerIndexMap = new int[n2];
        }
    }

    private static native void nativeAddBatch(long var0, long var2, PointerCoords[] var4, int var5);

    private static native int nativeAxisFromString(String var0);

    private static native String nativeAxisToString(int var0);

    private static native long nativeCopy(long var0, long var2, boolean var4);

    private static native void nativeDispose(long var0);

    private static native int nativeFindPointerIndex(long var0, int var2);

    private static native int nativeGetAction(long var0);

    private static native float nativeGetAxisValue(long var0, int var2, int var3, int var4);

    private static native int nativeGetButtonState(long var0);

    private static native int nativeGetDeviceId(long var0);

    private static native long nativeGetDownTimeNanos(long var0);

    private static native int nativeGetEdgeFlags(long var0);

    private static native long nativeGetEventTimeNanos(long var0, int var2);

    private static native int nativeGetFlags(long var0);

    private static native int nativeGetHistorySize(long var0);

    private static native int nativeGetMetaState(long var0);

    private static native void nativeGetPointerCoords(long var0, int var2, int var3, PointerCoords var4);

    private static native int nativeGetPointerCount(long var0);

    private static native int nativeGetPointerId(long var0, int var2);

    private static native void nativeGetPointerProperties(long var0, int var2, PointerProperties var3);

    private static native float nativeGetRawAxisValue(long var0, int var2, int var3, int var4);

    private static native int nativeGetSource(long var0);

    private static native int nativeGetToolType(long var0, int var2);

    private static native float nativeGetXOffset(long var0);

    private static native float nativeGetXPrecision(long var0);

    private static native float nativeGetYOffset(long var0);

    private static native float nativeGetYPrecision(long var0);

    private static native long nativeInitialize(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9, float var10, float var11, float var12, long var13, long var15, int var17, PointerProperties[] var18, PointerCoords[] var19);

    private static native boolean nativeIsTouchEvent(long var0);

    private static native void nativeOffsetLocation(long var0, float var2, float var3);

    private static native long nativeReadFromParcel(long var0, Parcel var2);

    private static native void nativeScale(long var0, float var2);

    private static native void nativeSetAction(long var0, int var2);

    private static native void nativeSetDownTimeNanos(long var0, long var2);

    private static native void nativeSetEdgeFlags(long var0, int var2);

    private static native void nativeSetFlags(long var0, int var2);

    private static native int nativeSetSource(long var0, int var2);

    private static native void nativeTransform(long var0, Matrix var2);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MotionEvent obtain() {
        MotionEvent motionEvent;
        Object object = gRecyclerLock;
        synchronized (object) {
            motionEvent = gRecyclerTop;
            if (motionEvent == null) {
                return new MotionEvent();
            }
            gRecyclerTop = motionEvent.mNext;
            gRecyclerUsed = -1 + gRecyclerUsed;
        }
        motionEvent.mNext = null;
        motionEvent.prepareForReuse();
        return motionEvent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MotionEvent obtain(long l, long l2, int n, float f, float f2, float f3, float f4, int n2, float f5, float f6, int n3, int n4) {
        MotionEvent motionEvent = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerProperties[] pointerPropertiesArray = gSharedTempPointerProperties;
            pointerPropertiesArray[0].clear();
            pointerPropertiesArray[0].id = 0;
            PointerCoords[] pointerCoordsArray = gSharedTempPointerCoords;
            pointerCoordsArray[0].clear();
            pointerCoordsArray[0].x = f;
            pointerCoordsArray[0].y = f2;
            pointerCoordsArray[0].pressure = f3;
            pointerCoordsArray[0].size = f4;
            motionEvent.mNativePtr = MotionEvent.nativeInitialize(motionEvent.mNativePtr, n3, 0, n, 0, n4, n2, 0, 0.0f, 0.0f, f5, f6, l * 1000000L, l2 * 1000000L, 1, pointerPropertiesArray, pointerCoordsArray);
            return motionEvent;
        }
    }

    public static MotionEvent obtain(long l, long l2, int n, float f, float f2, int n2) {
        return MotionEvent.obtain(l, l2, n, f, f2, 1.0f, 1.0f, n2, 1.0f, 1.0f, 0, 0);
    }

    @Deprecated
    public static MotionEvent obtain(long l, long l2, int n, int n2, float f, float f2, float f3, float f4, int n3, float f5, float f6, int n4, int n5) {
        return MotionEvent.obtain(l, l2, n, f, f2, f3, f4, n3, f5, f6, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static MotionEvent obtain(long l, long l2, int n, int n2, int[] nArray, PointerCoords[] pointerCoordsArray, int n3, float f, float f2, int n4, int n5, int n6, int n7) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(n2);
            PointerProperties[] pointerPropertiesArray = gSharedTempPointerProperties;
            int n8 = 0;
            while (n8 < n2) {
                pointerPropertiesArray[n8].clear();
                pointerPropertiesArray[n8].id = nArray[n8];
                ++n8;
            }
            return MotionEvent.obtain(l, l2, n, n2, pointerPropertiesArray, pointerCoordsArray, n3, 0, f, f2, n4, n5, n6, n7);
        }
    }

    public static MotionEvent obtain(long l, long l2, int n, int n2, PointerProperties[] pointerPropertiesArray, PointerCoords[] pointerCoordsArray, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8) {
        MotionEvent motionEvent = MotionEvent.obtain();
        motionEvent.mNativePtr = MotionEvent.nativeInitialize(motionEvent.mNativePtr, n5, n7, n, n8, n6, n3, n4, 0.0f, 0.0f, f, f2, l * 1000000L, l2 * 1000000L, n2, pointerPropertiesArray, pointerCoordsArray);
        return motionEvent;
    }

    public static MotionEvent obtain(MotionEvent motionEvent) {
        if (motionEvent == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent motionEvent2 = MotionEvent.obtain();
        motionEvent2.mNativePtr = MotionEvent.nativeCopy(motionEvent2.mNativePtr, motionEvent.mNativePtr, true);
        return motionEvent2;
    }

    public static MotionEvent obtainNoHistory(MotionEvent motionEvent) {
        if (motionEvent == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent motionEvent2 = MotionEvent.obtain();
        motionEvent2.mNativePtr = MotionEvent.nativeCopy(motionEvent2.mNativePtr, motionEvent.mNativePtr, false);
        return motionEvent2;
    }

    public static String toolTypeToString(int n) {
        String string2 = TOOL_TYPE_SYMBOLIC_NAMES.get(n);
        if (string2 != null) {
            return string2;
        }
        return Integer.toString(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addBatch(long l, float f, float f2, float f3, float f4, int n) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerCoords[] pointerCoordsArray = gSharedTempPointerCoords;
            pointerCoordsArray[0].clear();
            pointerCoordsArray[0].x = f;
            pointerCoordsArray[0].y = f2;
            pointerCoordsArray[0].pressure = f3;
            pointerCoordsArray[0].size = f4;
            MotionEvent.nativeAddBatch(this.mNativePtr, 1000000L * l, pointerCoordsArray, n);
            return;
        }
    }

    public final void addBatch(long l, PointerCoords[] pointerCoordsArray, int n) {
        MotionEvent.nativeAddBatch(this.mNativePtr, 1000000L * l, pointerCoordsArray, n);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean addBatch(MotionEvent motionEvent) {
        int n = MotionEvent.nativeGetAction(this.mNativePtr);
        if (n != 2 && n != 7) {
            return false;
        }
        if (n != MotionEvent.nativeGetAction(motionEvent.mNativePtr)) {
            return false;
        }
        if (MotionEvent.nativeGetDeviceId(this.mNativePtr) != MotionEvent.nativeGetDeviceId(motionEvent.mNativePtr) || MotionEvent.nativeGetSource(this.mNativePtr) != MotionEvent.nativeGetSource(motionEvent.mNativePtr) || MotionEvent.nativeGetFlags(this.mNativePtr) != MotionEvent.nativeGetFlags(motionEvent.mNativePtr)) {
            return false;
        }
        int n2 = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        if (n2 != MotionEvent.nativeGetPointerCount(motionEvent.mNativePtr)) {
            return false;
        }
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(Math.max(n2, 2));
            PointerProperties[] pointerPropertiesArray = gSharedTempPointerProperties;
            PointerCoords[] pointerCoordsArray = gSharedTempPointerCoords;
            for (int i = 0; i < n2; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pointerPropertiesArray[0]);
                MotionEvent.nativeGetPointerProperties(motionEvent.mNativePtr, i, pointerPropertiesArray[1]);
                if (pointerPropertiesArray[0].equals(pointerPropertiesArray[1])) continue;
                return false;
            }
            int n3 = MotionEvent.nativeGetMetaState(motionEvent.mNativePtr);
            int n4 = MotionEvent.nativeGetHistorySize(motionEvent.mNativePtr);
            int n5 = 0;
            boolean bl = true;
            while (true) {
                int n6;
                int n7;
                if (!bl || (bl = false) || !true) {
                    if (n7 < n2) {
                        MotionEvent.nativeGetPointerCoords(motionEvent.mNativePtr, n7, n6, pointerCoordsArray[n7]);
                        ++n7;
                        continue;
                    }
                    long l = MotionEvent.nativeGetEventTimeNanos(motionEvent.mNativePtr, n6);
                    MotionEvent.nativeAddBatch(this.mNativePtr, l, pointerCoordsArray, n3);
                    ++n5;
                }
                if (n5 > n4) {
                    return true;
                }
                n6 = n5 == n4 ? Integer.MIN_VALUE : n5;
                n7 = 0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MotionEvent clampNoHistory(float f, float f2, float f3, float f4) {
        MotionEvent motionEvent = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int n = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(n);
            PointerProperties[] pointerPropertiesArray = gSharedTempPointerProperties;
            PointerCoords[] pointerCoordsArray = gSharedTempPointerCoords;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    motionEvent.mNativePtr = MotionEvent.nativeInitialize(motionEvent.mNativePtr, MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), MotionEvent.nativeGetAction(this.mNativePtr), MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE), n, pointerPropertiesArray, pointerCoordsArray);
                    return motionEvent;
                }
                long l = this.mNativePtr;
                PointerProperties pointerProperties = pointerPropertiesArray[n2];
                MotionEvent.nativeGetPointerProperties(l, n2, pointerProperties);
                long l2 = this.mNativePtr;
                PointerCoords pointerCoords = pointerCoordsArray[n2];
                MotionEvent.nativeGetPointerCoords(l2, n2, Integer.MIN_VALUE, pointerCoords);
                pointerCoordsArray[n2].x = MotionEvent.clamp(pointerCoordsArray[n2].x, f, f3);
                pointerCoordsArray[n2].y = MotionEvent.clamp(pointerCoordsArray[n2].y, f2, f4);
                ++n2;
            }
        }
    }

    @Override
    public MotionEvent copy() {
        return MotionEvent.obtain(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                MotionEvent.nativeDispose(this.mNativePtr);
                this.mNativePtr = 0L;
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public final int findPointerIndex(int n) {
        return MotionEvent.nativeFindPointerIndex(this.mNativePtr, n);
    }

    public final int getAction() {
        return MotionEvent.nativeGetAction(this.mNativePtr);
    }

    public final int getActionIndex() {
        return (0xFF00 & MotionEvent.nativeGetAction(this.mNativePtr)) >> 8;
    }

    public final int getActionMasked() {
        return 0xFF & MotionEvent.nativeGetAction(this.mNativePtr);
    }

    public final float getAxisValue(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, n, 0, Integer.MIN_VALUE);
    }

    public final float getAxisValue(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, n, n2, Integer.MIN_VALUE);
    }

    public final int getButtonState() {
        return MotionEvent.nativeGetButtonState(this.mNativePtr);
    }

    @Override
    public final int getDeviceId() {
        return MotionEvent.nativeGetDeviceId(this.mNativePtr);
    }

    public final long getDownTime() {
        return MotionEvent.nativeGetDownTimeNanos(this.mNativePtr) / 1000000L;
    }

    public final int getEdgeFlags() {
        return MotionEvent.nativeGetEdgeFlags(this.mNativePtr);
    }

    @Override
    public final long getEventTime() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE) / 1000000L;
    }

    @Override
    public final long getEventTimeNano() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE);
    }

    public final int getFlags() {
        return MotionEvent.nativeGetFlags(this.mNativePtr);
    }

    public final float getHistoricalAxisValue(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, n, 0, n2);
    }

    public final float getHistoricalAxisValue(int n, int n2, int n3) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, n, n2, n3);
    }

    public final long getHistoricalEventTime(int n) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, n) / 1000000L;
    }

    public final long getHistoricalEventTimeNano(int n) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, n);
    }

    public final float getHistoricalOrientation(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, n);
    }

    public final float getHistoricalOrientation(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, n, n2);
    }

    public final void getHistoricalPointerCoords(int n, int n2, PointerCoords pointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, n, n2, pointerCoords);
    }

    public final float getHistoricalPressure(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, n);
    }

    public final float getHistoricalPressure(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, n, n2);
    }

    public final float getHistoricalSize(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, n);
    }

    public final float getHistoricalSize(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, n, n2);
    }

    public final float getHistoricalToolMajor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, n);
    }

    public final float getHistoricalToolMajor(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, n, n2);
    }

    public final float getHistoricalToolMinor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, n);
    }

    public final float getHistoricalToolMinor(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, n, n2);
    }

    public final float getHistoricalTouchMajor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, n);
    }

    public final float getHistoricalTouchMajor(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, n, n2);
    }

    public final float getHistoricalTouchMinor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, n);
    }

    public final float getHistoricalTouchMinor(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, n, n2);
    }

    public final float getHistoricalX(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, n);
    }

    public final float getHistoricalX(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, n, n2);
    }

    public final float getHistoricalY(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, n);
    }

    public final float getHistoricalY(int n, int n2) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, n, n2);
    }

    public final int getHistorySize() {
        return MotionEvent.nativeGetHistorySize(this.mNativePtr);
    }

    public final int getMetaState() {
        return MotionEvent.nativeGetMetaState(this.mNativePtr);
    }

    public final float getOrientation() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, Integer.MIN_VALUE);
    }

    public final float getOrientation(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, n, Integer.MIN_VALUE);
    }

    public final void getPointerCoords(int n, PointerCoords pointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, n, Integer.MIN_VALUE, pointerCoords);
    }

    public final int getPointerCount() {
        return MotionEvent.nativeGetPointerCount(this.mNativePtr);
    }

    public final int getPointerId(int n) {
        return MotionEvent.nativeGetPointerId(this.mNativePtr, n);
    }

    public final int getPointerIdBits() {
        int n = 0;
        int n2 = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < n2; ++i) {
            n |= 1 << MotionEvent.nativeGetPointerId(this.mNativePtr, i);
        }
        return n;
    }

    public final void getPointerProperties(int n, PointerProperties pointerProperties) {
        MotionEvent.nativeGetPointerProperties(this.mNativePtr, n, pointerProperties);
    }

    public final float getPressure() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, Integer.MIN_VALUE);
    }

    public final float getPressure(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, n, Integer.MIN_VALUE);
    }

    public final float getRawX() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public final float getRawY() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public final float getSize() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, Integer.MIN_VALUE);
    }

    public final float getSize(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, n, Integer.MIN_VALUE);
    }

    @Override
    public final int getSource() {
        return MotionEvent.nativeGetSource(this.mNativePtr);
    }

    public final float getToolMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, Integer.MIN_VALUE);
    }

    public final float getToolMajor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, n, Integer.MIN_VALUE);
    }

    public final float getToolMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, Integer.MIN_VALUE);
    }

    public final float getToolMinor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, n, Integer.MIN_VALUE);
    }

    public final int getToolType(int n) {
        return MotionEvent.nativeGetToolType(this.mNativePtr, n);
    }

    public final float getTouchMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, Integer.MIN_VALUE);
    }

    public final float getTouchMajor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, n, Integer.MIN_VALUE);
    }

    public final float getTouchMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, Integer.MIN_VALUE);
    }

    public final float getTouchMinor(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, n, Integer.MIN_VALUE);
    }

    public final float getX() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public final float getX(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, n, Integer.MIN_VALUE);
    }

    public final float getXPrecision() {
        return MotionEvent.nativeGetXPrecision(this.mNativePtr);
    }

    public final float getY() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public final float getY(int n) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, n, Integer.MIN_VALUE);
    }

    public final float getYPrecision() {
        return MotionEvent.nativeGetYPrecision(this.mNativePtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean isButtonPressed(int n) {
        return n != 0 && (n & this.getButtonState()) == n;
    }

    @Override
    public final boolean isTainted() {
        return (Integer.MIN_VALUE & this.getFlags()) != 0;
    }

    public final boolean isTouchEvent() {
        return MotionEvent.nativeIsTouchEvent(this.mNativePtr);
    }

    public final boolean isWithinBoundsNoHistory(float f, float f2, float f3, float f4) {
        int n = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < n; ++i) {
            float f5 = MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, i, Integer.MIN_VALUE);
            float f6 = MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, i, Integer.MIN_VALUE);
            if (!(f5 < f || f5 > f3 || f6 < f2) && !(f6 > f4)) continue;
            return false;
        }
        return true;
    }

    public final void offsetLocation(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            MotionEvent.nativeOffsetLocation(this.mNativePtr, f, f2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void recycle() {
        super.recycle();
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                gRecyclerUsed = 1 + gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
            return;
        }
    }

    public final void scale(float f) {
        if (f != 1.0f) {
            MotionEvent.nativeScale(this.mNativePtr, f);
        }
    }

    public final void setAction(int n) {
        MotionEvent.nativeSetAction(this.mNativePtr, n);
    }

    public final void setDownTime(long l) {
        MotionEvent.nativeSetDownTimeNanos(this.mNativePtr, 1000000L * l);
    }

    public final void setEdgeFlags(int n) {
        MotionEvent.nativeSetEdgeFlags(this.mNativePtr, n);
    }

    public final void setLocation(float f, float f2) {
        float f3 = this.getX();
        float f4 = this.getY();
        this.offsetLocation(f - f3, f2 - f4);
    }

    @Override
    public final void setSource(int n) {
        MotionEvent.nativeSetSource(this.mNativePtr, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void setTainted(boolean bl) {
        int n = this.getFlags();
        long l = this.mNativePtr;
        int n2 = bl ? Integer.MIN_VALUE | n : Integer.MAX_VALUE & n;
        MotionEvent.nativeSetFlags(l, n2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MotionEvent split(int n) {
        MotionEvent motionEvent = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int n2;
            int n3;
            int[] nArray;
            PointerCoords[] pointerCoordsArray;
            PointerProperties[] pointerPropertiesArray;
            block18: {
                int n4;
                block17: {
                    int n5 = MotionEvent.nativeGetPointerCount(this.mNativePtr);
                    MotionEvent.ensureSharedTempPointerCapacity(n5);
                    pointerPropertiesArray = gSharedTempPointerProperties;
                    pointerCoordsArray = gSharedTempPointerCoords;
                    nArray = gSharedTempPointerIndexMap;
                    n4 = MotionEvent.nativeGetAction(this.mNativePtr);
                    int n6 = n4 & 0xFF;
                    int n7 = (0xFF00 & n4) >> 8;
                    int n8 = -1;
                    n3 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    while (true) {
                        if (n10 < n5) {
                            long l = this.mNativePtr;
                            PointerProperties pointerProperties = pointerPropertiesArray[n3];
                            MotionEvent.nativeGetPointerProperties(l, n10, pointerProperties);
                            int n11 = 1 << pointerPropertiesArray[n3].id;
                            if ((n11 & n) != 0) {
                                if (n10 == n7) {
                                    n8 = n3;
                                }
                                nArray[n3] = n10;
                                ++n3;
                                n9 |= n11;
                            }
                        } else {
                            if (n3 == 0) {
                                throw new IllegalArgumentException("idBits did not match any ids in the event");
                            }
                            if (n6 != 5 && n6 != 6) break block17;
                            if (n8 >= 0) break;
                            n2 = 2;
                            break block18;
                        }
                        ++n10;
                    }
                    n2 = n3 == 1 ? (n6 == 5 ? 0 : 1) : n6 | n8 << 8;
                    break block18;
                }
                n2 = n4;
            }
            int n12 = MotionEvent.nativeGetHistorySize(this.mNativePtr);
            int n13 = 0;
            boolean bl = true;
            while (true) {
                int n14;
                int n15;
                if (!bl || (bl = false) || !true) {
                    if (n15 < n3) {
                        long l = this.mNativePtr;
                        int n16 = nArray[n15];
                        PointerCoords pointerCoords = pointerCoordsArray[n15];
                        MotionEvent.nativeGetPointerCoords(l, n16, n14, pointerCoords);
                        ++n15;
                        continue;
                    }
                    long l = MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, n14);
                    if (n13 == 0) {
                        motionEvent.mNativePtr = MotionEvent.nativeInitialize(motionEvent.mNativePtr, MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), n2, MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), l, n3, pointerPropertiesArray, pointerCoordsArray);
                    } else {
                        MotionEvent.nativeAddBatch(motionEvent.mNativePtr, l, pointerCoordsArray, 0);
                    }
                    ++n13;
                }
                if (n13 > n12) {
                    return motionEvent;
                }
                n14 = n13 == n12 ? Integer.MIN_VALUE : n13;
                n15 = 0;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MotionEvent { action=").append(MotionEvent.actionToString(this.getAction()));
        int n = this.getPointerCount();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(", id[").append(i).append("]=").append(this.getPointerId(i));
            stringBuilder.append(", x[").append(i).append("]=").append(this.getX(i));
            stringBuilder.append(", y[").append(i).append("]=").append(this.getY(i));
            stringBuilder.append(", toolType[").append(i).append("]=").append(MotionEvent.toolTypeToString(this.getToolType(i)));
        }
        stringBuilder.append(", buttonState=").append(MotionEvent.buttonStateToString(this.getButtonState()));
        stringBuilder.append(", metaState=").append(KeyEvent.metaStateToString(this.getMetaState()));
        stringBuilder.append(", flags=0x").append(Integer.toHexString(this.getFlags()));
        stringBuilder.append(", edgeFlags=0x").append(Integer.toHexString(this.getEdgeFlags()));
        stringBuilder.append(", pointerCount=").append(n);
        stringBuilder.append(", historySize=").append(this.getHistorySize());
        stringBuilder.append(", eventTime=").append(this.getEventTime());
        stringBuilder.append(", downTime=").append(this.getDownTime());
        stringBuilder.append(", deviceId=").append(this.getDeviceId());
        stringBuilder.append(", source=0x").append(Integer.toHexString(this.getSource()));
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public final void transform(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix must not be null");
        }
        MotionEvent.nativeTransform(this.mNativePtr, matrix);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(1);
        MotionEvent.nativeWriteToParcel(this.mNativePtr, parcel);
    }

    public static final class PointerCoords {
        private static final int INITIAL_PACKED_AXIS_VALUES = 8;
        private long mPackedAxisBits;
        private float[] mPackedAxisValues;
        public float orientation;
        public float pressure;
        public float size;
        public float toolMajor;
        public float toolMinor;
        public float touchMajor;
        public float touchMinor;
        public float x;
        public float y;

        public PointerCoords() {
        }

        public PointerCoords(PointerCoords pointerCoords) {
            this.copyFrom(pointerCoords);
        }

        public static PointerCoords[] createArray(int n) {
            PointerCoords[] pointerCoordsArray = new PointerCoords[n];
            for (int i = 0; i < n; ++i) {
                pointerCoordsArray[i] = new PointerCoords();
            }
            return pointerCoordsArray;
        }

        public void clear() {
            this.mPackedAxisBits = 0L;
            this.x = 0.0f;
            this.y = 0.0f;
            this.pressure = 0.0f;
            this.size = 0.0f;
            this.touchMajor = 0.0f;
            this.touchMinor = 0.0f;
            this.toolMajor = 0.0f;
            this.toolMinor = 0.0f;
            this.orientation = 0.0f;
        }

        public void copyFrom(PointerCoords pointerCoords) {
            long l;
            this.mPackedAxisBits = l = pointerCoords.mPackedAxisBits;
            if (l != 0L) {
                float[] fArray = pointerCoords.mPackedAxisValues;
                int n = Long.bitCount(l);
                float[] fArray2 = this.mPackedAxisValues;
                if (fArray2 == null || n > fArray2.length) {
                    this.mPackedAxisValues = fArray2 = new float[fArray.length];
                }
                System.arraycopy((float[])fArray, (int)0, (float[])fArray2, (int)0, (int)n);
            }
            this.x = pointerCoords.x;
            this.y = pointerCoords.y;
            this.pressure = pointerCoords.pressure;
            this.size = pointerCoords.size;
            this.touchMajor = pointerCoords.touchMajor;
            this.touchMinor = pointerCoords.touchMinor;
            this.toolMajor = pointerCoords.toolMajor;
            this.toolMinor = pointerCoords.toolMinor;
            this.orientation = pointerCoords.orientation;
        }

        public float getAxisValue(int n) {
            switch (n) {
                default: {
                    if (n >= 0 && n <= 63) break;
                    throw new IllegalArgumentException("Axis out of range.");
                }
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
                case 2: {
                    return this.pressure;
                }
                case 3: {
                    return this.size;
                }
                case 4: {
                    return this.touchMajor;
                }
                case 5: {
                    return this.touchMinor;
                }
                case 6: {
                    return this.toolMajor;
                }
                case 7: {
                    return this.toolMinor;
                }
                case 8: {
                    return this.orientation;
                }
            }
            long l = this.mPackedAxisBits;
            if ((l & Long.MIN_VALUE >>> n) == 0L) {
                return 0.0f;
            }
            int n2 = Long.bitCount(l & (0xFFFFFFFFFFFFFFFFL ^ -1L >>> n));
            return this.mPackedAxisValues[n2];
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setAxisValue(int n, float f) {
            switch (n) {
                default: {
                    if (n >= 0 && n <= 63) break;
                    throw new IllegalArgumentException("Axis out of range.");
                }
                case 0: {
                    this.x = f;
                    return;
                }
                case 1: {
                    this.y = f;
                    return;
                }
                case 2: {
                    this.pressure = f;
                    return;
                }
                case 3: {
                    this.size = f;
                    return;
                }
                case 4: {
                    this.touchMajor = f;
                    return;
                }
                case 5: {
                    this.touchMinor = f;
                    return;
                }
                case 6: {
                    this.toolMajor = f;
                    return;
                }
                case 7: {
                    this.toolMinor = f;
                    return;
                }
                case 8: {
                    this.orientation = f;
                    return;
                }
            }
            long l = this.mPackedAxisBits;
            long l2 = Long.MIN_VALUE >>> n;
            int n2 = Long.bitCount(l & (0xFFFFFFFFFFFFFFFFL ^ -1L >>> n));
            float[] fArray = this.mPackedAxisValues;
            if ((l & l2) == 0L) {
                if (fArray == null) {
                    this.mPackedAxisValues = fArray = new float[8];
                } else {
                    int n3 = Long.bitCount(l);
                    if (n3 < fArray.length) {
                        if (n2 != n3) {
                            System.arraycopy((float[])fArray, (int)n2, (float[])fArray, (int)(n2 + 1), (int)(n3 - n2));
                        }
                    } else {
                        float[] fArray2 = new float[n3 * 2];
                        System.arraycopy((float[])fArray, (int)0, (float[])fArray2, (int)0, (int)n2);
                        System.arraycopy((float[])fArray, (int)n2, (float[])fArray2, (int)(n2 + 1), (int)(n3 - n2));
                        this.mPackedAxisValues = fArray = fArray2;
                    }
                }
                this.mPackedAxisBits = l | l2;
            }
            fArray[n2] = f;
        }
    }

    public static final class PointerProperties {
        public int id;
        public int toolType;

        public PointerProperties() {
            this.clear();
        }

        public PointerProperties(PointerProperties pointerProperties) {
            this.copyFrom(pointerProperties);
        }

        public static PointerProperties[] createArray(int n) {
            PointerProperties[] pointerPropertiesArray = new PointerProperties[n];
            for (int i = 0; i < n; ++i) {
                pointerPropertiesArray[i] = new PointerProperties();
            }
            return pointerPropertiesArray;
        }

        private boolean equals(PointerProperties pointerProperties) {
            return pointerProperties != null && this.id == pointerProperties.id && this.toolType == pointerProperties.toolType;
        }

        public void clear() {
            this.id = -1;
            this.toolType = 0;
        }

        public void copyFrom(PointerProperties pointerProperties) {
            this.id = pointerProperties.id;
            this.toolType = pointerProperties.toolType;
        }

        public boolean equals(Object object) {
            if (object instanceof PointerProperties) {
                return this.equals((PointerProperties)object);
            }
            return false;
        }

        public int hashCode() {
            return this.id | this.toolType << 8;
        }
    }
}

