/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.GLES20RecordingCanvas;
import android.view.HardwareCanvas;
import android.view.RenderNodeAnimator;
import android.view.View;

public class RenderNode {
    public static final int FLAG_CLIP_CHILDREN = 1;
    public static final int STATUS_DONE = 0;
    public static final int STATUS_DRAW = 1;
    public static final int STATUS_DREW = 4;
    public static final int STATUS_INVOKE = 2;
    final long mNativeRenderNode;
    private final View mOwningView;
    private boolean mValid;

    private RenderNode(long l) {
        this.mNativeRenderNode = l;
        this.mOwningView = null;
    }

    private RenderNode(String string2, View view) {
        this.mNativeRenderNode = RenderNode.nCreate(string2);
        this.mOwningView = view;
    }

    public static RenderNode adopt(long l) {
        return new RenderNode(l);
    }

    public static RenderNode create(String string2, View view) {
        return new RenderNode(string2, view);
    }

    private static native void nAddAnimator(long var0, long var2);

    private static native long nCreate(String var0);

    private static native void nDestroyRenderNode(long var0);

    private static native void nEndAllAnimators(long var0);

    private static native float nGetAlpha(long var0);

    private static native float nGetCameraDistance(long var0);

    private static native boolean nGetClipToOutline(long var0);

    private static native int nGetDebugSize(long var0);

    private static native float nGetElevation(long var0);

    private static native void nGetInverseTransformMatrix(long var0, long var2);

    private static native float nGetPivotX(long var0);

    private static native float nGetPivotY(long var0);

    private static native float nGetRotation(long var0);

    private static native float nGetRotationX(long var0);

    private static native float nGetRotationY(long var0);

    private static native float nGetScaleX(long var0);

    private static native float nGetScaleY(long var0);

    private static native void nGetTransformMatrix(long var0, long var2);

    private static native float nGetTranslationX(long var0);

    private static native float nGetTranslationY(long var0);

    private static native float nGetTranslationZ(long var0);

    private static native boolean nHasIdentityMatrix(long var0);

    private static native boolean nHasOverlappingRendering(long var0);

    private static native boolean nHasShadow(long var0);

    private static native boolean nIsPivotExplicitlySet(long var0);

    private static native boolean nOffsetLeftAndRight(long var0, int var2);

    private static native boolean nOffsetTopAndBottom(long var0, int var2);

    private static native void nOutput(long var0);

    private static native boolean nSetAlpha(long var0, float var2);

    private static native boolean nSetAnimationMatrix(long var0, long var2);

    private static native boolean nSetBottom(long var0, int var2);

    private static native boolean nSetCameraDistance(long var0, float var2);

    private static native boolean nSetClipBounds(long var0, int var2, int var3, int var4, int var5);

    private static native boolean nSetClipBoundsEmpty(long var0);

    private static native boolean nSetClipToBounds(long var0, boolean var2);

    private static native boolean nSetClipToOutline(long var0, boolean var2);

    private static native void nSetDisplayListData(long var0, long var2);

    private static native boolean nSetElevation(long var0, float var2);

    private static native boolean nSetHasOverlappingRendering(long var0, boolean var2);

    private static native boolean nSetLayerPaint(long var0, long var2);

    private static native boolean nSetLayerType(long var0, int var2);

    private static native boolean nSetLeft(long var0, int var2);

    private static native boolean nSetLeftTopRightBottom(long var0, int var2, int var3, int var4, int var5);

    private static native boolean nSetOutlineConvexPath(long var0, long var2, float var4);

    private static native boolean nSetOutlineEmpty(long var0);

    private static native boolean nSetOutlineNone(long var0);

    private static native boolean nSetOutlineRoundRect(long var0, int var2, int var3, int var4, int var5, float var6, float var7);

    private static native boolean nSetPivotX(long var0, float var2);

    private static native boolean nSetPivotY(long var0, float var2);

    private static native boolean nSetProjectBackwards(long var0, boolean var2);

    private static native boolean nSetProjectionReceiver(long var0, boolean var2);

    private static native boolean nSetRevealClip(long var0, boolean var2, float var3, float var4, float var5);

    private static native boolean nSetRight(long var0, int var2);

    private static native boolean nSetRotation(long var0, float var2);

    private static native boolean nSetRotationX(long var0, float var2);

    private static native boolean nSetRotationY(long var0, float var2);

    private static native boolean nSetScaleX(long var0, float var2);

    private static native boolean nSetScaleY(long var0, float var2);

    private static native boolean nSetStaticMatrix(long var0, long var2);

    private static native boolean nSetTop(long var0, int var2);

    private static native boolean nSetTranslationX(long var0, float var2);

    private static native boolean nSetTranslationY(long var0, float var2);

    private static native boolean nSetTranslationZ(long var0, float var2);

    public void addAnimator(RenderNodeAnimator renderNodeAnimator) {
        if (this.mOwningView == null || this.mOwningView.mAttachInfo == null) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        RenderNode.nAddAnimator(this.mNativeRenderNode, renderNodeAnimator.getNativeAnimator());
        this.mOwningView.mAttachInfo.mViewRootImpl.registerAnimatingRenderNode(this);
    }

    public void destroyDisplayListData() {
        if (!this.mValid) {
            return;
        }
        RenderNode.nSetDisplayListData(this.mNativeRenderNode, 0L);
        this.mValid = false;
    }

    public void end(HardwareCanvas hardwareCanvas) {
        if (!(hardwareCanvas instanceof GLES20RecordingCanvas)) {
            throw new IllegalArgumentException("Passed an invalid canvas to end!");
        }
        GLES20RecordingCanvas gLES20RecordingCanvas = (GLES20RecordingCanvas)hardwareCanvas;
        gLES20RecordingCanvas.onPostDraw();
        long l = gLES20RecordingCanvas.finishRecording();
        RenderNode.nSetDisplayListData(this.mNativeRenderNode, l);
        gLES20RecordingCanvas.recycle();
        this.mValid = true;
    }

    public void endAllAnimators() {
        RenderNode.nEndAllAnimators(this.mNativeRenderNode);
    }

    protected void finalize() throws Throwable {
        try {
            RenderNode.nDestroyRenderNode(this.mNativeRenderNode);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public float getAlpha() {
        return RenderNode.nGetAlpha(this.mNativeRenderNode);
    }

    public float getCameraDistance() {
        return RenderNode.nGetCameraDistance(this.mNativeRenderNode);
    }

    public boolean getClipToOutline() {
        return RenderNode.nGetClipToOutline(this.mNativeRenderNode);
    }

    public int getDebugSize() {
        return RenderNode.nGetDebugSize(this.mNativeRenderNode);
    }

    public float getElevation() {
        return RenderNode.nGetElevation(this.mNativeRenderNode);
    }

    public void getInverseMatrix(Matrix matrix) {
        RenderNode.nGetInverseTransformMatrix(this.mNativeRenderNode, matrix.native_instance);
    }

    public void getMatrix(Matrix matrix) {
        RenderNode.nGetTransformMatrix(this.mNativeRenderNode, matrix.native_instance);
    }

    long getNativeDisplayList() {
        if (!this.mValid) {
            throw new IllegalStateException("The display list is not valid.");
        }
        return this.mNativeRenderNode;
    }

    public float getPivotX() {
        return RenderNode.nGetPivotX(this.mNativeRenderNode);
    }

    public float getPivotY() {
        return RenderNode.nGetPivotY(this.mNativeRenderNode);
    }

    public float getRotation() {
        return RenderNode.nGetRotation(this.mNativeRenderNode);
    }

    public float getRotationX() {
        return RenderNode.nGetRotationX(this.mNativeRenderNode);
    }

    public float getRotationY() {
        return RenderNode.nGetRotationY(this.mNativeRenderNode);
    }

    public float getScaleX() {
        return RenderNode.nGetScaleX(this.mNativeRenderNode);
    }

    public float getScaleY() {
        return RenderNode.nGetScaleY(this.mNativeRenderNode);
    }

    public float getTranslationX() {
        return RenderNode.nGetTranslationX(this.mNativeRenderNode);
    }

    public float getTranslationY() {
        return RenderNode.nGetTranslationY(this.mNativeRenderNode);
    }

    public float getTranslationZ() {
        return RenderNode.nGetTranslationZ(this.mNativeRenderNode);
    }

    public boolean hasIdentityMatrix() {
        return RenderNode.nHasIdentityMatrix(this.mNativeRenderNode);
    }

    public boolean hasOverlappingRendering() {
        return RenderNode.nHasOverlappingRendering(this.mNativeRenderNode);
    }

    public boolean hasShadow() {
        return RenderNode.nHasShadow(this.mNativeRenderNode);
    }

    public boolean isPivotExplicitlySet() {
        return RenderNode.nIsPivotExplicitlySet(this.mNativeRenderNode);
    }

    public boolean isValid() {
        return this.mValid;
    }

    public boolean offsetLeftAndRight(int n) {
        return RenderNode.nOffsetLeftAndRight(this.mNativeRenderNode, n);
    }

    public boolean offsetTopAndBottom(int n) {
        return RenderNode.nOffsetTopAndBottom(this.mNativeRenderNode, n);
    }

    public void output() {
        RenderNode.nOutput(this.mNativeRenderNode);
    }

    public boolean setAlpha(float f) {
        return RenderNode.nSetAlpha(this.mNativeRenderNode, f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setAnimationMatrix(Matrix matrix) {
        long l;
        long l2 = this.mNativeRenderNode;
        if (matrix != null) {
            l = matrix.native_instance;
            return RenderNode.nSetAnimationMatrix(l2, l);
        }
        l = 0L;
        return RenderNode.nSetAnimationMatrix(l2, l);
    }

    public boolean setBottom(int n) {
        return RenderNode.nSetBottom(this.mNativeRenderNode, n);
    }

    public boolean setCameraDistance(float f) {
        return RenderNode.nSetCameraDistance(this.mNativeRenderNode, f);
    }

    public boolean setClipBounds(Rect rect) {
        if (rect == null) {
            return RenderNode.nSetClipBoundsEmpty(this.mNativeRenderNode);
        }
        return RenderNode.nSetClipBounds(this.mNativeRenderNode, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean setClipToBounds(boolean bl) {
        return RenderNode.nSetClipToBounds(this.mNativeRenderNode, bl);
    }

    public boolean setClipToOutline(boolean bl) {
        return RenderNode.nSetClipToOutline(this.mNativeRenderNode, bl);
    }

    public boolean setElevation(float f) {
        return RenderNode.nSetElevation(this.mNativeRenderNode, f);
    }

    public boolean setHasOverlappingRendering(boolean bl) {
        return RenderNode.nSetHasOverlappingRendering(this.mNativeRenderNode, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setLayerPaint(Paint paint) {
        long l;
        long l2 = this.mNativeRenderNode;
        if (paint != null) {
            l = paint.mNativePaint;
            return RenderNode.nSetLayerPaint(l2, l);
        }
        l = 0L;
        return RenderNode.nSetLayerPaint(l2, l);
    }

    public boolean setLayerType(int n) {
        return RenderNode.nSetLayerType(this.mNativeRenderNode, n);
    }

    public boolean setLeft(int n) {
        return RenderNode.nSetLeft(this.mNativeRenderNode, n);
    }

    public boolean setLeftTopRightBottom(int n, int n2, int n3, int n4) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, n, n2, n3, n4);
    }

    public boolean setOutline(Outline outline) {
        if (outline == null) {
            return RenderNode.nSetOutlineNone(this.mNativeRenderNode);
        }
        if (outline.isEmpty()) {
            return RenderNode.nSetOutlineEmpty(this.mNativeRenderNode);
        }
        if (outline.mRect != null) {
            return RenderNode.nSetOutlineRoundRect(this.mNativeRenderNode, outline.mRect.left, outline.mRect.top, outline.mRect.right, outline.mRect.bottom, outline.mRadius, outline.mAlpha);
        }
        if (outline.mPath != null) {
            return RenderNode.nSetOutlineConvexPath(this.mNativeRenderNode, outline.mPath.mNativePath, outline.mAlpha);
        }
        throw new IllegalArgumentException("Unrecognized outline?");
    }

    public boolean setPivotX(float f) {
        return RenderNode.nSetPivotX(this.mNativeRenderNode, f);
    }

    public boolean setPivotY(float f) {
        return RenderNode.nSetPivotY(this.mNativeRenderNode, f);
    }

    public boolean setProjectBackwards(boolean bl) {
        return RenderNode.nSetProjectBackwards(this.mNativeRenderNode, bl);
    }

    public boolean setProjectionReceiver(boolean bl) {
        return RenderNode.nSetProjectionReceiver(this.mNativeRenderNode, bl);
    }

    public boolean setRevealClip(boolean bl, float f, float f2, float f3) {
        return RenderNode.nSetRevealClip(this.mNativeRenderNode, bl, f, f2, f3);
    }

    public boolean setRight(int n) {
        return RenderNode.nSetRight(this.mNativeRenderNode, n);
    }

    public boolean setRotation(float f) {
        return RenderNode.nSetRotation(this.mNativeRenderNode, f);
    }

    public boolean setRotationX(float f) {
        return RenderNode.nSetRotationX(this.mNativeRenderNode, f);
    }

    public boolean setRotationY(float f) {
        return RenderNode.nSetRotationY(this.mNativeRenderNode, f);
    }

    public boolean setScaleX(float f) {
        return RenderNode.nSetScaleX(this.mNativeRenderNode, f);
    }

    public boolean setScaleY(float f) {
        return RenderNode.nSetScaleY(this.mNativeRenderNode, f);
    }

    public boolean setStaticMatrix(Matrix matrix) {
        return RenderNode.nSetStaticMatrix(this.mNativeRenderNode, matrix.native_instance);
    }

    public boolean setTop(int n) {
        return RenderNode.nSetTop(this.mNativeRenderNode, n);
    }

    public boolean setTranslationX(float f) {
        return RenderNode.nSetTranslationX(this.mNativeRenderNode, f);
    }

    public boolean setTranslationY(float f) {
        return RenderNode.nSetTranslationY(this.mNativeRenderNode, f);
    }

    public boolean setTranslationZ(float f) {
        return RenderNode.nSetTranslationZ(this.mNativeRenderNode, f);
    }

    public HardwareCanvas start(int n, int n2) {
        GLES20RecordingCanvas gLES20RecordingCanvas = GLES20RecordingCanvas.obtain(this);
        ((Canvas)gLES20RecordingCanvas).setViewport(n, n2);
        ((HardwareCanvas)gLES20RecordingCanvas).onPreDraw(null);
        return gLES20RecordingCanvas;
    }
}

