/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.util.ArrayList;

public class ViewOverlay {
    OverlayViewGroup mOverlayViewGroup;

    ViewOverlay(Context context, View view) {
        this.mOverlayViewGroup = new OverlayViewGroup(context, view);
    }

    public void add(Drawable drawable2) {
        this.mOverlayViewGroup.add(drawable2);
    }

    public void clear() {
        this.mOverlayViewGroup.clear();
    }

    ViewGroup getOverlayView() {
        return this.mOverlayViewGroup;
    }

    boolean isEmpty() {
        return this.mOverlayViewGroup.isEmpty();
    }

    public void remove(Drawable drawable2) {
        this.mOverlayViewGroup.remove(drawable2);
    }

    static class OverlayViewGroup
    extends ViewGroup {
        ArrayList<Drawable> mDrawables = null;
        View mHostView;

        OverlayViewGroup(Context context, View view) {
            super(context);
            this.mHostView = view;
            this.mAttachInfo = this.mHostView.mAttachInfo;
            this.mRight = view.getWidth();
            this.mBottom = view.getHeight();
        }

        public void add(Drawable drawable2) {
            if (this.mDrawables == null) {
                this.mDrawables = new ArrayList();
            }
            if (!this.mDrawables.contains(drawable2)) {
                this.mDrawables.add(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback(this);
            }
        }

        public void add(View view) {
            if (view.getParent() instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view.getParent();
                if (viewGroup != this.mHostView && viewGroup.getParent() != null && viewGroup.mAttachInfo != null) {
                    int[] nArray = new int[2];
                    int[] nArray2 = new int[2];
                    viewGroup.getLocationOnScreen(nArray);
                    this.mHostView.getLocationOnScreen(nArray2);
                    view.offsetLeftAndRight(nArray[0] - nArray2[0]);
                    view.offsetTopAndBottom(nArray[1] - nArray2[1]);
                }
                viewGroup.removeView(view);
                if (viewGroup.getLayoutTransition() != null) {
                    viewGroup.getLayoutTransition().cancel(3);
                }
                if (view.getParent() != null) {
                    view.mParent = null;
                }
            }
            super.addView(view);
        }

        public void clear() {
            this.removeAllViews();
            if (this.mDrawables != null) {
                this.mDrawables.clear();
            }
        }

        @Override
        public void damageChild(View view, Rect rect) {
            if (this.mHostView != null) {
                int n = view.mLeft;
                int n2 = view.mTop;
                if (!view.getMatrix().isIdentity()) {
                    view.transformRect(rect);
                }
                rect.offset(n, n2);
                this.mHostView.invalidate(rect);
            }
        }

        @Override
        protected ViewParent damageChildInParent(int n, int n2, Rect rect) {
            if (this.mHostView instanceof ViewGroup) {
                return ((ViewGroup)this.mHostView).damageChildInParent(n, n2, rect);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            if (this.mDrawables == null) {
                return;
            }
            int n = this.mDrawables.size();
            int n2 = 0;
            while (n2 < n) {
                this.mDrawables.get(n2).draw(canvas);
                ++n2;
            }
            return;
        }

        @Override
        public void invalidate() {
            super.invalidate();
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }

        @Override
        public void invalidate(int n, int n2, int n3, int n4) {
            super.invalidate(n, n2, n3, n4);
            if (this.mHostView != null) {
                this.mHostView.invalidate(n, n2, n3, n4);
            }
        }

        @Override
        public void invalidate(Rect rect) {
            super.invalidate(rect);
            if (this.mHostView != null) {
                this.mHostView.invalidate(rect);
            }
        }

        @Override
        void invalidate(boolean bl) {
            super.invalidate(bl);
            if (this.mHostView != null) {
                this.mHostView.invalidate(bl);
            }
        }

        @Override
        public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
            if (this.mHostView != null) {
                rect.offset(nArray[0], nArray[1]);
                if (this.mHostView instanceof ViewGroup) {
                    nArray[0] = 0;
                    nArray[1] = 0;
                    super.invalidateChildInParent(nArray, rect);
                    return ((ViewGroup)this.mHostView).invalidateChildInParent(nArray, rect);
                }
                this.invalidate(rect);
            }
            return null;
        }

        @Override
        public void invalidateDrawable(Drawable drawable2) {
            this.invalidate(drawable2.getBounds());
        }

        @Override
        protected void invalidateParentCaches() {
            super.invalidateParentCaches();
            if (this.mHostView != null) {
                this.mHostView.invalidateParentCaches();
            }
        }

        @Override
        protected void invalidateParentIfNeeded() {
            super.invalidateParentIfNeeded();
            if (this.mHostView != null) {
                this.mHostView.invalidateParentIfNeeded();
            }
        }

        @Override
        void invalidateViewProperty(boolean bl, boolean bl2) {
            super.invalidateViewProperty(bl, bl2);
            if (this.mHostView != null) {
                this.mHostView.invalidateViewProperty(bl, bl2);
            }
        }

        boolean isEmpty() {
            return this.getChildCount() == 0 && (this.mDrawables == null || this.mDrawables.size() == 0);
        }

        @Override
        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        }

        public void remove(Drawable drawable2) {
            if (this.mDrawables != null) {
                this.mDrawables.remove(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback(null);
            }
        }

        public void remove(View view) {
            super.removeView(view);
        }

        @Override
        protected boolean verifyDrawable(Drawable drawable2) {
            return super.verifyDrawable(drawable2) || this.mDrawables != null && this.mDrawables.contains(drawable2);
        }
    }
}

