/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;

public final class WindowInsets {
    public static final WindowInsets CONSUMED;
    private static final Rect EMPTY_RECT;
    private boolean mIsRound;
    private Rect mStableInsets;
    private boolean mStableInsetsConsumed;
    private Rect mSystemWindowInsets;
    private boolean mSystemWindowInsetsConsumed;
    private Rect mTempRect;
    private Rect mWindowDecorInsets;
    private boolean mWindowDecorInsetsConsumed;

    static {
        EMPTY_RECT = new Rect(0, 0, 0, 0);
        CONSUMED = new WindowInsets(null, null, null, false);
    }

    public WindowInsets(Rect rect) {
        this(rect, null, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public WindowInsets(Rect rect, Rect rect2, Rect rect3, boolean bl) {
        boolean bl2 = true;
        this.mSystemWindowInsetsConsumed = false;
        this.mWindowDecorInsetsConsumed = false;
        this.mStableInsetsConsumed = false;
        boolean bl3 = rect == null ? bl2 : false;
        this.mSystemWindowInsetsConsumed = bl3;
        if (this.mSystemWindowInsetsConsumed) {
            rect = EMPTY_RECT;
        }
        this.mSystemWindowInsets = rect;
        boolean bl4 = rect2 == null ? bl2 : false;
        this.mWindowDecorInsetsConsumed = bl4;
        if (this.mWindowDecorInsetsConsumed) {
            rect2 = EMPTY_RECT;
        }
        this.mWindowDecorInsets = rect2;
        if (rect3 != null) {
            bl2 = false;
        }
        this.mStableInsetsConsumed = bl2;
        if (this.mStableInsetsConsumed) {
            rect3 = EMPTY_RECT;
        }
        this.mStableInsets = rect3;
        this.mIsRound = bl;
    }

    public WindowInsets(WindowInsets windowInsets) {
        this.mSystemWindowInsetsConsumed = false;
        this.mWindowDecorInsetsConsumed = false;
        this.mStableInsetsConsumed = false;
        this.mSystemWindowInsets = windowInsets.mSystemWindowInsets;
        this.mWindowDecorInsets = windowInsets.mWindowDecorInsets;
        this.mStableInsets = windowInsets.mStableInsets;
        this.mSystemWindowInsetsConsumed = windowInsets.mSystemWindowInsetsConsumed;
        this.mWindowDecorInsetsConsumed = windowInsets.mWindowDecorInsetsConsumed;
        this.mStableInsetsConsumed = windowInsets.mStableInsetsConsumed;
        this.mIsRound = windowInsets.mIsRound;
    }

    public WindowInsets consumeStableInsets() {
        WindowInsets windowInsets = new WindowInsets(this);
        windowInsets.mStableInsets = EMPTY_RECT;
        windowInsets.mStableInsetsConsumed = true;
        return windowInsets;
    }

    public WindowInsets consumeSystemWindowInsets() {
        WindowInsets windowInsets = new WindowInsets(this);
        windowInsets.mSystemWindowInsets = EMPTY_RECT;
        windowInsets.mSystemWindowInsetsConsumed = true;
        return windowInsets;
    }

    /*
     * Enabled aggressive block sorting
     */
    public WindowInsets consumeSystemWindowInsets(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!(bl || bl2 || bl3)) {
            if (!bl4) return this;
        }
        WindowInsets windowInsets = new WindowInsets(this);
        int n = bl ? 0 : this.mSystemWindowInsets.left;
        int n2 = bl2 ? 0 : this.mSystemWindowInsets.top;
        int n3 = bl3 ? 0 : this.mSystemWindowInsets.right;
        int n4 = 0;
        if (!bl4) {
            n4 = this.mSystemWindowInsets.bottom;
        }
        windowInsets.mSystemWindowInsets = new Rect(n, n2, n3, n4);
        return windowInsets;
    }

    public WindowInsets consumeWindowDecorInsets() {
        WindowInsets windowInsets = new WindowInsets(this);
        windowInsets.mWindowDecorInsets.set(0, 0, 0, 0);
        windowInsets.mWindowDecorInsetsConsumed = true;
        return windowInsets;
    }

    /*
     * Enabled aggressive block sorting
     */
    public WindowInsets consumeWindowDecorInsets(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!(bl || bl2 || bl3)) {
            if (!bl4) return this;
        }
        WindowInsets windowInsets = new WindowInsets(this);
        int n = bl ? 0 : this.mWindowDecorInsets.left;
        int n2 = bl2 ? 0 : this.mWindowDecorInsets.top;
        int n3 = bl3 ? 0 : this.mWindowDecorInsets.right;
        int n4 = 0;
        if (!bl4) {
            n4 = this.mWindowDecorInsets.bottom;
        }
        windowInsets.mWindowDecorInsets = new Rect(n, n2, n3, n4);
        return windowInsets;
    }

    public int getStableInsetBottom() {
        return this.mStableInsets.bottom;
    }

    public int getStableInsetLeft() {
        return this.mStableInsets.left;
    }

    public int getStableInsetRight() {
        return this.mStableInsets.right;
    }

    public int getStableInsetTop() {
        return this.mStableInsets.top;
    }

    public int getSystemWindowInsetBottom() {
        return this.mSystemWindowInsets.bottom;
    }

    public int getSystemWindowInsetLeft() {
        return this.mSystemWindowInsets.left;
    }

    public int getSystemWindowInsetRight() {
        return this.mSystemWindowInsets.right;
    }

    public int getSystemWindowInsetTop() {
        return this.mSystemWindowInsets.top;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rect getSystemWindowInsets() {
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        if (this.mSystemWindowInsets != null) {
            this.mTempRect.set(this.mSystemWindowInsets);
            return this.mTempRect;
        }
        this.mTempRect.setEmpty();
        return this.mTempRect;
    }

    public int getWindowDecorInsetBottom() {
        return this.mWindowDecorInsets.bottom;
    }

    public int getWindowDecorInsetLeft() {
        return this.mWindowDecorInsets.left;
    }

    public int getWindowDecorInsetRight() {
        return this.mWindowDecorInsets.right;
    }

    public int getWindowDecorInsetTop() {
        return this.mWindowDecorInsets.top;
    }

    public boolean hasInsets() {
        return this.hasSystemWindowInsets() || this.hasWindowDecorInsets();
    }

    public boolean hasStableInsets() {
        return this.mStableInsets.top != 0 || this.mStableInsets.left != 0 || this.mStableInsets.right != 0 || this.mStableInsets.bottom != 0;
    }

    public boolean hasSystemWindowInsets() {
        return this.mSystemWindowInsets.left != 0 || this.mSystemWindowInsets.top != 0 || this.mSystemWindowInsets.right != 0 || this.mSystemWindowInsets.bottom != 0;
    }

    public boolean hasWindowDecorInsets() {
        return this.mWindowDecorInsets.left != 0 || this.mWindowDecorInsets.top != 0 || this.mWindowDecorInsets.right != 0 || this.mWindowDecorInsets.bottom != 0;
    }

    public boolean isConsumed() {
        return this.mSystemWindowInsetsConsumed && this.mWindowDecorInsetsConsumed && this.mStableInsetsConsumed;
    }

    public boolean isRound() {
        return this.mIsRound;
    }

    public WindowInsets replaceSystemWindowInsets(int n, int n2, int n3, int n4) {
        WindowInsets windowInsets = new WindowInsets(this);
        windowInsets.mSystemWindowInsets = new Rect(n, n2, n3, n4);
        return windowInsets;
    }

    public WindowInsets replaceSystemWindowInsets(Rect rect) {
        WindowInsets windowInsets = new WindowInsets(this);
        windowInsets.mSystemWindowInsets = new Rect(rect);
        return windowInsets;
    }

    public WindowInsets replaceWindowDecorInsets(int n, int n2, int n3, int n4) {
        WindowInsets windowInsets = new WindowInsets(this);
        windowInsets.mWindowDecorInsets = new Rect(n, n2, n3, n4);
        return windowInsets;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("WindowInsets{systemWindowInsets=").append(this.mSystemWindowInsets).append(" windowDecorInsets=").append(this.mWindowDecorInsets).append(" stableInsets=").append(this.mStableInsets);
        if (this.isRound()) {
            string2 = " round}";
            return stringBuilder.append(string2).toString();
        }
        string2 = "}";
        return stringBuilder.append(string2).toString();
    }
}

