/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.ArraySet;
import android.util.Log;
import android.view.Display;
import android.view.HardwareRenderer;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class WindowManagerGlobal {
    public static final int ADD_APP_EXITING = -4;
    public static final int ADD_BAD_APP_TOKEN = -1;
    public static final int ADD_BAD_SUBWINDOW_TOKEN = -2;
    public static final int ADD_DUPLICATE_ADD = -5;
    public static final int ADD_FLAG_APP_VISIBLE = 2;
    public static final int ADD_FLAG_IN_TOUCH_MODE = 1;
    public static final int ADD_INVALID_DISPLAY = -9;
    public static final int ADD_MULTIPLE_SINGLETON = -7;
    public static final int ADD_NOT_APP_TOKEN = -3;
    public static final int ADD_OKAY = 0;
    public static final int ADD_PERMISSION_DENIED = -8;
    public static final int ADD_STARTING_NOT_NEEDED = -6;
    public static final int RELAYOUT_DEFER_SURFACE_DESTROY = 2;
    public static final int RELAYOUT_INSETS_PENDING = 1;
    public static final int RELAYOUT_RES_ANIMATING = 8;
    public static final int RELAYOUT_RES_FIRST_TIME = 2;
    public static final int RELAYOUT_RES_IN_TOUCH_MODE = 1;
    public static final int RELAYOUT_RES_SURFACE_CHANGED = 4;
    private static final String TAG = "WindowManager";
    private static WindowManagerGlobal sDefaultWindowManager;
    private static IWindowManager sWindowManagerService;
    private static IWindowSession sWindowSession;
    private final ArraySet<View> mDyingViews;
    private final Object mLock = new Object();
    private final ArrayList<WindowManager.LayoutParams> mParams;
    private final ArrayList<ViewRootImpl> mRoots;
    private Runnable mSystemPropertyUpdater;
    private final ArrayList<View> mViews = new ArrayList();

    private WindowManagerGlobal() {
        this.mRoots = new ArrayList();
        this.mParams = new ArrayList();
        this.mDyingViews = new ArraySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTrimForeground() {
        boolean bl = false;
        Object object = this.mLock;
        synchronized (object) {
            int n = -1 + this.mRoots.size();
            while (true) {
                if (n >= 0) {
                    ViewRootImpl viewRootImpl = this.mRoots.get(n);
                    if (viewRootImpl.mView != null && viewRootImpl.getHostVisibility() == 0 && viewRootImpl.mAttachInfo.mHardwareRenderer != null) {
                        bl = true;
                    } else {
                        viewRootImpl.destroyHardwareResources();
                    }
                } else {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 7] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (!bl) {
                        HardwareRenderer.trimMemory(80);
                    }
                    return;
                }
                --n;
            }
        }
    }

    private int findViewLocked(View view, boolean bl) {
        int n = this.mViews.indexOf(view);
        if (bl && n < 0) {
            throw new IllegalArgumentException("View=" + view + " not attached to window manager");
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WindowManagerGlobal getInstance() {
        synchronized (WindowManagerGlobal.class) {
            if (sDefaultWindowManager != null) return sDefaultWindowManager;
            sDefaultWindowManager = new WindowManagerGlobal();
            return sDefaultWindowManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IWindowManager getWindowManagerService() {
        synchronized (WindowManagerGlobal.class) {
            if (sWindowManagerService != null) return sWindowManagerService;
            sWindowManagerService = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            return sWindowManagerService;
        }
    }

    private static String getWindowName(ViewRootImpl viewRootImpl) {
        return viewRootImpl.mWindowAttributes.getTitle() + "/" + viewRootImpl.getClass().getName() + '@' + Integer.toHexString(viewRootImpl.hashCode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IWindowSession getWindowSession() {
        synchronized (WindowManagerGlobal.class) {
            IWindowSession iWindowSession = sWindowSession;
            if (iWindowSession != null) return sWindowSession;
            try {
                InputMethodManager inputMethodManager = InputMethodManager.getInstance();
                IWindowManager iWindowManager = WindowManagerGlobal.getWindowManagerService();
                sWindowSession = iWindowManager.openSession(new IWindowSessionCallback.Stub(){

                    @Override
                    public void onAnimatorScaleChanged(float f) {
                        ValueAnimator.setDurationScale(f);
                    }
                }, inputMethodManager.getClient(), inputMethodManager.getInputContext());
                ValueAnimator.setDurationScale(iWindowManager.getCurrentAnimatorScale());
                return sWindowSession;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Failed to open window session", remoteException);
            }
            return sWindowSession;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IWindowSession peekWindowSession() {
        synchronized (WindowManagerGlobal.class) {
            return sWindowSession;
        }
    }

    private void removeViewLocked(int n, boolean bl) {
        InputMethodManager inputMethodManager;
        ViewRootImpl viewRootImpl = this.mRoots.get(n);
        View view = viewRootImpl.getView();
        if (view != null && (inputMethodManager = InputMethodManager.getInstance()) != null) {
            inputMethodManager.windowDismissed(this.mViews.get(n).getWindowToken());
        }
        boolean bl2 = viewRootImpl.die(bl);
        if (view != null) {
            view.assignParent(null);
            if (bl2) {
                this.mDyingViews.add(view);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean shouldDestroyEglContext(int n) {
        return n >= 80 || n >= 60 && !ActivityManager.isHighEndGfx() || n >= 60 && ActivityManager.isOneGigaByteDevice();
    }

    public static void trimForeground() {
        if (HardwareRenderer.sTrimForeground && HardwareRenderer.isAvailable()) {
            WindowManagerGlobal.getInstance().doTrimForeground();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addView(View view, ViewGroup.LayoutParams layoutParams, Display display, Window window) {
        ViewRootImpl viewRootImpl;
        View view2;
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
        if (window != null) {
            window.adjustLayoutParamsForSubWindow(layoutParams2);
        } else {
            Context context = view.getContext();
            if (context != null && context.getApplicationInfo().targetSdkVersion >= 21) {
                layoutParams2.flags = 0x1000000 | layoutParams2.flags;
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            int n;
            if (this.mSystemPropertyUpdater == null) {
                this.mSystemPropertyUpdater = new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        Object object = WindowManagerGlobal.this.mLock;
                        synchronized (object) {
                            int n = -1 + WindowManagerGlobal.this.mRoots.size();
                            while (n >= 0) {
                                ((ViewRootImpl)WindowManagerGlobal.this.mRoots.get(n)).loadSystemProperties();
                                --n;
                            }
                            return;
                        }
                    }
                };
                SystemProperties.addChangeCallback(this.mSystemPropertyUpdater);
            }
            if ((n = this.findViewLocked(view, false)) >= 0) {
                if (!this.mDyingViews.contains(view)) {
                    throw new IllegalStateException("View " + view + " has already been added to the window manager.");
                }
                this.mRoots.get(n).doDie();
            }
            int n2 = layoutParams2.type;
            view2 = null;
            if (n2 >= 1000) {
                int n3 = layoutParams2.type;
                view2 = null;
                if (n3 <= 1999) {
                    int n4 = this.mViews.size();
                    for (int i = 0; i < n4; ++i) {
                        if (this.mRoots.get((int)i).mWindow.asBinder() != layoutParams2.token) continue;
                        view2 = this.mViews.get(i);
                    }
                }
            }
            viewRootImpl = new ViewRootImpl(view.getContext(), display);
            view.setLayoutParams(layoutParams2);
            this.mViews.add(view);
            this.mRoots.add(viewRootImpl);
            this.mParams.add(layoutParams2);
        }
        try {
            viewRootImpl.setView(view, layoutParams2, view2);
            return;
        }
        catch (RuntimeException runtimeException) {
            Object object2 = this.mLock;
            synchronized (object2) {
                int n = this.findViewLocked(view, false);
                if (n >= 0) {
                    this.removeViewLocked(n, true);
                }
                throw runtimeException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeCanvasOpacity(IBinder iBinder, boolean bl) {
        if (iBinder == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int n = -1 + this.mParams.size();
            while (n >= 0) {
                if (this.mParams.get((int)n).token == iBinder) {
                    this.mRoots.get(n).changeCanvasOpacity(bl);
                    return;
                }
                --n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeAll(IBinder iBinder, String string2, String string3) {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mViews.size();
            int n2 = 0;
            while (n2 < n) {
                if (iBinder == null || this.mParams.get((int)n2).token == iBinder) {
                    ViewRootImpl viewRootImpl = this.mRoots.get(n2);
                    if (string2 != null) {
                        WindowLeaked windowLeaked = new WindowLeaked(string3 + " " + string2 + " has leaked window " + viewRootImpl.getView() + " that was originally added here");
                        windowLeaked.setStackTrace(viewRootImpl.getLocation().getStackTrace());
                        Log.e(TAG, "", windowLeaked);
                    }
                    this.removeViewLocked(n2, false);
                }
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void doRemoveView(ViewRootImpl viewRootImpl) {
        Object object = this.mLock;
        // MONITORENTER : object
        int n = this.mRoots.indexOf(viewRootImpl);
        if (n >= 0) {
            this.mRoots.remove(n);
            this.mParams.remove(n);
            View view = this.mViews.remove(n);
            this.mDyingViews.remove(view);
        }
        // MONITOREXIT : object
        if (!HardwareRenderer.sTrimForeground) return;
        if (!HardwareRenderer.isAvailable()) return;
        this.doTrimForeground();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpGfxInfo(FileDescriptor fileDescriptor) {
        int n;
        int n2;
        FastPrintWriter fastPrintWriter = new FastPrintWriter(new FileOutputStream(fileDescriptor));
        try {
            Object object = this.mLock;
            synchronized (object) {
                n2 = this.mViews.size();
                fastPrintWriter.println("Profile data in ms:");
                n = 0;
            }
        }
        catch (Throwable throwable) {
            ((PrintWriter)fastPrintWriter).flush();
            throw throwable;
        }
        {
            while (true) {
                if (n < n2) {
                    ViewRootImpl viewRootImpl = this.mRoots.get(n);
                    String string2 = WindowManagerGlobal.getWindowName(viewRootImpl);
                    Object[] objectArray = new Object[]{string2, viewRootImpl.getHostVisibility()};
                    fastPrintWriter.printf("\n\t%s (visibility=%d)", objectArray);
                    HardwareRenderer hardwareRenderer = viewRootImpl.getView().mAttachInfo.mHardwareRenderer;
                    if (hardwareRenderer != null) {
                        hardwareRenderer.dumpGfxInfo(fastPrintWriter, fileDescriptor);
                    }
                } else {
                    fastPrintWriter.println("\nView hierarchy:\n");
                    int n3 = 0;
                    int n4 = 0;
                    int[] nArray = new int[2];
                    int n5 = 0;
                    while (true) {
                        if (n5 >= n2) {
                            Object[] objectArray = new Object[]{n2};
                            fastPrintWriter.printf("\nTotal ViewRootImpl: %d\n", objectArray);
                            Object[] objectArray2 = new Object[]{n3};
                            fastPrintWriter.printf("Total Views:        %d\n", objectArray2);
                            Object[] objectArray3 = new Object[]{Float.valueOf((float)n4 / 1024.0f)};
                            fastPrintWriter.printf("Total DisplayList:  %.2f kB\n\n", objectArray3);
                            // MONITOREXIT @DISABLED, blocks:[5, 7, 8, 9, 11] lbl40 : MonitorExitStatement: MONITOREXIT : var4_3
                            ((PrintWriter)fastPrintWriter).flush();
                            return;
                        }
                        ViewRootImpl viewRootImpl = this.mRoots.get(n5);
                        viewRootImpl.dumpGfxInfo(nArray);
                        String string3 = WindowManagerGlobal.getWindowName(viewRootImpl);
                        Object[] objectArray = new Object[]{string3, nArray[0], Float.valueOf((float)nArray[1] / 1024.0f)};
                        fastPrintWriter.printf("  %s\n  %d views, %.2f kB of display lists", objectArray);
                        fastPrintWriter.printf("\n\n", new Object[0]);
                        n3 += nArray[0];
                        n4 += nArray[1];
                        ++n5;
                    }
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public View getRootView(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            int n = -1 + this.mRoots.size();
            while (n >= 0) {
                ViewRootImpl viewRootImpl = this.mRoots.get(n);
                if (string2.equals(WindowManagerGlobal.getWindowName(viewRootImpl))) {
                    return viewRootImpl.getView();
                }
                --n;
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getViewRootNames() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mRoots.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = WindowManagerGlobal.getWindowName(this.mRoots.get(n2));
                ++n2;
            }
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeView(View view, boolean bl) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int n = this.findViewLocked(view, true);
            View view2 = this.mRoots.get(n).getView();
            this.removeViewLocked(n, bl);
            if (view2 == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewAncestor is attached to " + view2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reportNewConfiguration(Configuration configuration) {
        Object object = this.mLock;
        synchronized (object) {
            Throwable throwable2;
            block7: {
                int n = this.mViews.size();
                Configuration configuration2 = new Configuration(configuration);
                for (int i = 0; i < n; ++i) {
                    try {
                        this.mRoots.get(i).requestUpdateConfiguration(configuration2);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        break block7;
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStoppedState(IBinder iBinder, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mViews.size();
            int n2 = 0;
            while (n2 < n) {
                if (iBinder == null || this.mParams.get((int)n2).token == iBinder) {
                    this.mRoots.get(n2).setStopped(bl);
                }
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void trimMemory(int n) {
        if (HardwareRenderer.isAvailable()) {
            if (WindowManagerGlobal.shouldDestroyEglContext(n)) {
                Object object = this.mLock;
                synchronized (object) {
                    for (int i = -1 + this.mRoots.size(); i >= 0; --i) {
                        this.mRoots.get(i).destroyHardwareResources();
                    }
                }
                n = 80;
            }
            HardwareRenderer.trimMemory(n);
            if (HardwareRenderer.sTrimForeground) {
                this.doTrimForeground();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
        view.setLayoutParams(layoutParams2);
        Object object = this.mLock;
        synchronized (object) {
            int n = this.findViewLocked(view, true);
            ViewRootImpl viewRootImpl = this.mRoots.get(n);
            this.mParams.remove(n);
            this.mParams.add(n, layoutParams2);
            viewRootImpl.setLayoutParams(layoutParams2, false);
            return;
        }
    }
}

