/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class AccessibilityManager {
    public static final int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    public static final int DALTONIZER_DISABLED = -1;
    public static final int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManager";
    public static final int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static final int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static final int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    private static AccessibilityManager sInstance;
    static final Object sInstanceSync;
    private final CopyOnWriteArrayList<AccessibilityStateChangeListener> mAccessibilityStateChangeListeners;
    private final IAccessibilityManagerClient.Stub mClient;
    final Handler mHandler;
    private final CopyOnWriteArrayList<HighTextContrastChangeListener> mHighTextContrastStateChangeListeners;
    boolean mIsEnabled;
    boolean mIsHighTextContrastEnabled;
    boolean mIsTouchExplorationEnabled;
    private final Object mLock = new Object();
    private IAccessibilityManager mService;
    private final CopyOnWriteArrayList<TouchExplorationStateChangeListener> mTouchExplorationStateChangeListeners;
    final int mUserId;

    static {
        sInstanceSync = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityManager(Context context, IAccessibilityManager iAccessibilityManager, int n) {
        this.mAccessibilityStateChangeListeners = new CopyOnWriteArrayList();
        this.mTouchExplorationStateChangeListeners = new CopyOnWriteArrayList();
        this.mHighTextContrastStateChangeListeners = new CopyOnWriteArrayList();
        this.mClient = new IAccessibilityManagerClient.Stub(){

            @Override
            public void setState(int n) {
                AccessibilityManager.this.mHandler.obtainMessage(4, n, 0).sendToTarget();
            }
        };
        this.mHandler = new MyHandler(context.getMainLooper());
        this.mService = iAccessibilityManager;
        this.mUserId = n;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int n = Binder.getCallingUid() != 1000 && context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") != 0 && context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0 ? UserHandle.myUserId() : -2;
                IBinder iBinder = ServiceManager.getService("accessibility");
                IAccessibilityManager iAccessibilityManager = iBinder == null ? null : IAccessibilityManager.Stub.asInterface(iBinder);
                sInstance = new AccessibilityManager(context, iAccessibilityManager, n);
            }
            return sInstance;
        }
    }

    private IAccessibilityManager getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked();
        }
        return this.mService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNotifyAccessibilityStateChanged() {
        boolean bl;
        Object object = this.mLock;
        synchronized (object) {
            bl = this.mIsEnabled;
        }
        Iterator<AccessibilityStateChangeListener> iterator = this.mAccessibilityStateChangeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAccessibilityStateChanged(bl);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNotifyHighTextContrastStateChanged() {
        boolean bl;
        Object object = this.mLock;
        synchronized (object) {
            bl = this.mIsHighTextContrastEnabled;
        }
        Iterator<HighTextContrastChangeListener> iterator = this.mHighTextContrastStateChangeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onHighTextContrastStateChanged(bl);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNotifyTouchExplorationStateChanged() {
        boolean bl;
        Object object = this.mLock;
        synchronized (object) {
            bl = this.mIsTouchExplorationEnabled;
        }
        Iterator<TouchExplorationStateChangeListener> iterator = this.mTouchExplorationStateChangeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onTouchExplorationStateChanged(bl);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setStateLocked(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        int n2 = n & 4;
        boolean bl3 = false;
        if (n2 != 0) {
            bl3 = true;
        }
        boolean bl4 = this.mIsEnabled;
        boolean bl5 = this.mIsTouchExplorationEnabled;
        boolean bl6 = this.mIsHighTextContrastEnabled;
        this.mIsEnabled = bl;
        this.mIsTouchExplorationEnabled = bl2;
        this.mIsHighTextContrastEnabled = bl3;
        if (bl4 != bl) {
            this.mHandler.sendEmptyMessage(1);
        }
        if (bl5 != bl2) {
            this.mHandler.sendEmptyMessage(2);
        }
        if (bl6 != bl3) {
            this.mHandler.sendEmptyMessage(3);
        }
    }

    private void tryConnectToServiceLocked() {
        IBinder iBinder = ServiceManager.getService("accessibility");
        if (iBinder == null) {
            return;
        }
        IAccessibilityManager iAccessibilityManager = IAccessibilityManager.Stub.asInterface(iBinder);
        try {
            this.setStateLocked(iAccessibilityManager.addClient(this.mClient, this.mUserId));
            this.mService = iAccessibilityManager;
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addAccessibilityInteractionConnection(IWindow iWindow, IAccessibilityInteractionConnection iAccessibilityInteractionConnection) {
        int n;
        IAccessibilityManager iAccessibilityManager;
        Object object = this.mLock;
        synchronized (object) {
            iAccessibilityManager = this.getServiceLocked();
            if (iAccessibilityManager == null) {
                return -1;
            }
            n = this.mUserId;
        }
        try {
            return iAccessibilityManager.addAccessibilityInteractionConnection(iWindow, iAccessibilityInteractionConnection, n);
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while adding an accessibility interaction connection. ", remoteException);
            return -1;
        }
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener) {
        return this.mAccessibilityStateChangeListeners.add(accessibilityStateChangeListener);
    }

    public boolean addHighTextContrastStateChangeListener(HighTextContrastChangeListener highTextContrastChangeListener) {
        return this.mHighTextContrastStateChangeListeners.add(highTextContrastChangeListener);
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener) {
        return this.mTouchExplorationStateChangeListeners.add(touchExplorationStateChangeListener);
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> list = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get((int)i).getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public IAccessibilityManagerClient getClient() {
        return this.mClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int n) {
        List<AccessibilityServiceInfo> list;
        int n2;
        IAccessibilityManager iAccessibilityManager;
        Object object = this.mLock;
        synchronized (object) {
            iAccessibilityManager = this.getServiceLocked();
            if (iAccessibilityManager == null) {
                return Collections.emptyList();
            }
            n2 = this.mUserId;
        }
        try {
            List<AccessibilityServiceInfo> list2;
            list = list2 = iAccessibilityManager.getEnabledAccessibilityServiceList(n, n2);
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", remoteException);
            list = null;
        }
        if (list == null) return Collections.emptyList();
        return Collections.unmodifiableList(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        List<AccessibilityServiceInfo> list;
        int n;
        IAccessibilityManager iAccessibilityManager;
        Object object = this.mLock;
        synchronized (object) {
            iAccessibilityManager = this.getServiceLocked();
            if (iAccessibilityManager == null) {
                return Collections.emptyList();
            }
            n = this.mUserId;
        }
        try {
            List<AccessibilityServiceInfo> list2;
            list = list2 = iAccessibilityManager.getInstalledAccessibilityServiceList(n);
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", remoteException);
            list = null;
        }
        if (list == null) return Collections.emptyList();
        return Collections.unmodifiableList(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interrupt() {
        int n;
        IAccessibilityManager iAccessibilityManager;
        Object object = this.mLock;
        synchronized (object) {
            iAccessibilityManager = this.getServiceLocked();
            if (iAccessibilityManager == null) {
                return;
            }
            if (!this.mIsEnabled) {
                throw new IllegalStateException("Accessibility off. Did you forget to check that?");
            }
            n = this.mUserId;
        }
        try {
            iAccessibilityManager.interrupt(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.getServiceLocked() != null) return this.mIsEnabled;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHighTextContrastEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.getServiceLocked() != null) return this.mIsHighTextContrastEnabled;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.getServiceLocked() != null) return this.mIsTouchExplorationEnabled;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAccessibilityInteractionConnection(IWindow iWindow) {
        IAccessibilityManager iAccessibilityManager;
        Object object = this.mLock;
        synchronized (object) {
            iAccessibilityManager = this.getServiceLocked();
            if (iAccessibilityManager == null) {
                return;
            }
        }
        try {
            iAccessibilityManager.removeAccessibilityInteractionConnection(iWindow);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while removing an accessibility interaction connection. ", remoteException);
            return;
        }
    }

    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener) {
        return this.mAccessibilityStateChangeListeners.remove(accessibilityStateChangeListener);
    }

    public boolean removeHighTextContrastStateChangeListener(HighTextContrastChangeListener highTextContrastChangeListener) {
        return this.mHighTextContrastStateChangeListeners.remove(highTextContrastChangeListener);
    }

    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener) {
        return this.mTouchExplorationStateChangeListeners.remove(touchExplorationStateChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        int n;
        IAccessibilityManager iAccessibilityManager;
        Object object = this.mLock;
        synchronized (object) {
            iAccessibilityManager = this.getServiceLocked();
            if (iAccessibilityManager == null) {
                return;
            }
            if (!this.mIsEnabled) {
                throw new IllegalStateException("Accessibility off. Did you forget to check that?");
            }
            n = this.mUserId;
        }
        boolean bl = false;
        try {
            accessibilityEvent.setEventTime(SystemClock.uptimeMillis());
            long l = Binder.clearCallingIdentity();
            bl = iAccessibilityManager.sendAccessibilityEvent(accessibilityEvent, n);
            Binder.restoreCallingIdentity(l);
            if (!bl) return;
            accessibilityEvent.recycle();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error during sending " + accessibilityEvent + " ", remoteException);
            return;
        }
        finally {
            if (!bl) return;
            accessibilityEvent.recycle();
        }
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }

    public static interface HighTextContrastChangeListener {
        public void onHighTextContrastStateChanged(boolean var1);
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_NOTIFY_ACCESSIBILITY_STATE_CHANGED = 1;
        public static final int MSG_NOTIFY_EXPLORATION_STATE_CHANGED = 2;
        public static final int MSG_NOTIFY_HIGH_TEXT_CONTRAST_STATE_CHANGED = 3;
        public static final int MSG_SET_STATE = 4;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    AccessibilityManager.this.handleNotifyAccessibilityStateChanged();
                    return;
                }
                case 2: {
                    AccessibilityManager.this.handleNotifyTouchExplorationStateChanged();
                    return;
                }
                case 3: {
                    AccessibilityManager.this.handleNotifyHighTextContrastStateChanged();
                    return;
                }
                case 4: 
            }
            int n = message.arg1;
            Object object = AccessibilityManager.this.mLock;
            synchronized (object) {
                AccessibilityManager.this.setStateLocked(n);
                return;
            }
        }
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }
}

