/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.PathParser;
import android.view.InflateException;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class PathInterpolator
implements Interpolator {
    private static final float PRECISION = 0.002f;
    private float[] mX;
    private float[] mY;

    public PathInterpolator(float f, float f2) {
        this.initQuad(f, f2);
    }

    public PathInterpolator(float f, float f2, float f3, float f4) {
        this.initCubic(f, f2, f3, f4);
    }

    public PathInterpolator(Context context, AttributeSet attributeSet) {
        this(context.getResources(), context.getTheme(), attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PathInterpolator(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.PathInterpolator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.PathInterpolator);
        this.parseInterpolatorFromTypeArray(typedArray);
        typedArray.recycle();
    }

    public PathInterpolator(Path path) {
        this.initPath(path);
    }

    private void initCubic(float f, float f2, float f3, float f4) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.cubicTo(f, f2, f3, f4, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initPath(Path path) {
        float[] fArray = path.approximate(0.002f);
        int n = fArray.length / 3;
        if (fArray[1] != 0.0f || fArray[2] != 0.0f || fArray[-2 + fArray.length] != 1.0f || fArray[-1 + fArray.length] != 1.0f) {
            throw new IllegalArgumentException("The Path must start at (0,0) and end at (1,1)");
        }
        this.mX = new float[n];
        this.mY = new float[n];
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + 1;
            float f3 = fArray[n2];
            int n4 = n3 + 1;
            float f4 = fArray[n3];
            int n5 = n4 + 1;
            float f5 = fArray[n4];
            if (f3 == f2 && f4 != f) {
                throw new IllegalArgumentException("The Path cannot have discontinuity in the X axis.");
            }
            if (f4 < f) {
                throw new IllegalArgumentException("The Path cannot loop back on itself.");
            }
            this.mX[i] = f4;
            this.mY[i] = f5;
            f = f4;
            f2 = f3;
            n2 = n5;
        }
    }

    private void initQuad(float f, float f2) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(f, f2, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void parseInterpolatorFromTypeArray(TypedArray typedArray) {
        if (typedArray.hasValue(4)) {
            String string2 = typedArray.getString(4);
            Path path = PathParser.createPathFromPathData(string2);
            if (path == null) {
                throw new InflateException("The path is null, which is created from " + string2);
            }
            this.initPath(path);
            return;
        }
        if (!typedArray.hasValue(0)) {
            throw new InflateException("pathInterpolator requires the controlX1 attribute");
        }
        if (!typedArray.hasValue(1)) {
            throw new InflateException("pathInterpolator requires the controlY1 attribute");
        }
        float f = typedArray.getFloat(0, 0.0f);
        float f2 = typedArray.getFloat(1, 0.0f);
        boolean bl = typedArray.hasValue(2);
        if (bl != typedArray.hasValue(3)) {
            throw new InflateException("pathInterpolator requires both controlX2 and controlY2 for cubic Beziers.");
        }
        if (!bl) {
            this.initQuad(f, f2);
            return;
        }
        this.initCubic(f, f2, typedArray.getFloat(2, 0.0f), typedArray.getFloat(3, 0.0f));
    }

    @Override
    public float getInterpolation(float f) {
        if (f <= 0.0f) {
            return 0.0f;
        }
        if (f >= 1.0f) {
            return 1.0f;
        }
        int n = 0;
        int n2 = -1 + this.mX.length;
        while (n2 - n > 1) {
            int n3 = (n + n2) / 2;
            if (f < this.mX[n3]) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        float f2 = this.mX[n2] - this.mX[n];
        if (f2 == 0.0f) {
            return this.mY[n];
        }
        float f3 = (f - this.mX[n]) / f2;
        float f4 = this.mY[n];
        return f4 + f3 * (this.mY[n2] - f4);
    }
}

