/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class ScaleAnimation
extends Animation {
    private float mFromX;
    private int mFromXData = 0;
    private int mFromXType = 0;
    private float mFromY;
    private int mFromYData = 0;
    private int mFromYType = 0;
    private float mPivotX;
    private int mPivotXType = 0;
    private float mPivotXValue = 0.0f;
    private float mPivotY;
    private int mPivotYType = 0;
    private float mPivotYValue = 0.0f;
    private final Resources mResources;
    private float mToX;
    private int mToXData = 0;
    private int mToXType = 0;
    private float mToY;
    private int mToYData = 0;
    private int mToYType = 0;

    public ScaleAnimation(float f, float f2, float f3, float f4) {
        this.mResources = null;
        this.mFromX = f;
        this.mToX = f2;
        this.mFromY = f3;
        this.mToY = f4;
        this.mPivotX = 0.0f;
        this.mPivotY = 0.0f;
    }

    public ScaleAnimation(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mResources = null;
        this.mFromX = f;
        this.mToX = f2;
        this.mFromY = f3;
        this.mToY = f4;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = f5;
        this.mPivotYValue = f6;
        this.initializePivotPoint();
    }

    public ScaleAnimation(float f, float f2, float f3, float f4, int n, float f5, int n2, float f6) {
        this.mResources = null;
        this.mFromX = f;
        this.mToX = f2;
        this.mFromY = f3;
        this.mToY = f4;
        this.mPivotXValue = f5;
        this.mPivotXType = n;
        this.mPivotYValue = f6;
        this.mPivotYType = n2;
        this.initializePivotPoint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ScaleAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mResources = context.getResources();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ScaleAnimation);
        TypedValue typedValue = typedArray.peekValue(2);
        this.mFromX = 0.0f;
        if (typedValue != null) {
            if (typedValue.type == 4) {
                this.mFromX = typedValue.getFloat();
            } else {
                this.mFromXType = typedValue.type;
                this.mFromXData = typedValue.data;
            }
        }
        TypedValue typedValue2 = typedArray.peekValue(3);
        this.mToX = 0.0f;
        if (typedValue2 != null) {
            if (typedValue2.type == 4) {
                this.mToX = typedValue2.getFloat();
            } else {
                this.mToXType = typedValue2.type;
                this.mToXData = typedValue2.data;
            }
        }
        TypedValue typedValue3 = typedArray.peekValue(4);
        this.mFromY = 0.0f;
        if (typedValue3 != null) {
            if (typedValue3.type == 4) {
                this.mFromY = typedValue3.getFloat();
            } else {
                this.mFromYType = typedValue3.type;
                this.mFromYData = typedValue3.data;
            }
        }
        TypedValue typedValue4 = typedArray.peekValue(5);
        this.mToY = 0.0f;
        if (typedValue4 != null) {
            if (typedValue4.type == 4) {
                this.mToY = typedValue4.getFloat();
            } else {
                this.mToYType = typedValue4.type;
                this.mToYData = typedValue4.data;
            }
        }
        Animation.Description description = Animation.Description.parseValue(typedArray.peekValue(0));
        this.mPivotXType = description.type;
        this.mPivotXValue = description.value;
        Animation.Description description2 = Animation.Description.parseValue(typedArray.peekValue(1));
        this.mPivotYType = description2.type;
        this.mPivotYValue = description2.value;
        typedArray.recycle();
        this.initializePivotPoint();
    }

    private void initializePivotPoint() {
        if (this.mPivotXType == 0) {
            this.mPivotX = this.mPivotXValue;
        }
        if (this.mPivotYType == 0) {
            this.mPivotY = this.mPivotYValue;
        }
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = this.getScaleFactor();
        if (this.mFromX != 1.0f || this.mToX != 1.0f) {
            f2 = this.mFromX + f * (this.mToX - this.mFromX);
        }
        if (this.mFromY != 1.0f || this.mToY != 1.0f) {
            f3 = this.mFromY + f * (this.mToY - this.mFromY);
        }
        if (this.mPivotX == 0.0f && this.mPivotY == 0.0f) {
            transformation.getMatrix().setScale(f2, f3);
            return;
        }
        transformation.getMatrix().setScale(f2, f3, f4 * this.mPivotX, f4 * this.mPivotY);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        super.initialize(n, n2, n3, n4);
        this.mFromX = this.resolveScale(this.mFromX, this.mFromXType, this.mFromXData, n, n3);
        this.mToX = this.resolveScale(this.mToX, this.mToXType, this.mToXData, n, n3);
        this.mFromY = this.resolveScale(this.mFromY, this.mFromYType, this.mFromYData, n2, n4);
        this.mToY = this.resolveScale(this.mToY, this.mToYType, this.mToYData, n2, n4);
        this.mPivotX = this.resolveSize(this.mPivotXType, this.mPivotXValue, n, n3);
        this.mPivotY = this.resolveSize(this.mPivotYType, this.mPivotYValue, n2, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    float resolveScale(float f, int n, int n2, int n3, int n4) {
        float f2;
        if (n == 6) {
            f2 = TypedValue.complexToFraction(n2, n3, n4);
        } else {
            if (n != 5) return f;
            f2 = TypedValue.complexToDimension(n2, this.mResources.getDisplayMetrics());
        }
        if (n3 == 0) return 1.0f;
        return f2 / (float)n3;
    }
}

