/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Trace;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.RemotableViewMethod;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.GridLayoutAnimationController;
import android.widget.AbsListView;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class GridView
extends AbsListView {
    public static final int AUTO_FIT = -1;
    public static final int NO_STRETCH = 0;
    public static final int STRETCH_COLUMN_WIDTH = 2;
    public static final int STRETCH_SPACING = 1;
    public static final int STRETCH_SPACING_UNIFORM = 3;
    private int mColumnWidth;
    private int mGravity = 0x800003;
    private int mHorizontalSpacing = 0;
    private int mNumColumns = -1;
    private View mReferenceView = null;
    private View mReferenceViewInSelectedRow = null;
    private int mRequestedColumnWidth;
    private int mRequestedHorizontalSpacing;
    private int mRequestedNumColumns;
    private int mStretchMode = 2;
    private final Rect mTempRect = new Rect();
    private int mVerticalSpacing = 0;

    public GridView(Context context) {
        this(context, null);
    }

    public GridView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010071);
    }

    public GridView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public GridView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        int n3;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridView, n, n2);
        this.setHorizontalSpacing(typedArray.getDimensionPixelOffset(1, 0));
        this.setVerticalSpacing(typedArray.getDimensionPixelOffset(2, 0));
        int n4 = typedArray.getInt(3, 2);
        if (n4 >= 0) {
            this.setStretchMode(n4);
        }
        if ((n3 = typedArray.getDimensionPixelOffset(4, -1)) > 0) {
            this.setColumnWidth(n3);
        }
        this.setNumColumns(typedArray.getInt(5, 1));
        int n5 = typedArray.getInt(0, -1);
        if (n5 >= 0) {
            this.setGravity(n5);
        }
        typedArray.recycle();
    }

    private void adjustForBottomFadingEdge(View view, int n, int n2) {
        if (view.getBottom() > n2) {
            this.offsetChildrenTopAndBottom(-Math.min(view.getTop() - n, view.getBottom() - n2));
        }
    }

    private void adjustForTopFadingEdge(View view, int n, int n2) {
        if (view.getTop() < n) {
            this.offsetChildrenTopAndBottom(Math.min(n - view.getTop(), n2 - view.getBottom()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustViewsUpOrDown() {
        int n;
        int n2 = this.getChildCount();
        if (n2 <= 0) return;
        if (!this.mStackFromBottom) {
            n = this.getChildAt(0).getTop() - this.mListPadding.top;
            if (this.mFirstPosition != 0) {
                n -= this.mVerticalSpacing;
            }
            if (n < 0) {
                return;
            }
        } else {
            n = this.getChildAt(n2 - 1).getBottom() - (this.getHeight() - this.mListPadding.bottom);
            if (n2 + this.mFirstPosition < this.mItemCount) {
                n += this.mVerticalSpacing;
            }
            if (n > 0) {
                return;
            }
        }
        if (n == 0) return;
        this.offsetChildrenTopAndBottom(-n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean commonKey(int n, int n2, KeyEvent keyEvent) {
        if (this.mAdapter == null) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        int n3 = keyEvent.getAction();
        boolean bl = false;
        if (n3 != 1) {
            bl = false;
            switch (n) {
                case 21: {
                    boolean bl2 = keyEvent.hasNoModifiers();
                    bl = false;
                    if (!bl2) break;
                    if (this.resurrectSelectionIfNeeded() || this.arrowScroll(17)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 22: {
                    boolean bl3 = keyEvent.hasNoModifiers();
                    bl = false;
                    if (!bl3) break;
                    if (this.resurrectSelectionIfNeeded() || this.arrowScroll(66)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 19: {
                    if (keyEvent.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.arrowScroll(33)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    boolean bl4 = keyEvent.hasModifiers(2);
                    bl = false;
                    if (!bl4) break;
                    if (this.resurrectSelectionIfNeeded() || this.fullScroll(33)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 20: {
                    if (keyEvent.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.arrowScroll(130)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    boolean bl5 = keyEvent.hasModifiers(2);
                    bl = false;
                    if (!bl5) break;
                    if (this.resurrectSelectionIfNeeded() || this.fullScroll(130)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 23: 
                case 66: {
                    boolean bl6 = keyEvent.hasNoModifiers();
                    bl = false;
                    if (!bl6 || (bl = this.resurrectSelectionIfNeeded()) || keyEvent.getRepeatCount() != 0 || this.getChildCount() <= 0) break;
                    this.keyPressed();
                    bl = true;
                    break;
                }
                case 62: {
                    if (this.mPopup != null) {
                        boolean bl7 = this.mPopup.isShowing();
                        bl = false;
                        if (bl7) break;
                    }
                    if (keyEvent.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.pageScroll(130)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    boolean bl8 = keyEvent.hasModifiers(1);
                    bl = false;
                    if (!bl8) break;
                    if (this.resurrectSelectionIfNeeded() || this.pageScroll(33)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 92: {
                    if (keyEvent.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.pageScroll(33)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    boolean bl9 = keyEvent.hasModifiers(2);
                    bl = false;
                    if (!bl9) break;
                    if (this.resurrectSelectionIfNeeded() || this.fullScroll(33)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 93: {
                    if (keyEvent.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.pageScroll(130)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    boolean bl10 = keyEvent.hasModifiers(2);
                    bl = false;
                    if (!bl10) break;
                    if (this.resurrectSelectionIfNeeded() || this.fullScroll(130)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 122: {
                    boolean bl11 = keyEvent.hasNoModifiers();
                    bl = false;
                    if (!bl11) break;
                    if (this.resurrectSelectionIfNeeded() || this.fullScroll(33)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 123: {
                    boolean bl12 = keyEvent.hasNoModifiers();
                    bl = false;
                    if (!bl12) break;
                    bl = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                }
            }
        }
        if (bl) {
            return true;
        }
        if (this.sendToTextFilter(n, n2, keyEvent)) {
            return true;
        }
        switch (n3) {
            default: {
                return false;
            }
            case 0: {
                return super.onKeyDown(n, keyEvent);
            }
            case 1: {
                return super.onKeyUp(n, keyEvent);
            }
            case 2: 
        }
        return super.onKeyMultiple(n, n2, keyEvent);
    }

    private void correctTooHigh(int n, int n2, int n3) {
        if (-1 + (n3 + this.mFirstPosition) == -1 + this.mItemCount && n3 > 0) {
            int n4 = this.getChildAt(n3 - 1).getBottom();
            int n5 = this.mBottom - this.mTop - this.mListPadding.bottom - n4;
            View view = this.getChildAt(0);
            int n6 = view.getTop();
            if (n5 > 0 && (this.mFirstPosition > 0 || n6 < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    n5 = Math.min(n5, this.mListPadding.top - n6);
                }
                this.offsetChildrenTopAndBottom(n5);
                if (this.mFirstPosition > 0) {
                    int n7 = this.mFirstPosition;
                    if (this.mStackFromBottom) {
                        n = 1;
                    }
                    this.fillUp(n7 - n, view.getTop() - n2);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private void correctTooLow(int n, int n2, int n3) {
        if (this.mFirstPosition == 0 && n3 > 0) {
            int n4 = this.getChildAt(0).getTop();
            int n5 = this.mListPadding.top;
            int n6 = this.mBottom - this.mTop - this.mListPadding.bottom;
            int n7 = n4 - n5;
            View view = this.getChildAt(n3 - 1);
            int n8 = view.getBottom();
            int n9 = -1 + (n3 + this.mFirstPosition);
            if (n7 > 0 && (n9 < -1 + this.mItemCount || n8 > n6)) {
                if (n9 == -1 + this.mItemCount) {
                    n7 = Math.min(n7, n8 - n6);
                }
                this.offsetChildrenTopAndBottom(-n7);
                if (n9 < -1 + this.mItemCount) {
                    if (!this.mStackFromBottom) {
                        n = 1;
                    }
                    this.fillDown(n9 + n, n2 + view.getBottom());
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean determineColumns(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private View fillDown(int n, int n2) {
        int n3 = this.mBottom - this.mTop;
        int n4 = 0x22 & this.mGroupFlags;
        View view = null;
        if (n4 == 34) {
            n3 -= this.mListPadding.bottom;
        }
        while (n2 < n3 && n < this.mItemCount) {
            View view2 = this.makeRow(n, n2, true);
            if (view2 != null) {
                view = view2;
            }
            n2 = this.mReferenceView.getBottom() + this.mVerticalSpacing;
            n += this.mNumColumns;
        }
        this.setVisibleRangeHint(this.mFirstPosition, -1 + (this.mFirstPosition + this.getChildCount()));
        return view;
    }

    private View fillFromBottom(int n, int n2) {
        int n3 = Math.min(Math.max(n, this.mSelectedPosition), -1 + this.mItemCount);
        int n4 = -1 + this.mItemCount - n3;
        return this.fillUp(-1 + this.mItemCount - (n4 - n4 % this.mNumColumns), n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillFromSelection(int n, int n2, int n3) {
        int n4;
        int n5 = this.getVerticalFadingEdgeLength();
        int n6 = this.mSelectedPosition;
        int n7 = this.mNumColumns;
        int n8 = this.mVerticalSpacing;
        int n9 = -1;
        if (!this.mStackFromBottom) {
            n4 = n6 - n6 % n7;
        } else {
            int n10 = -1 + this.mItemCount - n6;
            n9 = -1 + this.mItemCount - (n10 - n10 % n7);
            n4 = Math.max(0, 1 + (n9 - n7));
        }
        int n11 = this.getTopSelectionPixel(n2, n5, n4);
        int n12 = this.getBottomSelectionPixel(n3, n5, n7, n4);
        int n13 = this.mStackFromBottom ? n9 : n4;
        View view = this.makeRow(n13, n, true);
        this.mFirstPosition = n4;
        View view2 = this.mReferenceView;
        this.adjustForTopFadingEdge(view2, n11, n12);
        this.adjustForBottomFadingEdge(view2, n11, n12);
        if (!this.mStackFromBottom) {
            this.fillUp(n4 - n7, view2.getTop() - n8);
            this.adjustViewsUpOrDown();
            this.fillDown(n4 + n7, n8 + view2.getBottom());
            return view;
        }
        this.fillDown(n9 + n7, n8 + view2.getBottom());
        this.adjustViewsUpOrDown();
        this.fillUp(n4 - 1, view2.getTop() - n8);
        return view;
    }

    private View fillFromTop(int n) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, -1 + this.mItemCount);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        this.mFirstPosition -= this.mFirstPosition % this.mNumColumns;
        return this.fillDown(this.mFirstPosition, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillSelection(int n, int n2) {
        int n3;
        int n4 = this.reconcileSelectedPosition();
        int n5 = this.mNumColumns;
        int n6 = this.mVerticalSpacing;
        int n7 = -1;
        if (!this.mStackFromBottom) {
            n3 = n4 - n4 % n5;
        } else {
            int n8 = -1 + this.mItemCount - n4;
            n7 = -1 + this.mItemCount - (n8 - n8 % n5);
            n3 = Math.max(0, 1 + (n7 - n5));
        }
        int n9 = this.getVerticalFadingEdgeLength();
        int n10 = this.getTopSelectionPixel(n, n9, n3);
        int n11 = this.mStackFromBottom ? n7 : n3;
        View view = this.makeRow(n11, n10, true);
        this.mFirstPosition = n3;
        View view2 = this.mReferenceView;
        if (!this.mStackFromBottom) {
            this.fillDown(n3 + n5, n6 + view2.getBottom());
            this.pinToBottom(n2);
            this.fillUp(n3 - n5, view2.getTop() - n6);
            this.adjustViewsUpOrDown();
            return view;
        }
        this.offsetChildrenTopAndBottom(this.getBottomSelectionPixel(n2, n9, n5, n3) - view2.getBottom());
        this.fillUp(n3 - 1, view2.getTop() - n6);
        this.pinToTop(n);
        this.fillDown(n7 + n5, n6 + view2.getBottom());
        this.adjustViewsUpOrDown();
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillSpecific(int n, int n2) {
        View view;
        View view2;
        int n3;
        int n4 = this.mNumColumns;
        int n5 = -1;
        if (!this.mStackFromBottom) {
            n3 = n - n % n4;
        } else {
            int n6 = -1 + this.mItemCount - n;
            n5 = -1 + this.mItemCount - (n6 - n6 % n4);
            n3 = Math.max(0, 1 + (n5 - n4));
        }
        int n7 = this.mStackFromBottom ? n5 : n3;
        View view3 = this.makeRow(n7, n2, true);
        this.mFirstPosition = n3;
        View view4 = this.mReferenceView;
        if (view4 == null) {
            return null;
        }
        int n8 = this.mVerticalSpacing;
        if (!this.mStackFromBottom) {
            view2 = this.fillUp(n3 - n4, view4.getTop() - n8);
            this.adjustViewsUpOrDown();
            view = this.fillDown(n3 + n4, n8 + view4.getBottom());
            int n9 = this.getChildCount();
            if (n9 > 0) {
                this.correctTooHigh(n4, n8, n9);
            }
        } else {
            view = this.fillDown(n5 + n4, n8 + view4.getBottom());
            this.adjustViewsUpOrDown();
            view2 = this.fillUp(n3 - 1, view4.getTop() - n8);
            int n10 = this.getChildCount();
            if (n10 > 0) {
                this.correctTooLow(n4, n8, n10);
            }
        }
        if (view3 != null) return view3;
        if (view2 == null) return view;
        return view2;
    }

    private View fillUp(int n, int n2) {
        int n3 = 0x22 & this.mGroupFlags;
        int n4 = 0;
        View view = null;
        if (n3 == 34) {
            n4 = this.mListPadding.top;
        }
        while (n2 > n4 && n >= 0) {
            View view2 = this.makeRow(n, n2, false);
            if (view2 != null) {
                view = view2;
            }
            n2 = this.mReferenceView.getTop() - this.mVerticalSpacing;
            this.mFirstPosition = n;
            n -= this.mNumColumns;
        }
        if (this.mStackFromBottom) {
            this.mFirstPosition = Math.max(0, n + 1);
        }
        this.setVisibleRangeHint(this.mFirstPosition, -1 + (this.mFirstPosition + this.getChildCount()));
        return view;
    }

    private int getBottomSelectionPixel(int n, int n2, int n3, int n4) {
        int n5 = n;
        if (-1 + (n4 + n3) < -1 + this.mItemCount) {
            n5 -= n2;
        }
        return n5;
    }

    private int getTopSelectionPixel(int n, int n2, int n3) {
        int n4 = n;
        if (n3 > 0) {
            n4 += n2;
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isCandidateSelection(int n, int n2) {
        block10: {
            int n3;
            int n4;
            int n5 = this.getChildCount();
            int n6 = n5 - 1 - n;
            if (!this.mStackFromBottom) {
                n4 = n - n % this.mNumColumns;
                n3 = Math.max(-1 + (n4 + this.mNumColumns), n5);
            } else {
                n3 = n5 - 1 - (n6 - n6 % this.mNumColumns);
                n4 = Math.max(0, 1 + (n3 - this.mNumColumns));
            }
            switch (n2) {
                default: {
                    throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
                }
                case 66: {
                    if (n == n4) break;
                    return false;
                }
                case 130: {
                    if (n4 == 0) break;
                    return false;
                }
                case 17: {
                    if (n == n3) break;
                    return false;
                }
                case 33: {
                    if (n3 == n5 - 1) break;
                    return false;
                }
                case 2: {
                    if (n == n4 && n4 == 0) break;
                    return false;
                }
                case 1: {
                    if (n != n3 || n3 != n5 - 1) break block10;
                }
            }
            return true;
        }
        return false;
    }

    private View makeAndAddView(int n, int n2, boolean bl, int n3, boolean bl2, int n4) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.getActiveView(n)) != null) {
            this.setupChild(view, n, n2, bl, n3, bl2, true, n4);
            return view;
        }
        View view2 = this.obtainView(n, this.mIsScrap);
        this.setupChild(view2, n, n2, bl, n3, bl2, this.mIsScrap[0], n4);
        return view2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View makeRow(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = this.mColumnWidth;
        int n6 = this.mHorizontalSpacing;
        boolean bl2 = this.isLayoutRtl();
        if (bl2) {
            int n7 = this.getWidth() - this.mListPadding.right - n5;
            int n8 = this.mStretchMode == 3 ? n6 : 0;
            n4 = n7 - n8;
        } else {
            int n9 = this.mListPadding.left;
            int n10 = this.mStretchMode == 3 ? n6 : 0;
            n4 = n9 + n10;
        }
        if (!this.mStackFromBottom) {
            n3 = Math.min(n + this.mNumColumns, this.mItemCount);
        } else {
            n3 = n + 1;
            if (n3 - (n = Math.max(0, 1 + (n - this.mNumColumns))) < this.mNumColumns) {
                int n11 = (this.mNumColumns - (n3 - n)) * (n5 + n6);
                int n12 = bl2 ? -1 : 1;
                n4 += n12 * n11;
            }
        }
        View view = null;
        boolean bl3 = this.shouldShowSelector();
        boolean bl4 = this.touchModeDrawsInPressedState();
        int n13 = this.mSelectedPosition;
        View view2 = null;
        int n14 = bl2 ? -1 : 1;
        for (int i = n; i < n3; ++i) {
            boolean bl5 = i == n13;
            int n15 = bl ? -1 : i - n;
            view2 = this.makeAndAddView(i, n2, bl, n4, bl5, n15);
            n4 += n14 * n5;
            if (i < n3 - 1) {
                n4 += n14 * n6;
            }
            if (!bl5 || !bl3 && !bl4) continue;
            view = view2;
        }
        this.mReferenceView = view2;
        if (view != null) {
            this.mReferenceViewInSelectedRow = this.mReferenceView;
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View moveSelection(int n, int n2, int n3) {
        View view;
        View view2;
        int n4;
        int n5;
        int n6 = this.getVerticalFadingEdgeLength();
        int n7 = this.mSelectedPosition;
        int n8 = this.mNumColumns;
        int n9 = this.mVerticalSpacing;
        int n10 = -1;
        if (!this.mStackFromBottom) {
            n5 = n7 - n - (n7 - n) % n8;
            n4 = n7 - n7 % n8;
        } else {
            int n11 = -1 + this.mItemCount - n7;
            n10 = -1 + this.mItemCount - (n11 - n11 % n8);
            n4 = Math.max(0, 1 + (n10 - n8));
            int n12 = -1 + this.mItemCount - (n7 - n);
            n5 = Math.max(0, 1 + (-1 + this.mItemCount - (n12 - n12 % n8) - n8));
        }
        int n13 = n4 - n5;
        int n14 = this.getTopSelectionPixel(n2, n6, n4);
        int n15 = this.getBottomSelectionPixel(n3, n6, n8, n4);
        this.mFirstPosition = n4;
        if (n13 > 0) {
            int n16 = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getBottom();
            int n17 = this.mStackFromBottom ? n10 : n4;
            int n18 = n16 + n9;
            view2 = this.makeRow(n17, n18, true);
            view = this.mReferenceView;
            this.adjustForBottomFadingEdge(view, n14, n15);
        } else if (n13 < 0) {
            int n19 = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            int n20 = this.mStackFromBottom ? n10 : n4;
            int n21 = n19 - n9;
            view2 = this.makeRow(n20, n21, false);
            view = this.mReferenceView;
            this.adjustForTopFadingEdge(view, n14, n15);
        } else {
            int n22 = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            int n23 = this.mStackFromBottom ? n10 : n4;
            view2 = this.makeRow(n23, n22, true);
            view = this.mReferenceView;
        }
        if (!this.mStackFromBottom) {
            this.fillUp(n4 - n8, view.getTop() - n9);
            this.adjustViewsUpOrDown();
            this.fillDown(n4 + n8, n9 + view.getBottom());
            return view2;
        }
        this.fillDown(n10 + n8, n9 + view.getBottom());
        this.adjustViewsUpOrDown();
        this.fillUp(n4 - 1, view.getTop() - n9);
        return view2;
    }

    private void pinToBottom(int n) {
        int n2;
        int n3 = this.getChildCount();
        if (n3 + this.mFirstPosition == this.mItemCount && (n2 = n - this.getChildAt(n3 - 1).getBottom()) > 0) {
            this.offsetChildrenTopAndBottom(n2);
        }
    }

    private void pinToTop(int n) {
        int n2;
        if (this.mFirstPosition == 0 && (n2 = n - this.getChildAt(0).getTop()) < 0) {
            this.offsetChildrenTopAndBottom(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3, int n4) {
        int n5;
        int n6;
        Trace.traceBegin(8L, "setupGridItem");
        boolean bl4 = bl2 && this.shouldShowSelector();
        boolean bl5 = bl4 != view.isSelected();
        int n7 = this.mTouchMode;
        boolean bl6 = n7 > 0 && n7 < 3 && this.mMotionPosition == n;
        boolean bl7 = bl6 != view.isPressed();
        boolean bl8 = !bl3 || bl5 || view.isLayoutRequested();
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
        }
        layoutParams.viewType = n6 = this.mAdapter.getItemViewType(n);
        if (bl3 && !layoutParams.forceAdd) {
            this.attachViewToParent(view, n4, layoutParams);
        } else {
            layoutParams.forceAdd = false;
            this.addViewInLayout(view, n4, layoutParams, true);
        }
        if (bl5) {
            view.setSelected(bl4);
            if (bl4) {
                this.requestFocus();
            }
        }
        if (bl7) {
            view.setPressed(bl6);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            if (view instanceof Checkable) {
                ((Checkable)((Object)view)).setChecked(this.mCheckStates.get(n));
            } else if (this.getContext().getApplicationInfo().targetSdkVersion >= 11) {
                view.setActivated(this.mCheckStates.get(n));
            }
        }
        if (bl8) {
            int n8 = ViewGroup.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(0, 0), 0, layoutParams.height);
            view.measure(ViewGroup.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000), 0, layoutParams.width), n8);
        } else {
            this.cleanupLayoutState(view);
        }
        int n9 = view.getMeasuredWidth();
        int n10 = view.getMeasuredHeight();
        int n11 = bl ? n2 : n2 - n10;
        int n12 = this.getLayoutDirection();
        switch (7 & Gravity.getAbsoluteGravity(this.mGravity, n12)) {
            default: {
                n5 = n3;
                break;
            }
            case 3: {
                n5 = n3;
                break;
            }
            case 1: {
                n5 = n3 + (this.mColumnWidth - n9) / 2;
                break;
            }
            case 5: {
                n5 = n3 + this.mColumnWidth - n9;
            }
        }
        if (bl8) {
            view.layout(n5, n11, n5 + n9, n11 + n10);
        } else {
            view.offsetLeftAndRight(n5 - view.getLeft());
            view.offsetTopAndBottom(n11 - view.getTop());
        }
        if (this.mCachingStarted) {
            view.setDrawingCacheEnabled(true);
        }
        if (bl3 && ((AbsListView.LayoutParams)view.getLayoutParams()).scrappedFromPosition != n) {
            view.jumpDrawablesToCurrentState();
        }
        Trace.traceEnd(8L);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean arrowScroll(int n) {
        int n2;
        int n3;
        int n4 = this.mSelectedPosition;
        int n5 = this.mNumColumns;
        if (!this.mStackFromBottom) {
            n3 = n5 * (n4 / n5);
            n2 = Math.min(-1 + (n3 + n5), -1 + this.mItemCount);
        } else {
            int n6 = -1 + this.mItemCount - n4;
            n2 = -1 + this.mItemCount - n5 * (n6 / n5);
            n3 = Math.max(0, 1 + (n2 - n5));
        }
        boolean bl = false;
        switch (n) {
            case 33: {
                bl = false;
                if (n3 <= 0) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.max(0, n4 - n5));
                bl = true;
                break;
            }
            case 130: {
                int n7 = -1 + this.mItemCount;
                bl = false;
                if (n2 >= n7) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.min(n4 + n5, -1 + this.mItemCount));
                bl = true;
                break;
            }
            case 17: {
                bl = false;
                if (n4 <= n3) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.max(0, n4 - 1));
                bl = true;
                break;
            }
            case 66: {
                bl = false;
                if (n4 >= n2) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.min(n4 + 1, -1 + this.mItemCount));
                bl = true;
                break;
            }
        }
        if (bl) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(n));
            this.invokeOnItemScrollListener();
        }
        if (bl) {
            this.awakenScrollBars();
        }
        return bl;
    }

    @Override
    protected void attachLayoutAnimationParameters(View view, ViewGroup.LayoutParams layoutParams, int n, int n2) {
        GridLayoutAnimationController.AnimationParameters animationParameters = (GridLayoutAnimationController.AnimationParameters)layoutParams.layoutAnimationParameters;
        if (animationParameters == null) {
            animationParameters = new GridLayoutAnimationController.AnimationParameters();
            layoutParams.layoutAnimationParameters = animationParameters;
        }
        animationParameters.count = n2;
        animationParameters.index = n;
        animationParameters.columnsCount = this.mNumColumns;
        animationParameters.rowsCount = n2 / this.mNumColumns;
        if (!this.mStackFromBottom) {
            animationParameters.column = n % this.mNumColumns;
            animationParameters.row = n / this.mNumColumns;
            return;
        }
        int n3 = n2 - 1 - n;
        animationParameters.column = -1 + this.mNumColumns - n3 % this.mNumColumns;
        animationParameters.row = -1 + animationParameters.rowsCount - n3 / this.mNumColumns;
    }

    @Override
    protected int computeVerticalScrollExtent() {
        int n = this.getChildCount();
        if (n > 0) {
            int n2 = this.mNumColumns;
            int n3 = 100 * ((-1 + (n + n2)) / n2);
            View view = this.getChildAt(0);
            int n4 = view.getTop();
            int n5 = view.getHeight();
            if (n5 > 0) {
                n3 += n4 * 100 / n5;
            }
            View view2 = this.getChildAt(n - 1);
            int n6 = view2.getBottom();
            int n7 = view2.getHeight();
            if (n7 > 0) {
                n3 -= 100 * (n6 - this.getHeight()) / n7;
            }
            return n3;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int computeVerticalScrollOffset() {
        int n;
        int n2 = this.mFirstPosition;
        int n3 = 0;
        if (n2 < 0) return n3;
        int n4 = this.getChildCount();
        n3 = 0;
        if (n4 <= 0) return n3;
        View view = this.getChildAt(0);
        int n5 = view.getTop();
        int n6 = view.getHeight();
        n3 = 0;
        if (n6 <= 0) return n3;
        int n7 = this.mNumColumns;
        int n8 = (-1 + (n7 + this.mItemCount)) / n7;
        if (this.isStackFromBottom()) {
            n = n8 * n7 - this.mItemCount;
            return Math.max(100 * ((n + this.mFirstPosition) / n7) - n5 * 100 / n6 + (int)(100.0f * ((float)this.mScrollY / (float)this.getHeight() * (float)n8)), 0);
        }
        n = 0;
        return Math.max(100 * ((n + this.mFirstPosition) / n7) - n5 * 100 / n6 + (int)(100.0f * ((float)this.mScrollY / (float)this.getHeight() * (float)n8)), 0);
    }

    @Override
    protected int computeVerticalScrollRange() {
        int n = this.mNumColumns;
        int n2 = (-1 + (n + this.mItemCount)) / n;
        int n3 = Math.max(n2 * 100, 0);
        if (this.mScrollY != 0) {
            n3 += Math.abs((int)(100.0f * ((float)this.mScrollY / (float)this.getHeight() * (float)n2)));
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void fillGap(boolean bl) {
        int n = this.mNumColumns;
        int n2 = this.mVerticalSpacing;
        int n3 = this.getChildCount();
        if (bl) {
            int n4 = 0x22 & this.mGroupFlags;
            int n5 = 0;
            if (n4 == 34) {
                n5 = this.getListPaddingTop();
            }
            int n6 = n3 > 0 ? n2 + this.getChildAt(n3 - 1).getBottom() : n5;
            int n7 = n3 + this.mFirstPosition;
            if (this.mStackFromBottom) {
                n7 += n - 1;
            }
            this.fillDown(n7, n6);
            this.correctTooHigh(n, n2, this.getChildCount());
            return;
        }
        int n8 = 0x22 & this.mGroupFlags;
        int n9 = 0;
        if (n8 == 34) {
            n9 = this.getListPaddingBottom();
        }
        int n10 = n3 > 0 ? this.getChildAt(0).getTop() - n2 : this.getHeight() - n9;
        int n11 = this.mFirstPosition;
        int n12 = !this.mStackFromBottom ? n11 - n : n11 - 1;
        this.fillUp(n12, n10);
        this.correctTooLow(n, n2, this.getChildCount());
    }

    @Override
    int findMotionRow(int n) {
        block4: {
            int n2 = this.getChildCount();
            if (n2 <= 0) break block4;
            int n3 = this.mNumColumns;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < n2; i += n3) {
                    if (n > this.getChildAt(i).getBottom()) continue;
                    return i + this.mFirstPosition;
                }
            } else {
                for (int i = n2 - 1; i >= 0; i -= n3) {
                    if (n < this.getChildAt(i).getTop()) continue;
                    return i + this.mFirstPosition;
                }
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean fullScroll(int n) {
        boolean bl;
        if (n == 33) {
            this.mLayoutMode = 2;
            this.setSelectionInt(0);
            this.invokeOnItemScrollListener();
            bl = true;
        } else {
            bl = false;
            if (n == 130) {
                this.mLayoutMode = 2;
                this.setSelectionInt(-1 + this.mItemCount);
                this.invokeOnItemScrollListener();
                bl = true;
            }
        }
        if (bl) {
            this.awakenScrollBars();
        }
        return bl;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getColumnWidth() {
        return this.mColumnWidth;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getHorizontalSpacing() {
        return this.mHorizontalSpacing;
    }

    @ViewDebug.ExportedProperty
    public int getNumColumns() {
        return this.mNumColumns;
    }

    public int getRequestedColumnWidth() {
        return this.mRequestedColumnWidth;
    }

    public int getRequestedHorizontalSpacing() {
        return this.mRequestedHorizontalSpacing;
    }

    public int getStretchMode() {
        return this.mStretchMode;
    }

    public int getVerticalSpacing() {
        return this.mVerticalSpacing;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void layoutChildren() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 23[TRYBLOCK] [36 : 826->963)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        if (this.mAdapter == null) return -1;
        if (this.isInTouchMode()) {
            return -1;
        }
        if (n < 0) return -1;
        if (n < this.mItemCount) return n;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        int n2 = -1;
        if (bl && rect != null) {
            rect.offset(this.mScrollX, this.mScrollY);
            Rect rect2 = this.mTempRect;
            int n3 = Integer.MAX_VALUE;
            int n4 = this.getChildCount();
            for (int i = 0; i < n4; ++i) {
                if (!this.isCandidateSelection(i, n)) continue;
                View view = this.getChildAt(i);
                view.getDrawingRect(rect2);
                this.offsetDescendantRectToMyCoords(view, rect2);
                int n5 = GridView.getDistance(rect, rect2, n);
                if (n5 >= n3) continue;
                n3 = n5;
                n2 = i;
            }
        }
        if (n2 >= 0) {
            this.setSelection(n2 + this.mFirstPosition);
            return;
        }
        this.requestLayout();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(GridView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(GridView.class.getName());
        int n = this.getNumColumns();
        accessibilityNodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(this.getCount() / n, n, false, this.getSelectionModeForAccessibility()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInitializeAccessibilityNodeInfoForItem(View view, int n, AccessibilityNodeInfo accessibilityNodeInfo) {
        AbsListView.LayoutParams layoutParams;
        int n2;
        int n3;
        super.onInitializeAccessibilityNodeInfoForItem(view, n, accessibilityNodeInfo);
        int n4 = this.getCount();
        int n5 = this.getNumColumns();
        int n6 = n4 / n5;
        if (!this.mStackFromBottom) {
            n3 = n % n5;
            n2 = n / n5;
        } else {
            int n7 = n4 - 1 - n;
            n3 = n5 - 1 - n7 % n5;
            n2 = n6 - 1 - n7 / n5;
        }
        boolean bl = (layoutParams = (AbsListView.LayoutParams)view.getLayoutParams()) != null && layoutParams.viewType != -2;
        accessibilityNodeInfo.setCollectionItemInfo(AccessibilityNodeInfo.CollectionItemInfo.obtain(n2, 1, n3, 1, bl, this.isItemChecked(n)));
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.commonKey(n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        block11: {
            super.onMeasure(n, n2);
            n5 = View.MeasureSpec.getMode(n);
            int n6 = View.MeasureSpec.getMode(n2);
            n4 = View.MeasureSpec.getSize(n);
            n3 = View.MeasureSpec.getSize(n2);
            if (n5 == 0) {
                int n7 = this.mColumnWidth > 0 ? this.mColumnWidth + this.mListPadding.left + this.mListPadding.right : this.mListPadding.left + this.mListPadding.right;
                n4 = n7 + this.getVerticalScrollbarWidth();
            }
            bl = this.determineColumns(n4 - this.mListPadding.left - this.mListPadding.right);
            int n8 = this.mAdapter == null ? 0 : this.mAdapter.getCount();
            int n9 = this.mItemCount = n8;
            int n10 = 0;
            if (n9 > 0) {
                int n11;
                View view = this.obtainView(0, this.mIsScrap);
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
                if (layoutParams == null) {
                    layoutParams = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
                    view.setLayoutParams(layoutParams);
                }
                layoutParams.viewType = n11 = this.mAdapter.getItemViewType(0);
                layoutParams.forceAdd = true;
                int n12 = GridView.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(0, 0), 0, layoutParams.height);
                view.measure(GridView.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000), 0, layoutParams.width), n12);
                n10 = view.getMeasuredHeight();
                GridView.combineMeasuredStates(0, view.getMeasuredState());
                if (this.mRecycler.shouldRecycleViewType(layoutParams.viewType)) {
                    this.mRecycler.addScrapView(view, -1);
                }
            }
            if (n6 == 0) {
                n3 = n10 + (this.mListPadding.top + this.mListPadding.bottom) + 2 * this.getVerticalFadingEdgeLength();
            }
            if (n6 != Integer.MIN_VALUE) break block11;
            int n13 = this.mListPadding.top + this.mListPadding.bottom;
            int n14 = this.mNumColumns;
            int n15 = 0;
            while (true) {
                block13: {
                    block12: {
                        if (n15 >= n9) break block12;
                        n13 += n10;
                        if (n15 + n14 < n9) {
                            n13 += this.mVerticalSpacing;
                        }
                        if (n13 < n3) break block13;
                        n13 = n3;
                    }
                    n3 = n13;
                    break;
                }
                n15 += n14;
            }
        }
        if (n5 == Integer.MIN_VALUE && this.mRequestedNumColumns != -1 && (this.mRequestedNumColumns * this.mColumnWidth + (-1 + this.mRequestedNumColumns) * this.mHorizontalSpacing + this.mListPadding.left + this.mListPadding.right > n4 || bl)) {
            n4 |= 0x1000000;
        }
        this.setMeasuredDimension(n4, n3);
        this.mWidthMeasureSpec = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean pageScroll(int n) {
        int n2 = -1;
        if (n == 33) {
            n2 = Math.max(0, this.mSelectedPosition - this.getChildCount());
        } else if (n == 130) {
            n2 = Math.min(-1 + this.mItemCount, this.mSelectedPosition + this.getChildCount());
        }
        boolean bl = false;
        if (n2 < 0) return bl;
        this.setSelectionInt(n2);
        this.invokeOnItemScrollListener();
        this.awakenScrollBars();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean sequenceScroll(int n) {
        int n2;
        int n3;
        int n4 = this.mSelectedPosition;
        int n5 = this.mNumColumns;
        int n6 = this.mItemCount;
        if (!this.mStackFromBottom) {
            n3 = n5 * (n4 / n5);
            n2 = Math.min(-1 + (n3 + n5), n6 - 1);
        } else {
            int n7 = n6 - 1 - n4;
            n2 = n6 - 1 - n5 * (n7 / n5);
            n3 = Math.max(0, 1 + (n2 - n5));
        }
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 2: {
                int n8 = n6 - 1;
                bl = false;
                bl2 = false;
                if (n4 < n8) {
                    this.mLayoutMode = 6;
                    this.setSelectionInt(n4 + 1);
                    bl = true;
                    if (n4 == n2) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                }
            }
            default: {
                break;
            }
            case 1: {
                bl = false;
                bl2 = false;
                if (n4 <= 0) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(n4 - 1);
                bl = true;
                bl2 = n4 == n3;
            }
        }
        if (bl) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(n));
            this.invokeOnItemScrollListener();
        }
        if (bl2) {
            this.awakenScrollBars();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = listAdapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        super.setAdapter(listAdapter);
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.mDataChanged = true;
            this.checkFocus();
            this.mDataSetObserver = new AbsListView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int n = this.mStackFromBottom ? this.lookForSelectablePosition(-1 + this.mItemCount, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            this.checkSelectionChanged();
        } else {
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    public void setColumnWidth(int n) {
        if (n != this.mRequestedColumnWidth) {
            this.mRequestedColumnWidth = n;
            this.requestLayoutIfNecessary();
        }
    }

    public void setGravity(int n) {
        if (this.mGravity != n) {
            this.mGravity = n;
            this.requestLayoutIfNecessary();
        }
    }

    public void setHorizontalSpacing(int n) {
        if (n != this.mRequestedHorizontalSpacing) {
            this.mRequestedHorizontalSpacing = n;
            this.requestLayoutIfNecessary();
        }
    }

    public void setNumColumns(int n) {
        if (n != this.mRequestedNumColumns) {
            this.mRequestedNumColumns = n;
            this.requestLayoutIfNecessary();
        }
    }

    @Override
    @RemotableViewMethod
    public void setRemoteViewsAdapter(Intent intent) {
        super.setRemoteViewsAdapter(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSelection(int n) {
        if (!this.isInTouchMode()) {
            this.setNextSelectedPositionInt(n);
        } else {
            this.mResurrectToPosition = n;
        }
        this.mLayoutMode = 2;
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void setSelectionInt(int n) {
        int n2 = this.mNextSelectedPosition;
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.setNextSelectedPositionInt(n);
        this.layoutChildren();
        int n3 = this.mStackFromBottom ? -1 + this.mItemCount - this.mNextSelectedPosition : this.mNextSelectedPosition;
        int n4 = this.mStackFromBottom ? -1 + this.mItemCount - n2 : n2;
        if (n3 / this.mNumColumns != n4 / this.mNumColumns) {
            this.awakenScrollBars();
        }
    }

    public void setStretchMode(int n) {
        if (n != this.mStretchMode) {
            this.mStretchMode = n;
            this.requestLayoutIfNecessary();
        }
    }

    public void setVerticalSpacing(int n) {
        if (n != this.mVerticalSpacing) {
            this.mVerticalSpacing = n;
            this.requestLayoutIfNecessary();
        }
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollByOffset(int n) {
        super.smoothScrollByOffset(n);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollToPosition(int n) {
        super.smoothScrollToPosition(n);
    }
}

