/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import android.widget.TimePickerClockDelegate;
import com.android.internal.R;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class RadialTimePickerView
extends View
implements View.OnTouchListener {
    private static final int ALPHA_AMPM_PRESSED = 255;
    private static final int ALPHA_AMPM_SELECTED = 60;
    private static final int ALPHA_OPAQUE = 255;
    private static final int ALPHA_SELECTOR = 60;
    private static final int ALPHA_TRANSPARENT = 0;
    private static final int AM = 0;
    private static final int AMPM = 3;
    private static final int CENTER_RADIUS = 2;
    private static final float COSINE_30_DEGREES = 0.0f;
    private static final boolean DEBUG = false;
    private static final int DEBUG_COLOR = 0x20FF0000;
    private static final int DEBUG_STROKE_WIDTH = 2;
    private static final int DEBUG_TEXT_COLOR = 0x60FF0000;
    private static final int DEGREES_FOR_ONE_HOUR = 30;
    private static final int DEGREES_FOR_ONE_MINUTE = 6;
    private static final int HOURS = 0;
    private static final int HOURS_INNER = 2;
    private static final int[] HOURS_NUMBERS;
    private static final int[] HOURS_NUMBERS_24;
    private static final int MINUTES = 1;
    private static final int[] MINUTES_NUMBERS;
    private static final int PM = 1;
    private static final int SELECTOR_CIRCLE = 0;
    private static final int SELECTOR_DOT = 1;
    private static final int SELECTOR_LINE = 2;
    private static final float SINE_30_DEGREES = 0.5f;
    private static final int[] STATE_SET_SELECTED;
    private static final String TAG = "ClockView";
    private static int[] sSnapPrefer30sMap;
    private final IntHolder[] mAlpha;
    private final IntHolder[][] mAlphaSelector;
    private int mAmOrPm;
    private int mAmOrPmPressed;
    private int mAmPmCircleRadius;
    private float mAmPmCircleRadiusMultiplier;
    private int mAmPmSelectedColor;
    private final String[] mAmPmText;
    private int mAmPmTextColor;
    private int mAmPmUnselectedColor;
    private float mAmPmYCenter;
    private float[] mAnimationRadiusMultiplier;
    private float[] mCircleRadius;
    private float[] mCircleRadiusMultiplier;
    private final int[] mColor;
    private final int[][] mColorSelector;
    private int mDisabledAlpha;
    private int mHalfwayHypotenusePoint;
    private final String[] mHours12Texts = new String[12];
    private final ArrayList<Animator> mHoursToMinutesAnims;
    private final String[] mInnerHours24Texts;
    private float[] mInnerTextGridHeights;
    private float[] mInnerTextGridWidths;
    private String[] mInnerTextHours;
    private float mInnerTextSize;
    private boolean mInputEnabled;
    private InvalidateUpdateListener mInvalidateUpdateListener;
    private boolean mIs24HourMode;
    private boolean mIsOnInnerCircle;
    private float mLeftIndicatorXCenter;
    private int[] mLineLength;
    private OnValueSelectedListener mListener;
    private int mMaxHypotenuseForOuterNumber;
    private int mMinHypotenuseForInnerNumber;
    private final ArrayList<Animator> mMinuteToHoursAnims;
    private final String[] mMinutesTexts;
    private float[] mNumbersRadiusMultiplier;
    private final String[] mOuterHours24Texts = new String[12];
    private String[] mOuterTextHours;
    private String[] mOuterTextMinutes;
    private final Paint[] mPaint;
    private final Paint[] mPaintAmPmCircle;
    private final Paint mPaintAmPmText;
    private final Paint mPaintBackground;
    private final Paint mPaintCenter;
    private final Paint mPaintDebug;
    private final Paint mPaintDisabled;
    private final Paint[][] mPaintSelector;
    private RectF mRectF;
    private float mRightIndicatorXCenter;
    private int[] mSelectionDegrees;
    private int[] mSelectionRadius;
    private float mSelectionRadiusMultiplier;
    private boolean mShowHours;
    private float[][] mTextGridHeights;
    private float[][] mTextGridWidths;
    private float[] mTextSize;
    private float[] mTextSizeMultiplier;
    private AnimatorSet mTransition;
    private float mTransitionEndRadiusMultiplier;
    private float mTransitionMidRadiusMultiplier;
    private Typeface mTypeface;
    private int mXCenter;
    private int mYCenter;

    static {
        COSINE_30_DEGREES = 0.5f * (float)Math.sqrt(3.0);
        HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        STATE_SET_SELECTED = new int[]{0x10100A1};
        sSnapPrefer30sMap = new int[361];
        RadialTimePickerView.preparePrefer30sMap();
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843933);
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.mInnerHours24Texts = new String[12];
        this.mMinutesTexts = new String[12];
        this.mAmPmText = new String[2];
        this.mPaint = new Paint[2];
        this.mColor = new int[2];
        this.mAlpha = new IntHolder[2];
        this.mPaintCenter = new Paint();
        this.mPaintSelector = (Paint[][])Array.newInstance(Paint.class, 2, 3);
        int[] nArray = new int[]{2, 3};
        this.mColorSelector = (int[][])Array.newInstance(Integer.TYPE, nArray);
        this.mAlphaSelector = (IntHolder[][])Array.newInstance(IntHolder.class, 2, 3);
        this.mPaintAmPmText = new Paint();
        this.mPaintAmPmCircle = new Paint[2];
        this.mPaintBackground = new Paint();
        this.mPaintDisabled = new Paint();
        this.mPaintDebug = new Paint();
        this.mCircleRadius = new float[3];
        this.mTextSize = new float[2];
        int[] nArray2 = new int[]{2, 7};
        this.mTextGridHeights = (float[][])Array.newInstance(Float.TYPE, nArray2);
        int[] nArray3 = new int[]{2, 7};
        this.mTextGridWidths = (float[][])Array.newInstance(Float.TYPE, nArray3);
        this.mInnerTextGridHeights = new float[7];
        this.mInnerTextGridWidths = new float[7];
        this.mCircleRadiusMultiplier = new float[2];
        this.mNumbersRadiusMultiplier = new float[3];
        this.mTextSizeMultiplier = new float[3];
        this.mAnimationRadiusMultiplier = new float[3];
        this.mInvalidateUpdateListener = new InvalidateUpdateListener();
        this.mLineLength = new int[3];
        this.mSelectionRadius = new int[3];
        this.mSelectionDegrees = new int[3];
        this.mRectF = new RectF();
        this.mInputEnabled = true;
        this.mHoursToMinutesAnims = new ArrayList();
        this.mMinuteToHoursAnims = new ArrayList();
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, typedValue, true);
        this.mDisabledAlpha = (int)(0.5f + 255.0f * typedValue.getFloat());
        Resources resources = this.getResources();
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.TimePicker, n, 0);
        ColorStateList colorStateList = typedArray.getColorStateList(7);
        if (colorStateList == null) {
            colorStateList = resources.getColorStateList(17170668);
        }
        int n2 = typedArray.getColor(12, resources.getColor(17170667));
        ColorStateList colorStateList2 = ColorStateList.addFirstIfMissing(colorStateList, 0x10100A1, n2);
        this.mAmPmSelectedColor = colorStateList2.getColorForState(STATE_SET_SELECTED, n2);
        this.mAmPmUnselectedColor = colorStateList2.getDefaultColor();
        this.mAmPmTextColor = typedArray.getColor(6, resources.getColor(17170666));
        this.mTypeface = Typeface.create("sans-serif", 0);
        for (int i = 0; i < this.mAlpha.length; ++i) {
            this.mAlpha[i] = new IntHolder(255);
        }
        for (int i = 0; i < this.mAlphaSelector.length; ++i) {
            for (int j = 0; j < this.mAlphaSelector[i].length; ++j) {
                this.mAlphaSelector[i][j] = new IntHolder(255);
            }
        }
        int n3 = typedArray.getColor(3, resources.getColor(17170666));
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mColor[0] = n3;
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        this.mColor[1] = n3;
        this.mPaintCenter.setColor(n3);
        this.mPaintCenter.setAntiAlias(true);
        this.mPaintCenter.setTextAlign(Paint.Align.CENTER);
        this.mPaintSelector[0][0] = new Paint();
        this.mPaintSelector[0][0].setAntiAlias(true);
        this.mColorSelector[0][0] = typedArray.getColor(5, 17170669);
        this.mPaintSelector[0][1] = new Paint();
        this.mPaintSelector[0][1].setAntiAlias(true);
        this.mColorSelector[0][1] = typedArray.getColor(5, 17170669);
        this.mPaintSelector[0][2] = new Paint();
        this.mPaintSelector[0][2].setAntiAlias(true);
        this.mPaintSelector[0][2].setStrokeWidth(2.0f);
        this.mColorSelector[0][2] = typedArray.getColor(5, 17170669);
        this.mPaintSelector[1][0] = new Paint();
        this.mPaintSelector[1][0].setAntiAlias(true);
        this.mColorSelector[1][0] = typedArray.getColor(5, 17170669);
        this.mPaintSelector[1][1] = new Paint();
        this.mPaintSelector[1][1].setAntiAlias(true);
        this.mColorSelector[1][1] = typedArray.getColor(5, 17170669);
        this.mPaintSelector[1][2] = new Paint();
        this.mPaintSelector[1][2].setAntiAlias(true);
        this.mPaintSelector[1][2].setStrokeWidth(2.0f);
        this.mColorSelector[1][2] = typedArray.getColor(5, 17170669);
        this.mPaintAmPmText.setColor(this.mAmPmTextColor);
        this.mPaintAmPmText.setTypeface(this.mTypeface);
        this.mPaintAmPmText.setAntiAlias(true);
        this.mPaintAmPmText.setTextAlign(Paint.Align.CENTER);
        this.mPaintAmPmCircle[0] = new Paint();
        this.mPaintAmPmCircle[0].setAntiAlias(true);
        this.mPaintAmPmCircle[1] = new Paint();
        this.mPaintAmPmCircle[1].setAntiAlias(true);
        this.mPaintBackground.setColor(typedArray.getColor(4, resources.getColor(17170670)));
        this.mPaintBackground.setAntiAlias(true);
        this.mShowHours = true;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mAmOrPmPressed = -1;
        this.initHoursAndMinutesText();
        this.initData();
        this.mTransitionMidRadiusMultiplier = Float.parseFloat(resources.getString(17039445));
        this.mTransitionEndRadiusMultiplier = Float.parseFloat(resources.getString(17039446));
        this.mTextGridHeights[0] = new float[7];
        this.mTextGridHeights[1] = new float[7];
        this.mSelectionRadiusMultiplier = Float.parseFloat(resources.getString(17039437));
        typedArray.recycle();
        this.setOnTouchListener(this);
        this.setClickable(true);
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        this.setCurrentHour(n4);
        this.setCurrentMinute(n5);
        this.setHapticFeedbackEnabled(true);
    }

    private static void calculateGridSizes(Paint paint, float f, float f2, float f3, float f4, float[] fArray, float[] fArray2) {
        float f5 = f * COSINE_30_DEGREES;
        float f6 = f * 0.5f;
        paint.setTextSize(f4);
        float f7 = f3 - (paint.descent() + paint.ascent()) / 2.0f;
        fArray[0] = f7 - f;
        fArray2[0] = f2 - f;
        fArray[1] = f7 - f5;
        fArray2[1] = f2 - f5;
        fArray[2] = f7 - f6;
        fArray2[2] = f2 - f6;
        fArray[3] = f7;
        fArray2[3] = f2;
        fArray[4] = f7 + f6;
        fArray2[4] = f2 + f6;
        fArray[5] = f7 + f5;
        fArray2[5] = f2 + f5;
        fArray[6] = f7 + f;
        fArray2[6] = f2 + f;
    }

    private void calculateGridSizesHours() {
        float f = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0] * this.mAnimationRadiusMultiplier[0];
        RadialTimePickerView.calculateGridSizes(this.mPaint[0], f, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mTextGridHeights[0], this.mTextGridWidths[0]);
        if (this.mIs24HourMode) {
            float f2 = this.mCircleRadius[2] * this.mNumbersRadiusMultiplier[2] * this.mAnimationRadiusMultiplier[2];
            RadialTimePickerView.calculateGridSizes(this.mPaint[0], f2, this.mXCenter, this.mYCenter, this.mInnerTextSize, this.mInnerTextGridHeights, this.mInnerTextGridWidths);
        }
    }

    private void calculateGridSizesMinutes() {
        float f = this.mCircleRadius[1] * this.mNumbersRadiusMultiplier[1] * this.mAnimationRadiusMultiplier[1];
        RadialTimePickerView.calculateGridSizes(this.mPaint[1], f, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mTextGridHeights[1], this.mTextGridWidths[1]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawAmPm(Canvas canvas) {
        boolean bl = this.isLayoutRtl();
        int n = this.mAmPmUnselectedColor;
        int n2 = 255;
        int n3 = this.mAmPmUnselectedColor;
        int n4 = 255;
        if (this.mAmOrPm == 0) {
            n = this.mAmPmSelectedColor;
            n2 = 60;
        } else if (this.mAmOrPm == 1) {
            n3 = this.mAmPmSelectedColor;
            n4 = 60;
        }
        if (this.mAmOrPmPressed == 0) {
            n = this.mAmPmSelectedColor;
            n2 = 255;
        } else if (this.mAmOrPmPressed == 1) {
            n3 = this.mAmPmSelectedColor;
            n4 = 255;
        }
        this.mPaintAmPmCircle[0].setColor(n);
        this.mPaintAmPmCircle[0].setAlpha(this.getMultipliedAlpha(n, n2));
        float f = bl ? this.mRightIndicatorXCenter : this.mLeftIndicatorXCenter;
        canvas.drawCircle(f, this.mAmPmYCenter, this.mAmPmCircleRadius, this.mPaintAmPmCircle[0]);
        this.mPaintAmPmCircle[1].setColor(n3);
        this.mPaintAmPmCircle[1].setAlpha(this.getMultipliedAlpha(n3, n4));
        float f2 = bl ? this.mLeftIndicatorXCenter : this.mRightIndicatorXCenter;
        canvas.drawCircle(f2, this.mAmPmYCenter, this.mAmPmCircleRadius, this.mPaintAmPmCircle[1]);
        this.mPaintAmPmText.setColor(this.mAmPmTextColor);
        float f3 = this.mAmPmYCenter - (float)((int)(this.mPaintAmPmText.descent() + this.mPaintAmPmText.ascent()) / 2);
        String string2 = bl ? this.mAmPmText[1] : this.mAmPmText[0];
        canvas.drawText(string2, this.mLeftIndicatorXCenter, f3, this.mPaintAmPmText);
        String string3 = bl ? this.mAmPmText[0] : this.mAmPmText[1];
        canvas.drawText(string3, this.mRightIndicatorXCenter, f3, this.mPaintAmPmText);
    }

    private void drawCenter(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, 2.0f, this.mPaintCenter);
    }

    private void drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintBackground);
    }

    private void drawDebug(Canvas canvas) {
        RectF rectF;
        float f = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0];
        canvas.drawCircle(this.mXCenter, this.mYCenter, f, this.mPaintDebug);
        float f2 = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2];
        canvas.drawCircle(this.mXCenter, this.mYCenter, f2, this.mPaintDebug);
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintDebug);
        float f3 = (float)this.mXCenter - f;
        float f4 = (float)this.mYCenter - f;
        float f5 = f + (float)this.mXCenter;
        float f6 = f + (float)this.mYCenter;
        this.mRectF = rectF = new RectF(f3, f4, f5, f6);
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        float f7 = (float)this.mXCenter - this.mCircleRadius[0];
        float f8 = (float)this.mYCenter - this.mCircleRadius[0];
        float f9 = (float)this.mXCenter + this.mCircleRadius[0];
        float f10 = (float)this.mYCenter + this.mCircleRadius[0];
        this.mRectF.set(f7, f8, f9, f10);
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        this.mRectF.set(0.0f, 0.0f, this.getWidth(), this.getHeight());
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        Object[] objectArray = new Object[]{this.getCurrentHour(), this.getCurrentMinute()};
        String string2 = String.format("%02d:%02d", objectArray);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        TextView textView = new TextView(this.getContext());
        textView.setLayoutParams(layoutParams);
        textView.setText(string2);
        textView.measure(0, 0);
        TextPaint textPaint = textView.getPaint();
        textPaint.setColor(0x60FF0000);
        int n = textView.getMeasuredWidth();
        float f11 = textPaint.descent() - textPaint.ascent();
        float f12 = this.mXCenter - n / 2;
        float f13 = (float)this.mYCenter + 1.5f * f11;
        canvas.drawText(string2.toString(), f12, f13, textPaint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawSelector(Canvas canvas) {
        int n = this.mIsOnInnerCircle ? 2 : 0;
        this.drawSelector(canvas, n);
        this.drawSelector(canvas, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawSelector(Canvas canvas, int n) {
        this.mLineLength[n] = (int)(this.mCircleRadius[n] * this.mNumbersRadiusMultiplier[n] * this.mAnimationRadiusMultiplier[n]);
        double d = Math.toRadians(this.mSelectionDegrees[n]);
        int n2 = this.mXCenter + (int)((double)this.mLineLength[n] * Math.sin(d));
        int n3 = this.mYCenter - (int)((double)this.mLineLength[n] * Math.cos(d));
        int n4 = this.mColorSelector[n % 2][0];
        int n5 = this.mAlphaSelector[n % 2][0].getValue();
        Paint paint = this.mPaintSelector[n % 2][0];
        paint.setColor(n4);
        paint.setAlpha(this.getMultipliedAlpha(n4, n5));
        canvas.drawCircle(n2, n3, this.mSelectionRadius[n], paint);
        if (this.mSelectionDegrees[n] % 30 != 0) {
            int n6 = this.mColorSelector[n % 2][1];
            int n7 = this.mAlphaSelector[n % 2][1].getValue();
            Paint paint2 = this.mPaintSelector[n % 2][1];
            paint2.setColor(n6);
            paint2.setAlpha(this.getMultipliedAlpha(n6, n7));
            canvas.drawCircle(n2, n3, 2 * this.mSelectionRadius[n] / 7, paint2);
        } else {
            int n8 = this.mLineLength[n] - this.mSelectionRadius[n];
            n2 = this.mXCenter + (int)((double)n8 * Math.sin(d));
            n3 = this.mYCenter - (int)((double)n8 * Math.cos(d));
        }
        int n9 = this.mColorSelector[n % 2][2];
        int n10 = this.mAlphaSelector[n % 2][2].getValue();
        Paint paint3 = this.mPaintSelector[n % 2][2];
        paint3.setColor(n9);
        paint3.setAlpha(this.getMultipliedAlpha(n9, n10));
        canvas.drawLine(this.mXCenter, this.mYCenter, n2, n3, paint3);
    }

    private void drawTextElements(Canvas canvas, float f, Typeface typeface, String[] stringArray, float[] fArray, float[] fArray2, Paint paint, int n, int n2) {
        paint.setTextSize(f);
        paint.setTypeface(typeface);
        paint.setColor(n);
        paint.setAlpha(this.getMultipliedAlpha(n, n2));
        canvas.drawText(stringArray[0], fArray[3], fArray2[0], paint);
        canvas.drawText(stringArray[1], fArray[4], fArray2[1], paint);
        canvas.drawText(stringArray[2], fArray[5], fArray2[2], paint);
        canvas.drawText(stringArray[3], fArray[6], fArray2[3], paint);
        canvas.drawText(stringArray[4], fArray[5], fArray2[4], paint);
        canvas.drawText(stringArray[5], fArray[4], fArray2[5], paint);
        canvas.drawText(stringArray[6], fArray[3], fArray2[6], paint);
        canvas.drawText(stringArray[7], fArray[2], fArray2[5], paint);
        canvas.drawText(stringArray[8], fArray[1], fArray2[4], paint);
        canvas.drawText(stringArray[9], fArray[0], fArray2[3], paint);
        canvas.drawText(stringArray[10], fArray[1], fArray2[2], paint);
        canvas.drawText(stringArray[11], fArray[2], fArray2[1], paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getDegreesFromXY(float f, float f2) {
        double d = Math.sqrt((f2 - (float)this.mYCenter) * (f2 - (float)this.mYCenter) + (f - (float)this.mXCenter) * (f - (float)this.mXCenter));
        if (d > (double)this.mCircleRadius[0]) {
            return -1;
        }
        if (this.mIs24HourMode && this.mShowHours) {
            if (d >= (double)this.mMinHypotenuseForInnerNumber && d <= (double)this.mHalfwayHypotenusePoint) {
                this.mIsOnInnerCircle = true;
            } else {
                if (!(d <= (double)this.mMaxHypotenuseForOuterNumber)) return -1;
                if (!(d >= (double)this.mHalfwayHypotenusePoint)) return -1;
                this.mIsOnInnerCircle = false;
            }
        } else {
            int n = this.mShowHours ? 0 : 1;
            if ((int)Math.abs(d - (double)(this.mCircleRadius[n] * this.mNumbersRadiusMultiplier[n])) > (int)(this.mCircleRadius[n] * (1.0f - this.mNumbersRadiusMultiplier[n]))) {
                return -1;
            }
        }
        double d2 = Math.toDegrees(Math.asin((double)Math.abs(f2 - (float)this.mYCenter) / d));
        boolean bl = f > (float)this.mXCenter;
        boolean bl2 = f2 < (float)this.mYCenter;
        if (bl && bl2) {
            d2 = 90.0 - d2;
            return (int)d2;
        }
        if (bl && !bl2) {
            return (int)(d2 += 90.0);
        }
        if (!bl && !bl2) {
            d2 = 270.0 - d2;
            return (int)d2;
        }
        if (bl) return (int)d2;
        if (!bl2) return (int)d2;
        return (int)(d2 += 270.0);
    }

    private static ObjectAnimator getFadeInAnimator(IntHolder intHolder, int n, int n2, InvalidateUpdateListener invalidateUpdateListener) {
        int n3 = (int)((1.0f + 0.25f) * (float)500);
        float f = 0.25f * (float)500 / (float)n3;
        Animator animator2 = ObjectAnimator.ofPropertyValuesHolder(intHolder, PropertyValuesHolder.ofKeyframe("value", Keyframe.ofInt(0.0f, n), Keyframe.ofInt(f, n), Keyframe.ofInt(1.0f, n2))).setDuration(n3);
        ((ValueAnimator)animator2).addUpdateListener(invalidateUpdateListener);
        return animator2;
    }

    private static ObjectAnimator getFadeOutAnimator(IntHolder intHolder, int n, int n2, InvalidateUpdateListener invalidateUpdateListener) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)intHolder, "value", n, n2);
        objectAnimator.setDuration(500);
        objectAnimator.addUpdateListener(invalidateUpdateListener);
        return objectAnimator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getIsTouchingAmOrPm(float f, float f2) {
        boolean bl = this.isLayoutRtl();
        int n = (int)((f2 - this.mAmPmYCenter) * (f2 - this.mAmPmYCenter));
        if ((int)Math.sqrt((f - this.mLeftIndicatorXCenter) * (f - this.mLeftIndicatorXCenter) + (float)n) <= this.mAmPmCircleRadius) {
            if (!bl) return 0;
            return 1;
        }
        if ((int)Math.sqrt((f - this.mRightIndicatorXCenter) * (f - this.mRightIndicatorXCenter) + (float)n) > this.mAmPmCircleRadius) return -1;
        int n2 = 0;
        if (!bl) return 1;
        return n2;
    }

    private int getMultipliedAlpha(int n, int n2) {
        return (int)(0.5 + (double)Color.alpha(n) * ((double)n2 / 255.0));
    }

    private static ObjectAnimator getRadiusDisappearAnimator(Object object, String string2, InvalidateUpdateListener invalidateUpdateListener, float f, float f2) {
        Animator animator2 = ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofKeyframe(string2, Keyframe.ofFloat(0.0f, 1.0f), Keyframe.ofFloat(0.2f, f), Keyframe.ofFloat(1.0f, f2))).setDuration(500);
        ((ValueAnimator)animator2).addUpdateListener(invalidateUpdateListener);
        return animator2;
    }

    private static ObjectAnimator getRadiusReappearAnimator(Object object, String string2, InvalidateUpdateListener invalidateUpdateListener, float f, float f2) {
        int n = (int)((1.0f + 0.25f) * (float)500);
        float f3 = 0.25f * (float)500 / (float)n;
        float f4 = 1.0f - 0.2f * (1.0f - f3);
        Animator animator2 = ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofKeyframe(string2, Keyframe.ofFloat(0.0f, f2), Keyframe.ofFloat(f3, f2), Keyframe.ofFloat(f4, f), Keyframe.ofFloat(1.0f, 1.0f))).setDuration(n);
        ((ValueAnimator)animator2).addUpdateListener(invalidateUpdateListener);
        return animator2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initData() {
        int n = 255;
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = null;
        }
        this.mOuterTextMinutes = this.mMinutesTexts;
        Resources resources = this.getResources();
        if (this.mShowHours) {
            if (this.mIs24HourMode) {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(resources.getString(17039436));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(resources.getString(17039441));
                this.mTextSizeMultiplier[0] = Float.parseFloat(resources.getString(17039444));
                this.mNumbersRadiusMultiplier[2] = Float.parseFloat(resources.getString(17039440));
                this.mTextSizeMultiplier[2] = Float.parseFloat(resources.getString(17039443));
            } else {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(resources.getString(17039435));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(resources.getString(17039439));
                this.mTextSizeMultiplier[0] = Float.parseFloat(resources.getString(17039442));
            }
        } else {
            this.mCircleRadiusMultiplier[1] = Float.parseFloat(resources.getString(17039435));
            this.mNumbersRadiusMultiplier[1] = Float.parseFloat(resources.getString(17039439));
            this.mTextSizeMultiplier[1] = Float.parseFloat(resources.getString(17039442));
        }
        this.mAnimationRadiusMultiplier[0] = 1.0f;
        this.mAnimationRadiusMultiplier[2] = 1.0f;
        this.mAnimationRadiusMultiplier[1] = 1.0f;
        this.mAmPmCircleRadiusMultiplier = Float.parseFloat(resources.getString(17039438));
        IntHolder intHolder = this.mAlpha[0];
        int n2 = this.mShowHours ? n : 0;
        intHolder.setValue(n2);
        IntHolder intHolder2 = this.mAlpha[1];
        int n3 = this.mShowHours ? 0 : n;
        intHolder2.setValue(n3);
        IntHolder intHolder3 = this.mAlphaSelector[0][0];
        int n4 = this.mShowHours ? 60 : 0;
        intHolder3.setValue(n4);
        IntHolder intHolder4 = this.mAlphaSelector[0][1];
        int n5 = this.mShowHours ? n : 0;
        intHolder4.setValue(n5);
        IntHolder intHolder5 = this.mAlphaSelector[0][2];
        int n6 = this.mShowHours ? 60 : 0;
        intHolder5.setValue(n6);
        IntHolder intHolder6 = this.mAlphaSelector[1][0];
        int n7 = this.mShowHours ? 0 : 60;
        intHolder6.setValue(n7);
        IntHolder intHolder7 = this.mAlphaSelector[1][1];
        if (this.mShowHours) {
            n = 0;
        }
        intHolder7.setValue(n);
        IntHolder intHolder8 = this.mAlphaSelector[1][2];
        boolean bl = this.mShowHours;
        int n8 = 0;
        if (!bl) {
            n8 = 60;
        }
        intHolder8.setValue(n8);
    }

    private void initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            String[] stringArray = this.mHours12Texts;
            Object[] objectArray = new Object[]{HOURS_NUMBERS[i]};
            stringArray[i] = String.format("%d", objectArray);
            String[] stringArray2 = this.mOuterHours24Texts;
            Object[] objectArray2 = new Object[]{HOURS_NUMBERS_24[i]};
            stringArray2[i] = String.format("%02d", objectArray2);
            String[] stringArray3 = this.mInnerHours24Texts;
            Object[] objectArray3 = new Object[]{HOURS_NUMBERS[i]};
            stringArray3[i] = String.format("%d", objectArray3);
            String[] stringArray4 = this.mMinutesTexts;
            Object[] objectArray4 = new Object[]{MINUTES_NUMBERS[i]};
            stringArray4[i] = String.format("%02d", objectArray4);
        }
        String[] stringArray = TimePickerClockDelegate.getAmPmStrings(this.mContext);
        this.mAmPmText[0] = stringArray[0];
        this.mAmPmText[1] = stringArray[1];
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void preparePrefer30sMap() {
        int n = 0;
        int n2 = 1;
        int n3 = 8;
        int n4 = 0;
        while (n4 < 361) {
            RadialTimePickerView.sSnapPrefer30sMap[n4] = n;
            if (n2 == n3) {
                n3 = (n += 6) == 360 ? 7 : (n % 30 == 0 ? 14 : 4);
                n2 = 1;
            } else {
                ++n2;
            }
            ++n4;
        }
        return;
    }

    private void setAnimationRadiusMultiplierHours(float f) {
        this.mAnimationRadiusMultiplier[0] = f;
        this.mAnimationRadiusMultiplier[2] = f;
    }

    private void setAnimationRadiusMultiplierMinutes(float f) {
        this.mAnimationRadiusMultiplier[1] = f;
    }

    private static int snapOnly30s(int n, int n2) {
        int n3 = 30 * (n / 30);
        int n4 = n3 + 30;
        if (n2 == 1) {
            return n4;
        }
        if (n2 == -1) {
            if (n == n3) {
                n3 -= 30;
            }
            return n3;
        }
        if (n - n3 < n4 - n) {
            return n3;
        }
        return n4;
    }

    private static int snapPrefer30s(int n) {
        if (sSnapPrefer30sMap == null) {
            return -1;
        }
        return sSnapPrefer30sMap[n];
    }

    private void startHoursToMinutesAnimation() {
        if (this.mHoursToMinutesAnims.size() == 0) {
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[0], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][0], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][1], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][2], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][0], 0, 60, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mHoursToMinutesAnims);
        this.mTransition.start();
    }

    private void startMinutesToHoursAnimation() {
        if (this.mMinuteToHoursAnims.size() == 0) {
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][0], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][2], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[0], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][0], 0, 60, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][1], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mMinuteToHoursAnims);
        this.mTransition.start();
    }

    private void updateLayoutData() {
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        int n = Math.min(this.mXCenter, this.mYCenter);
        this.mCircleRadius[0] = (float)n * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[2] = (float)n * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[1] = (float)n * this.mCircleRadiusMultiplier[1];
        if (!this.mIs24HourMode) {
            int n2 = (int)(this.mCircleRadius[0] * this.mAmPmCircleRadiusMultiplier);
            this.mYCenter -= n2 / 2;
        }
        this.mMinHypotenuseForInnerNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2]) - this.mSelectionRadius[0];
        this.mMaxHypotenuseForOuterNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0]) + this.mSelectionRadius[0];
        this.mHalfwayHypotenusePoint = (int)(this.mCircleRadius[0] * ((this.mNumbersRadiusMultiplier[0] + this.mNumbersRadiusMultiplier[2]) / 2.0f));
        this.mTextSize[0] = this.mCircleRadius[0] * this.mTextSizeMultiplier[0];
        this.mTextSize[1] = this.mCircleRadius[1] * this.mTextSizeMultiplier[1];
        if (this.mIs24HourMode) {
            this.mInnerTextSize = this.mCircleRadius[0] * this.mTextSizeMultiplier[2];
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.mSelectionRadius[0] = (int)(this.mCircleRadius[0] * this.mSelectionRadiusMultiplier);
        this.mSelectionRadius[2] = this.mSelectionRadius[0];
        this.mSelectionRadius[1] = (int)(this.mCircleRadius[1] * this.mSelectionRadiusMultiplier);
        this.mAmPmCircleRadius = (int)(this.mCircleRadius[0] * this.mAmPmCircleRadiusMultiplier);
        this.mPaintAmPmText.setTextSize(3 * this.mAmPmCircleRadius / 4);
        this.mAmPmYCenter = (float)this.mYCenter + this.mCircleRadius[0];
        this.mLeftIndicatorXCenter = (float)this.mXCenter - this.mCircleRadius[0] + (float)this.mAmPmCircleRadius;
        this.mRightIndicatorXCenter = (float)this.mXCenter + this.mCircleRadius[0] - (float)this.mAmPmCircleRadius;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 32) {
            accessibilityEvent.getText().clear();
            Time time = new Time();
            time.hour = this.getCurrentHour();
            time.minute = this.getCurrentMinute();
            long l = time.normalize(true);
            int n = 1;
            if (this.mIs24HourMode) {
                n |= 0x80;
            }
            String string2 = DateUtils.formatDateTime(this.getContext(), l, n);
            accessibilityEvent.getText().add(string2);
            return true;
        }
        return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
    }

    public int getAmOrPm() {
        return this.mAmOrPm;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCurrentHour() {
        int[] nArray = this.mSelectionDegrees;
        int n = this.mIsOnInnerCircle ? 2 : 0;
        int n2 = nArray[n] / 30 % 12;
        if (this.mIs24HourMode) {
            if (this.mIsOnInnerCircle && n2 == 0) {
                return 12;
            }
            if (this.mIsOnInnerCircle) return n2;
            if (n2 == 0) return n2;
            return n2 + 12;
        }
        if (this.mAmOrPm != 1) return n2;
        return n2 + 12;
    }

    public int getCurrentItemShowing() {
        if (this.mShowHours) {
            return 0;
        }
        return 1;
    }

    public int getCurrentMinute() {
        return this.mSelectionDegrees[1] / 6;
    }

    public void initialize(int n, int n2, boolean bl) {
        this.mIs24HourMode = bl;
        this.setCurrentHour(n);
        this.setCurrentMinute(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onDraw(Canvas canvas) {
        if (!this.mInputEnabled) {
            canvas.saveLayerAlpha(0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mDisabledAlpha);
        } else {
            canvas.save();
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.drawCircleBackground(canvas);
        this.drawSelector(canvas);
        this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mOuterTextHours, this.mTextGridWidths[0], this.mTextGridHeights[0], this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        if (this.mIs24HourMode && this.mInnerTextHours != null) {
            this.drawTextElements(canvas, this.mInnerTextSize, this.mTypeface, this.mInnerTextHours, this.mInnerTextGridWidths, this.mInnerTextGridHeights, this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        }
        this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mOuterTextMinutes, this.mTextGridWidths[1], this.mTextGridHeights[1], this.mPaint[1], this.mColor[1], this.mAlpha[1].getValue());
        this.drawCenter(canvas);
        if (!this.mIs24HourMode) {
            this.drawAmPm(canvas);
        }
        canvas.restore();
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.addAction(4096);
        accessibilityNodeInfo.addAction(8192);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.updateLayoutData();
    }

    @Override
    public void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = View.MeasureSpec.getMode(n);
        int n5 = View.MeasureSpec.getSize(n2);
        int n6 = View.MeasureSpec.getMode(n2);
        int n7 = Math.min(n3, n5);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(n7, n4), View.MeasureSpec.makeMeasureSpec(n7, n6));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean bl;
        if (!this.mInputEnabled) {
            return true;
        }
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 0: 
            case 2: {
                boolean bl2;
                this.mAmOrPmPressed = this.getIsTouchingAmOrPm(f, f2);
                if (this.mAmOrPmPressed != -1) {
                    bl2 = true;
                } else {
                    int n = this.getDegreesFromXY(f, f2);
                    bl2 = false;
                    if (n != -1) {
                        int n2 = this.mShowHours ? RadialTimePickerView.snapOnly30s(n, 0) : RadialTimePickerView.snapPrefer30s(n);
                        int n3 = n2 % 360;
                        if (this.mShowHours) {
                            this.mSelectionDegrees[0] = n3;
                            this.mSelectionDegrees[2] = n3;
                        } else {
                            this.mSelectionDegrees[1] = n3;
                        }
                        this.performHapticFeedback(4);
                        if (this.mListener != null) {
                            if (this.mShowHours) {
                                this.mListener.onValueSelected(0, this.getCurrentHour(), false);
                            } else {
                                this.mListener.onValueSelected(1, this.getCurrentMinute(), false);
                            }
                        }
                        bl2 = true;
                    }
                }
                this.invalidate();
                return bl2;
            }
            case 1: 
        }
        this.mAmOrPmPressed = this.getIsTouchingAmOrPm(f, f2);
        if (this.mAmOrPmPressed != -1) {
            if (this.mAmOrPm != this.mAmOrPmPressed) {
                this.swapAmPm();
            }
            this.mAmOrPmPressed = -1;
            if (this.mListener != null) {
                this.mListener.onValueSelected(3, this.getCurrentHour(), true);
            }
            bl = true;
        } else {
            int n = this.getDegreesFromXY(f, f2);
            bl = false;
            if (n != -1) {
                int n4 = this.mShowHours ? RadialTimePickerView.snapOnly30s(n, 0) : RadialTimePickerView.snapPrefer30s(n);
                int n5 = n4 % 360;
                if (this.mShowHours) {
                    this.mSelectionDegrees[0] = n5;
                    this.mSelectionDegrees[2] = n5;
                } else {
                    this.mSelectionDegrees[1] = n5;
                }
                if (this.mListener != null) {
                    if (this.mShowHours) {
                        this.mListener.onValueSelected(0, this.getCurrentHour(), true);
                    } else {
                        this.mListener.onValueSelected(1, this.getCurrentMinute(), true);
                    }
                }
                bl = true;
            }
        }
        if (!bl) return bl;
        this.invalidate();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @SuppressLint(value={"NewApi"})
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (super.performAccessibilityAction(n, bundle)) return true;
        if (n == 4096) {
            n5 = 1;
        } else {
            n5 = 0;
            if (n == 8192) {
                n5 = -1;
            }
        }
        if (n5 == 0) {
            return false;
        }
        if (this.mShowHours) {
            n4 = 30;
            n3 = this.getCurrentHour() % 12;
        } else {
            n4 = 6;
            n3 = this.getCurrentMinute();
        }
        int n6 = RadialTimePickerView.snapOnly30s(n3 * n4, n5) / n4;
        int n7 = 0;
        if (this.mShowHours) {
            if (this.mIs24HourMode) {
                n2 = 23;
            } else {
                n2 = 12;
                n7 = 1;
            }
        } else {
            n2 = 55;
            n7 = 0;
        }
        if (n6 > n2) {
            n6 = n7;
        } else if (n6 < n7) {
            n6 = n2;
        }
        if (this.mShowHours) {
            this.setCurrentHour(n6);
            if (this.mListener == null) return true;
            this.mListener.onValueSelected(0, n6, false);
            return true;
        }
        this.setCurrentMinute(n6);
        if (this.mListener == null) {
            return true;
        }
        this.mListener.onValueSelected(1, n6, false);
        return true;
    }

    public void setAmOrPm(int n) {
        this.mAmOrPm = n % 2;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentHour(int n) {
        int n2;
        int n3 = 1;
        this.mSelectionDegrees[0] = n2 = 30 * (n % 12);
        this.mSelectionDegrees[2] = n2;
        int n4 = n == 0 || n % 24 < 12 ? 0 : n3;
        this.mAmOrPm = n4;
        if (this.mIs24HourMode) {
            if (n < n3 || n > 12) {
                n3 = 0;
            }
            this.mIsOnInnerCircle = n3;
        } else {
            this.mIsOnInnerCircle = false;
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    public void setCurrentItemShowing(int n, boolean bl) {
        switch (n) {
            default: {
                Log.e(TAG, "ClockView does not support showing item " + n);
                return;
            }
            case 0: {
                this.showHours(bl);
                return;
            }
            case 1: 
        }
        this.showMinutes(bl);
    }

    public void setCurrentMinute(int n) {
        this.mSelectionDegrees[1] = 6 * (n % 60);
        this.invalidate();
    }

    public void setInputEnabled(boolean bl) {
        this.mInputEnabled = bl;
        this.invalidate();
    }

    public void setOnValueSelectedListener(OnValueSelectedListener onValueSelectedListener) {
        this.mListener = onValueSelectedListener;
    }

    public void showHours(boolean bl) {
        if (this.mShowHours) {
            return;
        }
        this.mShowHours = true;
        if (bl) {
            this.startMinutesToHoursAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    public void showMinutes(boolean bl) {
        if (!this.mShowHours) {
            return;
        }
        this.mShowHours = false;
        if (bl) {
            this.startHoursToMinutesAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void swapAmPm() {
        int n = this.mAmOrPm == 0 ? 1 : 0;
        this.mAmOrPm = n;
        this.invalidate();
    }

    private static class IntHolder {
        private int mValue;

        public IntHolder(int n) {
            this.mValue = n;
        }

        public int getValue() {
            return this.mValue;
        }

        public void setValue(int n) {
            this.mValue = n;
        }
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        @Override
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            RadialTimePickerView.this.invalidate();
        }
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

