/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsSeekBar;
import com.android.internal.R;

public class RatingBar
extends AbsSeekBar {
    private int mNumStars = 5;
    private OnRatingBarChangeListener mOnRatingBarChangeListener;
    private int mProgressOnStartTracking;

    public RatingBar(Context context) {
        this(context, null);
    }

    public RatingBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842876);
    }

    public RatingBar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RatingBar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RatingBar, n, n2);
        int n3 = typedArray.getInt(0, this.mNumStars);
        boolean bl = this.mIsUserSeekable;
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        this.setIsIndicator(typedArray.getBoolean(3, bl2));
        float f = typedArray.getFloat(1, -1.0f);
        float f2 = typedArray.getFloat(2, -1.0f);
        typedArray.recycle();
        if (n3 > 0 && n3 != this.mNumStars) {
            this.setNumStars(n3);
        }
        if (f2 >= 0.0f) {
            this.setStepSize(f2);
        } else {
            this.setStepSize(0.5f);
        }
        if (f >= 0.0f) {
            this.setRating(f);
        }
        this.mTouchProgressOffset = 1.1f;
    }

    private float getProgressPerStar() {
        float f = 1.0f;
        if (this.mNumStars > 0) {
            f = f * (float)this.getMax() / (float)this.mNumStars;
        }
        return f;
    }

    private void updateSecondaryProgress(int n) {
        float f = this.getProgressPerStar();
        if (f > 0.0f) {
            this.setSecondaryProgress((int)(Math.ceil((float)n / f) * (double)f));
        }
    }

    @Override
    void animateSetProgress(int n) {
    }

    void dispatchRatingChange(boolean bl) {
        if (this.mOnRatingBarChangeListener != null) {
            this.mOnRatingBarChangeListener.onRatingChanged(this, this.getRating(), bl);
        }
    }

    @Override
    Shape getDrawableShape() {
        return new RectShape();
    }

    public int getNumStars() {
        return this.mNumStars;
    }

    public OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return this.mOnRatingBarChangeListener;
    }

    public float getRating() {
        return (float)this.getProgress() / this.getProgressPerStar();
    }

    public float getStepSize() {
        return (float)this.getNumStars() / (float)this.getMax();
    }

    public boolean isIndicator() {
        return !this.mIsUserSeekable;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(RatingBar.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(RatingBar.class.getName());
    }

    @Override
    void onKeyChange() {
        super.onKeyChange();
        this.dispatchRatingChange(true);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            super.onMeasure(n, n2);
            if (this.mSampleTile != null) {
                this.setMeasuredDimension(RatingBar.resolveSizeAndState(this.mSampleTile.getWidth() * this.mNumStars, n, 0), this.getMeasuredHeight());
            }
            return;
        }
    }

    @Override
    void onProgressRefresh(float f, boolean bl) {
        super.onProgressRefresh(f, bl);
        this.updateSecondaryProgress(this.getProgress());
        if (!bl) {
            this.dispatchRatingChange(false);
        }
    }

    @Override
    void onStartTrackingTouch() {
        this.mProgressOnStartTracking = this.getProgress();
        super.onStartTrackingTouch();
    }

    @Override
    void onStopTrackingTouch() {
        super.onStopTrackingTouch();
        if (this.getProgress() != this.mProgressOnStartTracking) {
            this.dispatchRatingChange(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setIsIndicator(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = !bl ? bl2 : false;
        this.mIsUserSeekable = bl3;
        if (bl) {
            bl2 = false;
        }
        this.setFocusable(bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setMax(int n) {
        synchronized (this) {
            if (n <= 0) {
                return;
            }
            super.setMax(n);
            return;
        }
    }

    public void setNumStars(int n) {
        if (n <= 0) {
            return;
        }
        this.mNumStars = n;
        this.requestLayout();
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener onRatingBarChangeListener) {
        this.mOnRatingBarChangeListener = onRatingBarChangeListener;
    }

    public void setRating(float f) {
        this.setProgress(Math.round(f * this.getProgressPerStar()));
    }

    public void setStepSize(float f) {
        if (f <= 0.0f) {
            return;
        }
        float f2 = (float)this.mNumStars / f;
        int n = (int)(f2 / (float)this.getMax() * (float)this.getProgress());
        this.setMax((int)f2);
        this.setProgress(n);
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(RatingBar var1, float var2, boolean var3);
    }
}

