/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.FloatMath;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

public class Scroller {
    private static float DECELERATION_RATE = 0.0f;
    private static final int DEFAULT_DURATION = 250;
    private static final float END_TENSION = 1.0f;
    private static final int FLING_MODE = 1;
    private static final float INFLEXION = 0.35f;
    private static final int NB_SAMPLES = 100;
    private static final float P1 = 0.175f;
    private static final float P2 = 0.35000002f;
    private static final int SCROLL_MODE = 0;
    private static final float[] SPLINE_POSITION;
    private static final float[] SPLINE_TIME;
    private static final float START_TENSION = 0.5f;
    private float mCurrVelocity;
    private int mCurrX;
    private int mCurrY;
    private float mDeceleration;
    private float mDeltaX;
    private float mDeltaY;
    private int mDistance;
    private int mDuration;
    private float mDurationReciprocal;
    private int mFinalX;
    private int mFinalY;
    private boolean mFinished;
    private float mFlingFriction;
    private boolean mFlywheel;
    private final Interpolator mInterpolator;
    private int mMaxX;
    private int mMaxY;
    private int mMinX;
    private int mMinY;
    private int mMode;
    private float mPhysicalCoeff;
    private final float mPpi;
    private long mStartTime;
    private int mStartX;
    private int mStartY;
    private float mVelocity;

    /*
     * Enabled aggressive block sorting
     */
    static {
        DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
        SPLINE_POSITION = new float[101];
        SPLINE_TIME = new float[101];
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        block0: while (true) {
            float f3;
            float f4;
            if (n >= 100) {
                float[] fArray = SPLINE_POSITION;
                Scroller.SPLINE_TIME[100] = 1.0f;
                fArray[100] = 1.0f;
                return;
            }
            float f5 = (float)n / 100.0f;
            float f6 = 1.0f;
            while (true) {
                float f7;
                if ((double)Math.abs((f7 = (f4 = 3.0f * (f3 = f + (f6 - f) / 2.0f) * (1.0f - f3)) * (0.175f * (1.0f - f3) + 0.35000002f * f3) + f3 * (f3 * f3)) - f5) < 1.0E-5) break;
                if (f7 > f5) {
                    f6 = f3;
                    continue;
                }
                f = f3;
            }
            Scroller.SPLINE_POSITION[n] = f4 * (f3 + 0.5f * (1.0f - f3)) + f3 * (f3 * f3);
            float f8 = 1.0f;
            while (true) {
                float f9;
                float f10;
                float f11;
                if ((double)Math.abs((f11 = (f10 = 3.0f * (f9 = f2 + (f8 - f2) / 2.0f) * (1.0f - f9)) * (f9 + 0.5f * (1.0f - f9)) + f9 * (f9 * f9)) - f5) < 1.0E-5) {
                    Scroller.SPLINE_TIME[n] = f10 * (0.175f * (1.0f - f9) + 0.35000002f * f9) + f9 * (f9 * f9);
                    ++n;
                    continue block0;
                }
                if (f11 > f5) {
                    f8 = f9;
                    continue;
                }
                f2 = f9;
            }
            break;
        }
    }

    public Scroller(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Scroller(Context context, Interpolator interpolator2) {
        boolean bl = context.getApplicationInfo().targetSdkVersion >= 11;
        this(context, interpolator2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Scroller(Context context, Interpolator interpolator2, boolean bl) {
        this.mFlingFriction = ViewConfiguration.getScrollFriction();
        this.mFinished = true;
        this.mInterpolator = interpolator2 == null ? new ViscousFluidInterpolator() : interpolator2;
        this.mPpi = 160.0f * context.getResources().getDisplayMetrics().density;
        this.mDeceleration = this.computeDeceleration(ViewConfiguration.getScrollFriction());
        this.mFlywheel = bl;
        this.mPhysicalCoeff = this.computeDeceleration(0.84f);
    }

    private float computeDeceleration(float f) {
        return f * (386.0878f * this.mPpi);
    }

    private double getSplineDeceleration(float f) {
        return Math.log(0.35f * Math.abs(f) / (this.mFlingFriction * this.mPhysicalCoeff));
    }

    private double getSplineFlingDistance(float f) {
        double d = this.getSplineDeceleration(f);
        double d2 = (double)DECELERATION_RATE - 1.0;
        return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp(d * ((double)DECELERATION_RATE / d2));
    }

    private int getSplineFlingDuration(float f) {
        return (int)(1000.0 * Math.exp(this.getSplineDeceleration(f) / ((double)DECELERATION_RATE - 1.0)));
    }

    public void abortAnimation() {
        this.mCurrX = this.mFinalX;
        this.mCurrY = this.mFinalY;
        this.mFinished = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int n = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (n >= this.mDuration) {
            this.mCurrX = this.mFinalX;
            this.mCurrY = this.mFinalY;
            this.mFinished = true;
            return true;
        }
        switch (this.mMode) {
            case 0: {
                float f = this.mInterpolator.getInterpolation((float)n * this.mDurationReciprocal);
                this.mCurrX = this.mStartX + Math.round(f * this.mDeltaX);
                this.mCurrY = this.mStartY + Math.round(f * this.mDeltaY);
            }
            default: {
                return true;
            }
            case 1: 
        }
        float f = (float)n / (float)this.mDuration;
        int n2 = (int)(100.0f * f);
        float f2 = 1.0f;
        float f3 = 0.0f;
        if (n2 < 100) {
            float f4 = (float)n2 / 100.0f;
            float f5 = (float)(n2 + 1) / 100.0f;
            float f6 = SPLINE_POSITION[n2];
            f3 = (SPLINE_POSITION[n2 + 1] - f6) / (f5 - f4);
            f2 = f6 + f3 * (f - f4);
        }
        this.mCurrVelocity = 1000.0f * (f3 * (float)this.mDistance / (float)this.mDuration);
        this.mCurrX = this.mStartX + Math.round(f2 * (float)(this.mFinalX - this.mStartX));
        this.mCurrX = Math.min(this.mCurrX, this.mMaxX);
        this.mCurrX = Math.max(this.mCurrX, this.mMinX);
        this.mCurrY = this.mStartY + Math.round(f2 * (float)(this.mFinalY - this.mStartY));
        this.mCurrY = Math.min(this.mCurrY, this.mMaxY);
        this.mCurrY = Math.max(this.mCurrY, this.mMinY);
        if (this.mCurrX != this.mFinalX) return true;
        if (this.mCurrY != this.mFinalY) return true;
        this.mFinished = true;
        return true;
    }

    public void extendDuration(int n) {
        this.mDuration = n + this.timePassed();
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        float f;
        if (this.mFlywheel && !this.mFinished) {
            float f2 = this.getCurrVelocity();
            float f3 = this.mFinalX - this.mStartX;
            float f4 = this.mFinalY - this.mStartY;
            float f5 = FloatMath.sqrt(f3 * f3 + f4 * f4);
            float f6 = f3 / f5;
            float f7 = f4 / f5;
            float f8 = f6 * f2;
            float f9 = f7 * f2;
            if (Math.signum(n3) == Math.signum(f8) && Math.signum(n4) == Math.signum(f9)) {
                n3 = (int)(f8 + (float)n3);
                n4 = (int)(f9 + (float)n4);
            }
        }
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = f = FloatMath.sqrt(n3 * n3 + n4 * n4);
        this.mDuration = this.getSplineFlingDuration(f);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = n;
        this.mStartY = n2;
        float f10 = f == 0.0f ? 1.0f : (float)n3 / f;
        float f11 = f == 0.0f ? 1.0f : (float)n4 / f;
        double d = this.getSplineFlingDistance(f);
        this.mDistance = (int)(d * (double)Math.signum(f));
        this.mMinX = n5;
        this.mMaxX = n6;
        this.mMinY = n7;
        this.mMaxY = n8;
        this.mFinalX = n + (int)Math.round(d * (double)f10);
        this.mFinalX = Math.min(this.mFinalX, this.mMaxX);
        this.mFinalX = Math.max(this.mFinalX, this.mMinX);
        this.mFinalY = n2 + (int)Math.round(d * (double)f11);
        this.mFinalY = Math.min(this.mFinalY, this.mMaxY);
        this.mFinalY = Math.max(this.mFinalY, this.mMinY);
    }

    public final void forceFinished(boolean bl) {
        this.mFinished = bl;
    }

    public float getCurrVelocity() {
        if (this.mMode == 1) {
            return this.mCurrVelocity;
        }
        return this.mVelocity - this.mDeceleration * (float)this.timePassed() / 2000.0f;
    }

    public final int getCurrX() {
        return this.mCurrX;
    }

    public final int getCurrY() {
        return this.mCurrY;
    }

    public final int getDuration() {
        return this.mDuration;
    }

    public final int getFinalX() {
        return this.mFinalX;
    }

    public final int getFinalY() {
        return this.mFinalY;
    }

    public final int getStartX() {
        return this.mStartX;
    }

    public final int getStartY() {
        return this.mStartY;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public boolean isScrollingInDirection(float f, float f2) {
        return !this.mFinished && Math.signum(f) == Math.signum(this.mFinalX - this.mStartX) && Math.signum(f2) == Math.signum(this.mFinalY - this.mStartY);
    }

    public void setFinalX(int n) {
        this.mFinalX = n;
        this.mDeltaX = this.mFinalX - this.mStartX;
        this.mFinished = false;
    }

    public void setFinalY(int n) {
        this.mFinalY = n;
        this.mDeltaY = this.mFinalY - this.mStartY;
        this.mFinished = false;
    }

    public final void setFriction(float f) {
        this.mDeceleration = this.computeDeceleration(f);
        this.mFlingFriction = f;
    }

    public void startScroll(int n, int n2, int n3, int n4) {
        this.startScroll(n, n2, n3, n4, 250);
    }

    public void startScroll(int n, int n2, int n3, int n4, int n5) {
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = n5;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = n;
        this.mStartY = n2;
        this.mFinalX = n + n3;
        this.mFinalY = n2 + n4;
        this.mDeltaX = n3;
        this.mDeltaY = n4;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    static class ViscousFluidInterpolator
    implements Interpolator {
        private static final float VISCOUS_FLUID_NORMALIZE = 0.0f;
        private static final float VISCOUS_FLUID_OFFSET = 0.0f;
        private static final float VISCOUS_FLUID_SCALE = 8.0f;

        static {
            VISCOUS_FLUID_NORMALIZE = 1.0f / ViscousFluidInterpolator.viscousFluid(1.0f);
            VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(1.0f);
        }

        ViscousFluidInterpolator() {
        }

        private static float viscousFluid(float f) {
            float f2 = f * 8.0f;
            if (f2 < 1.0f) {
                return f2 - (1.0f - (float)Math.exp(-f2));
            }
            return 0.36787945f + (1.0f - (float)Math.exp(1.0f - f2)) * (1.0f - 0.36787945f);
        }

        @Override
        public float getInterpolation(float f) {
            float f2 = VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(f);
            if (f2 > 0.0f) {
                f2 += VISCOUS_FLUID_OFFSET;
            }
            return f2;
        }
    }
}

