/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.DatePickerController;
import android.widget.SimpleMonthView;
import java.util.Calendar;
import java.util.HashMap;

class SimpleMonthAdapter
extends BaseAdapter
implements SimpleMonthView.OnDayClickListener {
    private static final String TAG = "SimpleMonthAdapter";
    private ColorStateList mCalendarTextColors;
    private final Context mContext;
    private final DatePickerController mController;
    private Calendar mSelectedDay;

    public SimpleMonthAdapter(Context context, DatePickerController datePickerController) {
        this.mContext = context;
        this.mController = datePickerController;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
    }

    private boolean isSelectedDayInMonth(int n, int n2) {
        return this.mSelectedDay.get(1) == n && this.mSelectedDay.get(2) == n2;
    }

    @Override
    public int getCount() {
        int n = this.mController.getMaxYear() - this.mController.getMinYear();
        return 1 + this.mController.getMaxMonth() - this.mController.getMinMonth() + n * 12;
    }

    @Override
    public Object getItem(int n) {
        return null;
    }

    @Override
    public long getItemId(int n) {
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        HashMap hashMap;
        SimpleMonthView simpleMonthView;
        if (view != null) {
            simpleMonthView = (SimpleMonthView)view;
            hashMap = (HashMap)simpleMonthView.getTag();
        } else {
            simpleMonthView = new SimpleMonthView(this.mContext);
            simpleMonthView.setLayoutParams(new AbsListView.LayoutParams(-1, -1));
            simpleMonthView.setClickable(true);
            simpleMonthView.setOnDayClickListener(this);
            ColorStateList colorStateList = this.mCalendarTextColors;
            hashMap = null;
            if (colorStateList != null) {
                simpleMonthView.setTextColor(this.mCalendarTextColors);
                hashMap = null;
            }
        }
        if (hashMap == null) {
            new HashMap();
        } else {
            hashMap.clear();
        }
        int n2 = n + this.mController.getMinMonth();
        int n3 = n2 % 12;
        int n4 = n2 / 12 + this.mController.getMinYear();
        int n5 = -1;
        if (this.isSelectedDayInMonth(n4, n3)) {
            n5 = this.mSelectedDay.get(5);
        }
        simpleMonthView.reuse();
        int n6 = this.mController.getMinMonth() == n3 && this.mController.getMinYear() == n4 ? this.mController.getMinDay() : 1;
        int n7 = this.mController.getMaxMonth() == n3 && this.mController.getMaxYear() == n4 ? this.mController.getMaxDay() : 31;
        simpleMonthView.setMonthParams(n5, n3, n4, this.mController.getFirstDayOfWeek(), n6, n7);
        simpleMonthView.invalidate();
        return simpleMonthView;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    protected void init() {
        this.mSelectedDay = Calendar.getInstance();
    }

    @Override
    public void onDayClick(SimpleMonthView simpleMonthView, Calendar calendar) {
        if (calendar != null) {
            this.onDayTapped(calendar);
        }
    }

    protected void onDayTapped(Calendar calendar) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(calendar.get(1), calendar.get(2), calendar.get(5));
        this.setSelectedDay(calendar);
    }

    void setCalendarTextColor(ColorStateList colorStateList) {
        this.mCalendarTextColors = colorStateList;
    }

    public void setSelectedDay(Calendar calendar) {
        if (this.mSelectedDay != calendar) {
            this.mSelectedDay = calendar;
            this.notifyDataSetChanged();
        }
    }
}

