/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.CursorAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class AlertController {
    private ListAdapter mAdapter;
    private int mAlertDialogLayout;
    private final View.OnClickListener mButtonHandler = new View.OnClickListener(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onClick(View view) {
            Message message = view == AlertController.this.mButtonPositive && AlertController.this.mButtonPositiveMessage != null ? Message.obtain(AlertController.this.mButtonPositiveMessage) : (view == AlertController.this.mButtonNegative && AlertController.this.mButtonNegativeMessage != null ? Message.obtain(AlertController.this.mButtonNegativeMessage) : (view == AlertController.this.mButtonNeutral && AlertController.this.mButtonNeutralMessage != null ? Message.obtain(AlertController.this.mButtonNeutralMessage) : null));
            if (message != null) {
                message.sendToTarget();
            }
            AlertController.this.mHandler.obtainMessage(1, AlertController.this.mDialogInterface).sendToTarget();
        }
    };
    private Button mButtonNegative;
    private Message mButtonNegativeMessage;
    private CharSequence mButtonNegativeText;
    private Button mButtonNeutral;
    private Message mButtonNeutralMessage;
    private CharSequence mButtonNeutralText;
    private int mButtonPanelLayoutHint = 0;
    private int mButtonPanelSideLayout;
    private Button mButtonPositive;
    private Message mButtonPositiveMessage;
    private CharSequence mButtonPositiveText;
    private int mCheckedItem = -1;
    private final Context mContext;
    private View mCustomTitleView;
    private final DialogInterface mDialogInterface;
    private boolean mDoShowMessageView = false;
    private boolean mForceInverseBackground;
    private Handler mHandler;
    private Drawable mIcon;
    private int mIconId = 0;
    private ImageView mIconView;
    private int mListItemLayout;
    private int mListLayout;
    private ListView mListView;
    private CharSequence mMessage;
    private TextView mMessageView;
    private int mMultiChoiceItemLayout;
    private ScrollView mScrollView;
    private int mSingleChoiceItemLayout;
    private CharSequence mTitle;
    private TextView mTitleView;
    private View mView;
    private int mViewLayoutResId;
    private int mViewSpacingBottom;
    private int mViewSpacingLeft;
    private int mViewSpacingRight;
    private boolean mViewSpacingSpecified = false;
    private int mViewSpacingTop;
    private final Window mWindow;

    public AlertController(Context context, DialogInterface dialogInterface, Window window) {
        this.mContext = context;
        this.mDialogInterface = dialogInterface;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(dialogInterface);
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        this.mAlertDialogLayout = typedArray.getResourceId(10, 17367078);
        this.mButtonPanelSideLayout = typedArray.getResourceId(11, 0);
        this.mListLayout = typedArray.getResourceId(12, 17367260);
        this.mMultiChoiceItemLayout = typedArray.getResourceId(13, 17367059);
        this.mSingleChoiceItemLayout = typedArray.getResourceId(14, 17367058);
        this.mListItemLayout = typedArray.getResourceId(15, 0x1090011);
        typedArray.recycle();
        this.mDoShowMessageView = false;
    }

    static /* synthetic */ ListAdapter access$1302(AlertController alertController, ListAdapter listAdapter) {
        alertController.mAdapter = listAdapter;
        return listAdapter;
    }

    static /* synthetic */ int access$1402(AlertController alertController, int n) {
        alertController.mCheckedItem = n;
        return n;
    }

    static /* synthetic */ ListView access$1502(AlertController alertController, ListView listView) {
        alertController.mListView = listView;
        return listView;
    }

    static boolean canTextInput(View view) {
        if (view.onCheckIsTextEditor()) {
            return true;
        }
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        while (n > 0) {
            if (!AlertController.canTextInput(viewGroup.getChildAt(--n))) continue;
            return true;
        }
        return false;
    }

    private void centerButton(Button button) {
        View view;
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)button.getLayoutParams();
        layoutParams.gravity = 1;
        layoutParams.weight = 0.5f;
        button.setLayoutParams(layoutParams);
        View view2 = this.mWindow.findViewById(16909015);
        if (view2 != null) {
            view2.setVisibility(0);
        }
        if ((view = this.mWindow.findViewById(16909016)) != null) {
            view.setVisibility(0);
        }
    }

    private int selectContentView() {
        if (this.mButtonPanelSideLayout == 0) {
            return this.mAlertDialogLayout;
        }
        if (this.mButtonPanelLayoutHint == 1) {
            return this.mButtonPanelSideLayout;
        }
        return this.mAlertDialogLayout;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBackground(TypedArray typedArray, View view, View view2, View view3, View view4, boolean bl, boolean bl2, boolean bl3) {
        ListView listView;
        int n;
        boolean bl4 = typedArray.getBoolean(18, true);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (bl4) {
            n8 = 17303097;
            n10 = 17303111;
            n6 = 17303094;
            n3 = 17303091;
            n7 = 17303096;
            n9 = 17303110;
            n5 = 17303093;
            n2 = 17303090;
            n4 = 17303092;
        }
        int n11 = typedArray.getResourceId(5, n9);
        int n12 = typedArray.getResourceId(1, n10);
        int n13 = typedArray.getResourceId(6, n5);
        int n14 = typedArray.getResourceId(2, n6);
        View[] viewArray = new View[4];
        boolean[] blArray = new boolean[4];
        View view5 = null;
        boolean bl5 = false;
        int n15 = 0;
        if (bl) {
            viewArray[0] = view;
            blArray[0] = false;
            n15 = 0 + 1;
        }
        if (view2.getVisibility() == 8) {
            view2 = null;
        }
        viewArray[n15] = view2;
        boolean bl6 = this.mListView != null;
        blArray[n15] = bl6;
        int n16 = n15 + 1;
        if (bl2) {
            viewArray[n16] = view3;
            blArray[n16] = this.mForceInverseBackground;
            ++n16;
        }
        if (bl3) {
            viewArray[n16] = view4;
            blArray[n16] = true;
        }
        boolean bl7 = false;
        for (int i = 0; i < (n = viewArray.length); ++i) {
            View view6 = viewArray[i];
            if (view6 == null) continue;
            if (view5 != null) {
                if (!bl7) {
                    int n17 = bl5 ? n11 : n12;
                    view5.setBackgroundResource(n17);
                } else {
                    int n18 = bl5 ? n13 : n14;
                    view5.setBackgroundResource(n18);
                }
                bl7 = true;
            }
            view5 = view6;
            bl5 = blArray[i];
        }
        if (view5 != null) {
            if (bl7) {
                int n19 = typedArray.getResourceId(7, n2);
                int n20 = typedArray.getResourceId(8, n4);
                int n21 = typedArray.getResourceId(3, n3);
                int n22 = bl5 ? (bl3 ? n20 : n19) : n21;
                view5.setBackgroundResource(n22);
            } else {
                int n23 = typedArray.getResourceId(4, n7);
                int n24 = typedArray.getResourceId(0, n8);
                int n25 = bl5 ? n23 : n24;
                view5.setBackgroundResource(n25);
            }
        }
        if ((listView = this.mListView) != null && this.mAdapter != null) {
            listView.setAdapter(this.mAdapter);
            int n26 = this.mCheckedItem;
            if (n26 > -1) {
                listView.setItemChecked(n26, true);
                listView.setSelection(n26);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupButtons() {
        int n = 0;
        this.mButtonPositive = (Button)this.mWindow.findViewById(16908313);
        this.mButtonPositive.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonPositiveText)) {
            this.mButtonPositive.setVisibility(8);
        } else {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setVisibility(0);
            n = 0 | 1;
        }
        this.mButtonNegative = (Button)this.mWindow.findViewById(16908314);
        this.mButtonNegative.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNegativeText)) {
            this.mButtonNegative.setVisibility(8);
        } else {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setVisibility(0);
            n |= 2;
        }
        this.mButtonNeutral = (Button)this.mWindow.findViewById(16908315);
        this.mButtonNeutral.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNeutralText)) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setVisibility(0);
            n |= 4;
        }
        if (!AlertController.shouldCenterSingleButton(this.mContext)) return n != 0;
        if (n == 1) {
            this.centerButton(this.mButtonPositive);
            return n != 0;
        } else if (n == 2) {
            this.centerButton(this.mButtonNegative);
            return n != 0;
        } else {
            if (n != 4) return n != 0;
            this.centerButton(this.mButtonNeutral);
        }
        return n != 0;
    }

    private void setupContent(LinearLayout linearLayout) {
        this.mScrollView = (ScrollView)this.mWindow.findViewById(16909018);
        this.mScrollView.setFocusable(false);
        this.mMessageView = (TextView)this.mWindow.findViewById(16908299);
        if (this.mMessageView == null) {
            return;
        }
        if (this.mDoShowMessageView && this.mMessage != null) {
            this.mMessageView.setText(this.mMessage);
            if (this.mListView != null) {
                linearLayout.addView((View)this.mListView, new LinearLayout.LayoutParams(-1, -1));
                linearLayout.setLayoutParams(new LinearLayout.LayoutParams(-1, 0, 1.0f));
                this.mScrollView.setVisibility(8);
                return;
            }
            this.mScrollView.setVisibility(0);
            return;
        }
        if (this.mMessage != null) {
            this.mMessageView.setText(this.mMessage);
            return;
        }
        this.mMessageView.setVisibility(8);
        this.mScrollView.removeView(this.mMessageView);
        if (this.mListView != null) {
            linearLayout.removeView(this.mWindow.findViewById(16909018));
            linearLayout.addView((View)this.mListView, new LinearLayout.LayoutParams(-1, -1));
            linearLayout.setLayoutParams(new LinearLayout.LayoutParams(-1, 0, 1.0f));
            return;
        }
        linearLayout.setVisibility(8);
    }

    private void setupDecor() {
        View view = this.mWindow.getDecorView();
        final View view2 = this.mWindow.findViewById(16909009);
        if (view2 != null && view != null) {
            view.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                @Override
                public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
                    if (windowInsets.isRound()) {
                        int n = AlertController.this.mContext.getResources().getDimensionPixelOffset(17104947);
                        view2.setPadding(n, n, n, n);
                    }
                    return windowInsets.consumeSystemWindowInsets();
                }
            });
            view.setFitsSystemWindows(true);
            view.requestApplyInsets();
        }
    }

    private boolean setupTitle(LinearLayout linearLayout) {
        if (this.mCustomTitleView != null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            linearLayout.addView(this.mCustomTitleView, 0, layoutParams);
            this.mWindow.findViewById(16909011).setVisibility(8);
            return true;
        }
        this.mIconView = (ImageView)this.mWindow.findViewById(16908294);
        boolean bl = TextUtils.isEmpty(this.mTitle);
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        if (bl2) {
            this.mTitleView = (TextView)this.mWindow.findViewById(16909012);
            this.mTitleView.setText(this.mTitle);
            if (this.mIconId != 0) {
                this.mIconView.setImageResource(this.mIconId);
                return true;
            }
            if (this.mIcon != null) {
                this.mIconView.setImageDrawable(this.mIcon);
                return true;
            }
            this.mTitleView.setPadding(this.mIconView.getPaddingLeft(), this.mIconView.getPaddingTop(), this.mIconView.getPaddingRight(), this.mIconView.getPaddingBottom());
            this.mIconView.setVisibility(8);
            return true;
        }
        this.mWindow.findViewById(16909011).setVisibility(8);
        this.mIconView.setVisibility(8);
        linearLayout.setVisibility(8);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupView() {
        View view;
        LinearLayout linearLayout = (LinearLayout)this.mWindow.findViewById(16909017);
        this.setupContent(linearLayout);
        boolean bl = this.setupButtons();
        LinearLayout linearLayout2 = (LinearLayout)this.mWindow.findViewById(16909010);
        TypedArray typedArray = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        boolean bl2 = this.setupTitle(linearLayout2);
        View view2 = this.mWindow.findViewById(16909014);
        if (!bl) {
            view2.setVisibility(8);
            View view3 = this.mWindow.findViewById(16909022);
            if (view3 != null) {
                view3.setVisibility(0);
            }
            this.mWindow.setCloseOnTouchOutsideIfNotSet(true);
        }
        FrameLayout frameLayout = (FrameLayout)this.mWindow.findViewById(16909019);
        View view4 = this.mView != null ? this.mView : (this.mViewLayoutResId != 0 ? LayoutInflater.from(this.mContext).inflate(this.mViewLayoutResId, (ViewGroup)frameLayout, false) : null);
        boolean bl3 = view4 != null;
        if (!bl3 || !AlertController.canTextInput(view4)) {
            this.mWindow.setFlags(131072, 131072);
        }
        if (bl3) {
            FrameLayout frameLayout2 = (FrameLayout)this.mWindow.findViewById(16908331);
            frameLayout2.addView(view4, new ViewGroup.LayoutParams(-1, -1));
            if (this.mViewSpacingSpecified) {
                frameLayout2.setPadding(this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
            }
            if (this.mListView != null) {
                ((LinearLayout.LayoutParams)frameLayout.getLayoutParams()).weight = 0.0f;
            }
        } else {
            frameLayout.setVisibility(8);
        }
        if (bl2 && (view = this.mMessage != null || view4 != null || this.mListView != null ? this.mWindow.findViewById(16909013) : this.mWindow.findViewById(16909020)) != null) {
            view.setVisibility(0);
        }
        this.setBackground(typedArray, linearLayout2, linearLayout, frameLayout, view2, bl2, bl3, bl);
        typedArray.recycle();
    }

    private static boolean shouldCenterSingleButton(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16843803, typedValue, true);
        return typedValue.data != 0;
    }

    public Button getButton(int n) {
        switch (n) {
            default: {
                return null;
            }
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: 
        }
        return this.mButtonNeutral;
    }

    public int getIconAttributeResId(int n) {
        TypedValue typedValue = new TypedValue();
        this.mContext.getTheme().resolveAttribute(n, typedValue, true);
        return typedValue.resourceId;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public ScrollView getScrollView() {
        return this.mScrollView;
    }

    public void installContent() {
        this.mWindow.requestFeature(1);
        int n = this.selectContentView();
        this.mWindow.setContentView(n);
        this.setupView();
        this.setupDecor();
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(keyEvent);
    }

    public void setButton(int n, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message) {
        if (message == null && onClickListener != null) {
            message = this.mHandler.obtainMessage(n, onClickListener);
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
            case -1: {
                this.mButtonPositiveText = charSequence;
                this.mButtonPositiveMessage = message;
                return;
            }
            case -2: {
                this.mButtonNegativeText = charSequence;
                this.mButtonNegativeMessage = message;
                return;
            }
            case -3: 
        }
        this.mButtonNeutralText = charSequence;
        this.mButtonNeutralMessage = message;
    }

    public void setButtonPanelLayoutHint(int n) {
        this.mButtonPanelLayoutHint = n;
    }

    public void setCustomTitle(View view) {
        this.mCustomTitleView = view;
    }

    public void setDoShowMessage(boolean bl) {
        this.mDoShowMessageView = bl;
    }

    public void setIcon(int n) {
        block3: {
            block2: {
                this.mIcon = null;
                this.mIconId = n;
                if (this.mIconView == null) break block2;
                if (n == 0) break block3;
                this.mIconView.setImageResource(this.mIconId);
            }
            return;
        }
        this.mIconView.setVisibility(8);
    }

    public void setIcon(Drawable drawable2) {
        block3: {
            block2: {
                this.mIcon = drawable2;
                this.mIconId = 0;
                if (this.mIconView == null) break block2;
                if (drawable2 == null) break block3;
                this.mIconView.setImageDrawable(drawable2);
            }
            return;
        }
        this.mIconView.setVisibility(8);
    }

    public void setInverseBackgroundForced(boolean bl) {
        this.mForceInverseBackground = bl;
    }

    public void setMessage(CharSequence charSequence) {
        this.mMessage = charSequence;
        if (this.mMessageView != null) {
            this.mMessageView.setText(charSequence);
        }
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        if (this.mTitleView != null) {
            this.mTitleView.setText(charSequence);
        }
    }

    public void setView(int n) {
        this.mView = null;
        this.mViewLayoutResId = n;
        this.mViewSpacingSpecified = false;
    }

    public void setView(View view) {
        this.mView = view;
        this.mViewLayoutResId = 0;
        this.mViewSpacingSpecified = false;
    }

    public void setView(View view, int n, int n2, int n3, int n4) {
        this.mView = view;
        this.mViewLayoutResId = 0;
        this.mViewSpacingSpecified = true;
        this.mViewSpacingLeft = n;
        this.mViewSpacingTop = n2;
        this.mViewSpacingRight = n3;
        this.mViewSpacingBottom = n4;
    }

    public static class AlertParams {
        public ListAdapter mAdapter;
        public boolean mCancelable;
        public int mCheckedItem = -1;
        public boolean[] mCheckedItems;
        public final Context mContext;
        public Cursor mCursor;
        public View mCustomTitleView;
        public boolean mForceInverseBackground;
        public Drawable mIcon;
        public int mIconAttrId = 0;
        public int mIconId = 0;
        public final LayoutInflater mInflater;
        public String mIsCheckedColumn;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public CharSequence[] mItems;
        public String mLabelColumn;
        public CharSequence mMessage;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public DialogInterface.OnClickListener mOnClickListener;
        public DialogInterface.OnDismissListener mOnDismissListener;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public OnPrepareListViewListener mOnPrepareListViewListener;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mPositiveButtonText;
        public boolean mRecycleOnMeasure = true;
        public CharSequence mTitle;
        public View mView;
        public int mViewLayoutResId;
        public int mViewSpacingBottom;
        public int mViewSpacingLeft;
        public int mViewSpacingRight;
        public boolean mViewSpacingSpecified = false;
        public int mViewSpacingTop;

        public AlertParams(Context context) {
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        /*
         * Enabled aggressive block sorting
         */
        private void createListView(final AlertController alertController) {
            ListAdapter listAdapter;
            final RecycleListView recycleListView = (RecycleListView)this.mInflater.inflate(alertController.mListLayout, null);
            if (this.mIsMultiChoice) {
                if (this.mCursor == null) {
                    listAdapter = new ArrayAdapter<CharSequence>(this.mContext, alertController.mMultiChoiceItemLayout, 16908308, this.mItems){

                        @Override
                        public View getView(int n, View view, ViewGroup viewGroup) {
                            View view2 = super.getView(n, view, viewGroup);
                            if (AlertParams.this.mCheckedItems != null && AlertParams.this.mCheckedItems[n]) {
                                recycleListView.setItemChecked(n, true);
                            }
                            return view2;
                        }
                    };
                } else {
                    Context context = this.mContext;
                    Cursor cursor = this.mCursor;
                    listAdapter = new CursorAdapter(context, cursor, false){
                        private final int mIsCheckedIndex;
                        private final int mLabelIndex;
                        {
                            super(context, cursor, bl);
                            Cursor cursor2 = this.getCursor();
                            this.mLabelIndex = cursor2.getColumnIndexOrThrow(AlertParams.this.mLabelColumn);
                            this.mIsCheckedIndex = cursor2.getColumnIndexOrThrow(AlertParams.this.mIsCheckedColumn);
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        @Override
                        public void bindView(View view, Context context, Cursor cursor) {
                            int n = 1;
                            ((CheckedTextView)view.findViewById(16908308)).setText(cursor.getString(this.mLabelIndex));
                            RecycleListView recycleListView2 = recycleListView;
                            int n2 = cursor.getPosition();
                            if (cursor.getInt(this.mIsCheckedIndex) != n) {
                                n = 0;
                            }
                            recycleListView2.setItemChecked(n2, n != 0);
                        }

                        @Override
                        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
                            return AlertParams.this.mInflater.inflate(alertController.mMultiChoiceItemLayout, viewGroup, false);
                        }
                    };
                }
            } else {
                int n = this.mIsSingleChoice ? alertController.mSingleChoiceItemLayout : alertController.mListItemLayout;
                if (this.mCursor == null) {
                    listAdapter = this.mAdapter != null ? this.mAdapter : new CheckedItemAdapter(this.mContext, n, 16908308, this.mItems);
                } else {
                    Context context = this.mContext;
                    Cursor cursor = this.mCursor;
                    String[] stringArray = new String[]{this.mLabelColumn};
                    listAdapter = new SimpleCursorAdapter(context, n, cursor, stringArray, new int[]{16908308});
                }
            }
            if (this.mOnPrepareListViewListener != null) {
                this.mOnPrepareListViewListener.onPrepareListView(recycleListView);
            }
            AlertController.access$1302(alertController, listAdapter);
            AlertController.access$1402(alertController, this.mCheckedItem);
            if (this.mOnClickListener != null) {
                recycleListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        AlertParams.this.mOnClickListener.onClick(alertController.mDialogInterface, n);
                        if (!AlertParams.this.mIsSingleChoice) {
                            alertController.mDialogInterface.dismiss();
                        }
                    }
                });
            } else if (this.mOnCheckboxClickListener != null) {
                recycleListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        if (AlertParams.this.mCheckedItems != null) {
                            AlertParams.this.mCheckedItems[n] = recycleListView.isItemChecked(n);
                        }
                        AlertParams.this.mOnCheckboxClickListener.onClick(alertController.mDialogInterface, n, recycleListView.isItemChecked(n));
                    }
                });
            }
            if (this.mOnItemSelectedListener != null) {
                recycleListView.setOnItemSelectedListener(this.mOnItemSelectedListener);
            }
            if (this.mIsSingleChoice) {
                recycleListView.setChoiceMode(1);
            } else if (this.mIsMultiChoice) {
                recycleListView.setChoiceMode(2);
            }
            recycleListView.mRecycleOnMeasure = this.mRecycleOnMeasure;
            AlertController.access$1502(alertController, recycleListView);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void apply(AlertController alertController) {
            if (this.mCustomTitleView != null) {
                alertController.setCustomTitle(this.mCustomTitleView);
            } else {
                if (this.mTitle != null) {
                    alertController.setTitle(this.mTitle);
                }
                if (this.mIcon != null) {
                    alertController.setIcon(this.mIcon);
                }
                if (this.mIconId >= 0) {
                    alertController.setIcon(this.mIconId);
                }
                if (this.mIconAttrId > 0) {
                    alertController.setIcon(alertController.getIconAttributeResId(this.mIconAttrId));
                }
            }
            if (this.mMessage != null) {
                alertController.setMessage(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                alertController.setButton(-1, this.mPositiveButtonText, this.mPositiveButtonListener, null);
            }
            if (this.mNegativeButtonText != null) {
                alertController.setButton(-2, this.mNegativeButtonText, this.mNegativeButtonListener, null);
            }
            if (this.mNeutralButtonText != null) {
                alertController.setButton(-3, this.mNeutralButtonText, this.mNeutralButtonListener, null);
            }
            if (this.mForceInverseBackground) {
                alertController.setInverseBackgroundForced(true);
            }
            if (this.mItems != null || this.mCursor != null || this.mAdapter != null) {
                this.createListView(alertController);
            }
            if (this.mView != null) {
                if (!this.mViewSpacingSpecified) {
                    alertController.setView(this.mView);
                    return;
                }
                alertController.setView(this.mView, this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
                return;
            } else {
                if (this.mViewLayoutResId == 0) return;
                alertController.setView(this.mViewLayoutResId);
                return;
            }
        }

        public static interface OnPrepareListViewListener {
            public void onPrepareListView(ListView var1);
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        public ButtonHandler(DialogInterface dialogInterface) {
            this.mDialog = new WeakReference<DialogInterface>(dialogInterface);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)message.obj).onClick((DialogInterface)this.mDialog.get(), message.what);
                    return;
                }
                case 1: 
            }
            ((DialogInterface)message.obj).dismiss();
        }
    }

    private static class CheckedItemAdapter
    extends ArrayAdapter<CharSequence> {
        public CheckedItemAdapter(Context context, int n, int n2, CharSequence[] charSequenceArray) {
            super(context, n, n2, charSequenceArray);
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        @Override
        public boolean hasStableIds() {
            return true;
        }
    }

    public static class RecycleListView
    extends ListView {
        boolean mRecycleOnMeasure = true;

        public RecycleListView(Context context) {
            super(context);
        }

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public RecycleListView(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        public RecycleListView(Context context, AttributeSet attributeSet, int n, int n2) {
            super(context, attributeSet, n, n2);
        }

        @Override
        protected boolean recycleOnMeasure() {
            return this.mRecycleOnMeasure;
        }
    }
}

