/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.android.internal.app.MediaRouteChooserDialog;

public class MediaRouteChooserDialogFragment
extends DialogFragment {
    private final String ARGUMENT_ROUTE_TYPES;
    private View.OnClickListener mExtendedSettingsClickListener;

    public MediaRouteChooserDialogFragment() {
        this.ARGUMENT_ROUTE_TYPES = "routeTypes";
        this.setCancelable(true);
        this.setStyle(0, 16974126);
    }

    public int getRouteTypes() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            return bundle.getInt("routeTypes");
        }
        return 0;
    }

    public MediaRouteChooserDialog onCreateChooserDialog(Context context, Bundle bundle) {
        return new MediaRouteChooserDialog(context, this.getTheme());
    }

    @Override
    public Dialog onCreateDialog(Bundle bundle) {
        MediaRouteChooserDialog mediaRouteChooserDialog = this.onCreateChooserDialog(this.getActivity(), bundle);
        mediaRouteChooserDialog.setRouteTypes(this.getRouteTypes());
        mediaRouteChooserDialog.setExtendedSettingsClickListener(this.mExtendedSettingsClickListener);
        return mediaRouteChooserDialog;
    }

    public void setExtendedSettingsClickListener(View.OnClickListener onClickListener) {
        if (onClickListener != this.mExtendedSettingsClickListener) {
            this.mExtendedSettingsClickListener = onClickListener;
            MediaRouteChooserDialog mediaRouteChooserDialog = (MediaRouteChooserDialog)this.getDialog();
            if (mediaRouteChooserDialog != null) {
                mediaRouteChooserDialog.setExtendedSettingsClickListener(onClickListener);
            }
        }
    }

    public void setRouteTypes(int n) {
        if (n != this.getRouteTypes()) {
            Bundle bundle = this.getArguments();
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putInt("routeTypes", n);
            this.setArguments(bundle);
            MediaRouteChooserDialog mediaRouteChooserDialog = (MediaRouteChooserDialog)this.getDialog();
            if (mediaRouteChooserDialog != null) {
                mediaRouteChooserDialog.setRouteTypes(n);
            }
        }
    }
}

