/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.net.NetworkStats;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ProcFileReader;
import com.android.server.NetworkManagementSocketTagger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Objects;
import libcore.io.IoUtils;

public class NetworkStatsFactory {
    private static final boolean SANITY_CHECK_NATIVE = false;
    private static final String TAG = "NetworkStatsFactory";
    private static final boolean USE_NATIVE_PARSING = true;
    @GuardedBy(value="sStackedIfaces")
    private static final ArrayMap<String, String> sStackedIfaces = new ArrayMap();
    private final File mStatsXtIfaceAll;
    private final File mStatsXtIfaceFmt;
    private final File mStatsXtUid;

    public NetworkStatsFactory() {
        this(new File("/proc/"));
    }

    public NetworkStatsFactory(File file) {
        this.mStatsXtIfaceAll = new File(file, "net/xt_qtaguid/iface_stat_all");
        this.mStatsXtIfaceFmt = new File(file, "net/xt_qtaguid/iface_stat_fmt");
        this.mStatsXtUid = new File(file, "net/xt_qtaguid/stats");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkStats javaReadNetworkStatsDetail(File var0, int var1_1, String[] var2_2, int var3_3) throws IOException {
        var4_4 = StrictMode.allowThreadDiskReads();
        var5_5 = new NetworkStats(SystemClock.elapsedRealtime(), 24);
        var6_6 = new NetworkStats.Entry();
        var7_7 = 1;
        var8_8 = 1;
        var9_9 = null;
        var10_10 = new ProcFileReader(new FileInputStream(var0));
        try {
            var10_10.finishLine();
            while (var10_10.hasMoreData()) {
                var7_7 = var10_10.nextInt();
                if (var7_7 != var8_8 + 1) {
                    throw new ProtocolException("inconsistent idx=" + var7_7 + " after lastIdx=" + var8_8);
                }
                var8_8 = var7_7;
                var6_6.iface = var10_10.nextString();
                var6_6.tag = NetworkManagementSocketTagger.kernelToTag(var10_10.nextString());
                var6_6.uid = var10_10.nextInt();
                var6_6.set = var10_10.nextInt();
                var6_6.rxBytes = var10_10.nextLong();
                var6_6.rxPackets = var10_10.nextLong();
                var6_6.txBytes = var10_10.nextLong();
                var6_6.txPackets = var10_10.nextLong();
                if (!(var2_2 != null && !ArrayUtils.contains(var2_2, var6_6.iface) || var1_1 != -1 && var1_1 != var6_6.uid || var3_3 != -1 && var3_3 != var6_6.tag)) {
                    var5_5.addValues(var6_6);
                }
                var10_10.finishLine();
            }
            ** GOTO lbl36
        }
        catch (NullPointerException var13_11) {
            var9_9 = var10_10;
            ** GOTO lbl42
            catch (NumberFormatException var12_17) {
                var9_9 = var10_10;
                throw new ProtocolException("problem parsing idx " + var7_7, (Throwable)var12_18);
lbl36:
                // 1 sources

                IoUtils.closeQuietly((AutoCloseable)var10_10);
                StrictMode.setThreadPolicy(var4_4);
                return var5_5;
                catch (Throwable var11_16) {
                    var9_9 = var10_10;
                    ** GOTO lbl-1000
                }
lbl42:
                // 2 sources

                while (true) {
                    try {
                        throw new ProtocolException("problem parsing idx " + var7_7, (Throwable)var13_12);
                    }
                    catch (Throwable var11_14) {}
                    ** GOTO lbl-1000
                    break;
                }
                catch (NumberFormatException var12_19) {
                    var9_9 = null;
                }
                {
                    throw new ProtocolException("problem parsing idx " + var7_7, (Throwable)var12_18);
                }
                catch (NullPointerException var13_13) {
                    var9_9 = null;
                    ** continue;
                }
lbl-1000:
                // 2 sources

                {
                    IoUtils.closeQuietly(var9_9);
                    StrictMode.setThreadPolicy(var4_4);
                    throw var11_15;
                }
            }
        }
    }

    public static native int nativeReadNetworkStatsDetail(NetworkStats var0, String var1, int var2, String[] var3, int var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void noteStackedIface(String string2, String string3) {
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            if (string3 != null) {
                sStackedIfaces.put(string2, string3);
            } else {
                sStackedIfaces.remove(string2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private NetworkStats readNetworkStatsDetailInternal(int n, String[] stringArray, int n2, NetworkStats networkStats) throws IOException {
        NetworkStats networkStats2;
        if (networkStats != null) {
            networkStats2 = networkStats;
            networkStats2.setElapsedRealtime(SystemClock.elapsedRealtime());
        } else {
            networkStats2 = new NetworkStats(SystemClock.elapsedRealtime(), -1);
        }
        if (NetworkStatsFactory.nativeReadNetworkStatsDetail(networkStats2, this.mStatsXtUid.getAbsolutePath(), n, stringArray, n2) != 0) {
            throw new IOException("Failed to parse network stats");
        }
        return networkStats2;
    }

    public void assertEquals(NetworkStats networkStats, NetworkStats networkStats2) {
        if (networkStats.size() != networkStats2.size()) {
            throw new AssertionError((Object)("Expected size " + networkStats.size() + ", actual size " + networkStats2.size()));
        }
        NetworkStats.Entry entry = null;
        NetworkStats.Entry entry2 = null;
        for (int i = 0; i < networkStats.size(); ++i) {
            if (!(entry = networkStats.getValues(i, entry)).equals(entry2 = networkStats2.getValues(i, entry2))) {
                throw new AssertionError((Object)("Expected row " + i + ": " + entry + ", actual row " + entry2));
            }
        }
    }

    public NetworkStats readNetworkStatsDetail() throws IOException {
        return this.readNetworkStatsDetail(-1, null, -1, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkStats readNetworkStatsDetail(int n, String[] stringArray, int n2, NetworkStats networkStats) throws IOException {
        NetworkStats networkStats2 = this.readNetworkStatsDetailInternal(n, stringArray, n2, networkStats);
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            int n3 = sStackedIfaces.size();
            int n4 = 0;
            block4: while (true) {
                if (n4 >= n3) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 9] lbl8 : MonitorExitStatement: MONITOREXIT : var6_6
                    NetworkStats.Entry entry = null;
                    int n5 = 0;
                    while (true) {
                        int n6;
                        if (n5 >= (n6 = networkStats2.size())) {
                            return networkStats2;
                        }
                        entry = networkStats2.getValues(n5, entry);
                        if (entry.iface != null && entry.iface.startsWith("clat")) {
                            entry.rxBytes = 20L * entry.rxPackets;
                            entry.rxPackets = 0L;
                            entry.txBytes = 0L;
                            entry.txPackets = 0L;
                            networkStats2.combineValues(entry);
                        }
                        ++n5;
                    }
                }
                String string2 = sStackedIfaces.keyAt(n4);
                NetworkStats.Entry entry = new NetworkStats.Entry(sStackedIfaces.valueAt(n4), 0, 0, 0, 0L, 0L, 0L, 0L, 0L);
                NetworkStats.Entry entry2 = null;
                int n7 = 0;
                while (true) {
                    int n8;
                    if (n7 < (n8 = networkStats2.size())) {
                        entry2 = networkStats2.getValues(n7, entry2);
                        if (Objects.equals(entry2.iface, string2)) {
                            entry.txBytes -= entry2.txBytes;
                            entry.txPackets -= entry2.txPackets;
                        }
                    } else {
                        networkStats2.combineValues(entry);
                        ++n4;
                        continue block4;
                    }
                    ++n7;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkStats readNetworkStatsSummaryDev() throws IOException {
        var1_1 = StrictMode.allowThreadDiskReads();
        var2_2 = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        var3_3 = new NetworkStats.Entry();
        var4_4 = null;
        var5_5 = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceAll));
        try {
            while (var5_5.hasMoreData()) {
                var3_3.iface = var5_5.nextString();
                var3_3.uid = -1;
                var3_3.set = -1;
                var3_3.tag = 0;
                var9_6 = var5_5.nextInt() != 0;
                var3_3.rxBytes = var5_5.nextLong();
                var3_3.rxPackets = var5_5.nextLong();
                var3_3.txBytes = var5_5.nextLong();
                var3_3.txPackets = var5_5.nextLong();
                if (var9_6) {
                    var3_3.rxBytes += var5_5.nextLong();
                    var3_3.rxPackets += var5_5.nextLong();
                    var3_3.txBytes += var5_5.nextLong();
                    var3_3.txPackets += var5_5.nextLong();
                }
                var2_2.addValues(var3_3);
                var5_5.finishLine();
            }
            ** GOTO lbl30
        }
        catch (NullPointerException var8_7) {
            block13: {
                break block13;
lbl30:
                // 1 sources

                IoUtils.closeQuietly((AutoCloseable)var5_5);
                StrictMode.setThreadPolicy(var1_1);
                return var2_2;
                catch (Throwable var7_12) {
                    var4_4 = var5_5;
                    ** GOTO lbl-1000
                }
                catch (NumberFormatException var6_15) {
                    var4_4 = var5_5;
                    throw new ProtocolException("problem parsing stats", (Throwable)var6_14);
                }
            }
            var4_4 = var5_5;
            while (true) {
                throw new ProtocolException("problem parsing stats", (Throwable)var8_8);
                {
                    catch (Throwable var7_10) {}
                    ** GOTO lbl-1000
                    catch (NumberFormatException var6_13) {}
                    {
                        throw new ProtocolException("problem parsing stats", (Throwable)var6_14);
                    }
                    catch (NullPointerException var8_9) {
                        var4_4 = null;
                        continue;
                    }
lbl-1000:
                    // 2 sources

                    {
                        IoUtils.closeQuietly(var4_4);
                        StrictMode.setThreadPolicy(var1_1);
                        throw var7_11;
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkStats readNetworkStatsSummaryXt() throws IOException {
        var1_1 = StrictMode.allowThreadDiskReads();
        if (!this.mStatsXtIfaceFmt.exists()) {
            return null;
        }
        var2_2 = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        var3_3 = new NetworkStats.Entry();
        var4_4 = null;
        var5_5 = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceFmt));
        try {
            var5_5.finishLine();
            while (var5_5.hasMoreData()) {
                var3_3.iface = var5_5.nextString();
                var3_3.uid = -1;
                var3_3.set = -1;
                var3_3.tag = 0;
                var3_3.rxBytes = var5_5.nextLong();
                var3_3.rxPackets = var5_5.nextLong();
                var3_3.txBytes = var5_5.nextLong();
                var3_3.txPackets = var5_5.nextLong();
                var2_2.addValues(var3_3);
                var5_5.finishLine();
            }
            ** GOTO lbl27
        }
        catch (NullPointerException var8_6) {
            block13: {
                break block13;
lbl27:
                // 1 sources

                IoUtils.closeQuietly((AutoCloseable)var5_5);
                StrictMode.setThreadPolicy(var1_1);
                return var2_2;
                catch (Throwable var7_11) {
                    var4_4 = var5_5;
                    ** GOTO lbl-1000
                }
                catch (NumberFormatException var6_14) {
                    var4_4 = var5_5;
                    throw new ProtocolException("problem parsing stats", (Throwable)var6_13);
                }
            }
            var4_4 = var5_5;
            while (true) {
                throw new ProtocolException("problem parsing stats", (Throwable)var8_7);
                {
                    catch (Throwable var7_9) {}
                    ** GOTO lbl-1000
                    catch (NumberFormatException var6_12) {}
                    {
                        throw new ProtocolException("problem parsing stats", (Throwable)var6_13);
                    }
                    catch (NullPointerException var8_8) {
                        var4_4 = null;
                        continue;
                    }
lbl-1000:
                    // 2 sources

                    {
                        IoUtils.closeQuietly(var4_4);
                        StrictMode.setThreadPolicy(var1_1);
                        throw var7_10;
                    }
                }
                break;
            }
        }
    }
}

