/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Slog;
import dalvik.system.ZygoteHooks;

public final class Zygote {
    public static final int DEBUG_ENABLE_ASSERT = 4;
    public static final int DEBUG_ENABLE_CHECKJNI = 2;
    public static final int DEBUG_ENABLE_DEBUGGER = 1;
    public static final int DEBUG_ENABLE_JNI_LOGGING = 16;
    public static final int DEBUG_ENABLE_SAFEMODE = 8;
    public static final int MOUNT_EXTERNAL_MULTIUSER = 2;
    public static final int MOUNT_EXTERNAL_MULTIUSER_ALL = 3;
    public static final int MOUNT_EXTERNAL_NONE = 0;
    public static final int MOUNT_EXTERNAL_SINGLEUSER = 1;
    private static final String TAG = "Zygote";
    private static final ZygoteHooks VM_HOOKS = new ZygoteHooks();

    private Zygote() {
    }

    public static void appendQuotedShellArgs(StringBuilder stringBuilder, String[] stringArray) {
        for (String string2 : stringArray) {
            stringBuilder.append(" '").append(string2.replace("'", "'\\''")).append("'");
        }
    }

    private static void callPostForkChildHooks(int n, String string2) {
        long l = SystemClock.elapsedRealtime();
        VM_HOOKS.postForkChild(n, string2);
        Zygote.checkTime(l, "Zygote.callPostForkChildHooks");
    }

    private static void checkTime(long l, String string2) {
        long l2 = SystemClock.elapsedRealtime();
        if (l2 - l > 1000L) {
            Slog.w(TAG, "Slow operation: " + (l2 - l) + "ms so far, now at " + string2);
        }
    }

    public static void execShell(String string2) {
        String[] stringArray = new String[]{"/system/bin/sh", "-c", string2};
        try {
            Os.execv(stringArray[0], stringArray);
            return;
        }
        catch (ErrnoException errnoException) {
            throw new RuntimeException(errnoException);
        }
    }

    public static int forkAndSpecialize(int n, int n2, int[] nArray, int n3, int[][] nArray2, int n4, String string2, String string3, int[] nArray3, String string4, String string5) {
        long l = SystemClock.elapsedRealtime();
        VM_HOOKS.preFork();
        Zygote.checkTime(l, "Zygote.preFork");
        int n5 = Zygote.nativeForkAndSpecialize(n, n2, nArray, n3, nArray2, n4, string2, string3, nArray3, string4, string5);
        Zygote.checkTime(l, "Zygote.nativeForkAndSpecialize");
        VM_HOOKS.postForkCommon();
        Zygote.checkTime(l, "Zygote.postForkCommon");
        return n5;
    }

    public static int forkSystemServer(int n, int n2, int[] nArray, int n3, int[][] nArray2, long l, long l2) {
        VM_HOOKS.preFork();
        int n4 = Zygote.nativeForkSystemServer(n, n2, nArray, n3, nArray2, l, l2);
        VM_HOOKS.postForkCommon();
        return n4;
    }

    private static native int nativeForkAndSpecialize(int var0, int var1, int[] var2, int var3, int[][] var4, int var5, String var6, String var7, int[] var8, String var9, String var10);

    private static native int nativeForkSystemServer(int var0, int var1, int[] var2, int var3, int[][] var4, long var5, long var7);
}

